/*****************************************************************************
*   Default point/vector drawing routine common to graphics drivers.	     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 0.1, June 1993.  *
*****************************************************************************/

#include "irit_sm.h"
#include "iritprsr.h"
#include "cagd_lib.h"
#include "symb_lib.h"
#include "grap_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Draw a single Point/Vector object using current modes and transformations. M
*                                                                            *
* PARAMETERS:                                                                M
*   PObj:     A point/vector object to draw.                                 M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   IGDrawPtVec                                                              M
*****************************************************************************/
void IGDrawPtVec(IPObjectStruct *PObj)
{
    STATIC_DATA PointType
	Zero = { 0.0, 0.0, 0.0 };
    int i;
    PointType Ends[6];
    RealType
	*Pt = PObj -> U.Pt;

    
    if (IGGlblDrawStyle == IG_STATE_DRAW_STYLE_POINTS) {
	IGPlotTo3D(Pt);
    }
    else {
        for (i = 0; i < 6; i++)
	    PT_COPY(Ends[i], Pt);

	Ends[0][0] -= IGGlblPointWidth;
	Ends[1][0] += IGGlblPointWidth;
	Ends[2][1] -= IGGlblPointWidth;
	Ends[3][1] += IGGlblPointWidth;
	Ends[4][2] -= IGGlblPointWidth;
	Ends[5][2] += IGGlblPointWidth;

	for (i = 0; i < 6; i += 2) {
	    IGMoveTo3D(Ends[i]);
	    IGLineTo3D(Ends[i+1]);
	}

	if (IP_IS_VEC_OBJ(PObj)) {
	    IGMoveTo3D(Pt);
	    IGLineTo3D(Zero);
	}
    }
}
