/*****************************************************************************
* Definitions, visible to others, of the dynamic allocator module.	     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
*****************************************************************************/

#ifndef	ALLOCATE_GH
#define	ALLOCATE_GH

#include "iritprsr.h"
#include "obj_dpnd.h"
#include "cagd_lib.h"
#include "trim_lib.h"
#include "triv_lib.h"

#define IP_SET_OBJ_NAME2(PObj, Name) { \
    if (PObj -> ObjName != NULL) \
	IritFree(PObj -> ObjName); \
    PObj -> ObjName = Name ? IritStrdup(Name) : NULL; }
#define IP_CAT_OBJ_NAME(PObj, Apndx) { \
    char Name[LINE_LEN_VLONG]; \
    strcpy(Name, PObj -> ObjName); \
    strcat(Name, Apndx); \
    IP_SET_OBJ_NAME2(PObj, Name); }
#define IP_SET_OBJ_NAME(PObj, Str, Param) { \
    char Name[LINE_LEN_VLONG]; \
    sprintf(Name, Str, Param); \
    IP_SET_OBJ_NAME2(PObj, Name); }
#define IP_VALID_OBJ_NAME(PObj) \
    (PObj -> ObjName != NULL && strlen(PObj -> ObjName) > 0)

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

void IPFreeObjectSlots(IPObjectStruct *PObj);
IPVertexStruct *IPAllocVertex(ByteType Tags,
			      IPPolygonStruct *PAdj,
			      IPVertexStruct *Pnext);
IPVertexStruct *IPAllocVertex2(IPVertexStruct *Pnext);
IPPolygonStruct *IPAllocPolygon(ByteType Tags,
				IPVertexStruct *V,
				IPPolygonStruct *Pnext);
IPObjectStruct *IPAllocObject(char *Name,
			      IPObjStructType ObjType,
			      IPObjectStruct *Pnext);
void IPFreeVertex(IPVertexStruct *V);
void IPFreePolygon(IPPolygonStruct *P);
void IPFreeObject(IPObjectStruct *O);
void IPFreeVertexList(IPVertexStruct *VFirst);
void IPFreePolygonList(IPPolygonStruct *PPoly);
void IPFreeObjectList(IPObjectStruct *O);

#ifdef DEBUG
#define IPFreeVertex(V)          { IPFreeVertex(V); V = NULL; }
#define IPFreePolygon(P)         { IPFreePolygon(P); P = NULL; }
#define IPFreeObject(O)          { IPFreeObject(O); O = NULL; }
#define IPFreeVertexList(VFirst) { IPFreeVertexList(VFirst); VFirst = NULL; }
#define IPFreePolygonList(PPoly) { IPFreePolygonList(PPoly); PPoly = NULL; }
#define IPFreeObjectList(O)      { IPFreeObjectList(O); O = NULL; }
#endif /* DEBUG */

IPPolyVrtxIdxStruct *IPPolyVrtxIdxNew(int NumVrtcs, int NumPlys);
IPPolyVrtxIdxStruct *IPPolyVrtxIdxNew2(IPObjectStruct *PObj);
void IPPolyVrtxIdxFree(IPPolyVrtxIdxStruct *PVIdx);

int IPIsFreeObject(IPObjectStruct *PObj);
int IPIsConsistentFreeObjList(void);

int IPListObjectLength(IPObjectStruct *PObj);
int IPListObjectFind(IPObjectStruct *PObjList, IPObjectStruct *PObj);
void IPListObjectInsert(IPObjectStruct *PObjList,
			int Index,
			IPObjectStruct *PObjItem);
void IPListObjectAppend(IPObjectStruct *PObjList, IPObjectStruct *PObjItem);
void IPListObjectDelete(IPObjectStruct *PObj, int Index, int FreeItem);
IPObjectStruct *IPListObjectGet(IPObjectStruct *PObjList, int Index);
void IPPropagateObjectName(IPObjectStruct *Obj, char *ObjName);
void IPReallocNewTypeObject(IPObjectStruct *PObj, IPObjStructType ObjType);

IPObjectStruct *IPGenPolyObject(char *Name,
				IPPolygonStruct *Pl,
				IPObjectStruct *Pnext);
IPObjectStruct *IPGenPOLYObject(IPPolygonStruct *Pl);
IPObjectStruct *IPGenPolylineObject(char *Name,
				    IPPolygonStruct *Pl,
				    IPObjectStruct *Pnext);
IPObjectStruct *IPGenPOLYLINEObject(IPPolygonStruct *Pl);
IPObjectStruct *IPGenPointListObject(char *Name,
				     IPPolygonStruct *Pl,
				     IPObjectStruct *Pnext);
IPObjectStruct *IPGenPOINTLISTObject(IPPolygonStruct *Pl);
IPObjectStruct *IPGenCrvObject(char *Name,
			       CagdCrvStruct *Crv,
			       IPObjectStruct *Pnext);
IPObjectStruct *IPGenCRVObject(CagdCrvStruct *Crv);
IPObjectStruct *IPGenSrfObject(char *Name,
			       CagdSrfStruct *Srf,
			       IPObjectStruct *Pnext);
IPObjectStruct *IPGenSRFObject(CagdSrfStruct *Srf);
IPObjectStruct *IPGenTrimSrfObject(char *Name,
				   TrimSrfStruct *TrimSrf,
				   IPObjectStruct *Pnext);
IPObjectStruct *IPGenTRIMSRFObject(TrimSrfStruct *TrimSrf);
IPObjectStruct *IPGenTrivarObject(char *Name,
				  TrivTVStruct *Triv,
				  IPObjectStruct *Pnext);
IPObjectStruct *IPGenTRIVARObject(TrivTVStruct *Triv);
IPObjectStruct *IPGenTriSrfObject(char *Name,
				  TrngTriangSrfStruct *TriSrf,
				  IPObjectStruct *Pnext);
IPObjectStruct *IPGenTRISRFObject(TrngTriangSrfStruct *TriSrf);
IPObjectStruct *IPGenModelObject(char *Name,
				 MdlModelStruct *Model,
				 IPObjectStruct *Pnext);
IPObjectStruct *IPGenMODELObject(MdlModelStruct *Model);
IPObjectStruct *IPGenMultiVarObject(char *Name,
				    MvarMVStruct *MultiVar,
				    IPObjectStruct *Pnext);
IPObjectStruct *IPGenMULTIVARObject(MvarMVStruct *MultiVar);
IPObjectStruct *IPGenInstncObject(char *Name,
				  char *InstncName,
				  MatrixType *Mat,
				  IPObjectStruct *Pnext);
IPObjectStruct *IPGenINSTNCObject(char *InstncName, MatrixType *Mat);
IPObjectStruct *IPGenCtlPtObject(char *Name,
				 CagdPointType PtType,
				 CagdRType *CagdCoords,
				 RealType *Coords,
				 IPObjectStruct *Pnext);
IPObjectStruct *IPGenCTLPTObject(CagdPointType PtType,
				 CagdRType *CagdCoords,
				 RealType *Coords);
IPObjectStruct *IPGenNumObject(char *Name, RealType *R, IPObjectStruct *Pnext);
IPObjectStruct *IPGenNUMObject(RealType *R);
IPObjectStruct *IPGenNUMValObject(RealType R);
IPObjectStruct *IPGenPtObject(char *Name,
			      RealType *Pt0,
			      RealType *Pt1,
			      RealType *Pt2,
			      IPObjectStruct *Pnext);
IPObjectStruct *IPGenPTObject(RealType *Pt0, RealType *Pt1, RealType *Pt2);
IPObjectStruct *IPGenVecObject(char *Name,
			       RealType *Vec0,
			       RealType *Vec1,
			       RealType *Vec2,
			       IPObjectStruct *Pnext);
IPObjectStruct *IPGenVECObject(RealType *Vec0, RealType *Vec1, RealType *Vec2);
IPObjectStruct *IPGenStrObject(char *Name, char *Str, IPObjectStruct *Pnext);
IPObjectStruct *IPGenSTRObject(char *Str);
IPObjectStruct *IPGenListObject(char *Name,
				IPObjectStruct *First,
				IPObjectStruct *Pnext);
IPObjectStruct *IPGenLISTObject(IPObjectStruct *First);
IPObjectStruct *IPGenPlaneObject(char *Name,
				 RealType *Plane0,
				 RealType *Plane1,
				 RealType *Plane2,
				 RealType *Plane3,
				 IPObjectStruct *Pnext);
IPObjectStruct *IPGenPLANEObject(RealType *Plane0,
				 RealType *Plane1,
				 RealType *Plane2,
				 RealType *Plane3);
IPObjectStruct *IPGenMatObject(char *Name,
			       MatrixType Mat,
			       IPObjectStruct *Pnext);
IPObjectStruct *IPGenMATObject(MatrixType Mat);

void IPCopyObjectAuxInfo(IPObjectStruct *Dest, IPObjectStruct *Src);
IPObjectStruct *IPCopyObject(IPObjectStruct *Dest,
			     IPObjectStruct *Src,
			     int CopyAll);
int IPSetCopyObjectReferenceCount(int RefCount);

IPObjectStruct *IPCopyObjectList(IPObjectStruct *PObjs, int CopyAll);
IPPolygonStruct *IPCopyPolygon(IPPolygonStruct *Src);
IPPolygonStruct *IPCopyPolygonList(IPPolygonStruct *Src);
IPVertexStruct *IPCopyVertex(IPVertexStruct *Src);
IPVertexStruct *IPCopyVertexList(IPVertexStruct *Src);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif	/* ALLOCATE_GH */
