/*****************************************************************************
* Setting attributes for geometric objects.				     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
*****************************************************************************/

#ifndef ATTRIBUTE_H
#define ATTRIBUTE_H

#include "iritprsr.h"
#include "miscattr.h"

#define ATTR_OBJ_IS_INVISIBLE(PObj) \
	(AttrGetObjectIntAttrib((PObj), "Invisible") != IP_ATTR_BAD_INT)

#define ATTR_OBJ_ATTR_EXIST(PObj, Name) (AttrFindAttribute(PObj -> Attr, \
							   Name) != NULL)

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

void AttrSetObjectColor(IPObjectStruct *PObj, int Color);
int AttrGetObjectColor(IPObjectStruct *PObj);
void AttrSetObjectRGBColor(IPObjectStruct *PObj, int Red, int Green, int Blue);
int AttrGetObjectRGBColor(IPObjectStruct *PObj,
			  int *Red,
			  int *Green,
			  int *Blue);
void AttrSetObjectWidth(IPObjectStruct *PObj, RealType Width);
RealType AttrGetObjectWidth(IPObjectStruct *PObj);

void AttrSetObjectIntAttrib(IPObjectStruct *PObj, char *Name, int Data);
int AttrGetObjectIntAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectRealAttrib(IPObjectStruct *PObj, char *Name, RealType Data);
RealType AttrGetObjectRealAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectUVAttrib(IPObjectStruct *PObj,
			   char *Name,
			   RealType U,
			   RealType V);
float *AttrGetObjectUVAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectPtrAttrib(IPObjectStruct *PObj, char *Name, VoidPtr Data);
VoidPtr AttrGetObjectPtrAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectRefPtrAttrib(IPObjectStruct *PObj, char *Name, VoidPtr Data);
VoidPtr AttrGetObjectRefPtrAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectStrAttrib(IPObjectStruct *PObj, char *Name, char *Data);
char *AttrGetObjectStrAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectObjAttrib(IPObjectStruct *PObj,
			    char *Name,
			    IPObjectStruct *Data,
			    int CopyData);
void AttrSetObjAttrib(IPAttributeStruct **Attrs,
		      char *Name,
		      IPObjectStruct *Data,
		      int CopyData);
IPObjectStruct *AttrGetObjectObjAttrib(IPObjectStruct *PObj, char *Name);
IPObjectStruct *AttrGetObjAttrib(IPAttributeStruct *Attrs, char *Name);

void AttrFreeObjectAttribute(IPObjectStruct *PObj, char *Name);

IPAttributeStruct *AttrCopyOneAttribute(IPAttributeStruct *Src);
IPAttributeStruct *AttrCopyAttributes(IPAttributeStruct *Src);
void AttrPropagateAttr(IPObjectStruct *PObj, char *AttrName);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* ATTRIBUTE_H */
