/******************************************************************************
* Bsc_Geom.c - Basic geometry interface.				      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, March 1990.					      *
******************************************************************************/

#ifndef BSC_GEOM_H
#define BSC_GEOM_H

double DistPointPoint(PointType P1, PointType P2);
IPObjectStruct *PlaneFrom3Points(PointType Pt1, PointType Pt2, PointType Pt3);
IPObjectStruct *PointFromPointLine(PointType Point, PointType Pl, PointType Vl);
double DistPointLine(PointType Point, PointType Pl, PointType Vl);
double DistPointPlane(PointType Point, PlaneType Plane);
IPObjectStruct *PointFromLinePlane(PointType Pl, PointType Vl, PlaneType Plane);
IPObjectStruct *TwoPointsFromLineLine(PointType Pl1,
				      PointType Vl1,
				      PointType Pl2,
				      PointType Vl2);
IPObjectStruct *TwoPointsFromCircCirc(PointType Cntr1,
				      VectorType Nrml1,
				      RealType *Rad1,
				      PointType Cntr2,
				      VectorType Nrml2,
				      RealType *Rad2);
IPObjectStruct *TwoTangentsFromCircCirc(PointType Cntr1,
					RealType *Rad1,
					PointType Cntr2,
					RealType *Rad2,
					RealType *ROuterTans);
double DistLineLine(PointType Pl1, PointType Vl1, PointType Pl2, PointType Vl2);
IPObjectStruct *BaryCentric3Pts(PointType Pt1,
				PointType Pt2,
				PointType Pt3,
				PointType Pt);

IPObjectStruct *PolyPolyIntersection(IPObjectStruct *Pl1, IPObjectStruct *Pl2);

RealType ComputeZCollisions(IPObjectStruct *PObj1,
			    IPObjectStruct *PObj2,
			    RealType *FineNess,
			    RealType *NumIters);

#endif /* BSC_GEOM_H */
