/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
*   Module to provide the required interfact for the cagd library for the    *
* free form surfaces and curves.					     *
*****************************************************************************/

#ifndef FREEFORM_H
#define FREEFORM_H

#define MIN_FREE_FORM_RES 2

CagdRType *GetKnotVector(IPObjectStruct *KntObjList,
			 int Order,
			 int *Length,
			 char **ErrStr,
			 int Validate);
int GetDrawCtlPt(void);
int GetFourPerFlat(void);
int GetPolyApproxOptimal(void);
int GetPolyApproxUV(void);
int GetPolyApproxTri(void);
int GetPolyMergeCoplanar(void);
RealType GetPolyApproxTol(void);
IPObjectStruct *GenPowerSurfaceObject(IPObjectStruct *LstObjList);
IPObjectStruct *GenPowerCurveObject(IPObjectStruct *PtObjList);
IPObjectStruct *GenBezierSurfaceObject(IPObjectStruct *LstObjList);
IPObjectStruct *GenBezierCurveObject(IPObjectStruct *PtObjList);
IPObjectStruct *GenBsplineSurfaceObject(RealType *UOrder,
					RealType *VOrder,
					IPObjectStruct *LstObjList,
					IPObjectStruct *KntObjList);
IPObjectStruct *GenBsplineCurveObject(RealType *ROrder,
				      IPObjectStruct *PtObjList,
				      IPObjectStruct *KntObjList);
IPObjectStruct *GenSURFPREVObject(IPObjectStruct *Cross);
IPObjectStruct *DivideSurfaceObject(IPObjectStruct *SrfObj,
				    RealType *Dir,
				    RealType *ParamVal);
IPObjectStruct *RegionFromSurfaceObject(IPObjectStruct *SrfObj,
					RealType *RDir,
					RealType *ParamVal1,
					RealType *ParamVal2);
IPObjectStruct *DivideCurveObject(IPObjectStruct *CrvObj, RealType *ParamVal);
IPObjectStruct *RegionFromCurveObject(IPObjectStruct *CrvObj,
				      RealType *ParamVal1,
				      RealType *ParamVal2);
IPObjectStruct *RefineSurfaceObject(IPObjectStruct *SrfObj,
				    RealType *Dir,
				    RealType *Replace,
				    IPObjectStruct *KnotsObj);
IPObjectStruct *RefineCurveObject(IPObjectStruct *CrvObj,
				  RealType *Replace,
				  IPObjectStruct *KnotsObj);
IPObjectStruct *EvalSurfaceObject(IPObjectStruct *SrfObj,
				  RealType *u,
				  RealType *v);
IPObjectStruct *EvalCurveObject(IPObjectStruct *CrvObj, RealType *t);
IPObjectStruct *DeriveSurfaceObject(IPObjectStruct *SrfObj, RealType *Dir);
IPObjectStruct *IntegrateSurfaceObject(IPObjectStruct *SrfObj, RealType *Dir);
IPObjectStruct *DeriveCurveObject(IPObjectStruct *CrvObj);
IPObjectStruct *IntegrateCurveObject(IPObjectStruct *CrvObj);
IPObjectStruct *MoebiusCurveTrans(IPObjectStruct *CrvObj, RealType *C);
IPObjectStruct *MoebiusSurfaceTrans(IPObjectStruct *SrfObj,
				    RealType *C,
				    RealType *RDir);
IPObjectStruct *SurfaceNormalObject(IPObjectStruct *SrfObj);
IPObjectStruct *CurveNormalObject(IPObjectStruct *CrvObj);
IPObjectStruct *NormalSurfaceObject(IPObjectStruct *SrfObj,
				    RealType *u,
				    RealType *v);
IPObjectStruct *NormalCurveObject(IPObjectStruct *CrvObj, RealType *t);
IPObjectStruct *TangentSurfaceObject(IPObjectStruct *SrfObj,
				     RealType *Dir,
				     RealType *u,
				     RealType *v,
				     RealType *Normalize);
IPObjectStruct *TangentCurveObject(IPObjectStruct *CrvObj,
				   RealType *t,
				   RealType *Normalize);
IPObjectStruct *CurveFromSrfMesh(IPObjectStruct *SrfObj,
				 RealType *Dir,
				 RealType *Index);
IPObjectStruct *CurveFromSurface(IPObjectStruct *SrfObj,
				 RealType *Dir,
				 RealType *ParamVal);
IPObjectStruct *MeshGeometry2Polylines(IPObjectStruct *Obj);
IPObjectStruct *SurfaceReverse(IPObjectStruct *SrfObj);
void ComputeSurfacePolygons(IPObjectStruct *PObj, int Normals);
void ComputeTrimSrfPolygons(IPObjectStruct *PObj, int Normals);
void ComputeTriSrfPolygons(IPObjectStruct *PObj, int Normals);
void ComputeTrivarPolygons(IPObjectStruct *PObj, int Normals);
IPObjectStruct *Geometry2Polygons(IPObjectStruct *Obj, RealType *RNormals);
IPObjectStruct *Geometry2Polylines(IPObjectStruct *Obj, RealType *Optimal);
IPObjectStruct *ExtremumControlPointVals(IPObjectStruct *Obj, CagdRType *Min);
IPObjectStruct *GenCircleCurveObject(VectorType Position, RealType *Radius);
IPObjectStruct *GenPCircleCurveObject(VectorType Position, RealType *Radius);
IPObjectStruct *GenArcCurveObject(VectorType Start,
				  VectorType Center,
				  VectorType End);
IPObjectStruct *GenSpiralCurveObject(CagdRType *NumOfLoops,
				     CagdRType *Pitch,
				     CagdRType *RSampling,
				     CagdRType *RCtlPtsPerLoop);
IPObjectStruct *GenArc2CurveObject(VectorType Center,
				   RealType *Radius,
				   RealType *StartAngle,
				   RealType *EndAngle);
IPObjectStruct *GenRuledSrfObject(IPObjectStruct *Obj1, IPObjectStruct *Obj2);
IPObjectStruct *GenRuledTVObject(IPObjectStruct *Obj1, IPObjectStruct *Obj2);
IPObjectStruct *GenBoolSumSrfObject(IPObjectStruct *Crv1,
				    IPObjectStruct *Crv2,
				    IPObjectStruct *Crv3,
				    IPObjectStruct *Crv4);
IPObjectStruct *GenBoolOneSrfObject(IPObjectStruct *BndryCrv);
IPObjectStruct *GenSrfFromCrvsObject(IPObjectStruct *CrvList,
				     RealType *OtherOrder,
				     RealType *OtherEC);
IPObjectStruct *GenSweepScaleSrfObject(IPObjectStruct *CrossSection,
				       IPObjectStruct *Axis,
				       IPObjectStruct *Scale,
				       IPObjectStruct *Frame,
				       RealType *RRefine);
IPObjectStruct *GenSweepSrfObject(IPObjectStruct *CrossSection,
				  IPObjectStruct *Axis, 
				  IPObjectStruct *Frame);
IPObjectStruct *GenOffsetObject(IPObjectStruct *Obj,
				IPObjectStruct *Offset,
				RealType *Tolerance,
				RealType *BezInterp);
IPObjectStruct *GenAOffsetObject(IPObjectStruct *Obj,
				 IPObjectStruct *Offset,
				 RealType *Epsilon,
				 RealType *Trim,
				 RealType *BezInterp);
IPObjectStruct *GenLeastSqrOffsetObject(IPObjectStruct *Obj,
					RealType *Offset,
					RealType *NumOfSamples,
					RealType *NumOfDOF,
					RealType *Order);
IPObjectStruct *GenMatchingOffsetObject(IPObjectStruct *Obj,
					RealType *Offset,
					RealType *Tolerance);
IPObjectStruct *TrimOffsetObject(IPObjectStruct *Crv,
				 IPObjectStruct *OffCrv,
				 RealType *Tol,
				 RealType *TrimAmount,
				 RealType *NumerTol);
IPObjectStruct *MergeSrfSrf(IPObjectStruct *Srf1,
			    IPObjectStruct *Srf2,
			    RealType *Dir,
			    RealType *SameEdge);
IPObjectStruct *MergeCurvesAndCtlPoints(IPObjectStruct *PObj1,
					IPObjectStruct *PObj2);
IPObjectStruct *EditCrvControlPoint(IPObjectStruct *PObjCrv,
				    CagdCtlPtStruct *Pt,
				    RealType *Index);
IPObjectStruct *EditSrfControlPoint(IPObjectStruct *PObjSrf,
				    CagdCtlPtStruct *Pt,
				    RealType *UIndex,
				    RealType *VIndex);
IPObjectStruct *EditTVControlPoint(IPObjectStruct *PObjTV,
				   CagdCtlPtStruct *Pt,
				   RealType *UIndex,
				   RealType *VIndex,
				   RealType *WIndex);
IPObjectStruct *RaiseCurveObject(IPObjectStruct *PObjCrv, RealType *Order);
IPObjectStruct *ReduceCurveObject(IPObjectStruct *PObjCrv, RealType *RNewOrder);
IPObjectStruct *RaiseSurfaceObject(IPObjectStruct *PObjSrf,
				   RealType *RDir,
				   RealType *RNewOrder);
IPObjectStruct *RaiseTrivarObject(IPObjectStruct *PObjTV,
				  RealType *RDir,
				  RealType *RNewOrder);
IPObjectStruct *RaiseMultivarObject(IPObjectStruct *PObjMV,
				    RealType *RDir,
				    RealType *RNewOrder);
void MakeFreeFormCompatible(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsMorphing(IPObjectStruct *PObjCrv1,
				IPObjectStruct *PObjCrv2,
				RealType *Method,
				RealType *Blend);
IPObjectStruct *TwoSrfsMorphing(IPObjectStruct *PObjSrf1,
				IPObjectStruct *PObjSrf2,
				RealType *Blend);
IPObjectStruct *TwoTVsMorphing(IPObjectStruct *PObjTV1,
			       IPObjectStruct *PObjTV2,
			       RealType *Blend);
IPObjectStruct *CnvrtBezierToPower(IPObjectStruct *PObj);
IPObjectStruct *CnvrtGregoryToBezier(IPObjectStruct *PObj);
IPObjectStruct *CnvrtPowerToBezier(IPObjectStruct *PObj);
IPObjectStruct *CnvrtBezierToBspline(IPObjectStruct *PObj);
IPObjectStruct *CnvrtBsplineToBezier(IPObjectStruct *PObj);
IPObjectStruct *TwoFreeformsProduct(IPObjectStruct *PObj1,
				    IPObjectStruct *PObj2);
IPObjectStruct *TwoFreeformsDotProduct(IPObjectStruct *PObj1,
				       IPObjectStruct *PObj2);
IPObjectStruct *TwoFreeformsCrossProduct(IPObjectStruct *PObj1,
					 IPObjectStruct *PObj2);
IPObjectStruct *TwoBasisInnerProduct(IPObjectStruct *PCrv,
				     RealType *RInt1,
				     RealType *RInt2);
IPObjectStruct *TwoFreeformsSum(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *TwoFreeformsDiff(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *CrvReparametrization(IPObjectStruct *Obj,
				     RealType *TMin,
				     RealType *TMax);
IPObjectStruct *SrfReparametrization(IPObjectStruct *Obj,
				     RealType *RDir,
				     RealType *TMin,
				     RealType *TMax);
IPObjectStruct *TrivReparametrization(IPObjectStruct *Obj,
				      RealType *RDir,
				      RealType *TMin,
				      RealType *TMax);
IPObjectStruct *MvarReparametrization(IPObjectStruct *Obj,
				      RealType *RDir,
				      RealType *TMin,
				      RealType *TMax);
IPObjectStruct *CrvCurvaturePts(IPObjectStruct *PObj,
				RealType *Eps,
				 RealType *Operation);
IPObjectStruct *CrvInflectionPts(IPObjectStruct *PObj,
				 RealType *Eps,
				 RealType *Operation);
IPObjectStruct *CrvCurvatureFunction(IPObjectStruct *PObj,
				     RealType *RSamples,
				     RealType *ROrder,
				     RealType *RArcLen);
IPObjectStruct *SrfRadialCurvature(IPObjectStruct *PObj,
				   VectorType ViewDir,
				   RealType *SubdivTol,
				   RealType *NumerTol,
				   RealType *MergeTol);
IPObjectStruct *ImplicitCrvExtreme(IPObjectStruct *PSrf,
				   RealType *Dir,
				   RealType *SubdivTol,
				   RealType *NumerTol);
IPObjectStruct *SrfGaussCurvature(IPObjectStruct *PObj, RealType *NumerOnly);
IPObjectStruct *SrfMeanCurvature(IPObjectStruct *PObj, RealType *NumerOnly);
IPObjectStruct *SrfCurvatureBounds(IPObjectStruct *PObj,
				   RealType *RPtType,
				   RealType *RDir);
IPObjectStruct *FreeformEvolute(IPObjectStruct *PObj);
IPObjectStruct *SrfIsoFocalSrf(IPObjectStruct *PObj, RealType *RDir);
IPObjectStruct *CrvZeros(IPObjectStruct *PObj, RealType *Eps, RealType *Axis);
IPObjectStruct *CrvExtremes(IPObjectStruct *PObj,
			    RealType *Eps,
			    RealType *Axis);
IPObjectStruct *CrvCrvInter(IPObjectStruct *PObj1,
			    IPObjectStruct *PObj2,
			    RealType *Eps,
			    RealType *SelfInter);
IPObjectStruct *CrvCrvInterArrangment(IPObjectStruct *PObj,
				      RealType *Eps,
				      RealType *Operation,
				      IPObjectStruct *PtObj);
IPObjectStruct *SrfSrfInter(IPObjectStruct *PObj1,
			    IPObjectStruct *PObj2,
			    RealType *Euclidean,
			    RealType *Eps,
			    RealType *AlignSrfs);
IPObjectStruct *CrvPointDist(IPObjectStruct *PCrv,
			     PointType Point,
			     RealType *MinDist,
			     RealType *Eps);
IPObjectStruct *CrvLineDist(IPObjectStruct *PCrv,
			    PointType Point,
			    VectorType Vec,
			    RealType *MinDist,
			    RealType *Eps);
IPObjectStruct *SrfPointDist(IPObjectStruct *PSrf,
			     PointType Point,
			     RealType *MinDist,
			     RealType *SubdivTol,
			     RealType *NumerTol);
IPObjectStruct *SrfLineDist(IPObjectStruct *PSrf,
			    PointType LnPt,
			    VectorType LnDir,
			    RealType *MinDist,
			    RealType *SubdivTol,
			    RealType *NumerTol);
IPObjectStruct *CrvComposition(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *CrvDecomposition(IPObjectStruct *PObj);
IPObjectStruct *SrfsPrisa(IPObjectStruct *Srfs,
			  CagdRType *SamplesPerCurve,
			  CagdRType *Epsilon,
			  CagdRType *Dir,
			  CagdVType Space,
			  CagdRType *RDoCrossSecs);
IPObjectStruct *SrfAdapIsoCurves(IPObjectStruct *Srf,
				 CagdRType *Dir,
				 CagdRType *Eps,
				 CagdRType *FullIso,
				 CagdRType *SinglePath);
IPObjectStruct *GetFreefromParamDomain(IPObjectStruct *FreeformObj);
IPObjectStruct *LineLeastSquarePtData(IPObjectStruct *PtObjList);
IPObjectStruct *CrvLeastSquarePtData(IPObjectStruct *PtObjList,
				     CagdRType *Order,
				     CagdRType *CrvSize,
				     IPObjectStruct *Params,
				     CagdRType *RPeriodic);
IPObjectStruct *SrfLeastSquarePtData(IPObjectStruct *LstObjList,
				     CagdRType *UOrder,
				     CagdRType *VOrder,
				     CagdRType *USize,
				     CagdRType *VSize,
				     CagdRType *ParamType);
RealType GetResolutionReal(void);
int GetResolution(int ClipToMin);
IPObjectStruct *CurveMultiResDecomp(IPObjectStruct *CrvObj,
				    RealType *Discont,
				    RealType *LeastSqr);
IPObjectStruct *GenTrimmedSurface(IPObjectStruct *SrfObj,
				  IPObjectStruct *TrimmedCrvsObj,
				  RealType *RHasTopLvlTrim);
IPObjectStruct *GenTrimmedSurfaces2(IPObjectStruct *SrfObj,
				    IPObjectStruct *Cntrs);
IPObjectStruct *GetSrfFromTrimmedSrf(IPObjectStruct *TrimmedSrfObj);
IPObjectStruct *GetTrimCrvsFromTrimmedSrf(IPObjectStruct *TrimmedSrfObj,
					  RealType *RParamSpace);
IPObjectStruct *GenBezierTrivarObject(IPObjectStruct *LstLstObjList);
IPObjectStruct *GenBsplineTrivarObject(RealType *RUOrder,
				       RealType *RVOrder,
				       RealType *RWOrder,
				       IPObjectStruct *LstLstObjList,
				       IPObjectStruct *KntObjList);
IPObjectStruct *EvalTrivarObject(IPObjectStruct *TVObj,
				 RealType *u,
				 RealType *v,
				 RealType *w);
IPObjectStruct *SurfaceFromTrivar(IPObjectStruct *TVObj,
				  RealType *RDir,
				  RealType *ParamVal);
IPObjectStruct *SurfaceFromTrivMesh(IPObjectStruct *TVObj,
				    RealType *RDir,
				    RealType *RIndex);
IPObjectStruct *DivideTrivarObject(IPObjectStruct *TVObj,
				    RealType *RDir,
				    RealType *ParamVal);
IPObjectStruct *RegionFromTrivarObject(IPObjectStruct *TVObj, 
					RealType *RDir,
					RealType *ParamVal1,
					RealType *ParamVal2);
IPObjectStruct *RefineTrivarObject(IPObjectStruct *TVObj,
				    RealType *RDir,
				    RealType *RReplace,
				    IPObjectStruct *KnotsObj);
IPObjectStruct *DeriveTrivarObject(IPObjectStruct *TVObj, RealType *Dir);
IPObjectStruct *InterpolateTrivar(IPObjectStruct *PObj,
				  RealType *DULength,
				  RealType *DVLength,
				  RealType *DWLength,
				  RealType *DUOrder,
				  RealType *DVOrder,
				  RealType *DWOrder);
IPObjectStruct *ComputeCrvMoments(IPObjectStruct *CrvObj, RealType *RMoment);
IPObjectStruct *GenTVFromSrfsObject(IPObjectStruct *SrfList,
				    RealType *OtherOrder,
				    RealType *OtherEC);
IPObjectStruct *TrivZeroJacobian(IPObjectStruct *Tv,
				 RealType *REuclid,
				 RealType *RSkipRate,
				 IPObjectStruct *RFineness);
IPObjectStruct *CrvKernel(IPObjectStruct *Crv,
			  RealType *RGamma,
			  RealType *REuclid,
			  IPObjectStruct *RFineness,
			  RealType *RSilh);
IPObjectStruct *SrfKernel(IPObjectStruct *Srf,
			  RealType *Fineness,
			  RealType *RSkipRate);
IPObjectStruct *CrvDiameter(IPObjectStruct *Crv,
			    RealType *RSubEps,
			    RealType *RNumEps,
			    RealType *RMinMaxAll);
IPObjectStruct *GenHermiteObject(IPObjectStruct *Pos1,
				 IPObjectStruct *Pos2,
				 IPObjectStruct *Dir1,
				 IPObjectStruct *Dir);
IPObjectStruct *GenBlendHermiteObject(IPObjectStruct *Pos1,
				      IPObjectStruct *Pos2,
				      IPObjectStruct *Dir1,
				      IPObjectStruct *Dir2,
				      IPObjectStruct *CrossSec,
				      IPObjectStruct *Normal);
IPObjectStruct *GenBlendHermiteOnSrfObject(IPObjectStruct *Srf,
					   IPObjectStruct *UVCrv,
					   IPObjectStruct *CrossSecShape,
					   RealType *TanScale,
					   IPObjectStruct *Width,
					   IPObjectStruct *Height);
IPObjectStruct *MatchTwoCurves(IPObjectStruct *PCrv1,
			       IPObjectStruct *PCrv2,
			       RealType *RReduce,
			       RealType *RSampleSet,
			       RealType *RReparamOrder,
			       RealType *RRotate,
			       RealType *RNorm);
IPObjectStruct *ContourFreeform(IPObjectStruct *PSrfObj,
				PlaneType Plane,
				IPObjectStruct *PSrfEvalObj,
				IPObjectStruct *PValidationObj);
IPObjectStruct *SurfaceRayIntersect(IPObjectStruct *PSrfObj,
				    PointType ReyPos,
				    VectorType RayDir);
IPObjectStruct *PolygonRayIntersect(IPObjectStruct *PObj,
				    PointType RayOrigin,
				    RealType *RayDir);
IPObjectStruct *FreeFormSplitScalar(IPObjectStruct *FreeForm);
IPObjectStruct *FreeFormMergeScalar(IPObjectStruct *ScalarFreeFormList,
				    RealType *RPType);
IPObjectStruct *FreeFormPointType(IPObjectStruct *FreeForm);
IPObjectStruct *FreeFormGeomType(IPObjectStruct *FreeForm);
IPObjectStruct *ComputeConvexHull(IPObjectStruct *Geom, RealType *RFineNess);
IPObjectStruct *ComputeMinSpanCirc(IPObjectStruct *Geom, IPObjectStruct *Tols);
IPObjectStruct *CrvPointTangents(IPObjectStruct *Crv,
				 PointType Pt,
				 RealType *RFineNess);
IPObjectStruct *CrvTwoTangents(IPObjectStruct *Crv, RealType *RFineNess);
IPObjectStruct *CircTangentsTwoCrvs(IPObjectStruct *Crv1,
				    IPObjectStruct *Crv2,
				    RealType *Radius,
				    RealType *Tol);
IPObjectStruct *SrfThreeTangents(IPObjectStruct *SrfList,
				 RealType *Orientation,
				 RealType *SubdivTol,
				 RealType *NumericTol);
IPObjectStruct *FreeFormOrder(IPObjectStruct *FreeForm);
IPObjectStruct *FreeFormMeshSize(IPObjectStruct *FreeForm);
IPObjectStruct *FreeFormKnotVector(IPObjectStruct *FreeForm);
IPObjectStruct *FreeFormControlPoints(IPObjectStruct *FreeForm);
IPObjectStruct *CurveVisibility(IPObjectStruct *CrvObj,
				RealType *Tol,
				VectorType View);
IPObjectStruct *VisibConeDecomposition(IPObjectStruct *SrfObj,
				       RealType *Resolution,
				       RealType *ConeSize);
IPObjectStruct *CrvAngleMap(IPObjectStruct *CrvObj,
			    RealType *Tolerance,
			    RealType *Angle,
			    RealType *RDiagExtreme);
IPObjectStruct *CrvViewMap(IPObjectStruct *CrvObj,
			   IPObjectStruct *ViewCrvObj,
			   RealType *SubTol,
			   RealType *NumTol,
			   RealType *TrimInvisible);
IPObjectStruct *PointCoverOfHemiSphere(RealType *Size);
IPObjectStruct *FreeformPointDistrib(IPObjectStruct *FreeFormObj,
				     RealType *RParamUniform,
				     RealType *RNumOfPts);
IPObjectStruct *GenBezierTriSrfObject(RealType *RLength,
				      IPObjectStruct *PtObjList);
IPObjectStruct *GenBsplineTriSrfObject(RealType *RLength,
				       RealType *ROrder,
				       IPObjectStruct *PtObjList,
				       IPObjectStruct *KntObjList);
IPObjectStruct *GenGregoryTriSrfObject(RealType *RLength,
				       IPObjectStruct *PtObjList);
IPObjectStruct *EvalTriSrfObject(IPObjectStruct *TriSrfObj,
				 RealType *u,
				 RealType *v,
				 RealType *w);
IPObjectStruct *NormalTriSrfObject(IPObjectStruct *TriSrfObj,
				   RealType *u,
				   RealType *v,
				   RealType *w);
IPObjectStruct *DeriveTriSrfObject(IPObjectStruct *TriSrfObj, RealType *Dir);
IPObjectStruct *CurveEnvelopeOffset(IPObjectStruct *CrvObj,
				    RealType *Height,
				    RealType *Tolerance);
IPObjectStruct *SphericalBisector(IPObjectStruct *Objs, RealType *Tolerance);
IPObjectStruct *PlanePointBisector(PointType Pt, RealType *Size);
IPObjectStruct *CylinPointBisector(PointType CylPt,
				   VectorType CylDir,
				   RealType *CylRad,
				   PointType Pt,
				   RealType *Size);
IPObjectStruct *ConePointBisector(PointType ConeApex,
				  VectorType ConeDir,
				  RealType *ConeAngle,
				  PointType Pt,
				  RealType *Size);
IPObjectStruct *SpherePointBisector(PointType SprCntr,
				    RealType *SprRad,
				    PointType Pt);
IPObjectStruct *TorusPointBisector(PointType TrsCntr,
				   VectorType TrsDir,
				   RealType *TrsMajorRad,
				   RealType *TrsMinorRad,
				   PointType Pt);
IPObjectStruct *PlaneLineBisector(VectorType LineDir, RealType *Size);
IPObjectStruct *ConeLineBisector(VectorType ConeDir,
				 RealType *ConeAngle,
				 VectorType LineDir,
				 RealType *Size);
IPObjectStruct *SphereLineBisector(PointType SprCntr,
				   RealType *SprRad,
				   RealType *Size);
IPObjectStruct *SpherePlaneBisector(PointType SprCntr,
				    RealType *SprRad,
				    RealType *Size);
IPObjectStruct *CylinPlaneBisector(PointType CylPt,
				   VectorType CylDir,
				   RealType *CylRad,
				   RealType *Size);
IPObjectStruct *ConePlaneBisector(PointType ConeApex,
				  VectorType ConeDir,
				  RealType *ConeAngle,
				  RealType *Size);
IPObjectStruct *SphereSphereBisector(PointType SprCntr1,
				     RealType *SprRad1,
				     PointType SprCntr2,
				     RealType *SprRad2);
IPObjectStruct *CylinSphereBisector(PointType CylPt,
				    VectorType CylDir,
				    RealType *CylRad,
				    PointType SprCntr,
				    RealType *SprRad,
				    RealType *Size);
IPObjectStruct *ConeConeBisector(VectorType Cone1Dir,
				 RealType *Cone1Angle,
				 VectorType Cone2Dir,
				 RealType *Cone2Angle,
				 RealType *Size);
IPObjectStruct *ConeConeBisector2(PointType Cone1Pt,
				  VectorType Cone1Dir,
				  RealType *Cone1Angle,
				  PointType Cyl2Pt,
				  VectorType Cyl2Dir,
				  RealType *Cyl2Rad);
IPObjectStruct *ConeSphereBisector(PointType ConeApex,
				   VectorType ConeDir,
				   RealType *ConeAngle,
				   PointType SprCntr,
				   RealType *SprRad,
				   RealType *Size);
IPObjectStruct *TorusSphereBisector(PointType TrsCntr,
				    VectorType TrsDir,
				    RealType *TrsMajorRad,
				    RealType *TrsMinorRad,
				    PointType SprCntr,
				    RealType *SprRad);
IPObjectStruct *CylinCylinBisector(PointType Cyl1Pt,
				   VectorType Cyl1Dir,
				   RealType *Cyl1Rad,
				   PointType Cyl2Pt,
				   VectorType Cyl2Dir,
				   RealType *Cyl2Rad);
IPObjectStruct *ConeCylinBisector(PointType Cone1Pt,
				  VectorType Cone1Dir,
				  RealType *Cone1Angle,
				  PointType Cyl2Pt,
				  VectorType Cyl2Dir,
				  RealType *Cyl2Rad);
IPObjectStruct *CurveBisectorSkel2D(IPObjectStruct *CrvObj,
				    RealType *RZeroSet,
				    RealType *RBisectFun,
				    RealType *Tolerance,
				    RealType *RNumerImprove,
				    RealType *RSameNormal);
IPObjectStruct *CurveBisectorSkel3D(IPObjectStruct *CrvObj,
				    RealType *RBisectFun);
IPObjectStruct *CurveAlphaSector(IPObjectStruct *CrvObj, RealType *Alpha);
IPObjectStruct *SurfaceBisectorSkel(IPObjectStruct *CrvObj, PointType Pt);
IPObjectStruct *Skel2D2PrimsInter(IPObjectStruct *Obj1,
				  IPObjectStruct *Obj2,
				  IPObjectStruct *Obj3,
				  RealType *OutExtent,
				  RealType *Eps,
				  RealType *FineNess);
IPObjectStruct *EvalSrfNormalsCone(IPObjectStruct *PSrf);
IPObjectStruct *FreeFormOrthotomic(IPObjectStruct *FreeForm,
				   PointType Pt,
				   RealType *K);
IPObjectStruct *FreeFormSilhouette(IPObjectStruct *Srf,
				   VectorType VDir,
				   RealType *REuclidean);
IPObjectStruct *FreeFormBoundary(IPObjectStruct *PObj);
IPObjectStruct *FreeFormTopoAspectGraph(IPObjectStruct *PSrf);
IPObjectStruct *FreeFormSilhInflections(IPObjectStruct *PSrf,
					VectorType ViewDir,
					RealType *SubdivTol,
					RealType *NumerTol);
IPObjectStruct *FreeFormPolarSilhouette(IPObjectStruct *PSrf,
					VectorType VDir,
					RealType *REuclidean);
IPObjectStruct *FreeFormIsocline(IPObjectStruct *Srf,
				 VectorType VDir,
				 RealType *Theta,
				 RealType *REuclidean,
				 RealType *RMoreLessRgn);
IPObjectStruct *FreeFormPoles(IPObjectStruct *FreeForm);
IPObjectStruct *TrivIsoContourCurvature(IPObjectStruct *TrivObj,
					PointType Pos,
					RealType *RCompute);
IPObjectStruct *MarchCubeVolume(IPObjectStruct *VolumeSpec,
				PointType CubeDim,
				RealType *RSkipFactor,
				RealType *RIsoVal);
IPObjectStruct *PointCoverPolyObj(IPObjectStruct *PolyObj,
				  RealType *Rn,
				  RealType *Dir);
IPObjectStruct *IsoCoverTVObj(IPObjectStruct *TVObj,
			      RealType *RNumStrokes,
			      RealType *RStrokeType,
			      VectorType MinMaxPwrLen,
			      RealType *RStepSize,
			      RealType *RIsoVal,
			      VectorType ViewDir);
IPObjectStruct *LoadVolumeIntoTV(char *FileName,
				 RealType *RDataType,
				 VectorType VolSize,
				 VectorType Orders);
IPObjectStruct *DivideMultivarObject(IPObjectStruct *MVObj,
				     RealType *RDir,
				     RealType *ParamVal);
IPObjectStruct *RegionFromMultivarObject(IPObjectStruct *MVObj, 
					 RealType *RDir,
					 RealType *ParamVal1,
					 RealType *ParamVal2);
IPObjectStruct *RefineMultivarObject(IPObjectStruct *MVObj,
				     RealType *RDir,
				     RealType *RReplace,
				     IPObjectStruct *KnotsObj);
IPObjectStruct *DeriveMultivarObject(IPObjectStruct *MVObj, RealType *Dir);
IPObjectStruct *FreeFormDuality(IPObjectStruct *Obj);
IPObjectStruct *TwoCrvsAlgebraicSum(IPObjectStruct *Crv1Obj,
				    IPObjectStruct *Crv2Obj);
IPObjectStruct *TwoCrvsSwungAlgSum(IPObjectStruct *Crv1Obj,
				   IPObjectStruct *Crv2Obj);
IPObjectStruct *PromoteMultiVar(IPObjectStruct *MVObj, IPObjectStruct *PrmList);
IPObjectStruct *ReverseMultiVar(IPObjectStruct *MVObj,
				RealType *Axis1,
				RealType *Axis2);
IPObjectStruct *MultiVarFromMultiVar(IPObjectStruct *MVObj,
				     RealType *Dir,
				     RealType *t);
IPObjectStruct *MultiVarFromMVMesh(IPObjectStruct *MVObj,
				   RealType *Dir,
				   RealType *Index);
IPObjectStruct *EvalMultiVarObject(IPObjectStruct *MVObj,
				   IPObjectStruct *ParamObjs);
IPObjectStruct *EvalMultiVarZeros(IPObjectStruct *MVListObj,
				  RealType *SubdivTol,
				  RealType *NumerTol);
IPObjectStruct *MergeMVMV(IPObjectStruct *MV1Obj,
			  IPObjectStruct *MV2Obj,
			  RealType *Dir,
			  RealType *RDiscont);
IPObjectStruct *MultivarBisector(IPObjectStruct *MV1Obj,
				 IPObjectStruct *MV2Obj,
				 RealType *ROutputType,
				 RealType *SubdivTol,
				 RealType *NumerTol);
IPObjectStruct *MultivarRayTrap(IPObjectStruct *CrvObjList,
				RealType *SubdivTol,
				RealType *NumerTol);
IPObjectStruct *SurfaceAccessibility(IPObjectStruct *PosSrf,
				     IPObjectStruct *OrientSrf,
				     IPObjectStruct *CheckSrf,
				     IPObjectStruct *AccessDir,
				     RealType *SubdivTol,
				     RealType *NumerTol);
IPObjectStruct *SurfaceFlecnodals(IPObjectStruct *Srf,
				  RealType *SubdivTol,
				  RealType *NumerTol,
				  RealType *MergeTol,
				  RealType *RContactOrder);
IPObjectStruct *SurfaceBiTangents(IPObjectStruct *Srf,
				  RealType *Orientation,
				  RealType *SubdivTol,
				  RealType *NumerTol,
				  RealType *MergeTol);
IPObjectStruct *ConvertMVPtsToCtlPts(MvarPtStruct *MVPts, RealType MergeTol);
IPObjectStruct *ParabolicCurvesOnSrf(IPObjectStruct *PObjSrf,
				     RealType *Euclidean);
IPObjectStruct *SrfFundamentalForms(IPObjectStruct *PObjSrf,
				    RealType *FormNum);
IPObjectStruct *RuledRuledInter(IPObjectStruct *Srf1C1,
				IPObjectStruct *Srf1C2,
				IPObjectStruct *Srf2C1,
				IPObjectStruct *Srf2C2,
				RealType *Tolerance,
				RealType *RZeroSetFunc);
IPObjectStruct *RingRingInter(IPObjectStruct *Srf1C,
			      IPObjectStruct *Srf1r,
			      IPObjectStruct *Srf2C,
			      IPObjectStruct *Srf2r,
			      RealType *Tolerance,
			      RealType *RZeroSetFunc);
IPObjectStruct *CurvesCompare(IPObjectStruct *Crv1Obj,
			      IPObjectStruct *Crv2Obj,
			      RealType *Eps);
IPObjectStruct *GenConicSection(IPObjectStruct *ABCDEFObj,
				RealType *ZLevel,
				RealType *Distance,
				RealType *RCrvEval);
IPObjectStruct *GenEllipse3Points(PointType Pt1,
				  PointType Pt2,
				  PointType Pt3,
				  RealType *Offset);
IPObjectStruct *GenQuadric(IPObjectStruct *ABCDEFGHIJObj);
IPObjectStruct *PromoteConicToQuadric(IPObjectStruct *ABCDEFObj, RealType *Z);
IPObjectStruct *TransformImplicit(RealType *Oper,
				  IPObjectStruct *ABCDEFGHIJObj,
				  IPObjectStruct *TransMat);
IPObjectStruct *WasIsGeometry(IPObjectStruct *Geom,
			      RealType *RIsType,
			      RealType *Eps);
IPObjectStruct *ComputeSmoothPolyNormals(IPObjectStruct *PObj,
					 RealType *MaxAngle);
IPObjectStruct *FixPolyNormals(IPObjectStruct *PObj, RealType *TrustPlNrml);
IPObjectStruct *FixPolyGeometry(IPObjectStruct *PObj,
				RealType *Op,
				RealType *Eps);
IPObjectStruct *BlossomEvaluation(IPObjectStruct *PObj,
				  IPObjectStruct *BlsmVals);
IPObjectStruct *CleanRefinedKnots(IPObjectStruct *CrvObj,
				  RealType *SamplesNum);
IPObjectStruct *RemoveKnots(IPObjectStruct *CrvObj,
			    RealType *GlobalLimit,
			    RealType *IterationLimit,
			    RealType *SamplesNum);
IPObjectStruct *ReflectionLines(IPObjectStruct *SrfObj,
				VectorType ViewDir,
				IPObjectStruct *Lines,
				RealType *Euclidean);
IPObjectStruct *CrvAreaIntergal(IPObjectStruct *CrvObj);
IPObjectStruct *SrfVolumeIntergal(IPObjectStruct *SrfObj,
				  RealType *Method,
				  RealType *Eval);
IPObjectStruct *SrfMomentIntergal(IPObjectStruct *SrfObj,
				  RealType *Moment,
				  RealType *Axis1,
				  RealType *Axis2,
				  RealType *Eval);
IPObjectStruct *RegisterPointSet(IPObjectStruct *PointsSet1,
				 IPObjectStruct *PointsSetSrf2,
				 RealType *AlphaConverge,
				 RealType *Tolerance);
IPObjectStruct *EvalDDMForSrf(IPObjectStruct *Srf,
			      IPObjectStruct *Texture,
			      RealType *DuDup,
			      RealType *DvDup,
			      RealType *LclUVs);
IPObjectStruct *AnalyticSrfFit(IPObjectStruct *UVPts,
			       IPObjectStruct *EucPts,
			       RealType *RFirstAtOrigin,
			       RealType *RFitDegree);
IPObjectStruct *PolyPlaneClipping(IPObjectStruct *Poly, PlaneType Plane);
IPObjectStruct *EvalSurfaceCurvature(IPObjectStruct *PSrf,
				     RealType *U,
				     RealType *V,
				     RealType *REuclidean);
IPObjectStruct *EvalSurfaceAsympDir(IPObjectStruct *PSrf,
				    RealType *U,
				    RealType *V,
				    RealType *REuclidean);
IPObjectStruct *CrvArcLenApprox(IPObjectStruct *PCrv,
				RealType *Fineness,
				RealType *ROrder);
IPObjectStruct *TextWarpThroughSrf(IPObjectStruct *PSrf,
				   char *Txt,
				   RealType *HSpace,
				   RealType *VBase,
				   RealType *VTop,
				   RealType *RLigatures);
IPObjectStruct *BezierRayClipping(PointType RayPt,
				  VectorType RayDir,
				  IPObjectStruct *Srf);
IPObjectStruct *GenPowerMVObject(IPObjectStruct *LensLstObj,
				 IPObjectStruct *PtLstObj);
IPObjectStruct *GenBezierMVObject(IPObjectStruct *LensLstObj,
				  IPObjectStruct *PtLstObj);
IPObjectStruct *GenBsplineMVObject(IPObjectStruct *LensLstObj,
				   IPObjectStruct *OrdersLstObj,
				   IPObjectStruct *PtLstObj,
				   IPObjectStruct *KVLstObj);
IPObjectStruct *SrfUmbilicPts(IPObjectStruct *PSrfObj,
			      RealType *SubTol,
			      RealType *NumTol);
IPObjectStruct *CrvBiArcApprox(IPObjectStruct *PCrv,
			       RealType *Tolerance,
			       RealType *MaxAngle);
IPObjectStruct *DistanceTwoFreeforms(IPObjectStruct *PObj1,
				     IPObjectStruct *PObj2,
				     RealType *RDistType);
IPObjectStruct *FreeformCompareUptoRigidScale2D(IPObjectStruct *PObj1,
						IPObjectStruct *PObj2,
						CagdRType *Eps);
IPObjectStruct *ApproxCrvAsQuadratics(IPObjectStruct *Crv,
				      RealType *Tol,
				      RealType *MaxLen);
IPObjectStruct *ApproxCrvAsCubics(IPObjectStruct *Crv,
				  RealType *Tol,
				  RealType *MaxLen);
IPObjectStruct *ComputeVoronoiCell(IPObjectStruct *CrvObj);

#endif /* FREEFORM_H */
