/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
*   General, visible to others, definitions of Objects module.		     *
*****************************************************************************/

/*****************************************************************************
*   Prototype for visible function in the Objects module.		     *
*****************************************************************************/

#ifndef	OBJECTS_H
#define	OBJECTS_H

void SetUpPredefObjects(void);
void SetObjectAttrColor(IPObjectStruct *PObj, RealType *RColor);
void SetObjectAttrWidth(IPObjectStruct *PObj, RealType *RWidth);
void SetObjectAttrDWidth(IPObjectStruct *PObj, RealType *RDWidth);
void SetObjectAttrib(IPObjectStruct *PObj, char *Name, IPObjectStruct *Data);
void SetObjectAttribProp(IPObjectStruct *PObj,
			 char *Name,
			 IPObjectStruct *Data);
IPObjectStruct *GetObjectAttrib(IPObjectStruct *PObj, char *Name);
void CopyObjectAllAttribs(IPObjectStruct *PDest, IPObjectStruct *PSrc);
void RemoveObjectAttrib(IPObjectStruct *PObj, char *Name);
IPObjectStruct *SetPolyVrtxNormal(IPObjectStruct *PObj,
				  RealType *RVrtxID,
				  IPObjectStruct *Normal);
IPObjectStruct *SetGetPolyVrtxAttrib(IPObjectStruct *PObj,
				     RealType *RVrtxID,
				     char *Name,
				     IPObjectStruct *Data);
int SetDumpLevel(int DumpLvl);
IPObjectStruct *MakeTextGeometry(char *Str,
				 VectorType Spacing,
				 RealType *Scaling);
double ThisObjectIs(char *Name);
void VerifyGlobalObjectList(void);
IPObjectStruct *ReverseListHierarchy(IPObjectStruct *PObj);
void IritObjectPrintf(char *CtlStr, IPObjectStruct *PObjLst);
void IritObjectPrintfSetFile(char *FileName);
IPObjectStruct *EvalAnimationTime(RealType *RTime,
				  IPObjectStruct *Obj,
				  RealType *EvalMats);
double GetObjectSize(IPObjectStruct *ListObj);
double GetMeshSize(IPObjectStruct *ListObj, RealType *RDir);
RealType PolyCountPolys(IPObjectStruct *PObj);
IPObjectStruct *GetNilList(void);
IPObjectStruct *GetNthList(IPObjectStruct *ListObj, RealType *Rn);
IPObjectStruct *RefNthList(IPObjectStruct *ListObj, RealType *Rn);
IPObjectStruct *NthList(IPObjectStruct *ListObj, int n, int Ref);
void SetSubObjectName(IPObjectStruct *PListObj,
		      RealType *RIndex,
		      char *NewName);
IPObjectStruct *GetSubObjectName(IPObjectStruct *PListObj, RealType *RIndex);
void SnocList(IPObjectStruct *PObj, IPObjectStruct *ListObj);
IPObjectStruct *GetObject(char *ObjName);
IPObjectStruct *GetObjectCoord(IPObjectStruct *PObj, RealType *RIndex);
IPObjectStruct *ComputeBBOXObject(IPObjectStruct *PObj);
IPObjectStruct *GenerateInstance(char *InstanceName, IPObjectStruct *InstMat);
IPObjectStruct *ConvertPolysTriangles(IPObjectStruct *PObj, RealType *RRegular);
IPObjectStruct *LimitTrianglesEdgeLen(IPObjectStruct *PTris, RealType *RMaxLen);
IPObjectStruct *ConvertPointsToPolys(IPObjectStruct *PObj, RealType *MaxTol);
void FreeIritObject(IPObjectStruct *PObj);
void DeleteIritObject(IPObjectStruct *PObj, int Free);
void InsertIritObject(IPObjectStruct *PObj, int DelOld);
void InsertIritObjectLast(IPObjectStruct *PObj, int DelOld);
void PrintIritObject(IPObjectStruct *PObj);
char *GetObjectTypeAsString(IPObjectStruct *PObj);
void PrintIritObjectList(IPObjectStruct *PObj);
IPObjectStruct *CoerceIritObjectTo(IPObjectStruct *PObj, RealType *RNewType);
void SaveObjectInFile(char *FileName, IPObjectStruct *PObj);
IPObjectStruct *LoadObjectFromFile(char *FileName);
int LoadSaveObjectParseError(char **ErrorMsg);
IPObjectStruct *GenMatObjectPosDir(PointType Pos,
				   VectorType Dir,
				   VectorType UpDir);
IPObjectStruct *GetMatTransDecomp(IPObjectStruct *Mat);
IPObjectStruct *GenMatObjectGeneric(IPObjectStruct *LstObjList);
IPObjectStruct *GenMatProjectionMat(PlaneType Plane,
				    VectorType EyeDir,
				    RealType *EyeInfinity);
IPObjectStruct *GenMatReflectionMat(PlaneType Plane);

IPObjectStruct *GenBOXObject(VectorType Pt,
			     RealType *WidthX,
			     RealType *WidthY, RealType *WidthZ);
IPObjectStruct *GenGBOXObject(VectorType Pt,
			      VectorType Dir1,
			      VectorType Dir2,
			      VectorType Dir3);
IPObjectStruct *GenCONEObject(VectorType Pt,
			      VectorType Dir,
			      RealType *R,
			      RealType *Bases);
IPObjectStruct *GenCONE2Object(VectorType Pt,
			       VectorType Dir,
			       RealType *R1,
			       RealType *R2,
			       RealType *Bases);
IPObjectStruct *GenCYLINObject(VectorType Pt,
			       VectorType Dir,
			       RealType *R,
			       RealType *Bases);
IPObjectStruct *GenSPHEREObject(VectorType Center, RealType *R);
IPObjectStruct *GenTORUSObject(VectorType Center,
			       VectorType Normal,
			       RealType *Rmajor,
			       RealType *Rminor);
IPObjectStruct *GenPOLYDISKObject(VectorType N, VectorType T, RealType *R);
IPObjectStruct *GenPOLYGONObject(IPObjectStruct *PObjList,
				 RealType * RIsPolyline);
IPObjectStruct *GenObjectFromPolyList(IPObjectStruct *PObjList);
int InsertPolyToPoly(IPObjectStruct *PPoly, IPObjectStruct *PPolys);
IPObjectStruct *GenCROSSECObject(IPObjectStruct *PObj);
IPObjectStruct *GenSURFREVObject(IPObjectStruct *Cross);
IPObjectStruct *GenSURFREVAxisObject(IPObjectStruct *Cross,
				     VectorType Axis);
IPObjectStruct *GenSURFREV2Object(IPObjectStruct *Cross,
				  RealType *StartAngle,
				  RealType *EndAngle);
IPObjectStruct *GenSURFREV2AxisObject(IPObjectStruct *Cross,
				      RealType *StartAngle,
				      RealType *EndAngle,
				      VectorType Axis);
IPObjectStruct *GenEXTRUDEObject(IPObjectStruct *Cross,
				 VectorType Dir,
				 RealType *RBases);
IPObjectStruct *GenDecimatedObject(IPObjectStruct *PPolyObj,
				   RealType *RDecimType,
				   RealType *RThreshold);
IPObjectStruct *PolyCurvatureApprox(IPObjectStruct *PPolyObj,
				    RealType *RNumOfRings,
				    RealType *RCubicFit);
IPObjectStruct *PolyImportanceApprox(IPObjectStruct *PPolyObj,
				     RealType *RGetRange);
IPObjectStruct *TwoPolysMorphing(IPObjectStruct *Pl1,
				 IPObjectStruct *Pl2,
				 RealType *t);
IPObjectStruct *PolyPropFetch(IPObjectStruct *PObj,
			      RealType *RPropType,
			      IPObjectStruct *PropParam);
IPObjectStruct *FitPrim2PolyModel(IPObjectStruct *PObj,
				  RealType *FitType,
				  RealType *Tol,
				  RealType *NumIters);
IPObjectStruct *SetUVsToPolys(IPObjectStruct *PlObj, IPObjectStruct *Scales);
IPObjectStruct *SplitLnkList2ObjList(IPObjectStruct *LnkListObj);
IPObjectStruct *MinSetCover(IPObjectStruct *Set, RealType *Tol);

#endif	/* OBJECTS_H */

