/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Main definition Header file for Irit - the 3d (not only polygonal) sm.     *
*****************************************************************************/

#ifndef	PROGRAM_H
#define	PROGRAM_H

#include <setjmp.h>	/* Used for the long jumps - to main iteration loop. */
#include "irit_sm.h"
#include "cagd_lib.h"	   /* We define curves and surfaces handles as well. */
#include "symb_lib.h"
#include "trim_lib.h"
#include "triv_lib.h"
#include "mvar_lib.h"
#include "allocate.h"
#include "iritprsr.h"
#include "attribut.h"

#define INPUT_LINE_LEN 2500   		/* Input parser maximum line length. */

#define DEFAULT_LOAD_COLOR 1  /* Default colors for object loaded using LOAD */
#define DEFAULT_PRIM_COLOR 4  /* primitives colors, respectively.	     */

#define DEFAULT_RESOLUTION	20	/* Used in Primitiv/Boolean modules. */
#define DEFAULT_DRAW_CTLPT	FALSE	/* If control mesh/poly to be drawn. */
#define DEFAULT_ECHOSRC		TRUE	            /* Echo sourced program? */
#define DEFAULT_DUMPLVL		1		        /* Min. information. */

#define MACHINE_MSDOS		1
#define MACHINE_SGI		2
#define MACHINE_HP		3
#define MACHINE_APOLLO		4
#define MACHINE_SUN		5
#define MACHINE_UNIX		6
#define MACHINE_IBMOS2		7
#define MACHINE_IBMNT		8
#define MACHINE_AMIGA		9

#define KV_MIN_LEGAL		-9999
#define KV_UNIFORM_OPEN		-10000
#define KV_UNIFORM_FLOAT	-10001
#define KV_UNIFORM_PERIODIC	-10002
#define KV_UNIFORM_DISCONT_OPEN	-10003

#define FF_BEZIER_TYPE		5001
#define FF_BSPLINE_TYPE		5002
#define FF_POWER_TYPE		5003
#define FF_GREGORY_TYPE		5004

#define IRIT_PROMPT	"Irit> "

#define GUI_PROMPT	"<<GUI>> "

#ifdef IRIT_QUIET_STRINGS
#define IRIT_WNDW_FPRINTF2(p1, p2)
#define IRIT_WNDW_FPRINTF3(p1, p2, p3)
#define IRIT_WNDW_FPRINTF4(p1, p2, p3, p4)
#define IRIT_WNDW_FPRINTF5(p1, p2, p3, p4, p5)
#define IRIT_WNDW_PUT_STR(Str)
#define IRIT_WNDW_PUT_STR2(Str)
#define IRIT_NON_FATAL_ERROR(Str)			IritQuietError()
#define IRIT_NON_FATAL_ERROR2(Str, p2)			IritQuietError()
#define IRIT_NON_FATAL_ERROR3(Str, p2, p3)		IritQuietError()
#define IRIT_NON_FATAL_ERROR4(Str, p2, p3, p4)		IritQuietError()
#define IRIT_NON_FATAL_ERROR5(Str, p2, p3, p4, p5)	IritQuietError()
#else
#define IRIT_WNDW_FPRINTF2		IritWndwFprintf
#define IRIT_WNDW_FPRINTF3		IritWndwFprintf
#define IRIT_WNDW_FPRINTF4		IritWndwFprintf
#define IRIT_WNDW_FPRINTF5		IritWndwFprintf
#define IRIT_WNDW_PUT_STR(Str)		IritWndwPutStr(Str)
#define IRIT_WNDW_PUT_STR2(Str)		IritWndwPutStr2(Str)
#define IRIT_NON_FATAL_ERROR		IritNonFatalError
#define IRIT_NON_FATAL_ERROR2		IritNonFatalError
#define IRIT_NON_FATAL_ERROR3		IritNonFatalError
#define IRIT_NON_FATAL_ERROR4		IritNonFatalError
#define IRIT_NON_FATAL_ERROR5		IritNonFatalError
#endif /* IRIT_QUIET_STRINGS */

extern GLOBAL_DATA IPObjectStruct
    *GlblObjList;				   /* All objects on system. */

extern GLOBAL_DATA jmp_buf
    GlblLongJumpBuffer;			          /* Used in error recovery. */

extern GLOBAL_DATA FILE
    *GlblLogFile;		   /* If do log everything, it goes to here. */

extern GLOBAL_DATA int
#ifdef DJGCC		     		   /* Defaults for intr_lib windows. */
    GlblWindowFrameWidth,
    GlblViewFrameColor,
    GlblViewBackColor,
    GlblTransFrameColor,
    GlblTransBackColor,
    GlblStatusFrameColor,
    GlblStatusBackColor,
    GlblInputFrameColor,
    GlblInputBackColor,
    GlblDrawHeader,
    GlblSmoothTextScroll,
    GlblIntrSaveMethod,
    GlblMouseSensitivity,	     /* Sensitivity control of mouse device. */
    GlblJoystickExists,
#endif /* DJGCC */
    GlblCurrentDisplay,            /* Handlers to streams to display device. */
    GlblFlatLoadMode,          /* Hierarchy flattening in "load" operations. */
    GlblHandleDependencies,
    GlblStdinInteractive,
    GlblInterpProd,
    GlblLoadColor,	      /* Default colors for object loaded using LOAD */
    GlblPrimColor,	       /* primitives colors, respectively.	     */
    GlblDoGraphics,		/* Control if running in graphics/text mode. */
    GlblGUIMode,				     /* Running under a GUI. */
    GlblFatalError,		  /* True if disaster in system - must quit! */
    GlblPrintLogFile,		     /* If TRUE everything goes to log file. */
    GlblPointLenAux;

extern GLOBAL_DATA char 
#ifdef DJGCC			     /* Defaults for DJGCC intr_lib windows. */
    *GlblViewWndwPos,
    *GlblTransWndwPos,
    *GlblStatusWndwPos,
    *GlblInputWndwPos,
    *GlblIntrSaveDisk,
#endif /* DJGCC */
    *GlblHelpFileName,
    *GlblLineEditControl,
    *GlblStartFileName,			/* Name of startup file to executed. */
    *GlblLogFileName,					/* Name of log file. */
    *GlblFloatFormat;	      /* Controls the ways real numbers are printed. */

extern GLOBAL_DATA RealType
    GlblPointLen;			       /* Scaler for point if drawn. */

void ExecOneLine(char *Line);
IPObjectStruct *SetIritState(char *Name, IPObjectStruct *Data);
IPObjectStruct *IritPickCrsrClientEvent(RealType *RWaitTime);
#ifdef USE_VARARGS
void IritNonFatalError(char *va_alist, ...);
#else
void IritNonFatalError(char *Format, ...);
#endif /* USE_VARARGS */
void IritQuietError();
void IritIdleFunction(int MiliSeconds);
void IritInputWindowGetStr(char *Str, int Length);
void IritReset(void);
void IritExit0(void);
void IritExit(int ExitCode);
void DefaultFPEHandler(int Type);

/* Prototypes of the I/O window functions: */

char *WndwGetLineStdin(char *Line, char *Prompt, int MaxLen);
void WndwLogPrint(IPObjectStruct *Set);
void IritWndwPutStr(char *Msg);
void IritWndwPutStr2(char *Msg);
#ifdef USE_VARARGS
void IritWndwFprintf(char *va_alist, ...);
#else
void IritWndwFprintf(char *Format, ...);
#endif /* USE_VARARGS */
IPObjectStruct *WndwInputStdinObject(RealType *Type);
void WndwViewSetDisplay(void);
void WndwSetCrntDisplay(RealType *Ri);
void WndwViewObject(IPObjectStruct *PObj);
void WndwViewClearScreen(void);
void WndwViewSaveMatrix(char *FileName);
void WndwViewDisconnect(void);
void WndwViewExit(void);
double ClientExecute(char *PrgmName);
void ClientClose(RealType *RHandler, int KillClient);
IPObjectStruct *ClientRead(RealType *RHandler, RealType *RBlock);
IPObjectStruct *ClientCursor(RealType *RWaitTime);
void ClientWrite(RealType *RHandler, IPObjectStruct *PObj);


#endif	/* PROGRAM_H */
