#
# The XXX_DIR variables below MUST have ABSOLUTE path. Since this file
# is sourced from several directories relative path specification will
# be simple wrong.
#

SRC_DIR = Work:T/irit70/src

#
# All libraries created will be installed into the LIB_DIR directory.
#
LIB_DIR = $(SRC_DIR)/lib

#
# All includes files associated with the installed libraries will be
# installed into the INC_DIR directory.
#
INC_DIR = $(SRC_DIR)/include

#
# All binaries created will be installed into the BIN_DIR directory.
#
BIN_DIR = $(SRC_DIR)/bin

#
# Location of object file to resolve circularities in libraries.
#
CIRCLINK = $(SRC_DIR)/circlink/circlink.o

#
# The scan converter (irender) needs the Utah Raster Toolkit (URT) library
# to read/write image data. You can ftp it in cs.utah.edu.
#
#   Make these empty if you would like to give up on irender's compilation.
#
# URT = /usr/local/apps/urt/urt3.0
# URT_INC = IDIR=$(URT)/include
URT_LIB = LIB:rle.lib
URT_FLAGS = DEFINE=HAVE_URT_RLE=1 DEFINE=URT_OLD_COMPAT=1

#
# Uncomment the correct set of variables to be used or modify it for
# your system.
#
# -D flags:
#
# -D__GL__ - if your system supports gl graphics library (SGI 4d & IBM R6000).
#
# -D__X11__ - if your system supports X11. Only one of __GL__ or __X11__ should
#	be used.
#
#  Emulation to the following function are available by defining the
#  following. Look at misc_lib/xgeneral.c/h for implementation.
# -DGETCWD - if getcwd is not defined in this system.
# -DSTRSTR - if strstr is not defined in this system.
# -DSTRDUP - if strdup is not defined in this system.
# -DSTRICMP - if stricmp and strincmp are not defined in this system.
#
# -DTIMES - if times is defined in your system, otherwise uses time.
#
# -DRAND - if the (s)rand random number generator exists.
# -DRAND48 - ?rand48 random number generators exists.
#	If non of RAND or RAND48 are defined, (s)random is used.
#
# Unfortunately, there is no one Unix function to do subseconds' sleep.
# -DUSLEEP - if usleep is defined in the system.
# -DSGINAP - on sgi systems instead of usleep.
# -DUSLEEP_SELECT - do the usleep using the 'select' unix call.
# -DITIMERVAL - when all the above fails, try this.
#
# -DNO_VOID_PTR - if your C compiler does not support (void *).
#
# -DUSE_VARARGS - if your system does not have stdarg.h and have the old
#	varargs.h.
#
# -DNO_CONCAT_STR - if 'char *p = "This is" "one string";' is illegal.
#
# -DGRAPDRVS - any combination of of 'xgldrvs', 'xgladap', 'x11drvs'.
#
# -DMAKE_REAL_FLOAT - force real number to be float and not double.
#               Expect problems as it is not really tested.
#
# -DURT_INC and -DURT_LIB - library and include of the utah raster toolkit.
#               This library is used by irender to save images in rle format.
#
# -DHAVE_URT_RLE - if irender can use the URT RLE package. That is URT_INC/
#               URT_LIB are properly set.
#
# Other, possibly useful defines (for c code development):
#
# -DDEBUG - for some debugging functions in the code (that can be invoked
#		from a debugger).
#

#
# Flags for Amiga using gcc
#
CC = sc
DFLAGS = DEFINE=RAND48 DEFINE=USLEEP DEFINE=GRAPDRVS=amidrvs DEFINE=HAVE_URT_RLE
CPUFLAGS = CPU=68040 MATH=68882
CFLAGS = STACKEXT STRMERGE DATA=FAR CODE=FAR $(DFLAGS) $(CPUFLAGS)
MATHLIB = LIB:scm881.lib
SYMS = ND
MOREFLAGS =
MORELIBS = 

#
# Default rule for compilation.
#
.c.o:
	$(CC) $(CFLAGS) $(URT_FLAGS) $(MORE_FLAGS) IDIR= IDIR=$(INC_DIR) \
	IDIR=$(SRC_DIR)/amigalib $(URT_INC) $<

#
# All libraries.
#
LIBS = $(CIRCLINK) $(URT_LIB) \
$(LIB_DIR)/rndr.lib $(LIB_DIR)/user.lib $(LIB_DIR)/bool.lib \
$(LIB_DIR)/prsr.lib $(LIB_DIR)/mdl.lib $(LIB_DIR)/mvar.lib \
$(LIB_DIR)/trim.lib $(LIB_DIR)/triv.lib $(LIB_DIR)/trng.lib \
$(LIB_DIR)/symb.lib $(LIB_DIR)/cagd.lib $(LIB_DIR)/geom.lib \
$(LIB_DIR)/misc.lib $(LIB_DIR)/xtra.lib $(LIB_DIR)/amg.lib #$(LIB_DIR)/gif.lib
