/*****************************************************************************
* MdlCnvrt.c - model conversion routines.				     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by Gershon Elber	       		      	    January 1998     *
*****************************************************************************/

#include "mdl_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
*   Converting the model into the list of trimming surfaces with reduced     M
*   number points for trimming curves.                                       M
*                                                                            *
* PARAMETERS:                                                                M
*   Model:  Model to convert to a list of trimmed surfaces.                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   TrimSrfStruct *:  List of trimming surfaces.                             M
*                                                                            *
* SEE ALSO:                                                                  M
*   TrimCrvSegNew, TrimCrvNew, TrimsrfNew, MdlExtractUVCrv		     M
*                                                                            *
* KEYWORDS:                                                                  M
*   MdlTrimConvert                                                           M
*****************************************************************************/
TrimSrfStruct *MdlTrimConvert(MdlModelStruct *Model)
{
    int IsFirstSeg, IsFirstCrv, Length,
	IsFirstSrf = TRUE,
	MdlUVCrvReduce = 40;
    TrimSrfStruct *CurrSrf,
	*TrimSrfs = NULL;
    CagdSrfStruct *Srf;
    CagdCrvStruct *SegCrv;
    TrimCrvStruct *FirstCrv, *CurrCrv;
    TrimCrvSegStruct *FirstSeg, *CurrSeg;
    MdlLoopStruct *MdlLoop;
    MdlTrimSegRefStruct *MdlRef;
    MdlTrimSegStruct *MdlSeg;
    MdlTrimSrfStruct    
	*MdlSrf = Model -> TrimSrfList;

    while (MdlSrf) {
	Srf = MdlSrf -> Srf;
	MdlLoop = MdlSrf -> LoopList;
	IsFirstCrv = TRUE;

	while (MdlLoop) { 
	    MdlRef = MdlLoop -> SegRefList;
	    IsFirstSeg = TRUE;

	    while (MdlRef) {
		MdlSeg = MdlRef -> TrimSeg;
		SegCrv = CagdCrvCopy(MdlExtractUVCrv(MdlSrf, MdlSeg));
		Length = SegCrv -> Length;

		if (APX_EQ(SegCrv -> Points[1][0],
			   SegCrv -> Points[1][Length - 1]) &&
		    APX_EQ(SegCrv -> Points[2][0],
			   SegCrv -> Points[2][Length - 1])) {
		    SegCrv -> Points[1][Length - 1] = SegCrv -> Points[1][0];
		    SegCrv -> Points[2][Length - 1] = SegCrv -> Points[2][0];
		}

		if (IsFirstSeg) {
		    IsFirstSeg = FALSE;
		    FirstSeg = CurrSeg = TrimCrvSegNew(SegCrv, NULL);
		}
		else { 
		    CurrSeg -> Pnext =
			TrimCrvSegNew(SegCrv, NULL);
 
		    CurrSeg = CurrSeg -> Pnext;
		}
		MdlRef = MdlRef -> Pnext;
	    }

	    if (IsFirstCrv) {
		IsFirstCrv = FALSE;
		FirstCrv = CurrCrv = TrimCrvNew(FirstSeg);
	    }
	    else {
		CurrCrv -> Pnext = TrimCrvNew(FirstSeg);
		CurrCrv = CurrCrv -> Pnext;
	    }
	    MdlLoop = MdlLoop -> Pnext;
	}

	if (IsFirstSrf) {
	    IsFirstSrf = FALSE;
	    TrimSrfs = CurrSrf = TrimSrfNew(CagdSrfCopy(Srf), FirstCrv, TRUE);
	}
	else {
	    CurrSrf -> Pnext = TrimSrfNew(CagdSrfCopy(Srf), FirstCrv, TRUE); 
	    CurrSrf = CurrSrf -> Pnext;
	} 
	MdlSrf = MdlSrf -> Pnext;
    }			    

    return TrimSrfs;
}

/*****************************************************************************
* DESCRIPTION:                                                               M
*   Extracting the UV curve from MdlTrimSegStruct depending on the position  M
* of the current model surface.			                             M
*                                                                            *
* PARAMETERS:                                                                M
*   MdlSrf: Model's trimming surface.                                        M
*   MdlSeg: Model's trimming curve segment.                                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   CagdCrvStruct *: Extracted UV curve.                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   MdlExtractUVCrv                                                          M
*****************************************************************************/
CagdCrvStruct *MdlExtractUVCrv(MdlTrimSrfStruct *MdlSrf, 
			       MdlTrimSegStruct *MdlSeg)
{
    if (MdlSeg -> SrfFirst -> Srf == MdlSrf -> Srf)
        return MdlSeg -> UVCrvFirst;
    else {
        if (MdlSeg -> SrfSecond -> Srf == MdlSrf -> Srf)
	    return MdlSeg -> UVCrvSecond;
        else 
	    return NULL;
    }
} 
