/*****************************************************************************
* Default warning error handler for irit.				     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 0.2, April 1993  *
*****************************************************************************/

#include <stdio.h>
#include "irit_sm.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Default trap for IRIT programs for irit warning errors.		     M
*   This function just prints the given error message.			     M
*                                                                            *
* PARAMETERS:                                                                M
*   Msg:       Error message to print.                                       M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   IritWarningError, error trap                                             M
*****************************************************************************/
void IritWarningError(char *Msg)
{
    fprintf(stderr, IRIT_EXP_STR("Irit Warning: %s\n"), Msg);
}
