/******************************************************************************
* Mvar_err.c - handler for all mvar library fatal errors.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, May. 97.					      *
******************************************************************************/

#include "mvar_loc.h"

typedef struct MvarErrorStruct {
    MvarFatalErrorType ErrorNum;
    char *ErrorDesc;
} MvarErrorStruct;

STATIC_DATA MvarErrorStruct ErrMsgs[] =
{
    { MVAR_ERR_DIR_NOT_VALID,	"Dir is not valid" },
    { MVAR_ERR_UNDEF_CRV,	"Undefined curve type" },
    { MVAR_ERR_UNDEF_SRF,	"Undefined surface type" },
    { MVAR_ERR_UNDEF_CRV,	"Undefined curve type" },
    { MVAR_ERR_UNDEF_MVAR,	"Undefined multi-variate type" },
    { MVAR_ERR_UNDEF_GEOM,	"Undefined geometry type" },
    { MVAR_ERR_GEOM_NO_SUPPORT, "Given geometry is not supported" },
    { MVAR_ERR_RATIONAL_NO_SUPPORT, "Rational function is not supported" },
    { MVAR_ERR_RATIONAL_EXPECTED,"Rational function expected" },
    { MVAR_ERR_WRONG_ORDER,	"Provided order is wrong" },
    { MVAR_ERR_KNOT_NOT_ORDERED,"Provided knots are not in ascending order" },
    { MVAR_ERR_NUM_KNOT_MISMATCH,"Number of knots does not match" },
    { MVAR_ERR_INDEX_NOT_IN_MESH,"Index is out of mesh range" },
    { MVAR_ERR_POWER_NO_SUPPORT,"Power basis type is not supported" },
    { MVAR_ERR_WRONG_DOMAIN,	"Given parameter is not in domain" },
    { MVAR_ERR_INCONS_DOMAIN,	"Inconsistent domain (must be between zero and length)" },
    { MVAR_ERR_SCALAR_PT_EXPECTED,"A scalar field multivariate is expected." },
    { MVAR_ERR_INVALID_AXIS,     "Invalid axis specification." },
    { MVAR_ERR_NO_CLOSED_POLYGON,"Failed to form a closed polygon." },
    { MVAR_ERR_TWO_INTERSECTIONS,"Should have found two intersections only." },
    { MVAR_ERR_NO_MATCH_PAIR,    "Cannot find matching pairs." },
    { MVAR_ERR_FAIL_READ_FILE,	 "Failed to read from given file." },
    { MVAR_ERR_INVALID_STROKE_TYPE,"Invalid stroke type requested." },
    { MVAR_ERR_READ_FAIL,	 "Failed to read from file" },
    { MVAR_ERR_MVS_INCOMPATIBLE, "Mvariates are incompatible" },
    { MVAR_ERR_PT_OR_LEN_MISMATCH,"PtType or Length mismatch" },
    { MVAR_ERR_TOO_FEW_PARAMS,	 "Not enough parameters to compute" },
    { MVAR_ERR_TOO_MANY_PARAMS,	 "Too many parameters to compute" },
    { MVAR_ERR_FAIL_CMPT,	 "Failed multivariate compatibility" },
    { MVAR_ERR_NO_CROSS_PROD,    "Must be at least E3 for a Cross product" }, 
    { MVAR_ERR_BEZIER_EXPECTED,  "Multivariate Bezier expected" },
    { MVAR_ERR_BSPLINE_EXPECTED, "Multivariate Bspline expected" },
    { MVAR_ERR_SAME_GTYPE_EXPECTED,"Multivariate of same geom type expected" },
    { MVAR_ERR_ONE_OR_THREE_EXPECTED, "Expected either one or three multivariate(s)" },
    { MVAR_ERR_POWER_EXPECTED,   "Multivariate power basis expected" },
    { MVAR_ERR_MSC_TOO_FEW_OBJ,  "Attempting to compute spanning circle to too few entities" },
    { MVAR_ERR_MSC_FAILED,	 "Minimum spanning circle failed" },
    { MVAR_ERR_SCALAR_EXPECTED,  "A scalar field expected" },
    { MVAR_ERR_DIM_TOO_HIGH,     "Dimension of multivariate too high" },
    { MVAR_ERR_INVALID_MV,	 "Multivariate is invalid" },

    { MVAR_ERR_UNDEFINE_ERR,	NULL }
};

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a string describing a the given error. Errors can be raised by     M
* any member of this mvar library as well as other users. Raised error will  M
* cause an invokation of MvarFatalError function which decides how to handle M
* this error. MvarFatalError can for example, invoke this routine with the   M
* error type, print the appropriate message and quit the program.            M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrorNum:   Type of the error that was raised.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   char *:     A string describing the error type.                          M
*                                                                            *
* KEYWORDS:                                                                  M
*   MvarDescribeError, error handling                                        M
*****************************************************************************/
char *MvarDescribeError(MvarFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
