#ifndef _STENCIL_H_
#define _STENCIL_H_

#include "rndr_loc.h"

typedef struct StencilConfigStruct {
    IRndrFuncType Func;
    int Ref;
    unsigned Mask;

    IRndrOpType OpFail;
    IRndrOpType OpZFail;
    IRndrOpType OpZPass;

} StencilConfigStruct;

IRndrBoolType StencilTest(StencilConfigStruct* StencilCfg,
                          int Stencil);

void StencilOpFail(StencilConfigStruct* StencilCfg,
                   int *StencilPtr);

void StencilOpZFail(StencilConfigStruct* StencilCfg,
                    int *StencilPtr);

void StencilOpZPass(StencilConfigStruct* StencilCfg,
                    int *StencilPtr);

#endif /* _STENCIL_H_ */
