/******************************************************************************
* Symb_ftl.c - default FatalError function for the symb library.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, April. 93.					      *
******************************************************************************/

#include <stdio.h>
#include "symb_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Trap Symb_lib errors right here. Provides a default error handler for the  M
* symb library. Gets an error description using SymbDescribeError, prints it M
* and exit the program using exit.                                           M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrID:      Error type that was raised.                                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   SymbFatalError, error handling                                           M
*****************************************************************************/
void SymbFatalError(SymbFatalErrorType ErrID)
{
    char
	*ErrorMsg = SymbDescribeError(ErrID);

    fprintf(stderr, IRIT_EXP_STR("SYMB_LIB: %s\n"), ErrorMsg);

    exit(-1);
}
