/******************************************************************************
* User_err.c - handler for all user library fatal errors.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, May. 91.					      *
******************************************************************************/

#include "irit_sm.h"
#include "user_loc.h"

typedef struct UserErrorStruct {
    UserFatalErrorType ErrorNum;
    char *ErrorDesc;
} UserErrorStruct;

STATIC_DATA UserErrorStruct ErrMsgs[] =
{
    { USER_ERR_WRONG_SRF,		"Provided surface type is wrong" },
    { USER_ERR_MISSING_ATTRIB,		"Missing attribute that must be here" },
    { USER_ERR_WRONG_ANGLE,		"Given angle is out of range" },
    { USER_ERR_INVALID_PLANE,		"Invalid plane equation" },
    { USER_ERR_RATIONAL_NO_SUPPORT,	"Rational function is not supported" },
    { USER_ERR_NON_CRV_OBJ_IN_FONT,     "A non curve object found in font" },
    { USER_ERR_NO_ADJ_INFO,		"No polygonal adjacency information found" },
    { USER_ERR_NO_NRML_INFO,		"No polygonal normal information found" },
    { USER_ERR_NO_CRVTR_INFO,		"No polygonal curvature information found" },
    { USER_ERR_EXPCT_REG_TRIANG,	"Expecting regular triangles only" },
    { USER_ERR_EXPCT_POLY_OBJ,		"Expecting a poly object" },
    { USER_ERR_EXPCT_SRF_OBJ,		"Expecting a surface object" },
    { USER_ERR_EXPCT_VRTX_NRMLS,	"Expecting vertices' normal" },
    { USER_ERR_EXPCT_VRTX_UVS,		"Expecting vertices' UV params." },

    { USER_ERR_UNDEFINE_ERR,		NULL }
};

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a string describing a the given error. Errors can be raised by     M
* any member of this user library as well as other users. Raised error will  M
* cause an invokation of UserFatalError function which decides how to handle M
* this error. UserFatalError can for example, invoke this routine with the   M
* error type, print the appropriate message and quit the program.            M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrorNum:   Type of the error that was raised.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   char *:     A string describing the error type.                          M
*                                                                            *
* KEYWORDS:                                                                  M
*   UserDescribeError, error handling                                        M
*****************************************************************************/
char *UserDescribeError(UserFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
