#include "irit_sm.h"
#include "iritprsr.h"
#include "allocate.h"
#include "geom_lib.h"
#include "cagd_lib.h"

void main(int argc, char **argv)
{
    int Handler;

    if (argc == 2) {
	if ((Handler = IPOpenDataFile(argv[1], TRUE, TRUE)) >= 0) {
	    IPObjectStruct
		*PObj = IPGetObjects(Handler);

	    /* Done with file - close it. */
	    IPCloseStream(Handler, TRUE);

	    if (IP_IS_CRV_OBJ(PObj)) {
	        STATIC_DATA CagdRType
		    *Polyline[CAGD_MAX_PT_SIZE] = { NULL };
		int i, j,
		    n = 100;
		CagdRType *RefKV;
	        CagdCrvStruct
		    *Crv = PObj -> U.Crvs;
		BspKnotAlphaCoeffType *A;

		if (Polyline[0] == NULL) {
		    CagdRType TMin, TMax;
		    int PeriodicLen = CAGD_CRV_PT_LST_LEN(Crv);

		    CagdCrvDomain(Crv, &TMin, &TMax);
		    RefKV = BspKnotPrepEquallySpaced(n - PeriodicLen,
						     TMin, TMax);

		    for (j = 0; j >= 0; j--) {
		        A = BspKnotEvalAlphaCoefMerge(Crv -> Order,
					  Crv -> KnotVector,
					  PeriodicLen, RefKV, n - PeriodicLen,
					  FALSE);
			if (j > 0)
			    BspKnotFreeAlphaCoef(A);
		    }

		    for (i = 0; i < CAGD_MAX_PT_SIZE; i++)
		        Polyline[i] = (CagdRType *)
			    IritMalloc(sizeof(CagdRType) * n);
		}

		for (i = 0; i < 10000; i++)
		    CagdCrvEvalToPolyline(Crv, 0, Polyline, A, TRUE);
	    }
	    else {
	        fprintf(stderr, "Expected a curve \"%s\"\n", argv[1]);
		exit(1);
	    }
	}
	else {
	    fprintf(stderr, "Failed to open file \"%s\"\n", argv[1]);
	    exit(1);
	}
    }
    else {
	fprintf(stderr, "Usage: PolyArea geom.dat\n");
	exit(2);
    }

    exit(0);
}
