/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CImage;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public class CColorPaint
extends Color {
    public static final long serialVersionUID = -7032883349756409272L;
    private transient long fNSColor = 0L;

    public CColorPaint(long l2) {
        super(0, 0, 0);
        this.setNSColor(l2);
    }

    public CColorPaint(TexturePaint texturePaint) {
        super(0, 0, 0);
        CImage cImage = new CImage(texturePaint.getImage());
        this.setColorFromCImage(cImage);
        cImage.dispose();
    }

    public CColorPaint(CImage cImage) {
        super(0, 0, 0);
        this.setColorFromCImage(cImage);
    }

    public CColorPaint(long l2, int n2, int n3, int n4) {
        super(n2, n3, n4);
        this.setNSColor(l2);
    }

    public int getRGB() {
        int n2 = CColorPaint.getNativeRGB(this.fNSColor);
        if ((n2 & 0xFF000000) == 0) {
            n2 = super.getRGB();
        }
        return n2;
    }

    private void setColorFromCImage(CImage cImage) {
        long l2 = this.pattern(cImage.d());
        this.setNSColor(l2);
    }

    private synchronized void setNSColor(long l2) {
        if (this.fNSColor != 0L) {
            this._release(this.fNSColor);
        }
        this.fNSColor = l2;
    }

    public synchronized void dispose() {
        if (this.fNSColor != 0L) {
            this._release(this.fNSColor);
            this.fNSColor = 0L;
        }
    }

    private native void _release(long var1);

    public synchronized long a() {
        return this.fNSColor;
    }

    public void finalize() {
        this.dispose();
    }

    public synchronized boolean equals(Object object) {
        return object instanceof CColorPaint && ((CColorPaint)object).fNSColor == this.fNSColor;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        throw new IllegalAccessError("createContext() not valid for CColorPaint");
    }

    public int getTransparency() {
        return 3;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte[] byArray;
        int n2;
        int n3 = objectInputStream.readInt();
        this.fNSColor = 0L;
        if (n3 > 0 && (n2 = objectInputStream.read(byArray = new byte[n3], 0, n3)) == n3) {
            this.fNSColor = CColorPaint.unarchive(byArray, n3);
        }
        objectInputStream.defaultReadObject();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = CColorPaint.archive(this.fNSColor);
        if (byArray != null) {
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        } else {
            objectOutputStream.writeInt(0);
        }
        objectOutputStream.defaultWriteObject();
    }

    private native long pattern(long var1);

    private static native byte[] archive(long var0);

    private static native long unarchive(byte[] var0, int var1);

    private static native int getNativeRGB(long var0);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

