/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CSurfaceData;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.TextPipe;

public class CompositeCRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
DrawImagePipe,
TextPipe {
    public final boolean DEBUG = false;
    public final boolean DEBUG_PASS_THROUGH = false;
    private final int kCompositingBoundsPadX = 1;
    private final int kCompositingBoundsPadY = 1;
    public SunGraphics2D d;
    public PixelDrawPipe e;
    public PixelFillPipe c;
    public ShapeDrawPipe a;
    public DrawImagePipe g;
    public TextPipe f;
    public static final AffineTransform b = new AffineTransform();

    public CompositeCRenderer() {
    }

    public CompositeCRenderer(SunGraphics2D sunGraphics2D) {
        this.link(sunGraphics2D);
    }

    public void link(SunGraphics2D sunGraphics2D) {
        this.d = sunGraphics2D;
        this.e = sunGraphics2D.drawpipe;
        sunGraphics2D.drawpipe = this;
        this.c = sunGraphics2D.fillpipe;
        sunGraphics2D.fillpipe = this;
        this.a = sunGraphics2D.shapepipe;
        sunGraphics2D.shapepipe = this;
        this.g = sunGraphics2D.imagepipe;
        sunGraphics2D.imagepipe = this;
        this.f = sunGraphics2D.textpipe;
        sunGraphics2D.textpipe = this;
    }

    public void unlink() {
        if (this.d == null) {
            InternalError internalError = new InternalError("CompositeCRenderer.unlink: not in use - this is likely an error:");
            internalError.printStackTrace();
        }
        if (this.d != null) {
            this.d.drawpipe = this.e;
            this.e = null;
            this.d.fillpipe = this.c;
            this.c = null;
            this.d.shapepipe = this.a;
            this.a = null;
            this.d.imagepipe = this.g;
            this.g = null;
            this.d.textpipe = this.f;
            this.f = null;
            this.d = null;
        }
    }

    public void dispose() {
        if (this.d != null) {
            this.unlink();
        }
    }

    public void drawLine(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, n2, n3, n4, n5);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawLine(n2, n3, n4, n5);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void drawRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        if (n4 * n5 > 2048) {
            if (sunGraphics2D.transformState <= 2) {
                this.drawLine(sunGraphics2D, n2, n3, n2 + n4, n3);
                this.drawLine(sunGraphics2D, n2 + n4, n3, n2 + n4, n3 + n5);
                this.drawLine(sunGraphics2D, n2 + n4, n3 + n5, n2, n3 + n5);
                this.drawLine(sunGraphics2D, n2, n3 + n5, n2, n3);
                return;
            }
        }
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, true);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawRect(n2, n3, n4, n5);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, true);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawRoundRect(n2, n3, n4, n5, n6, n7);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void drawOval(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, true);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawOval(n2, n3, n4, n5);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void drawArc(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, true);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawArc(n2, n3, n4, n5, n6, n7);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, nArray, nArray2, n2, true, false);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawPolyline(nArray, nArray2, n2);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, nArray, nArray2, n2, true, true);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawPolygon(nArray, nArray2, n2);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void fillRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.fillRect(n2, n3, n4, n5);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.fillRoundRect(n2, n3, n4, n5, n6, n7);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.fillOval(n2, n3, n4, n5);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void fillArc(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.fillArc(n2, n3, n4, n5, n6, n7);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, nArray, nArray2, n2, false, true);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle);
            graphics2D.fillPolygon(nArray, nArray2, n2);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, shape, true);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForStroke(sunGraphics2D, graphics2D, rectangle);
            graphics2D.draw(shape);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.beginCompositingOp();
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, shape, false);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle);
            graphics2D.fill(shape);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        boolean bl2 = true;
        this.beginCompositingOp();
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (n4 == -1 || n5 == -1) {
            bl2 = this.waitForValidImageDimensions(image);
            n4 = image.getWidth(null);
            n5 = image.getHeight(null);
        }
        if (bl2) {
            Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
            Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
            if (rectangle2.width > 0 && rectangle2.height > 0) {
                BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle2);
                graphics2D.drawImage(image, n2, n3, color, imageObserver);
                graphics2D.dispose();
                this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
            }
        }
        this.endCompositingOp();
        return bl2;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, Color color, ImageObserver imageObserver) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n6, n7);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawImage(image, n2, n3, n2 + n6, n3 + n7, n4, n5, n4 + n6, n4 + n7, color, imageObserver);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawImage(image, n2, n3, n4, n5, color, imageObserver);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        this.beginCompositingOp();
        Rectangle rectangle = new Rectangle(Math.min(n2, n4), Math.min(n3, n5), Math.abs(n4 - n2), Math.abs(n5 - n3));
        Rectangle rectangle2 = this.getCompositingBounds(sunGraphics2D, rectangle, false);
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle2);
            graphics2D.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, color, imageObserver);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle2);
        }
        this.endCompositingOp();
        return true;
    }

    public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl2 = this.doTransformImage(sunGraphics2D, image, affineTransform, null, imageObserver);
        return bl2;
    }

    public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n2, n3);
        this.doTransformImage(sunGraphics2D, bufferedImage, affineTransform, bufferedImageOp, null);
    }

    public boolean doTransformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, ImageObserver imageObserver) {
        boolean bl2 = true;
        this.beginCompositingOp();
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        if (n2 == -1 || n3 == -1) {
            bl2 = this.waitForValidImageDimensions(image);
            n2 = image.getWidth(null);
            n3 = image.getHeight(null);
        }
        if (bl2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(n2, 0.0f);
            generalPath.lineTo(n2, n3);
            generalPath.lineTo(0.0f, n3);
            generalPath.closePath();
            AffineTransform affineTransform2 = sunGraphics2D.getTransform();
            generalPath.transform(affineTransform);
            generalPath.transform(affineTransform2);
            Rectangle rectangle = generalPath.getBounds();
            SurfaceData surfaceData = sunGraphics2D.getSurfaceData();
            Rectangle rectangle2 = sunGraphics2D.clipState == 0 ? surfaceData.getBounds() : sunGraphics2D.getClipBounds();
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle3);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                this.syncUpGraphicsContextsForImage(sunGraphics2D, graphics2D, rectangle3);
                if (bufferedImageOp != null) {
                    graphics2D.drawImage((BufferedImage)image, bufferedImageOp, (int)affineTransform.getTranslateX(), (int)affineTransform.getTranslateY());
                    BufferedImage bufferedImage2 = this.createCompositingSourceImage(sunGraphics2D, rectangle3);
                    bufferedImageOp.filter(bufferedImage, bufferedImage2);
                    bufferedImage = bufferedImage2;
                } else {
                    graphics2D.drawImage(image, affineTransform, imageObserver);
                }
                graphics2D.dispose();
                this.compositeImage(sunGraphics2D, bufferedImage, rectangle3);
            }
        }
        this.endCompositingOp();
        return bl2;
    }

    public void drawString(SunGraphics2D sunGraphics2D, String string, double d2, double d3) {
        this.beginCompositingOp();
        FontRenderContext fontRenderContext = sunGraphics2D.getFontRenderContext();
        Font font = sunGraphics2D.getFont();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        rectangle2D.setRect((int)d2, (int)(d3 - rectangle2D.getHeight()), Math.ceil(d2 + rectangle2D.getWidth()) - (double)((int)d2), Math.ceil(d3) - (double)((int)(d3 - rectangle2D.getHeight())));
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, rectangle2D, false);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawString(string, (int)d2, (int)d3);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f2, float f3) {
        this.beginCompositingOp();
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        rectangle2D.setRect(Math.floor(f2), Math.floor(f3), Math.ceil((double)f2 + rectangle2D.getWidth()) - (double)((int)f2), Math.ceil((double)f3 + rectangle2D.getHeight()) - (double)((int)f3));
        Rectangle rectangle = this.getCompositingBounds(sunGraphics2D, rectangle2D, false);
        if (rectangle.width > 0 && rectangle.height > 0) {
            BufferedImage bufferedImage = this.createCompositingSourceImage(sunGraphics2D, rectangle);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            this.syncUpGraphicsContextsForFill(sunGraphics2D, graphics2D, rectangle);
            graphics2D.drawGlyphVector(glyphVector, f2, f3);
            graphics2D.dispose();
            this.compositeImage(sunGraphics2D, bufferedImage, rectangle);
        }
        this.endCompositingOp();
    }

    public void drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n2, int n3, int n4, int n5) {
        String string = new String(cArray, n2, n3);
        this.drawString(sunGraphics2D, string, n4, n5);
    }

    public void drawBytes(SunGraphics2D sunGraphics2D, byte[] byArray, int n2, int n3, int n4, int n5) {
        String string = new String(byArray, n2, n3);
        this.drawString(sunGraphics2D, string, n4, n5);
    }

    public void beginCompositingOp() {
    }

    public void endCompositingOp() {
    }

    private BufferedImage createCompatibleImage(SunGraphics2D sunGraphics2D, int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = sunGraphics2D.getDeviceConfiguration();
        Object object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = ((GraphicsEnvironment)object).getDefaultScreenDevice();
        graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        object = graphicsConfiguration.createCompatibleImage(n2, n3);
        return object;
    }

    public BufferedImage createCompositingSourceImage(SunGraphics2D sunGraphics2D, Rectangle rectangle) {
        BufferedImage bufferedImage = this.createCompatibleImage(sunGraphics2D, rectangle.width, rectangle.height);
        return bufferedImage;
    }

    public void compositeImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, Rectangle rectangle) {
        BufferedImage bufferedImage2 = this.createCompatibleImage(sunGraphics2D, rectangle.width, rectangle.height);
        BufImgSurfaceData.createData(bufferedImage2);
        BufferedImage bufferedImage3 = bufferedImage2;
        if (sunGraphics2D.compositeState >= 3) {
            bufferedImage3 = this.createCompatibleImage(sunGraphics2D, rectangle.width, rectangle.height);
            BufImgSurfaceData.createData(bufferedImage3);
        }
        CSurfaceData cSurfaceData = (CSurfaceData)sunGraphics2D.getSurfaceData();
        cSurfaceData.copyArea(sunGraphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bufferedImage2);
        Composite composite = sunGraphics2D.getComposite();
        CompositeContext compositeContext = composite.createContext(bufferedImage.getColorModel(), bufferedImage2.getColorModel(), sunGraphics2D.getRenderingHints());
        compositeContext.compose(bufferedImage.getRaster(), bufferedImage2.getRaster(), bufferedImage3.getRaster());
        compositeContext.dispose();
        AffineTransform affineTransform = sunGraphics2D.getTransform();
        Composite composite2 = sunGraphics2D.getComposite();
        sunGraphics2D.setTransform(b);
        sunGraphics2D.setComposite(AlphaComposite.Src);
        int n2 = rectangle.x - sunGraphics2D.constrainX;
        int n3 = rectangle.y - sunGraphics2D.constrainY;
        sunGraphics2D.drawImage((Image)bufferedImage3, n2, n3, null);
        sunGraphics2D.setComposite(composite2);
        sunGraphics2D.setTransform(affineTransform);
    }

    public Rectangle getClipBounds(SunGraphics2D sunGraphics2D) {
        Object object;
        Rectangle rectangle;
        Rectangle rectangle2 = new Rectangle(sunGraphics2D.getCompClip().getLoX(), sunGraphics2D.getCompClip().getLoY(), sunGraphics2D.getCompClip().getWidth(), sunGraphics2D.getCompClip().getHeight());
        if (sunGraphics2D.clipState == 0) {
            rectangle = null;
        } else if (sunGraphics2D.transformState == 0) {
            rectangle = sunGraphics2D.getClipBounds();
        } else {
            object = sunGraphics2D.getTransform();
            int n2 = sunGraphics2D.constrainX;
            int n3 = sunGraphics2D.constrainY;
            sunGraphics2D.constrainY = 0;
            sunGraphics2D.constrainX = 0;
            sunGraphics2D.setTransform(b);
            rectangle = sunGraphics2D.getClipBounds();
            sunGraphics2D.constrainX = n2;
            sunGraphics2D.constrainY = n3;
            sunGraphics2D.setTransform((AffineTransform)object);
        }
        rectangle = rectangle == null ? rectangle2 : rectangle2.intersection(rectangle);
        object = sunGraphics2D.getSurfaceData();
        Rectangle rectangle3 = ((SurfaceData)object).getBounds();
        rectangle = rectangle3.intersection(rectangle);
        return rectangle;
    }

    public Rectangle getCompositingBounds(SunGraphics2D sunGraphics2D, Shape shape, boolean bl2) {
        Rectangle rectangle;
        Object object;
        Object object2;
        if (bl2) {
            object2 = sunGraphics2D.getStroke();
            object = object2.createStrokedShape(shape);
            rectangle = object.getBounds();
        } else {
            rectangle = shape.getBounds();
        }
        if (sunGraphics2D.transformState != 0) {
            if (sunGraphics2D.transformState == 1) {
                rectangle.translate(sunGraphics2D.transX, sunGraphics2D.transY);
            } else if (sunGraphics2D.transformState == 2) {
                object2 = sunGraphics2D.getTransform();
                rectangle.x = (int)((double)rectangle.x * ((AffineTransform)object2).getScaleX() + ((AffineTransform)object2).getTranslateX());
                rectangle.y = (int)((double)rectangle.y * ((AffineTransform)object2).getScaleY() + ((AffineTransform)object2).getTranslateY());
                rectangle.width = (int)Math.ceil((double)rectangle.width * ((AffineTransform)object2).getScaleX());
                rectangle.height = (int)Math.ceil((double)rectangle.height * ((AffineTransform)object2).getScaleY());
            } else {
                object2 = new Point(rectangle.x, rectangle.y);
                object = new Point(rectangle.x + rectangle.width, rectangle.y);
                Point point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                Point point2 = new Point(rectangle.x, rectangle.y + rectangle.height);
                AffineTransform affineTransform = sunGraphics2D.getTransform();
                affineTransform.transform((Point2D)object2, (Point2D)object2);
                affineTransform.transform((Point2D)object, (Point2D)object);
                affineTransform.transform(point, point);
                affineTransform.transform(point2, point2);
                rectangle.x = Math.min(((Point)object2).x, ((Point)object).x);
                rectangle.x = Math.min(rectangle.x, point.x);
                rectangle.x = Math.min(rectangle.x, point2.x);
                rectangle.y = Math.min(((Point)object2).y, ((Point)object).y);
                rectangle.y = Math.min(rectangle.y, point.y);
                rectangle.y = Math.min(rectangle.y, point2.y);
                rectangle.width = ((Point)object).x - rectangle.x;
                rectangle.width = Math.max(rectangle.width, point.x - rectangle.x);
                rectangle.width = Math.max(rectangle.width, point2.x - rectangle.x);
                rectangle.height = ((Point)object).y - rectangle.y;
                rectangle.height = Math.max(rectangle.height, point.y - rectangle.y);
                rectangle.height = Math.max(rectangle.height, point2.y - rectangle.y);
            }
        }
        --rectangle.x;
        --rectangle.y;
        rectangle.width += 2;
        rectangle.height += 2;
        object2 = this.getClipBounds(sunGraphics2D);
        object = rectangle.intersection((Rectangle)object2);
        return object;
    }

    public Rectangle getCompositingBounds(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5) {
        Rectangle rectangle;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n2, n3);
        generalPath.lineTo(n4, n5);
        if (sunGraphics2D.transformState <= 2) {
            rectangle = this.getCompositingBounds(sunGraphics2D, generalPath, true);
        } else {
            AffineTransform affineTransform = sunGraphics2D.getTransform();
            generalPath.transform(affineTransform);
            Stroke stroke = sunGraphics2D.getStroke();
            Shape shape = stroke.createStrokedShape(generalPath);
            Rectangle rectangle2 = shape.getBounds();
            --rectangle2.x;
            --rectangle2.y;
            rectangle2.width += 2;
            rectangle2.height += 2;
            Rectangle rectangle3 = this.getClipBounds(sunGraphics2D);
            rectangle = rectangle2.intersection(rectangle3);
        }
        return rectangle;
    }

    public Rectangle getCompositingBounds(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n2, boolean bl2, boolean bl3) {
        Shape shape;
        Shape shape2;
        if (bl2) {
            shape2 = new GeneralPath();
            if (bl3) {
                ((Path2D.Float)shape2).moveTo(nArray[0], nArray2[0]);
                for (int i2 = 1; i2 < n2; ++i2) {
                    ((Path2D.Float)shape2).lineTo(nArray[i2], nArray2[i2]);
                }
                ((Path2D)shape2).closePath();
            } else {
                for (int i3 = 0; i3 < n2; i3 += 2) {
                    ((Path2D.Float)shape2).moveTo(nArray[i3], nArray2[i3]);
                    ((Path2D.Float)shape2).lineTo(nArray[i3 + 1], nArray2[i3 + 1]);
                }
            }
            shape = shape2;
        } else {
            int n3 = nArray[0];
            int n4 = nArray2[0];
            int n5 = n3;
            int n6 = n4;
            for (int i4 = 1; i4 < n2; ++i4) {
                int n7 = nArray[i4];
                int n8 = nArray2[i4];
                if (n7 < n3) {
                    n3 = n7;
                } else if (n7 > n5) {
                    n5 = n7;
                }
                if (n8 < n4) {
                    n4 = n8;
                    continue;
                }
                if (n8 <= n6) continue;
                n6 = n8;
            }
            shape = new Rectangle(n3, n4, n5 - n3, n6 - n4);
        }
        shape2 = this.getCompositingBounds(sunGraphics2D, shape, bl2);
        return shape2;
    }

    public void syncUpGraphicsContexts(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle, boolean bl2, boolean bl3) {
        Object object;
        block12: {
            block11: {
                if (sunGraphics2D.transformState == 0) {
                    graphics2D.translate(-rectangle.x, -rectangle.y);
                } else if (sunGraphics2D.transformState == 1) {
                    graphics2D.translate(-rectangle.x + sunGraphics2D.transX, -rectangle.y + sunGraphics2D.transY);
                } else if (sunGraphics2D.transformState == 2) {
                    object = sunGraphics2D.getTransform();
                    graphics2D.translate((double)(-rectangle.x) + ((AffineTransform)object).getTranslateX(), (double)(-rectangle.y) + ((AffineTransform)object).getTranslateY());
                    graphics2D.scale(((AffineTransform)object).getScaleX(), ((AffineTransform)object).getScaleY());
                } else {
                    object = sunGraphics2D.getTransform();
                    graphics2D.translate(-rectangle.x, -rectangle.y);
                    graphics2D.transform((AffineTransform)object);
                }
                if (sunGraphics2D.clipState == 2) break block11;
                if (sunGraphics2D.clipState != 1) break block12;
                if (sunGraphics2D.transformState != 3) break block12;
            }
            object = sunGraphics2D.getClip();
            graphics2D.setClip((Shape)object);
        }
        if (bl2) {
            object = sunGraphics2D.getPaint();
            graphics2D.setPaint((Paint)object);
        }
        if (bl3) {
            object = sunGraphics2D.getStroke();
            graphics2D.setStroke((Stroke)object);
        }
    }

    public void syncUpGraphicsContextsForStroke(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle) {
        this.syncUpGraphicsContexts(sunGraphics2D, graphics2D, rectangle, true, true);
    }

    public void syncUpGraphicsContextsForFill(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle) {
        this.syncUpGraphicsContexts(sunGraphics2D, graphics2D, rectangle, true, false);
    }

    public void syncUpGraphicsContextsForDrawText(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle) {
        this.syncUpGraphicsContexts(sunGraphics2D, graphics2D, rectangle, true, false);
    }

    public void syncUpGraphicsContextsForImage(SunGraphics2D sunGraphics2D, Graphics2D graphics2D, Rectangle rectangle) {
        this.syncUpGraphicsContexts(sunGraphics2D, graphics2D, rectangle, false, false);
    }

    public boolean waitForValidImageDimensions(Image image) {
        boolean bl2 = true;
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        if (n2 == -1 || n3 == -1) {
            Panel panel = new Panel();
            MediaTracker mediaTracker = new MediaTracker(panel);
            int n4 = 0;
            mediaTracker.addImage(image, n4);
            try {
                mediaTracker.waitForID(n4);
                if (mediaTracker.isErrorID(n4)) {
                    bl2 = false;
                }
            }
            catch (InterruptedException interruptedException) {
                bl2 = false;
            }
        }
        return bl2;
    }
}

