/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.util.LayoutStyle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonBarBuilder
extends PanelBuilder {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[0];
    private static final RowSpec ROW_SPEC = new RowSpec("center:pref");
    private static final RowSpec[] ROW_SPECS = new RowSpec[]{ROW_SPEC};
    private static final String NARROW_KEY = "jgoodies.isNarrow";
    private boolean leftToRight = LayoutStyle.getCurrent().isLeftToRightButtonOrder();

    public ButtonBarBuilder() {
        this(new JPanel());
    }

    public ButtonBarBuilder(JPanel jPanel) {
        super(jPanel, new FormLayout(COL_SPECS, ROW_SPECS));
    }

    public static ButtonBarBuilder createLeftToRightBuilder() {
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.setLeftToRightButtonOrder(true);
        return buttonBarBuilder;
    }

    public boolean isLeftToRightButtonOrder() {
        return this.leftToRight;
    }

    public void setLeftToRightButtonOrder(boolean bl2) {
        this.leftToRight = bl2;
    }

    public void setDefaultButtonBarGapBorder() {
        this.getPanel().setBorder(Borders.BUTTON_BAR_GAP_BORDER);
    }

    public void addGriddedButtons(JButton[] jButtonArray) {
        int n2 = jButtonArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.leftToRight ? i2 : n2 - 1 - i2;
            this.addGridded(jButtonArray[n3]);
            if (i2 >= jButtonArray.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addGriddedGrowingButtons(JButton[] jButtonArray) {
        int n2 = jButtonArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.leftToRight ? i2 : n2 - 1 - i2;
            this.addGriddedGrowing(jButtonArray[n3]);
            if (i2 >= jButtonArray.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addFixed(JComponent jComponent) {
        this.getLayout().appendColumn(FormFactory.PREF_COLSPEC);
        this.add(jComponent);
        this.nextColumn();
    }

    public void addFixedNarrow(JComponent jComponent) {
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.addFixed(jComponent);
    }

    public void addGridded(JComponent jComponent) {
        this.getLayout().appendColumn(FormFactory.BUTTON_COLSPEC);
        this.getLayout().addGroupedColumn(this.getColumn());
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(jComponent);
        this.nextColumn();
    }

    public void addGriddedGrowing(JComponent jComponent) {
        this.getLayout().appendColumn(FormFactory.GROWING_BUTTON_COLSPEC);
        this.getLayout().addGroupedColumn(this.getColumn());
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(jComponent);
        this.nextColumn();
    }

    public void addGlue() {
        this.appendGlueColumn();
        this.nextColumn();
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapColumn();
        this.nextColumn();
    }

    public void addUnrelatedGap() {
        this.appendUnrelatedComponentsGapColumn();
        this.nextColumn();
    }

    public void addStrut(ConstantSize constantSize) {
        this.getLayout().appendColumn(new ColumnSpec(ColumnSpec.LEFT, constantSize, 0.0));
        this.nextColumn();
    }
}

