/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.debug;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JLabel;

public final class FormDebugUtils {
    public static void dumpAll(Container container) {
        if (!(container.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        FormDebugUtils.dumpColumnSpecs(formLayout);
        FormDebugUtils.dumpRowSpecs(formLayout);
        System.out.println();
        FormDebugUtils.dumpColumnGroups(formLayout);
        FormDebugUtils.dumpRowGroups(formLayout);
        System.out.println();
        FormDebugUtils.dumpConstraints(container);
        FormDebugUtils.dumpGridBounds(container);
    }

    public static void dumpColumnSpecs(FormLayout formLayout) {
        System.out.print("COLUMN SPECS:");
        for (int i2 = 1; i2 <= formLayout.getColumnCount(); ++i2) {
            ColumnSpec columnSpec = formLayout.getColumnSpec(i2);
            System.out.print(columnSpec.toShortString());
            if (i2 >= formLayout.getColumnCount()) continue;
            System.out.print(", ");
        }
        System.out.println();
    }

    public static void dumpRowSpecs(FormLayout formLayout) {
        System.out.print("ROW SPECS:   ");
        for (int i2 = 1; i2 <= formLayout.getRowCount(); ++i2) {
            RowSpec rowSpec = formLayout.getRowSpec(i2);
            System.out.print(rowSpec.toShortString());
            if (i2 >= formLayout.getRowCount()) continue;
            System.out.print(", ");
        }
        System.out.println();
    }

    public static void dumpColumnGroups(FormLayout formLayout) {
        FormDebugUtils.dumpGroups("COLUMN GROUPS: ", formLayout.getColumnGroups());
    }

    public static void dumpRowGroups(FormLayout formLayout) {
        FormDebugUtils.dumpGroups("ROW GROUPS:    ", formLayout.getRowGroups());
    }

    public static void dumpGridBounds(Container container) {
        System.out.println("GRID BOUNDS");
        FormDebugUtils.dumpGridBounds(FormDebugUtils.getLayoutInfo(container));
    }

    public static void dumpGridBounds(FormLayout.LayoutInfo layoutInfo) {
        int n2;
        System.out.print("COLUMN ORIGINS: ");
        for (n2 = 0; n2 < layoutInfo.columnOrigins.length; ++n2) {
            System.out.print(layoutInfo.columnOrigins[n2] + " ");
        }
        System.out.println();
        System.out.print("ROW ORIGINS:    ");
        for (n2 = 0; n2 < layoutInfo.rowOrigins.length; ++n2) {
            System.out.print(layoutInfo.rowOrigins[n2] + " ");
        }
        System.out.println();
    }

    public static void dumpConstraints(Container container) {
        System.out.println("COMPONENT CONSTRAINTS");
        if (!(container.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        int n2 = container.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            CellConstraints cellConstraints = formLayout.getConstraints(component);
            String string = cellConstraints == null ? "no constraints" : cellConstraints.toShortString(formLayout);
            System.out.print(string);
            System.out.print("; ");
            String string2 = component.getClass().getName();
            System.out.print(string2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                System.out.print("      \"" + jLabel.getText() + "\"");
            }
            if (component.getName() != null) {
                System.out.print("; name=");
                System.out.print(component.getName());
            }
            System.out.println();
        }
        System.out.println();
    }

    private static void dumpGroups(String string, int[][] nArray) {
        System.out.print(string + " {");
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int[] nArray2 = nArray[i2];
            System.out.print(" {");
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                System.out.print(nArray2[i3]);
                if (i3 >= nArray2.length - 1) continue;
                System.out.print(", ");
            }
            System.out.print("} ");
            if (i2 >= nArray.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println("}");
    }

    public static FormLayout.LayoutInfo getLayoutInfo(Container container) {
        if (!(container.getLayout() instanceof FormLayout)) {
            throw new IllegalArgumentException("The container must use an instance of FormLayout.");
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        return formLayout.getLayoutInfo(container);
    }
}

