/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;

public final class ConstantSize
implements Size,
Serializable {
    public static final Unit PIXEL = new Unit("Pixel", "px", true, null);
    public static final Unit POINT = new Unit("Point", "pt", true, null);
    public static final Unit DIALOG_UNITS_X;
    public static final Unit DLUX;
    public static final Unit DIALOG_UNITS_Y;
    public static final Unit DLUY;
    public static final Unit MILLIMETER;
    public static final Unit MM;
    public static final Unit CENTIMETER;
    public static final Unit CM;
    public static final Unit INCH;
    public static final Unit IN;
    private static final Unit[] VALUES;
    private final double value;
    private final Unit unit;

    public ConstantSize(int n2, Unit unit) {
        this.value = n2;
        this.unit = unit;
    }

    public ConstantSize(double d2, Unit unit) {
        this.value = d2;
        this.unit = unit;
    }

    public static ConstantSize a(String string, boolean bl2) {
        String[] stringArray = ConstantSize.a(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Unit unit = Unit.a(string3, bl2);
        double d2 = Double.parseDouble(string2);
        if (unit.a && d2 != (double)((int)d2)) {
            throw new IllegalArgumentException(unit.toString() + " value " + string2 + " must be an integer.");
        }
        return new ConstantSize(d2, unit);
    }

    public static ConstantSize a(int n2) {
        return new ConstantSize(n2, DLUX);
    }

    public static ConstantSize b(int n2) {
        return new ConstantSize(n2, DLUY);
    }

    public int getPixelSize(Component component) {
        if (this.unit == PIXEL) {
            return this.intValue();
        }
        if (this.unit == POINT) {
            return Sizes.pointAsPixel(this.intValue(), component);
        }
        if (this.unit == INCH) {
            return Sizes.inchAsPixel(this.value, component);
        }
        if (this.unit == MILLIMETER) {
            return Sizes.millimeterAsPixel(this.value, component);
        }
        if (this.unit == CENTIMETER) {
            return Sizes.centimeterAsPixel(this.value, component);
        }
        if (this.unit == DIALOG_UNITS_X) {
            return Sizes.dialogUnitXAsPixel(this.intValue(), component);
        }
        if (this.unit == DIALOG_UNITS_Y) {
            return Sizes.dialogUnitYAsPixel(this.intValue(), component);
        }
        throw new IllegalStateException("Invalid unit " + this.unit);
    }

    public int maximumSize(Container container, List list, FormLayout.Measure measure, FormLayout.Measure measure2, FormLayout.Measure measure3) {
        return this.getPixelSize(container);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConstantSize)) {
            return false;
        }
        ConstantSize constantSize = (ConstantSize)object;
        return this.value == constantSize.value && this.unit == constantSize.unit;
    }

    public int hashCode() {
        return new Double(this.value).hashCode() + 37 * this.unit.hashCode();
    }

    public String toString() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.abbreviation() : Double.toString(this.value) + this.unit.abbreviation();
    }

    private int intValue() {
        return (int)Math.round(this.value);
    }

    public static String[] a(String string) {
        int n2;
        int n3;
        String[] stringArray = new String[2];
        for (n3 = n2 = string.length(); n3 > 0 && Character.isLetter(string.charAt(n3 - 1)); --n3) {
        }
        stringArray[0] = string.substring(0, n3);
        stringArray[1] = string.substring(n3);
        return stringArray;
    }

    public static Unit[] a() {
        return VALUES;
    }

    static {
        DLUX = DIALOG_UNITS_X = new Unit("Dialog units X", "dluX", true, null);
        DLUY = DIALOG_UNITS_Y = new Unit("Dialog units Y", "dluY", true, null);
        MM = MILLIMETER = new Unit("Millimeter", "mm", false, null);
        CM = CENTIMETER = new Unit("Centimeter", "cm", false, null);
        IN = INCH = new Unit("Inch", "in", false, null);
        VALUES = new Unit[]{PIXEL, POINT, DIALOG_UNITS_X, DIALOG_UNITS_Y, MILLIMETER, CENTIMETER, INCH};
    }

    public static class 1 {
    }

    public static final class Unit
    implements Serializable {
        private final transient String name;
        private final transient String abbreviation;
        public final transient boolean a;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private Unit(String string, String string2, boolean bl2) {
            this.name = string;
            this.abbreviation = string2;
            this.a = bl2;
        }

        public static Unit a(String string, boolean bl2) {
            String string2 = string.toLowerCase();
            if (string2.equals("px") || string2.length() == 0) {
                return PIXEL;
            }
            if (string2.equals("dlu")) {
                return bl2 ? DIALOG_UNITS_X : DIALOG_UNITS_Y;
            }
            if (string2.equals("pt")) {
                return POINT;
            }
            if (string2.equals("in")) {
                return INCH;
            }
            if (string2.equals("mm")) {
                return MILLIMETER;
            }
            if (string2.equals("cm")) {
                return CENTIMETER;
            }
            throw new IllegalArgumentException("Invalid unit name '" + string + "'. Must be one of: " + "px, dlu, pt, mm, cm, in");
        }

        public String toString() {
            return this.name;
        }

        public String abbreviation() {
            return this.abbreviation;
        }

        private Object readResolve() {
            return ConstantSize.a()[this.ordinal];
        }

        public Unit(String string, String string2, boolean bl2, 1 var4_4) {
            this(string, string2, bl2);
        }
    }
}

