/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;
import java.util.StringTokenizer;

public abstract class FormSpec
implements Serializable {
    public static final DefaultAlignment e = new DefaultAlignment("left", null);
    public static final DefaultAlignment b = new DefaultAlignment("right", null);
    public static final DefaultAlignment f = new DefaultAlignment("top", null);
    public static final DefaultAlignment a = new DefaultAlignment("bottom", null);
    public static final DefaultAlignment c = new DefaultAlignment("center", null);
    public static final DefaultAlignment d = new DefaultAlignment("fill", null);
    private static final DefaultAlignment[] VALUES = new DefaultAlignment[]{e, b, f, a, c, d};
    public static final double NO_GROW = 0.0;
    public static final double DEFAULT_GROW = 1.0;
    private DefaultAlignment defaultAlignment;
    private Size size;
    private double resizeWeight;

    public FormSpec(DefaultAlignment defaultAlignment, Size size, double d2) {
        this.defaultAlignment = defaultAlignment;
        this.size = size;
        this.resizeWeight = d2;
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The resize weight must be non-negative.");
        }
    }

    public FormSpec(DefaultAlignment defaultAlignment, String string) {
        this(defaultAlignment, Sizes.DEFAULT, 0.0);
        this.parseAndInitValues(string.toLowerCase());
    }

    public final DefaultAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public void setDefaultAlignment(DefaultAlignment defaultAlignment) {
        this.defaultAlignment = defaultAlignment;
    }

    public final Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public final double getResizeWeight() {
        return this.resizeWeight;
    }

    public void setResizeWeight(double d2) {
        this.resizeWeight = d2;
    }

    public final boolean a() {
        return this.getResizeWeight() != 0.0;
    }

    private void parseAndInitValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        String string2 = stringTokenizer.nextToken();
        DefaultAlignment defaultAlignment = DefaultAlignment.a(string2, this.isHorizontal());
        if (defaultAlignment != null) {
            this.setDefaultAlignment(defaultAlignment);
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            string2 = stringTokenizer.nextToken();
        }
        this.parseAndInitSize(string2);
        if (stringTokenizer.hasMoreTokens()) {
            this.setResizeWeight(this.decodeResize(stringTokenizer.nextToken()));
        }
    }

    private void parseAndInitSize(String string) {
        if (string.startsWith("max(") && string.endsWith(")")) {
            this.setSize(this.parseAndInitBoundedSize(string, false));
            return;
        }
        if (string.startsWith("min(") && string.endsWith(")")) {
            this.setSize(this.parseAndInitBoundedSize(string, true));
            return;
        }
        this.setSize(this.decodeAtomicSize(string));
    }

    private Size parseAndInitBoundedSize(String string, boolean bl2) {
        int n2 = string.indexOf(59);
        String string2 = string.substring(4, n2);
        String string3 = string.substring(n2 + 1, string.length() - 1);
        Size size = this.decodeAtomicSize(string2);
        Size size2 = this.decodeAtomicSize(string3);
        if (size instanceof ConstantSize) {
            if (size2 instanceof Sizes.ComponentSize) {
                return new BoundedSize(size2, bl2 ? null : size, bl2 ? size : null);
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (size2 instanceof ConstantSize) {
            return new BoundedSize(size, bl2 ? null : size2, bl2 ? size2 : null);
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private Size decodeAtomicSize(String string) {
        Sizes.ComponentSize componentSize = Sizes.ComponentSize.a(string);
        if (componentSize != null) {
            return componentSize;
        }
        return ConstantSize.a(string, this.isHorizontal());
    }

    private double decodeResize(String string) {
        if (string.equals("g") || string.equals("grow")) {
            return 1.0;
        }
        if (string.equals("n") || string.equals("nogrow") || string.equals("none")) {
            return 0.0;
        }
        if ((string.startsWith("grow(") || string.startsWith("g(")) && string.endsWith(")")) {
            int n2 = string.indexOf(40);
            int n3 = string.indexOf(41);
            String string2 = string.substring(n2 + 1, n3);
            return Double.parseDouble(string2);
        }
        throw new IllegalArgumentException("The resize argument '" + string + "' is invalid. " + " Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.defaultAlignment);
        stringBuffer.append(":");
        stringBuffer.append(this.size.toString());
        stringBuffer.append(':');
        if (this.resizeWeight == 0.0) {
            stringBuffer.append("noGrow");
        } else if (this.resizeWeight == 1.0) {
            stringBuffer.append("grow");
        } else {
            stringBuffer.append("grow(");
            stringBuffer.append(this.resizeWeight);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public final String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.defaultAlignment.abbreviation());
        stringBuffer.append(":");
        stringBuffer.append(this.size.toString());
        stringBuffer.append(':');
        if (this.resizeWeight == 0.0) {
            stringBuffer.append("n");
        } else if (this.resizeWeight == 1.0) {
            stringBuffer.append("g");
        } else {
            stringBuffer.append("g(");
            stringBuffer.append(this.resizeWeight);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public abstract boolean isHorizontal();

    public final int a(Container container, List list, FormLayout.Measure measure, FormLayout.Measure measure2, FormLayout.Measure measure3) {
        return this.size.maximumSize(container, list, measure, measure2, measure3);
    }

    public static DefaultAlignment[] b() {
        return VALUES;
    }

    public static class 1 {
    }

    public static final class DefaultAlignment
    implements Serializable {
        private final transient String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private DefaultAlignment(String string) {
            this.name = string;
        }

        private static DefaultAlignment valueOf(String string, boolean bl2) {
            if (string.equals("f") || string.equals("fill")) {
                return d;
            }
            if (string.equals("c") || string.equals("center")) {
                return c;
            }
            if (bl2) {
                if (string.equals("r") || string.equals("right")) {
                    return b;
                }
                if (string.equals("l") || string.equals("left")) {
                    return e;
                }
                return null;
            }
            if (string.equals("t") || string.equals("top")) {
                return f;
            }
            if (string.equals("b") || string.equals("bottom")) {
                return a;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public char abbreviation() {
            return this.name.charAt(0);
        }

        private Object readResolve() {
            return FormSpec.b()[this.ordinal];
        }

        public DefaultAlignment(String string, 1 var2_2) {
            this(string);
        }

        public static DefaultAlignment a(String string, boolean bl2) {
            return DefaultAlignment.valueOf(string, bl2);
        }
    }
}

