/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.text.JTextComponent;

public final class PlasticBorders {
    private static Border buttonBorder;
    private static Border comboBoxEditorBorder;
    private static Border comboBoxArrowButtonBorder;
    private static Border etchedBorder;
    private static Border flush3DBorder;
    private static Border menuBarHeaderBorder;
    private static Border menuBorder;
    private static Border menuItemBorder;
    private static Border popupMenuBorder;
    private static Border rolloverButtonBorder;
    private static Border scrollPaneBorder;
    private static Border separatorBorder;
    private static Border textFieldBorder;
    private static Border thinLoweredBorder;
    private static Border thinRaisedBorder;
    private static Border toggleButtonBorder;
    private static Border toolBarHeaderBorder;

    public static Border l() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(null), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border q() {
        if (comboBoxArrowButtonBorder == null) {
            comboBoxArrowButtonBorder = new CompoundBorder(new ComboBoxArrowButtonBorder(null), new BasicBorders.MarginBorder());
        }
        return comboBoxArrowButtonBorder;
    }

    public static Border j() {
        if (comboBoxEditorBorder == null) {
            comboBoxEditorBorder = new CompoundBorder(new ComboBoxEditorBorder(null), new BasicBorders.MarginBorder());
        }
        return comboBoxEditorBorder;
    }

    public static Border f() {
        if (etchedBorder == null) {
            etchedBorder = new BorderUIResource.CompoundBorderUIResource(new EtchedBorder(null), new BasicBorders.MarginBorder());
        }
        return etchedBorder;
    }

    public static Border r() {
        if (flush3DBorder == null) {
            flush3DBorder = new Flush3DBorder(null);
        }
        return flush3DBorder;
    }

    public static Border a() {
        return new InternalFrameBorder(null);
    }

    public static Border b() {
        if (menuBarHeaderBorder == null) {
            menuBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBarHeaderBorder(null), new BasicBorders.MarginBorder());
        }
        return menuBarHeaderBorder;
    }

    public static Border k() {
        if (menuBorder == null) {
            menuBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBorder(null), new BasicBorders.MarginBorder());
        }
        return menuBorder;
    }

    public static Border m() {
        if (menuItemBorder == null) {
            menuItemBorder = new BorderUIResource(new BasicBorders.MarginBorder());
        }
        return menuItemBorder;
    }

    public static Border c() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder(null);
        }
        return popupMenuBorder;
    }

    public static Border o() {
        return new PaletteBorder(null);
    }

    public static Border h() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new BorderUIResource.CompoundBorderUIResource(new RolloverButtonBorder(null), new RolloverMarginBorder(null));
        }
        return rolloverButtonBorder;
    }

    public static Border n() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder(null);
        }
        return scrollPaneBorder;
    }

    public static Border i() {
        if (separatorBorder == null) {
            separatorBorder = new BorderUIResource.CompoundBorderUIResource(new SeparatorBorder(null), new BasicBorders.MarginBorder());
        }
        return separatorBorder;
    }

    public static Border d() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(null), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static Border e() {
        if (thinRaisedBorder == null) {
            thinRaisedBorder = new ThinRaisedBorder(null);
        }
        return thinRaisedBorder;
    }

    public static Border g() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(null), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    public static Border p() {
        if (toolBarHeaderBorder == null) {
            toolBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new ToolBarHeaderBorder(null), new BasicBorders.MarginBorder());
        }
        return toolBarHeaderBorder;
    }

    public static class 1 {
    }

    private static class ToggleButtonBorder
    extends ButtonBorder {
        private ToggleButtonBorder() {
            super(null);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (!component.isEnabled()) {
                PlasticUtils.g(graphics, n2, n3, n4 - 1, n5 - 1);
            } else {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    PlasticUtils.f(graphics, n2, n3, n4, n5);
                } else if (buttonModel.isSelected()) {
                    PlasticUtils.b(graphics, n2, n3, n4, n5);
                } else {
                    PlasticUtils.c(graphics, n2, n3, n4, n5);
                }
            }
        }

        public ToggleButtonBorder(1 var1_1) {
            this();
        }
    }

    private static class TextFieldBorder
    extends Flush3DBorder {
        private TextFieldBorder() {
            super(null);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (!(component instanceof JTextComponent)) {
                if (component.isEnabled()) {
                    PlasticUtils.c(graphics, n2, n3, n4, n5);
                } else {
                    PlasticUtils.g(graphics, n2, n3, n4, n5);
                }
                return;
            }
            if (component.isEnabled() && ((JTextComponent)component).isEditable()) {
                PlasticUtils.c(graphics, n2, n3, n4, n5);
            } else {
                PlasticUtils.g(graphics, n2, n3, n4, n5);
            }
        }

        public TextFieldBorder(1 var1_1) {
            this();
        }
    }

    private static class ScrollPaneBorder
    extends MetalBorders.ScrollPaneBorder {
        private ScrollPaneBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n4 - 2, n5 - 2);
            graphics.setColor(PlasticLookAndFeel.getControlHighlight());
            graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
            graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            graphics.translate(-n2, -n3);
        }

        public ScrollPaneBorder(1 var1_1) {
            this();
        }
    }

    private static class RolloverMarginBorder
    extends EmptyBorder {
        private RolloverMarginBorder() {
            super(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }

        public RolloverMarginBorder(1 var1_1) {
            this();
        }
    }

    private static class RolloverButtonBorder
    extends ButtonBorder {
        private static final Insets INSETS_3 = new Insets(3, 3, 3, 3);

        private RolloverButtonBorder() {
            super(null);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!(component instanceof JToggleButton)) {
                if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed())) {
                    super.paintBorder(component, graphics, n2, n3, n4, n5);
                }
                return;
            }
            if (buttonModel.isRollover()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    PlasticUtils.f(graphics, n2, n3, n4, n5);
                } else {
                    PlasticUtils.c(graphics, n2, n3, n4, n5);
                }
            } else if (buttonModel.isSelected()) {
                PlasticUtils.b(graphics, n2, n3, n4, n5);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS_3;
        }

        public RolloverButtonBorder(1 var1_1) {
            this();
        }
    }

    private static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(3, 3, 3, 3);

        private PopupMenuBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n4 - 1, n5 - 1);
            graphics.setColor(PlasticLookAndFeel.getMenuItemBackground());
            graphics.drawRect(1, 1, n4 - 3, n5 - 3);
            graphics.drawRect(2, 2, n4 - 5, n5 - 5);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public PopupMenuBorder(1 var1_1) {
            this();
        }
    }

    private static class MenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private MenuBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            if (buttonModel.isArmed() || buttonModel.isSelected()) {
                graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
                graphics.drawLine(0, 0, n4 - 2, 0);
                graphics.drawLine(0, 0, 0, n5 - 1);
                graphics.setColor(PlasticLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
            } else if (buttonModel.isRollover()) {
                graphics.translate(n2, n3);
                PlasticUtils.c(graphics, n2, n3, n4, n5);
                graphics.translate(-n2, -n3);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = MenuBorder.INSETS.top;
            insets.left = MenuBorder.INSETS.left;
            insets.bottom = MenuBorder.INSETS.bottom;
            insets.right = MenuBorder.INSETS.right;
            return insets;
        }

        public MenuBorder(1 var1_1) {
            this();
        }
    }

    private static class ToolBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 2, 2, 2);

        private ToolBarHeaderBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            PlasticUtils.d(graphics, n2, n3 - 1, n4, n5 + 1);
            PlasticUtils.e(graphics, n2 + 1, n3, n4 - 2, n5 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public ToolBarHeaderBorder(1 var1_1) {
            this();
        }
    }

    private static class MenuBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 1, 2);

        private MenuBarHeaderBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            PlasticUtils.d(graphics, n2, n3, n4, n5 + 1);
            PlasticUtils.e(graphics, n2 + 1, n3 + 1, n4 - 2, n5 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public MenuBarHeaderBorder(1 var1_1) {
            this();
        }
    }

    private static class EtchedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private EtchedBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            PlasticUtils.d(graphics, n2, n3, n4, n5);
            PlasticUtils.e(graphics, n2 + 1, n3 + 1, n4 - 2, n5 - 2);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public EtchedBorder(1 var1_1) {
            this();
        }
    }

    private static class ThinLoweredBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private ThinLoweredBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            PlasticUtils.d(graphics, n2, n3, n4, n5);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static class ThinRaisedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private ThinRaisedBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            PlasticUtils.e(graphics, n2, n3, n4, n5);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public ThinRaisedBorder(1 var1_1) {
            this();
        }
    }

    private static class SeparatorBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(0, 0, 2, 1);

        private SeparatorBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(UIManager.getColor("Separator.foreground"));
            graphics.drawLine(0, n5 - 2, n4 - 1, n5 - 2);
            graphics.setColor(UIManager.getColor("Separator.background"));
            graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public SeparatorBorder(1 var1_1) {
            this();
        }
    }

    private static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private PaletteBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n4 - 1, n5 - 1);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public PaletteBorder(1 var1_1) {
            this();
        }
    }

    private static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets NORMAL_INSETS = new Insets(2, 2, 3, 3);
        private static final Insets MAXIMIZED_INSETS = new Insets(2, 2, 2, 2);

        private InternalFrameBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JInternalFrame jInternalFrame = (JInternalFrame)component;
            if (jInternalFrame.isMaximum()) {
                PlasticUtils.c(graphics, n2, n3, n4, n5);
            } else {
                this.paintShadowedBorder(graphics, n2, n3, n4, n5);
            }
        }

        private void paintShadowedBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
            Color color = UIManager.getColor("desktop");
            Color color2 = UIManager.getColor("controlLtHighlight");
            Color color3 = UIManager.getColor("controlDkShadow");
            Color color4 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), 150);
            Color color5 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), 50);
            graphics.translate(n2, n3);
            graphics.setColor(color3);
            graphics.drawRect(0, 0, n4 - 3, n5 - 3);
            graphics.setColor(color2);
            graphics.drawLine(1, 1, n4 - 4, 1);
            graphics.drawLine(1, 1, 1, n5 - 4);
            graphics.setColor(color);
            graphics.fillRect(n4 - 2, 0, 2, n5);
            graphics.fillRect(0, n5 - 2, n4, 2);
            graphics.setColor(color4);
            graphics.drawLine(n4 - 2, 1, n4 - 2, n5 - 2);
            graphics.drawLine(1, n5 - 2, n4 - 3, n5 - 2);
            graphics.setColor(color5);
            graphics.drawLine(n4 - 1, 2, n4 - 1, n5 - 2);
            graphics.drawLine(2, n5 - 1, n4 - 2, n5 - 1);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return ((JInternalFrame)component).isMaximum() ? MAXIMIZED_INSETS : NORMAL_INSETS;
        }

        public InternalFrameBorder(1 var1_1) {
            this();
        }
    }

    private static class ComboBoxEditorBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(2, 2, 2, 0);

        private ComboBoxEditorBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (component.isEnabled()) {
                PlasticUtils.c(graphics, n2, n3, n4 + 2, n5);
            } else {
                PlasticUtils.g(graphics, n2, n3, n4 + 2, n5 - 1);
                graphics.setColor(UIManager.getColor("control"));
                graphics.drawLine(n2, n3 + n5 - 1, n2 + n4, n3 + n5 - 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public ComboBoxEditorBorder(1 var1_1) {
            this();
        }
    }

    private static class ComboBoxArrowButtonBorder
    extends AbstractBorder
    implements UIResource {
        public static final Insets INSETS = new Insets(1, 1, 1, 1);

        private ComboBoxArrowButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                boolean bl2;
                boolean bl3 = bl2 = buttonModel.isPressed() && buttonModel.isArmed();
                if (bl2) {
                    PlasticUtils.f(graphics, n2, n3, n4, n5);
                } else {
                    PlasticUtils.a(graphics, n2, n3, n4, n5, false);
                }
            } else {
                PlasticUtils.g(graphics, n2, n3, n4 - 1, n5 - 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public ComboBoxArrowButtonBorder(1 var1_1) {
            this();
        }
    }

    private static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        public static final Insets INSETS = LookUtils.IS_LOW_RESOLUTION ? new Insets(2, 3, 3, 3) : new Insets(1, 3, 1, 3);

        private ButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                boolean bl2;
                boolean bl3 = buttonModel.isPressed() && buttonModel.isArmed();
                boolean bl4 = bl2 = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
                if (bl3 && bl2) {
                    PlasticUtils.a(graphics, n2, n3, n4, n5);
                } else if (bl3) {
                    PlasticUtils.f(graphics, n2, n3, n4, n5);
                } else if (bl2) {
                    PlasticUtils.b(graphics, n2, n3, n4, n5, false);
                } else {
                    PlasticUtils.a(graphics, n2, n3, n4, n5, false);
                }
            } else {
                PlasticUtils.g(graphics, n2, n3, n4 - 1, n5 - 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = ButtonBorder.INSETS.top;
            insets.left = ButtonBorder.INSETS.left;
            insets.bottom = ButtonBorder.INSETS.bottom;
            insets.right = ButtonBorder.INSETS.right;
            return insets;
        }

        public ButtonBorder(1 var1_1) {
            this();
        }
    }

    private static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private Flush3DBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (component.isEnabled()) {
                PlasticUtils.c(graphics, n2, n3, n4, n5);
            } else {
                PlasticUtils.g(graphics, n2, n3, n4, n5);
            }
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = Flush3DBorder.INSETS.top;
            insets.left = Flush3DBorder.INSETS.left;
            insets.bottom = Flush3DBorder.INSETS.bottom;
            insets.right = Flush3DBorder.INSETS.right;
            return insets;
        }

        public Flush3DBorder(1 var1_1) {
            this();
        }
    }
}

