/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticInternalFrameTitlePane;
import java.awt.Color;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public final class PlasticInternalFrameUI
extends BasicInternalFrameUI {
    private static final String FRAME_TYPE = "JInternalFrame.frameType";
    public static final String IS_PALETTE = "JInternalFrame.isPalette";
    private static final String PALETTE_FRAME = "palette";
    private static final String OPTION_DIALOG = "optionDialog";
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private PlasticInternalFrameTitlePane titlePane;
    private PropertyChangeListener paletteListener;
    private PropertyChangeListener contentPaneListener;

    public PlasticInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.paletteListener = new PaletteListener(this, null);
        this.contentPaneListener = new ContentPaneListener(this, null);
        jComponent.addPropertyChangeListener(this.paletteListener);
        jComponent.addPropertyChangeListener(this.contentPaneListener);
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty(IS_PALETTE);
        if (object != null) {
            this.setPalette((Boolean)object);
        }
        Container container = this.frame.getContentPane();
        this.stripContentBorder(container);
    }

    public void uninstallUI(JComponent jComponent) {
        JComponent jComponent2;
        this.frame = (JInternalFrame)jComponent;
        jComponent.removePropertyChangeListener(this.paletteListener);
        jComponent.removePropertyChangeListener(this.contentPaneListener);
        Container container = ((JInternalFrame)jComponent).getContentPane();
        if (container instanceof JComponent && (jComponent2 = (JComponent)container).getBorder() == EMPTY_BORDER) {
            jComponent2.setBorder(null);
        }
        super.uninstallUI(jComponent);
    }

    public void installDefaults() {
        Color color;
        super.installDefaults();
        JComponent jComponent = (JComponent)this.frame.getContentPane();
        if (jComponent != null && (color = jComponent.getBackground()) instanceof UIResource) {
            jComponent.setBackground(null);
        }
        this.frame.setBackground(UIManager.getLookAndFeelDefaults().getColor("control"));
    }

    public void installKeyboardActions() {
    }

    public void uninstallKeyboardActions() {
    }

    private void stripContentBorder(Object object) {
        JComponent jComponent;
        Border border;
        if (object instanceof JComponent && ((border = (jComponent = (JComponent)object).getBorder()) == null || border instanceof UIResource)) {
            jComponent.setBorder(EMPTY_BORDER);
        }
    }

    public JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new PlasticInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public void setPalette(boolean bl2) {
        String string = bl2 ? "InternalFrame.paletteBorder" : "InternalFrame.border";
        LookAndFeel.installBorder(this.frame, string);
        this.titlePane.setPalette(bl2);
    }

    private void setFrameType(String string) {
        boolean bl2 = string.equals(PALETTE_FRAME);
        String string2 = string.equals(OPTION_DIALOG) ? "InternalFrame.optionDialogBorder" : (bl2 ? "InternalFrame.paletteBorder" : "InternalFrame.border");
        LookAndFeel.installBorder(this.frame, string2);
        this.titlePane.setPalette(bl2);
    }

    public static void a(PlasticInternalFrameUI plasticInternalFrameUI, String string) {
        plasticInternalFrameUI.setFrameType(string);
    }

    public static void a(PlasticInternalFrameUI plasticInternalFrameUI, Object object) {
        plasticInternalFrameUI.stripContentBorder(object);
    }

    public static class 1 {
    }

    private static class ContentPaneListener
    implements PropertyChangeListener {
        private final PlasticInternalFrameUI ui;

        private ContentPaneListener(PlasticInternalFrameUI plasticInternalFrameUI) {
            this.ui = plasticInternalFrameUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("contentPane")) {
                PlasticInternalFrameUI.a(this.ui, propertyChangeEvent.getNewValue());
            }
        }

        public ContentPaneListener(PlasticInternalFrameUI plasticInternalFrameUI, 1 var2_2) {
            this(plasticInternalFrameUI);
        }
    }

    private static class PaletteListener
    implements PropertyChangeListener {
        private final PlasticInternalFrameUI ui;

        private PaletteListener(PlasticInternalFrameUI plasticInternalFrameUI) {
            this.ui = plasticInternalFrameUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if (string.equals(PlasticInternalFrameUI.FRAME_TYPE)) {
                if (object instanceof String) {
                    PlasticInternalFrameUI.a(this.ui, (String)object);
                }
            } else if (string.equals(PlasticInternalFrameUI.IS_PALETTE)) {
                this.ui.setPalette(Boolean.TRUE.equals(object));
            }
        }

        public PaletteListener(PlasticInternalFrameUI plasticInternalFrameUI, 1 var2_2) {
            this(plasticInternalFrameUI);
        }
    }
}

