/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.common.ExtBasicArrowButtonHandler;
import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.windows.WindowsArrowButton;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;

public final class WindowsSpinnerUI
extends com.sun.java.swing.plaf.windows.WindowsSpinnerUI {
    private static final Border EMPTY_BORDER = new BorderUIResource(new EmptyBorder(2, 2, 2, 2));
    private static final ExtBasicArrowButtonHandler nextButtonHandler = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler previousButtonHandler = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsSpinnerUI();
    }

    public Component createPreviousButton() {
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            return super.createPreviousButton();
        }
        WindowsArrowButton windowsArrowButton = new WindowsArrowButton(5);
        windowsArrowButton.addActionListener(previousButtonHandler);
        windowsArrowButton.addMouseListener(previousButtonHandler);
        return windowsArrowButton;
    }

    public Component createNextButton() {
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            return super.createNextButton();
        }
        WindowsArrowButton windowsArrowButton = new WindowsArrowButton(1);
        windowsArrowButton.addActionListener(nextButtonHandler);
        windowsArrowButton.addMouseListener(nextButtonHandler);
        return windowsArrowButton;
    }

    public JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        this.configureEditor(jComponent);
        return jComponent;
    }

    public LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    public void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.configureEditor(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void configureEditor(JComponent jComponent) {
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            defaultEditor.getTextField().setBorder(EMPTY_BORDER);
        }
    }
}

