/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Jpeg
extends Image
implements Element {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID = new byte[]{74, 70, 73, 70, 0};

    public Jpeg(Image image) {
        super(image);
    }

    public Jpeg(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Jpeg(URL uRL, float f2, float f3) throws BadElementException, IOException {
        this(uRL);
        this.scaledWidth = f2;
        this.scaledHeight = f3;
    }

    public Jpeg(String string) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string));
    }

    public Jpeg(String string, float f2, float f3) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string), f2, f3);
    }

    public Jpeg(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    public Jpeg(byte[] byArray, float f2, float f3) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = f2;
        this.scaledHeight = f3;
    }

    private static final int getShort(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static final int marker(int n2) {
        int n3;
        for (n3 = 0; n3 < VALID_MARKERS.length; ++n3) {
            if (n2 != VALID_MARKERS[n3]) continue;
            return 0;
        }
        for (n3 = 0; n3 < NOPARAM_MARKERS.length; ++n3) {
            if (n2 != NOPARAM_MARKERS[n3]) continue;
            return 2;
        }
        for (n3 = 0; n3 < UNSUPPORTED_MARKERS.length; ++n3) {
            if (n2 != UNSUPPORTED_MARKERS[n3]) continue;
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParameters() throws BadElementException, IOException {
        block22: {
            this.type = 32;
            this.originalType = 1;
            InputStream inputStream = null;
            try {
                String string;
                if (this.rawData == null) {
                    inputStream = this.url.openStream();
                    string = this.url.toString();
                } else {
                    inputStream = new ByteArrayInputStream(this.rawData);
                    string = "Byte array";
                }
                if (inputStream.read() != 255) throw new BadElementException(string + " is not a valid JPEG-file.");
                if (inputStream.read() != 216) {
                    throw new BadElementException(string + " is not a valid JPEG-file.");
                }
                boolean bl2 = true;
                while (true) {
                    int n2;
                    byte[] byArray;
                    int n3;
                    int n4;
                    if ((n4 = inputStream.read()) < 0) {
                        throw new IOException("Premature EOF while reading JPG.");
                    }
                    if (n4 != 255) continue;
                    int n5 = inputStream.read();
                    if (bl2 && n5 == 224) {
                        int n6;
                        bl2 = false;
                        n3 = Jpeg.getShort(inputStream);
                        if (n3 < 16) {
                            Jpeg.skip(inputStream, n3 - 2);
                            continue;
                        }
                        byArray = new byte[JFIF_ID.length];
                        n2 = inputStream.read(byArray);
                        if (n2 != byArray.length) {
                            throw new BadElementException(string + " corrupted JFIF marker.");
                        }
                        boolean bl3 = true;
                        for (n6 = 0; n6 < byArray.length; ++n6) {
                            if (byArray[n6] == JFIF_ID[n6]) continue;
                            bl3 = false;
                            break;
                        }
                        if (!bl3) {
                            Jpeg.skip(inputStream, n3 - 2 - byArray.length);
                            continue;
                        }
                        Jpeg.skip(inputStream, 2);
                        n6 = inputStream.read();
                        int n7 = Jpeg.getShort(inputStream);
                        int n8 = Jpeg.getShort(inputStream);
                        if (n6 == 1) {
                            this.dpiX = n7;
                            this.dpiY = n8;
                        } else if (n6 == 2) {
                            this.dpiX = (int)((float)n7 * 2.54f + 0.5f);
                            this.dpiY = (int)((float)n8 * 2.54f + 0.5f);
                        }
                        Jpeg.skip(inputStream, n3 - 2 - byArray.length - 7);
                        continue;
                    }
                    if (n5 == 238) {
                        String string2;
                        n3 = Jpeg.getShort(inputStream);
                        byArray = new byte[n3];
                        for (n2 = 0; n2 < n3; ++n2) {
                            byArray[n2] = (byte)inputStream.read();
                        }
                        if (byArray.length > 12 && (string2 = new String(byArray, 0, 5, "ISO-8859-1")).equals("Adobe")) {
                            this.invert = true;
                        }
                    }
                    bl2 = false;
                    int n9 = Jpeg.marker(n5);
                    if (n9 == 0) {
                        Jpeg.skip(inputStream, 2);
                        if (inputStream.read() != 8) {
                            throw new BadElementException(string + " must have 8 bits per component.");
                        }
                        this.scaledHeight = Jpeg.getShort(inputStream);
                        this.setTop(this.scaledHeight);
                        this.scaledWidth = Jpeg.getShort(inputStream);
                        this.setRight(this.scaledWidth);
                        this.colorspace = inputStream.read();
                        this.bpc = 8;
                        Object var14_15 = null;
                        if (inputStream == null) break block22;
                        break;
                    }
                    if (n9 == 1) {
                        throw new BadElementException(string + ": unsupported JPEG marker: " + n5);
                    }
                    if (n9 == 2) continue;
                    Jpeg.skip(inputStream, Jpeg.getShort(inputStream) - 2);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                this.plainWidth = this.width();
                this.plainHeight = this.height();
                throw throwable;
            }
            inputStream.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }
}

