/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkupAttributes;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class Row
implements Element,
MarkupAttributes {
    public static final int NULL = 0;
    public static final int CELL = 1;
    public static final int TABLE = 2;
    public int columns;
    public int currentColumn;
    public boolean[] reserved;
    public Object[] cells;
    public int horizontalAlignment;
    public int verticalAlignment;
    public Properties markupAttributes;
    public static Class b;
    public static Class a;

    public Row(int n2) {
        this.columns = n2;
        this.reserved = new boolean[n2];
        this.cells = new Object[n2];
        this.currentColumn = 0;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 21;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void a(int n2) {
        int n3;
        if (n2 >= this.columns || n2 < 0) {
            throw new IndexOutOfBoundsException("getCell at illegal index : " + n2);
        }
        --this.columns;
        boolean[] blArray = new boolean[this.columns];
        Cell[] cellArray = new Cell[this.columns];
        for (n3 = 0; n3 < n2; ++n3) {
            blArray[n3] = this.reserved[n3];
            cellArray[n3] = this.cells[n3];
            if (cellArray[n3] == null || n3 + cellArray[n3].colspan() <= n2) continue;
            cellArray[n3].setColspan(((Cell)this.cells[n3]).colspan() - 1);
        }
        for (n3 = n2; n3 < this.columns; ++n3) {
            blArray[n3] = this.reserved[n3 + 1];
            cellArray[n3] = this.cells[n3 + 1];
        }
        if (this.cells[n2] != null && ((Cell)this.cells[n2]).colspan() > 1) {
            cellArray[n2] = this.cells[n2];
            cellArray[n2].setColspan(cellArray[n2].colspan() - 1);
        }
        this.reserved = blArray;
        this.cells = cellArray;
    }

    public int a(Object object, int n2) {
        int n3;
        if (object == null) {
            throw new NullPointerException("addCell - null argument");
        }
        if (n2 < 0 || n2 > this.columns) {
            throw new IndexOutOfBoundsException("addCell - illegal column argument");
        }
        if (this.a(object) != 1 && this.a(object) != 2) {
            throw new IllegalArgumentException("addCell - only Cells or Tables allowed");
        }
        int n4 = n3 = (b == null ? (b = Row.a("com.lowagie.text.Cell")) : b).isInstance(object) ? ((Cell)object).colspan() : 1;
        if (!this.a(n2, n3)) {
            return -1;
        }
        this.cells[n2] = object;
        this.currentColumn += n3 - 1;
        return n2;
    }

    public void b(Object object, int n2) {
        if (this.reserved[n2]) {
            throw new IllegalArgumentException("setElement - position already taken");
        }
        this.cells[n2] = object;
        if (object != null) {
            this.reserved[n2] = true;
        }
    }

    public boolean a(int n2, int n3) {
        if (n2 < 0 || n2 + n3 > this.columns) {
            throw new IndexOutOfBoundsException("reserve - incorrect column/size");
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (this.reserved[i2]) {
                for (int i3 = i2; i3 >= n2; --i3) {
                    this.reserved[i2] = false;
                }
                return false;
            }
            this.reserved[i2] = true;
        }
        return true;
    }

    public void setHorizontalAlignment(int n2) {
        this.horizontalAlignment = n2;
    }

    public void setVerticalAlignment(int n2) {
        this.verticalAlignment = n2;
    }

    public boolean b(int n2) {
        return this.reserved[n2];
    }

    public int a(Object object) {
        if (object == null) {
            return 0;
        }
        if ((b == null ? (b = Row.a("com.lowagie.text.Cell")) : b).isInstance(object)) {
            return 1;
        }
        if ((a == null ? (a = Row.a("com.lowagie.text.Table")) : a).isInstance(object)) {
            return 2;
        }
        return -1;
    }

    public Object getCell(int n2) {
        if (n2 < 0 || n2 > this.columns) {
            throw new IndexOutOfBoundsException("getCell at illegal index :" + n2 + " max is " + this.columns);
        }
        return this.cells[n2];
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.columns; ++i2) {
            if (this.cells[i2] == null) continue;
            return false;
        }
        return true;
    }

    public int columns() {
        return this.columns;
    }

    public int horizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int verticalAlignment() {
        return this.verticalAlignment;
    }

    public static boolean isTag(String string) {
        return "row".equals(string);
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        this.markupAttributes.put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

