/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TextField;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class AcroFields {
    public PdfReader a;
    public PdfWriter b;
    public HashMap c;
    private int topFirst;
    private boolean generateAppearances = true;

    public AcroFields(PdfReader pdfReader, PdfWriter pdfWriter) {
        this.a = pdfReader;
        this.b = pdfWriter;
        this.a();
    }

    public void a() {
        this.c = new HashMap();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.a.getCatalog().get(PdfName.ACROFORM));
        for (int i2 = 1; i2 <= this.a.getNumberOfPages(); ++i2) {
            PdfDictionary pdfDictionary2 = this.a.getPageN(i2);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.ANNOTS));
            if (pdfArray == null) continue;
            ArrayList arrayList = pdfArray.getArrayList();
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                Object object;
                PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList.get(i3));
                if (!PdfName.WIDGET.equals(pdfDictionary3.get(PdfName.SUBTYPE))) continue;
                PdfDictionary pdfDictionary4 = pdfDictionary3;
                PdfDictionary pdfDictionary5 = new PdfDictionary();
                pdfDictionary5.putAll(pdfDictionary3);
                String string = "";
                PdfDictionary pdfDictionary6 = null;
                PdfObject pdfObject = null;
                while (pdfDictionary3 != null) {
                    pdfDictionary5.mergeDifferent(pdfDictionary3);
                    object = (PdfString)pdfDictionary3.get(PdfName.T);
                    if (object != null) {
                        string = ((PdfString)object).toUnicodeString() + "." + string;
                    }
                    if (pdfObject == null && pdfDictionary3.get(PdfName.V) != null) {
                        pdfObject = pdfDictionary3.get(PdfName.V);
                    }
                    if (pdfDictionary6 == null && object != null) {
                        pdfDictionary6 = pdfDictionary3;
                        if (pdfDictionary3.get(PdfName.V) == null && pdfObject != null) {
                            pdfDictionary6.put(PdfName.V, pdfObject);
                        }
                    }
                    pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.PARENT));
                }
                if (string.length() > 0) {
                    string = string.substring(0, string.length() - 1);
                }
                if ((object = (Item)this.c.get(string)) == null) {
                    object = new Item();
                    this.c.put(string, object);
                }
                if (pdfDictionary6 == null) {
                    ((Item)object).values.add(pdfDictionary4);
                } else {
                    ((Item)object).values.add(pdfDictionary6);
                }
                ((Item)object).widgets.add(pdfDictionary4);
                ((Item)object).widget_refs.add(arrayList.get(i3));
                if (pdfDictionary != null) {
                    pdfDictionary5.mergeDifferent(pdfDictionary);
                }
                ((Item)object).merged.add(pdfDictionary5);
                ((Item)object).page.add(new Integer(i2));
            }
        }
    }

    public String[] getAppearanceStates(String string) {
        Item item = (Item)this.c.get(string);
        if (item == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        ArrayList arrayList = item.widgets;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            PdfObject pdfObject;
            PdfDictionary pdfDictionary = (PdfDictionary)arrayList.get(i2);
            if ((pdfDictionary = (PdfDictionary)pdfDictionary.get(PdfName.AP)) == null || (pdfObject = pdfDictionary.get(PdfName.N)) == null || !pdfObject.isDictionary()) continue;
            pdfDictionary = (PdfDictionary)pdfObject;
            Iterator iterator = pdfDictionary.getKeys().iterator();
            while (iterator.hasNext()) {
                String string2 = PdfName.decodeName(((PdfName)iterator.next()).toString());
                hashMap.put(string2, null);
            }
        }
        String[] stringArray = new String[hashMap.size()];
        return hashMap.keySet().toArray(stringArray);
    }

    public boolean renameField(String string, String string2) {
        int n2;
        int n3 = string.lastIndexOf(46) + 1;
        if (n3 != (n2 = string2.lastIndexOf(46) + 1)) {
            return false;
        }
        if (!string.substring(0, n3).equals(string2.substring(0, n2))) {
            return false;
        }
        if (this.c.containsKey(string2)) {
            return false;
        }
        Item item = (Item)this.c.get(string);
        if (item == null) {
            return false;
        }
        string2 = string2.substring(n2);
        PdfString pdfString = new PdfString(string2, "UnicodeBig");
        for (int i2 = 0; i2 < item.merged.size(); ++i2) {
            PdfDictionary pdfDictionary = (PdfDictionary)item.values.get(i2);
            pdfDictionary.put(PdfName.T, pdfString);
            pdfDictionary = (PdfDictionary)item.merged.get(i2);
            pdfDictionary.put(PdfName.T, pdfString);
        }
        this.c.remove(string);
        this.c.put(string2, item);
        return true;
    }

    public PdfAppearance a(PdfDictionary pdfDictionary, String string) throws IOException, DocumentException {
        Object object;
        PdfObject pdfObject;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.topFirst = 0;
        TextField textField = new TextField(this.b, null, null);
        PdfString pdfString = (PdfString)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DA));
        if (pdfString != null) {
            PRIndirectReference pRIndirectReference;
            object5 = new PRTokeniser(PdfEncodings.convertToBytes(pdfString.toUnicodeString(), null));
            object4 = new ArrayList();
            object3 = null;
            while (((PRTokeniser)object5).nextToken()) {
                if (((PRTokeniser)object5).getTokenType() == 4) continue;
                if (((PRTokeniser)object5).getTokenType() == 10) {
                    float f2;
                    float f3;
                    float f4;
                    object2 = ((PRTokeniser)object5).getStringValue();
                    if (((String)object2).equals("Tf")) {
                        if (((ArrayList)object4).size() >= 2) {
                            object3 = (String)((ArrayList)object4).get(((ArrayList)object4).size() - 2);
                            textField.setFontSize(new Float((String)((ArrayList)object4).get(((ArrayList)object4).size() - 1)).floatValue());
                        }
                    } else if (((String)object2).equals("g")) {
                        if (((ArrayList)object4).size() >= 1 && (f4 = new Float((String)((ArrayList)object4).get(((ArrayList)object4).size() - 1)).floatValue()) != 0.0f) {
                            textField.setTextColor(new GrayColor(f4));
                        }
                    } else if (((String)object2).equals("rg")) {
                        if (((ArrayList)object4).size() >= 3) {
                            f4 = new Float((String)((ArrayList)object4).get(((ArrayList)object4).size() - 3)).floatValue();
                            f3 = new Float((String)((ArrayList)object4).get(((ArrayList)object4).size() - 2)).floatValue();
                            f2 = new Float((String)((ArrayList)object4).get(((ArrayList)object4).size() - 1)).floatValue();
                            textField.setTextColor(new Color(f4, f3, f2));
                        }
                    } else if (((String)object2).equals("k") && ((ArrayList)object4).size() >= 4) {
                        f4 = new Float((String)((ArrayList)object4).get(((ArrayList)object4).size() - 4)).floatValue();
                        f3 = new Float((String)((ArrayList)object4).get(((ArrayList)object4).size() - 3)).floatValue();
                        f2 = new Float((String)((ArrayList)object4).get(((ArrayList)object4).size() - 2)).floatValue();
                        float f5 = new Float((String)((ArrayList)object4).get(((ArrayList)object4).size() - 1)).floatValue();
                        textField.setTextColor(new CMYKColor(f4, f3, f2, f5));
                    }
                    ((ArrayList)object4).clear();
                    continue;
                }
                ((ArrayList)object4).add(((PRTokeniser)object5).getStringValue());
            }
            if (object3 != null && (object2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.DR))) != null && (object2 = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.FONT))) != null && (pRIndirectReference = (PRIndirectReference)((PdfDictionary)object2).get(new PdfName((String)object3))) != null) {
                textField.setFont(new DocumentFont(pRIndirectReference));
            }
        }
        if ((object5 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MK))) != null) {
            object4 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.BC));
            textField.setBorderColor(this.a((PdfArray)object4));
            object4 = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.BG));
            textField.setBackgroundColor(this.a((PdfArray)object4));
            object3 = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object5).get(PdfName.R));
            if (object3 != null) {
                textField.setRotation(((PdfNumber)object3).intValue());
            }
        }
        int n2 = 0;
        object3 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FF));
        if (object3 != null) {
            n2 = ((PdfNumber)object3).intValue();
        }
        textField.setOptions((n2 & 0x1000) == 0 ? 0 : 4);
        object3 = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.Q));
        if (object3 != null) {
            if (((PdfNumber)object3).intValue() == 1) {
                textField.setAlignment(1);
            } else if (((PdfNumber)object3).intValue() == 2) {
                textField.setAlignment(2);
            }
        }
        if ((object2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BS))) != null) {
            PdfName pdfName;
            pdfObject = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.W));
            if (pdfObject != null) {
                textField.setBorderWidth(((PdfNumber)pdfObject).floatValue());
            }
            if (PdfName.D.equals(pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.S)))) {
                textField.setBorderStyle(1);
            } else if (PdfName.B.equals(pdfName)) {
                textField.setBorderStyle(2);
            } else if (PdfName.I.equals(pdfName)) {
                textField.setBorderStyle(3);
            } else if (PdfName.U.equals(pdfName)) {
                textField.setBorderStyle(4);
            }
        } else {
            pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.BORDER));
            if (pdfObject != null) {
                ArrayList arrayList = ((PdfArray)pdfObject).getArrayList();
                if (arrayList.size() >= 3) {
                    textField.setBorderWidth(((PdfNumber)arrayList.get(2)).floatValue());
                }
                if (arrayList.size() >= 4) {
                    textField.setBorderStyle(1);
                }
            }
        }
        pdfObject = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RECT));
        Rectangle rectangle = PdfReader.getNormalizedRectangle((PdfArray)pdfObject);
        if (textField.getRotation() == 90 || textField.getRotation() == 270) {
            rectangle = rectangle.rotate();
        }
        textField.setBox(rectangle);
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FT));
        if (PdfName.TX.equals(pdfName)) {
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(pdfDictionary.get(PdfName.MAXLEN));
            int n3 = 0;
            if (pdfNumber != null) {
                n3 = pdfNumber.intValue();
            }
            if (n3 > 0) {
                string = string.substring(0, Math.min(n3, string.length()));
            }
            textField.setText(string);
            return textField.getAppearance();
        }
        if (!PdfName.CH.equals(pdfName)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        if ((n2 & 0x20000) != 0) {
            textField.setText(string);
            return textField.getAppearance();
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.OPT));
        boolean bl2 = false;
        if (pdfArray != null) {
            int n4;
            object = pdfArray.getArrayList();
            String[] stringArray = new String[((ArrayList)object).size()];
            String[] stringArray2 = new String[((ArrayList)object).size()];
            for (n4 = 0; n4 < ((ArrayList)object).size(); ++n4) {
                PdfObject pdfObject2 = (PdfObject)((ArrayList)object).get(n4);
                if (pdfObject2.isString()) {
                    stringArray[n4] = stringArray2[n4] = ((PdfString)pdfObject2).toUnicodeString();
                    continue;
                }
                ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                stringArray2[n4] = ((PdfString)arrayList.get(0)).toUnicodeString();
                stringArray[n4] = ((PdfString)arrayList.get(1)).toUnicodeString();
            }
            n4 = 0;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!string.equals(stringArray[i2])) continue;
                n4 = i2;
                break;
            }
            textField.setChoices(stringArray);
            textField.setChoiceExports(stringArray2);
            textField.setChoiceSelection(n4);
        }
        object = textField.a();
        this.topFirst = textField.b();
        return object;
    }

    public Color a(PdfArray pdfArray) {
        if (pdfArray == null) {
            return null;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        switch (arrayList.size()) {
            case 1: {
                return new GrayColor(((PdfNumber)arrayList.get(0)).floatValue());
            }
            case 3: {
                return new Color(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue());
            }
            case 4: {
                return new CMYKColor(((PdfNumber)arrayList.get(0)).floatValue(), ((PdfNumber)arrayList.get(1)).floatValue(), ((PdfNumber)arrayList.get(2)).floatValue(), ((PdfNumber)arrayList.get(3)).floatValue());
            }
        }
        return null;
    }

    public String getField(String string) {
        Item item = (Item)this.c.get(string);
        if (item == null) {
            return null;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.V));
        if (pdfObject == null) {
            return "";
        }
        if (pdfObject.isString()) {
            return ((PdfString)pdfObject).toUnicodeString();
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    public void setFields(FdfReader fdfReader) throws IOException, DocumentException {
        HashMap hashMap = fdfReader.getFields();
        Iterator iterator = this.c.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = fdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public boolean setField(String string, String string2) throws IOException, DocumentException {
        return this.setField(string, string2, string2);
    }

    public boolean setField(String string, String string2, String string3) throws IOException, DocumentException {
        if (this.b == null) {
            throw new DocumentException("This AcroFields instance is read-only.");
        }
        Item item = (Item)this.c.get(string);
        if (item == null) {
            return false;
        }
        PdfName pdfName = (PdfName)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FT));
        if (PdfName.TX.equals(pdfName) || PdfName.CH.equals(pdfName)) {
            PdfString pdfString = new PdfString(string2, "UnicodeBig");
            for (int i2 = 0; i2 < item.values.size(); ++i2) {
                ((PdfDictionary)item.values.get(i2)).put(PdfName.V, pdfString);
                PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(i2);
                pdfDictionary.put(PdfName.V, pdfString);
                PdfDictionary pdfDictionary2 = (PdfDictionary)item.widgets.get(i2);
                if (this.generateAppearances) {
                    PdfObject pdfObject;
                    PdfAppearance pdfAppearance = this.a(pdfDictionary, string3);
                    if (PdfName.CH.equals(pdfName)) {
                        pdfObject = new PdfNumber(this.topFirst);
                        pdfDictionary2.put(PdfName.TI, pdfObject);
                        pdfDictionary.put(PdfName.TI, pdfObject);
                    }
                    if ((pdfObject = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.AP))) == null) {
                        pdfObject = new PdfDictionary();
                        pdfDictionary2.put(PdfName.AP, pdfObject);
                        pdfDictionary.put(PdfName.AP, pdfObject);
                    }
                    ((PdfDictionary)pdfObject).put(PdfName.N, pdfAppearance.g());
                    continue;
                }
                pdfDictionary2.remove(PdfName.AP);
                pdfDictionary.remove(PdfName.AP);
            }
            return true;
        }
        if (PdfName.BTN.equals(pdfName)) {
            PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)item.merged.get(0)).get(PdfName.FF));
            int n2 = 0;
            if (pdfNumber != null) {
                n2 = pdfNumber.intValue();
            }
            if ((n2 & 0x10000) != 0) {
                return true;
            }
            PdfName pdfName2 = new PdfName(string2);
            if ((n2 & 0x8000) == 0) {
                for (int i3 = 0; i3 < item.values.size(); ++i3) {
                    ((PdfDictionary)item.values.get(i3)).put(PdfName.V, pdfName2);
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(i3);
                    pdfDictionary.put(PdfName.V, pdfName2);
                    pdfDictionary.put(PdfName.AS, pdfName2);
                    PdfDictionary pdfDictionary3 = (PdfDictionary)item.widgets.get(i3);
                    pdfDictionary3.put(PdfName.AS, pdfName2);
                }
            } else {
                for (int i4 = 0; i4 < item.values.size(); ++i4) {
                    ((PdfDictionary)item.values.get(i4)).put(PdfName.V, pdfName2);
                    PdfDictionary pdfDictionary = (PdfDictionary)item.merged.get(i4);
                    PdfDictionary pdfDictionary4 = (PdfDictionary)item.widgets.get(i4);
                    pdfDictionary.put(PdfName.V, pdfName2);
                    if (this.a(pdfDictionary4, pdfName2)) {
                        pdfDictionary.put(PdfName.AS, pdfName2);
                        pdfDictionary4.put(PdfName.AS, pdfName2);
                        continue;
                    }
                    pdfDictionary.put(PdfName.AS, PdfName.OFF);
                    pdfDictionary4.put(PdfName.AS, PdfName.OFF);
                }
            }
            return true;
        }
        return false;
    }

    public boolean a(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.AP));
        if (pdfDictionary2 == null) {
            return false;
        }
        PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.N));
        return pdfDictionary3 != null && pdfDictionary3.get(pdfName) != null;
    }

    public HashMap getFields() {
        return this.c;
    }

    public Item getFieldItem(String string) {
        return (Item)this.c.get(string);
    }

    public float[] getFieldPositions(String string) {
        Item item = (Item)this.c.get(string);
        if (item == null) {
            return null;
        }
        float[] fArray = new float[item.page.size() * 5];
        int n2 = 0;
        for (int i2 = 0; i2 < item.page.size(); ++i2) {
            try {
                PdfDictionary pdfDictionary = (PdfDictionary)item.widgets.get(i2);
                PdfArray pdfArray = (PdfArray)pdfDictionary.get(PdfName.RECT);
                if (pdfArray == null) continue;
                Rectangle rectangle = PdfReader.getNormalizedRectangle(pdfArray);
                fArray[n2] = ((Integer)item.page.get(i2)).floatValue();
                int n3 = ++n2;
                fArray[n3] = rectangle.left();
                int n4 = ++n2;
                fArray[n4] = rectangle.bottom();
                int n5 = ++n2;
                fArray[n5] = rectangle.right();
                int n6 = ++n2;
                ++n2;
                fArray[n6] = rectangle.top();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 < fArray.length) {
            float[] fArray2 = new float[n2];
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            return fArray2;
        }
        return fArray;
    }

    private int removeRefFromArray(PdfArray pdfArray, PdfObject pdfObject) {
        ArrayList arrayList = pdfArray.getArrayList();
        if (pdfObject == null || !pdfObject.isIndirect()) {
            return arrayList.size();
        }
        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfObject;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            PdfObject pdfObject2 = (PdfObject)arrayList.get(i2);
            if (!pdfObject2.isIndirect() || ((PdfIndirectReference)pdfObject2).getNumber() != pdfIndirectReference.getNumber()) continue;
            arrayList.remove(i2--);
        }
        return arrayList.size();
    }

    public boolean removeFieldsFromPage(int n2) {
        if (n2 < 1) {
            return false;
        }
        boolean bl2 = false;
        Iterator iterator = this.c.keySet().iterator();
        while (iterator.hasNext()) {
            boolean bl3 = this.removeField((String)iterator.next(), n2);
            bl2 = bl2 || bl3;
        }
        return bl2;
    }

    public boolean removeField(String string, int n2) {
        Item item = (Item)this.c.get(string);
        if (item == null) {
            return false;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.a.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary == null) {
            return false;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIELDS));
        if (pdfArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < item.widget_refs.size(); ++i2) {
            PdfArray pdfArray2;
            int n3 = (Integer)item.page.get(i2);
            if (n2 != -1 && n2 != n3) continue;
            PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)item.widget_refs.get(i2);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference);
            PdfDictionary pdfDictionary3 = this.a.getPageN(n3);
            PdfArray pdfArray3 = (PdfArray)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.ANNOTS));
            if (pdfArray3 != null && this.removeRefFromArray(pdfArray3, pdfIndirectReference) == 0) {
                pdfDictionary3.remove(PdfName.ANNOTS);
            }
            PdfReader.a(pdfIndirectReference);
            PdfIndirectReference pdfIndirectReference2 = pdfIndirectReference;
            while ((pdfIndirectReference = (PdfIndirectReference)pdfDictionary2.get(PdfName.PARENT)) != null && this.removeRefFromArray(pdfArray2 = (PdfArray)PdfReader.getPdfObject((pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfIndirectReference)).get(PdfName.KIDS)), pdfIndirectReference2) == 0) {
                pdfIndirectReference2 = pdfIndirectReference;
                PdfReader.a(pdfIndirectReference);
            }
            if (pdfIndirectReference == null) {
                this.removeRefFromArray(pdfArray, pdfIndirectReference2);
            }
            if (n2 == -1) continue;
            item.merged.remove(i2);
            item.page.remove(i2);
            item.values.remove(i2);
            item.widget_refs.remove(i2);
            item.widgets.remove(i2);
            --i2;
        }
        if (n2 == -1 || item.merged.size() == 0) {
            this.c.remove(string);
        }
        return true;
    }

    public boolean removeField(String string) {
        return this.removeField(string, -1);
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    public void setGenerateAppearances(boolean bl2) {
        this.generateAppearances = bl2;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.a.getCatalog().get(PdfName.ACROFORM));
        if (bl2) {
            pdfDictionary.remove(PdfName.NEEDAPPEARANCES);
        } else {
            pdfDictionary.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public static class Item {
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList widget_refs = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
    }
}

