/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.awt.Image;

public class BarcodePostnet
extends Barcode {
    public static byte[][] a = new byte[][]{{1, 1, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0, 1, 1, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 0}, {1, 0, 1, 0, 0}};

    public BarcodePostnet() {
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = 7;
    }

    public static byte[] getBarsPostnet(String string) {
        int n2;
        int n3 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            n2 = string.charAt(i2) - 48;
            n3 += n2;
        }
        string = string + (char)((10 - n3 % 10) % 10 + 48);
        byte[] byArray = new byte[string.length() * 5 + 2];
        byArray[0] = 1;
        byArray[byArray.length - 1] = 1;
        for (n2 = 0; n2 < string.length(); ++n2) {
            int n4 = string.charAt(n2) - 48;
            System.arraycopy(a[n4], 0, byArray, n2 * 5 + 1, 5);
        }
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        float f2 = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(f2, this.barHeight);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        byte[] byArray = BarcodePostnet.getBarsPostnet(this.code);
        byte by2 = 1;
        if (this.codeType == 8) {
            by2 = 0;
            byArray[0] = 0;
            byArray[byArray.length - 1] = 0;
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            pdfContentByte.rectangle(f2, 0.0f, this.x - this.inkSpreading, byArray[i2] == by2 ? this.barHeight : this.size);
            f2 += this.n;
        }
        pdfContentByte.fill();
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        throw new UnsupportedOperationException("Not supported with postnet.");
    }
}

