/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfLine;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfCell
extends Rectangle {
    private ArrayList lines;
    private PdfLine line;
    private ArrayList images;
    private float leading;
    private int rownumber;
    private int rowspan;
    private float cellspacing;
    private float cellpadding;
    private boolean header = false;
    private int groupNumber;

    public PdfCell(Cell cell, int n2, float f2, float f3, float f4, float f5, float f6) {
        super(f2, f4, f3, f4);
        Object object;
        Object object2;
        this.setBorder(cell.border());
        this.setBorderWidth(cell.borderWidth());
        this.setBorderColor(cell.borderColor());
        this.setBackgroundColor(cell.backgroundColor());
        this.setGrayFill(cell.grayFill());
        this.lines = new ArrayList();
        this.images = new ArrayList();
        this.leading = cell.leading();
        int n3 = cell.horizontalAlignment();
        f2 += f5 + f6;
        f3 -= f5 + f6;
        float f7 = this.leading + f6;
        float f8 = cell.rowspan();
        switch (cell.verticalAlignment()) {
            case 6: {
                f7 *= f8;
                break;
            }
            case 5: {
                f7 = (float)((double)f7 * ((double)f8 / 1.5));
                break;
            }
            default: {
                f7 -= f6 * 0.4f;
            }
        }
        this.line = new PdfLine(f2, f3, n3, f7);
        Object object3 = cell.getElements();
        block11: while (object3.hasNext()) {
            PdfChunk pdfChunk;
            PdfChunk pdfChunk2;
            Object object4;
            int n4;
            ArrayList arrayList;
            Element element = (Element)object3.next();
            switch (element.type()) {
                case 32: 
                case 34: 
                case 35: {
                    f7 = this.addImage((Image)element, f2, f3, f7, n3);
                    continue block11;
                }
                case 14: {
                    if (this.line.size() > 0) {
                        this.line.resetAlignment();
                        this.lines.add(this.line);
                    }
                    arrayList = new ArrayList();
                    this.processActions(element, null, arrayList);
                    n4 = 0;
                    object2 = ((List)element).getItems().iterator();
                    while (object2.hasNext()) {
                        object = (ListItem)object2.next();
                        this.line = new PdfLine(f2 + ((Paragraph)object).indentationLeft(), f3, n3, this.leading);
                        this.line.setListItem((ListItem)object);
                        object4 = ((Phrase)object).getChunks().iterator();
                        while (object4.hasNext()) {
                            pdfChunk2 = new PdfChunk((Chunk)object4.next(), (PdfAction)arrayList.get(n4++));
                            while ((pdfChunk = this.line.a(pdfChunk2)) != null) {
                                this.lines.add(this.line);
                                this.line = new PdfLine(f2 + ((Paragraph)object).indentationLeft(), f3, n3, this.leading);
                                pdfChunk2 = pdfChunk;
                            }
                            this.line.resetAlignment();
                            this.lines.add(this.line);
                            this.line = new PdfLine(f2 + ((Paragraph)object).indentationLeft(), f3, n3, this.leading);
                        }
                    }
                    this.line = new PdfLine(f2, f3, n3, this.leading);
                    continue block11;
                }
            }
            arrayList = new ArrayList();
            this.processActions(element, null, arrayList);
            n4 = 0;
            object2 = element.getChunks().iterator();
            while (object2.hasNext()) {
                object4 = (Chunk)object2.next();
                pdfChunk2 = new PdfChunk((Chunk)object4, (PdfAction)arrayList.get(n4++));
                while ((pdfChunk = this.line.a(pdfChunk2)) != null) {
                    this.lines.add(this.line);
                    this.line = new PdfLine(f2, f3, n3, this.leading);
                    pdfChunk2 = pdfChunk;
                }
            }
            switch (element.type()) {
                case 12: 
                case 13: 
                case 16: {
                    this.line.resetAlignment();
                    this.lines.add(this.line);
                    this.line = new PdfLine(f2, f3, n3, this.leading);
                }
            }
        }
        if (this.line.size() > 0) {
            this.lines.add(this.line);
        }
        if (this.lines.size() > cell.getMaxLines()) {
            while (this.lines.size() > cell.getMaxLines()) {
                this.lines.remove(this.lines.size() - 1);
            }
            if (cell.getMaxLines() > 0 && (object3 = cell.getShowTruncation()) != null && ((String)object3).length() > 0) {
                object = (PdfLine)this.lines.get(this.lines.size() - 1);
                if (((PdfLine)object).size() >= 0) {
                    object2 = ((PdfLine)object).getChunk(((PdfLine)object).size() - 1);
                    float f9 = new PdfChunk((String)object3, (PdfChunk)object2).a();
                    while (((PdfChunk)object2).toString().length() > 0 && ((PdfChunk)object2).a() + f9 > f3 - f2) {
                        ((PdfChunk)object2).d(((PdfChunk)object2).toString().substring(0, ((PdfChunk)object2).c() - 1));
                    }
                    ((PdfChunk)object2).d(((PdfChunk)object2).toString() + (String)object3);
                } else {
                    ((PdfLine)object).a(new PdfChunk(new Chunk((String)object3), null));
                }
            }
        }
        this.setBottom(f4 - this.leading * (float)(this.lines.size() - 1) - f6 - f7 - 2.0f * f5);
        this.cellpadding = f6;
        this.cellspacing = f5;
        this.rowspan = cell.rowspan();
        this.rownumber = n2;
    }

    public float left() {
        return super.left(this.cellspacing);
    }

    public float right() {
        return super.right(this.cellspacing);
    }

    public float top() {
        return super.top(this.cellspacing);
    }

    public float bottom() {
        return super.bottom(this.cellspacing);
    }

    private float addImage(Image image, float f2, float f3, float f4, int n2) {
        Image image2 = Image.getInstance(image);
        if (image2.scaledWidth() > f3 - f2) {
            image2.scaleToFit(f3 - f2, Float.MAX_VALUE);
        }
        if (this.line.size() != 0) {
            this.lines.add(this.line);
        }
        this.line = new PdfLine(f2, f3, n2, image2.scaledHeight() + 0.4f * this.leading);
        this.lines.add(this.line);
        this.line = new PdfLine(f2, f3, n2, this.leading);
        if ((image2.alignment() & 2) == 2) {
            f2 = f3 - image2.scaledWidth();
        } else if ((image2.alignment() & 1) == 1) {
            f2 += (f3 - f2 - image2.scaledWidth()) / 2.0f;
        }
        image2.setAbsolutePosition(f2, f4 + (float)(this.lines.size() - 2) * this.leading + image2.scaledHeight() + 0.4f * this.leading);
        this.images.add(image2);
        return f4 + image2.scaledHeight() + 0.4f * this.leading;
    }

    public ArrayList getLines(float f2, float f3) {
        float f4 = Math.min(this.top(), f2);
        this.setTop(f4 + this.cellspacing);
        ArrayList<PdfLine> arrayList = new ArrayList<PdfLine>();
        if (this.top() < f3) {
            return arrayList;
        }
        int n2 = this.lines.size();
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2 && bl2; ++i2) {
            this.line = (PdfLine)this.lines.get(i2);
            float f5 = this.line.d();
            if ((f4 -= f5) > f3 + this.cellpadding) {
                arrayList.add(this.line);
                continue;
            }
            bl2 = false;
        }
        float f6 = 0.0f;
        if (!this.header) {
            if (bl2) {
                this.lines = new ArrayList();
            } else {
                n2 = arrayList.size();
                for (int i3 = 0; i3 < n2; ++i3) {
                    this.line = (PdfLine)this.lines.remove(0);
                    f6 += this.line.d();
                }
            }
        }
        if (f6 > 0.0f) {
            Iterator iterator = this.images.iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.setAbsolutePosition(image.absoluteX(), image.absoluteY() - f6 - this.leading);
            }
        }
        return arrayList;
    }

    public ArrayList getImages(float f2, float f3) {
        if (this.top() < f3) {
            return new ArrayList();
        }
        f2 = Math.min(this.top(), f2);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        Iterator iterator = this.images.iterator();
        while (iterator.hasNext() && !this.header) {
            Image image = (Image)iterator.next();
            float f4 = image.absoluteY();
            if (!(f2 - f4 > f3 + this.cellpadding)) continue;
            image.setAbsolutePosition(image.absoluteX(), f2 - f4);
            arrayList.add(image);
            iterator.remove();
        }
        return arrayList;
    }

    public boolean a() {
        return this.header;
    }

    public void b() {
        this.header = true;
    }

    public boolean c() {
        return this.header || this.lines.size() == 0 && this.images.size() == 0;
    }

    public int size() {
        return this.lines.size();
    }

    public int remainingLines() {
        if (this.lines.size() == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = this.lines.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            PdfLine pdfLine = (PdfLine)this.lines.get(i2);
            if (pdfLine.size() <= 0) continue;
            ++n2;
        }
        return n2;
    }

    public float remainingHeight() {
        float f2 = 0.0f;
        Iterator iterator = this.images.iterator();
        while (iterator.hasNext()) {
            Image image = (Image)iterator.next();
            f2 += image.scaledHeight();
        }
        return (float)this.remainingLines() * this.leading + 2.0f * this.cellpadding + this.cellspacing + f2 + this.leading / 2.5f;
    }

    public float leading() {
        return this.leading;
    }

    public int rownumber() {
        return this.rownumber;
    }

    public int rowspan() {
        return this.rowspan;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    public void processActions(Element element, PdfAction pdfAction, ArrayList arrayList) {
        Iterator iterator;
        if (element.type() == 17 && (iterator = ((Anchor)element).reference()) != null) {
            pdfAction = new PdfAction((String)((Object)iterator));
        }
        switch (element.type()) {
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                iterator = ((ArrayList)((Object)element)).iterator();
                while (iterator.hasNext()) {
                    this.processActions((Element)iterator.next(), pdfAction, arrayList);
                }
                break;
            }
            case 10: {
                arrayList.add(pdfAction);
                break;
            }
            case 14: {
                iterator = ((List)element).getItems().iterator();
                while (iterator.hasNext()) {
                    this.processActions((Element)iterator.next(), pdfAction, arrayList);
                }
                break;
            }
            default: {
                ArrayList arrayList2 = element.getChunks();
                int n2 = element.getChunks().size();
                while (n2-- > 0) {
                    arrayList.add(pdfAction);
                }
                break block0;
            }
        }
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public void a(int n2) {
        this.groupNumber = n2;
    }

    public Rectangle rectangle(float f2, float f3) {
        Rectangle rectangle = new Rectangle(this.left(), this.bottom(), this.right(), this.top());
        rectangle.setBorder(this.border);
        rectangle.setBorderWidth(this.borderWidth);
        rectangle.setBorderColor(this.color);
        rectangle.setBackgroundColor(this.background);
        rectangle.setGrayFill(this.grayFill);
        if (this.top() > f2) {
            rectangle.setTop(f2);
            rectangle.setBorder(this.border - (this.border & 1));
        }
        if (this.bottom() < f3) {
            rectangle.setBottom(f3);
            rectangle.setBorder(this.border - (this.border & 2));
        }
        return rectangle;
    }
}

