/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfFont;
import java.awt.Color;
import java.util.HashMap;

public class PdfChunk
implements SplitCharacter {
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final HashMap keysAttributes = new HashMap();
    private static final HashMap keysNoStroke = new HashMap();
    public String value = "";
    public String encoding = "Cp1252";
    public PdfFont font;
    public BaseFont baseFont;
    public SplitCharacter splitCharacter;
    public HashMap attributes = new HashMap();
    public HashMap noStroke = new HashMap();
    public boolean newlineSplit;
    public Image image;
    public float offsetX;
    public float offsetY;
    public boolean changeLeading = false;

    public PdfChunk(String string, PdfChunk pdfChunk) {
        this.value = string;
        this.font = pdfChunk.font;
        this.attributes = pdfChunk.attributes;
        this.noStroke = pdfChunk.noStroke;
        this.baseFont = pdfChunk.baseFont;
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.encoding = this.font.c().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    public PdfChunk(Chunk chunk, PdfAction pdfAction) {
        Object object;
        Object[] objectArray;
        this.value = chunk.content();
        Font font = chunk.font();
        float f2 = font.size();
        if (f2 == -1.0f) {
            f2 = 12.0f;
        }
        this.baseFont = font.getBaseFont();
        int n2 = font.style();
        if (n2 == -1) {
            n2 = 0;
        }
        if (this.baseFont == null) {
            this.baseFont = font.getCalculatedBaseFont(false);
        } else {
            if ((n2 & 1) != 0) {
                this.attributes.put("TEXTRENDERMODE", new Object[]{new Integer(2), new Float(f2 / 30.0f), null});
            }
            if ((n2 & 2) != 0) {
                this.attributes.put("SKEW", new float[]{0.0f, 0.21256f});
            }
        }
        this.font = new PdfFont(this.baseFont, f2);
        HashMap hashMap = chunk.getAttributes();
        if (hashMap != null) {
            objectArray = hashMap.keySet().iterator();
            while (objectArray.hasNext()) {
                object = objectArray.next();
                if (keysAttributes.containsKey(object)) {
                    this.attributes.put(object, hashMap.get(object));
                    continue;
                }
                if (!keysNoStroke.containsKey(object)) continue;
                this.noStroke.put(object, hashMap.get(object));
            }
            if ("".equals(hashMap.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.content());
            }
        }
        if (font.isUnderlined()) {
            objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, -0.33333334f, 0.0f}};
            object = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (font.isStrikethru()) {
            objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, 0.33333334f, 0.0f}};
            object = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (pdfAction != null) {
            this.attributes.put("ACTION", pdfAction);
        }
        this.noStroke.put("COLOR", font.color());
        this.noStroke.put("ENCODING", this.font.c().getEncoding());
        objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.font.a(this.image);
        this.encoding = this.font.c().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    public char getUnicodeEquivalent(char c2) {
        return this.baseFont.getUnicodeEquivalent(c2);
    }

    public int getWord(String string, int n2) {
        int n3 = string.length();
        while (n2 < n3 && Character.isLetter(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    public PdfChunk b(float f2) {
        Object object;
        char c2;
        int n2;
        this.newlineSplit = false;
        if (this.image != null) {
            if (this.image.scaledWidth() > f2) {
                PdfChunk pdfChunk = new PdfChunk("\ufffc", this);
                this.value = "";
                this.attributes = new HashMap();
                this.image = null;
                this.font = PdfFont.b();
                return pdfChunk;
            }
            return null;
        }
        HyphenationEvent hyphenationEvent = (HyphenationEvent)this.noStroke.get("HYPHENATION");
        int n3 = -1;
        float f3 = 0.0f;
        int n4 = -1;
        float f4 = 0.0f;
        int n5 = this.value.length();
        char c3 = '\u0000';
        BaseFont baseFont = this.font.c();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            for (n2 = 0; n2 < n5; ++n2) {
                c2 = this.value.charAt(n2);
                c3 = baseFont.getUnicodeEquivalent(c2);
                if (c3 == '\n') {
                    this.newlineSplit = true;
                    String string = this.value.substring(n2 + 1);
                    this.value = this.value.substring(0, n2);
                    if (this.value.length() < 1) {
                        this.value = "\u0001";
                    }
                    PdfChunk pdfChunk = new PdfChunk(string, this);
                    return pdfChunk;
                }
                f3 += this.font.a(c2);
                if (c3 == ' ') {
                    n4 = n2 + 1;
                    f4 = f3;
                }
                if (!(f3 > f2)) {
                    if (!this.splitCharacter.isSplitCharacter(c3)) continue;
                    n3 = n2 + 1;
                    continue;
                }
                break;
            }
        } else {
            while (n2 < n5) {
                c3 = this.value.charAt(n2);
                if (c3 == '\r' || c3 == '\n') {
                    this.newlineSplit = true;
                    int n6 = 1;
                    if (c3 == '\r' && n2 + 1 < n5 && this.value.charAt(n2 + 1) == '\n') {
                        n6 = 2;
                    }
                    String string = this.value.substring(n2 + n6);
                    this.value = this.value.substring(0, n2);
                    if (this.value.length() < 1) {
                        this.value = " ";
                    }
                    PdfChunk pdfChunk = new PdfChunk(string, this);
                    return pdfChunk;
                }
                f3 += this.font.a(c3);
                if (c3 == ' ') {
                    n4 = n2 + 1;
                    f4 = f3;
                }
                if (!(f3 > f2)) {
                    if (this.splitCharacter.isSplitCharacter(c3)) {
                        n3 = n2 + 1;
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        if (n2 == n5) {
            return null;
        }
        if (n3 < 0) {
            String string = this.value;
            this.value = "";
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        if (n4 > n3 && this.splitCharacter.isSplitCharacter(' ')) {
            n3 = n4;
        }
        if (hyphenationEvent != null && n4 < n2 && (c2 = this.getWord(this.value, n4)) > n4) {
            object = hyphenationEvent.getHyphenatedWordPre(this.value.substring(n4, c2), this.font.c(), this.font.d(), f2 - f4);
            String string = hyphenationEvent.getHyphenatedWordPost();
            if (((String)object).length() > 0) {
                String string2 = string + this.value.substring(c2);
                this.value = this.b(this.value.substring(0, n4) + (String)object);
                PdfChunk pdfChunk = new PdfChunk(string2, this);
                return pdfChunk;
            }
        }
        String string = this.value.substring(n3);
        this.value = this.b(this.value.substring(0, n3));
        object = new PdfChunk(string, this);
        return object;
    }

    public PdfChunk a(float f2) {
        char c2;
        int n2;
        if (this.image != null) {
            if (this.image.scaledWidth() > f2) {
                PdfChunk pdfChunk = new PdfChunk("", this);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = PdfFont.b();
                return pdfChunk;
            }
            return null;
        }
        float f3 = 0.0f;
        if (f2 < this.font.a()) {
            String string = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        int n3 = this.value.length();
        for (n2 = 0; n2 < n3 && !((f3 += this.font.a(c2 = this.value.charAt(n2))) > f2); ++n2) {
        }
        if (n2 == n3) {
            return null;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        String string = this.value.substring(n2);
        this.value = this.value.substring(0, n2);
        PdfChunk pdfChunk = new PdfChunk(string, this);
        return pdfChunk;
    }

    public PdfFont e() {
        return this.font;
    }

    public Color f() {
        return (Color)this.noStroke.get("COLOR");
    }

    public float a() {
        if (this.image != null) {
            return this.image.scaledWidth();
        }
        return this.font.c().getWidthPoint(this.value, this.font.d());
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float f2, float f3) {
        if (this.image != null) {
            return this.image.scaledWidth() + f2;
        }
        int n2 = 0;
        int n3 = -1;
        while ((n3 = this.value.indexOf(32, n3 + 1)) >= 0) {
            ++n2;
        }
        return this.font.c().getWidthPoint(this.value, this.font.d()) + (float)this.value.length() * f2 + (float)n2 * f3;
    }

    public float trimLastSpace() {
        BaseFont baseFont = this.font.c();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.a('\u0001');
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.a(' ');
        }
        return 0.0f;
    }

    public Object c(String string) {
        if (this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return this.noStroke.get(string);
    }

    public boolean a(String string) {
        if (this.attributes.containsKey(string)) {
            return true;
        }
        return this.noStroke.containsKey(string);
    }

    public boolean i() {
        return this.attributes.size() > 0;
    }

    public boolean j() {
        return this.image != null;
    }

    public Image g() {
        return this.image;
    }

    public float h() {
        return this.offsetX;
    }

    public float d() {
        return this.offsetY;
    }

    public void d(String string) {
        this.value = string;
    }

    public String toString() {
        return this.value;
    }

    public boolean b() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    public int c() {
        return this.value.length();
    }

    public boolean isSplitCharacter(char c2) {
        if (c2 <= ' ' || c2 == '-') {
            return true;
        }
        if (c2 < '\u2e80') {
            return false;
        }
        return c2 >= '\u2e80' && c2 < '\ud7a0' || c2 >= '\uf900' && c2 < '\ufb00' || c2 >= '\ufe30' && c2 < '\ufe50' || c2 >= '\uff61' && c2 < '\uffa0';
    }

    public boolean a(char c2) {
        return this.splitCharacter.isSplitCharacter(c2);
    }

    public String b(String string) {
        BaseFont baseFont = this.font.c();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            while (string.endsWith("\u0001")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            while (string.endsWith(" ") || string.endsWith("\t")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    public float b(char c2) {
        if (PdfChunk.noPrint(c2)) {
            return 0.0f;
        }
        return this.font.a(c2);
    }

    public static boolean noPrint(char c2) {
        return c2 >= '\u200b' && c2 <= '\u200f' || c2 >= '\u202a' && c2 <= '\u202e';
    }

    static {
        keysAttributes.put("ACTION", null);
        keysAttributes.put("UNDERLINE", null);
        keysAttributes.put("REMOTEGOTO", null);
        keysAttributes.put("LOCALGOTO", null);
        keysAttributes.put("LOCALDESTINATION", null);
        keysAttributes.put("GENERICTAG", null);
        keysAttributes.put("NEWPAGE", null);
        keysAttributes.put("IMAGE", null);
        keysAttributes.put("BACKGROUND", null);
        keysAttributes.put("PDFANNOTATION", null);
        keysAttributes.put("SKEW", null);
        keysNoStroke.put("SUBSUPSCRIPT", null);
        keysNoStroke.put("SPLITCHARACTER", null);
        keysNoStroke.put("HYPHENATION", null);
        keysNoStroke.put("TEXTRENDERMODE", null);
    }
}

