/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class PdfContents
extends PdfStream {
    public static final byte[] h = DocWriter.getISOBytes("q\n");
    public static final byte[] c = DocWriter.getISOBytes("Q\n");
    public static final byte[] d = DocWriter.getISOBytes("0 1 -1 0 ");
    public static final byte[] e = DocWriter.getISOBytes("-1 0 0 -1 ");
    public static final byte[] i = DocWriter.getISOBytes("0 -1 1 0 ");
    public static final byte[] a = DocWriter.getISOBytes(" cm\n");

    public PdfContents(PdfContentByte pdfContentByte, PdfContentByte pdfContentByte2, PdfContentByte pdfContentByte3, PdfContentByte pdfContentByte4, Rectangle rectangle) throws BadPdfFormatException {
        try {
            OutputStream outputStream = null;
            this.streamBytes = new ByteArrayOutputStream();
            if (Document.compress) {
                this.compressed = true;
                outputStream = new DeflaterOutputStream(this.streamBytes);
            } else {
                outputStream = this.streamBytes;
            }
            int n2 = rectangle.getRotation();
            switch (n2) {
                case 90: {
                    outputStream.write(d);
                    outputStream.write(DocWriter.getISOBytes(ByteBuffer.formatDouble(rectangle.top())));
                    outputStream.write(32);
                    outputStream.write(48);
                    outputStream.write(a);
                    break;
                }
                case 180: {
                    outputStream.write(e);
                    outputStream.write(DocWriter.getISOBytes(ByteBuffer.formatDouble(rectangle.right())));
                    outputStream.write(32);
                    outputStream.write(DocWriter.getISOBytes(ByteBuffer.formatDouble(rectangle.top())));
                    outputStream.write(a);
                    break;
                }
                case 270: {
                    outputStream.write(i);
                    outputStream.write(48);
                    outputStream.write(32);
                    outputStream.write(DocWriter.getISOBytes(ByteBuffer.formatDouble(rectangle.right())));
                    outputStream.write(a);
                }
            }
            if (pdfContentByte.b() > 0) {
                outputStream.write(h);
                pdfContentByte.a().writeTo(outputStream);
                outputStream.write(c);
            }
            if (pdfContentByte2.b() > 0) {
                outputStream.write(h);
                pdfContentByte2.a().writeTo(outputStream);
                outputStream.write(c);
            }
            if (pdfContentByte3 != null) {
                outputStream.write(h);
                pdfContentByte3.a().writeTo(outputStream);
                outputStream.write(c);
            }
            if (pdfContentByte4.b() > 0) {
                pdfContentByte4.a().writeTo(outputStream);
            }
            outputStream.close();
        }
        catch (Exception exception) {
            throw new BadPdfFormatException(exception.getMessage());
        }
        this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
        if (this.compressed) {
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        }
    }
}

