/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Graphic;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.StringCompare;
import com.lowagie.text.Table;
import com.lowagie.text.Watermark;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfCell;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPTableEvent;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTable;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class PdfDocument
extends Document
implements DocListener {
    private PdfWriter writer;
    private PdfInfo info = new PdfInfo(this);
    private boolean firstPageEvent = true;
    private boolean isParagraph = true;
    private PdfLine line = null;
    private float indentLeft = 0.0f;
    private float indentRight = 0.0f;
    private float listIndentLeft = 0.0f;
    private int alignment = 0;
    private PdfContentByte text;
    private PdfContentByte graphics;
    private ArrayList lines = new ArrayList();
    private float leading = 0.0f;
    private float currentHeight = 0.0f;
    private float indentTop = 0.0f;
    private float indentBottom = 0.0f;
    private boolean pageEmpty = true;
    private int textEmptySize;
    public Rectangle nextPageSize = null;
    public Rectangle thisCropSize = null;
    public Rectangle cropSize = null;
    public PageResources pageResources;
    private Image imageWait = null;
    private float imageEnd = -1.0f;
    private float imageIndentLeft = 0.0f;
    private float imageIndentRight = 0.0f;
    private ArrayList annotations;
    private ArrayList delayedAnnotations = new ArrayList();
    public PdfAcroForm a;
    private PdfOutline rootOutline;
    private PdfOutline currentOutline;
    private PdfAction currentAction = null;
    private TreeMap localDestinations = new TreeMap(new StringCompare());
    private ArrayList documentJavaScript = new ArrayList();
    private int viewerPreferences = 0;
    private String openActionName;
    private PdfAction openActionAction;
    private PdfDictionary additionalActions;
    private PdfPageLabels pageLabels;
    private boolean isNewpage = false;
    private float paraIndent = 0.0f;
    public float nextMarginLeft;
    public float nextMarginRight;
    public float nextMarginTop;
    public float nextMarginBottom;
    public int duration = -1;
    public PdfTransition transition = null;
    public PdfDictionary pageAA = null;
    private boolean strictImageSequence = false;

    public PdfDocument() throws DocumentException {
        this.addProducer();
        this.addCreationDate();
    }

    public void addWriter(PdfWriter pdfWriter) throws DocumentException {
        if (this.writer == null) {
            this.writer = pdfWriter;
            this.a = new PdfAcroForm(pdfWriter);
            return;
        }
        throw new DocumentException("You can only add a writer to a PdfDocument once.");
    }

    public boolean setPageSize(Rectangle rectangle) {
        if (this.writer != null && this.writer.g()) {
            return false;
        }
        this.nextPageSize = new Rectangle(rectangle);
        return true;
    }

    public void setHeader(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.g()) {
            return;
        }
        super.setHeader(headerFooter);
    }

    public void resetHeader() {
        if (this.writer != null && this.writer.g()) {
            return;
        }
        super.resetHeader();
    }

    public void setFooter(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.g()) {
            return;
        }
        super.setFooter(headerFooter);
    }

    public void resetFooter() {
        if (this.writer != null && this.writer.g()) {
            return;
        }
        super.resetFooter();
    }

    public void resetPageCount() {
        if (this.writer != null && this.writer.g()) {
            return;
        }
        super.resetPageCount();
    }

    public void setPageCount(int n2) {
        if (this.writer != null && this.writer.g()) {
            return;
        }
        super.setPageCount(n2);
    }

    public boolean add(Watermark watermark) {
        if (this.writer != null && this.writer.g()) {
            return false;
        }
        this.watermark = watermark;
        return true;
    }

    public void removeWatermark() {
        if (this.writer != null && this.writer.g()) {
            return;
        }
        this.watermark = null;
    }

    public boolean setMargins(float f2, float f3, float f4, float f5) {
        if (this.writer != null && this.writer.g()) {
            return false;
        }
        this.nextMarginLeft = f2;
        this.nextMarginRight = f3;
        this.nextMarginTop = f4;
        this.nextMarginBottom = f5;
        return true;
    }

    public PdfArray rotateAnnotations() {
        PdfArray pdfArray = new PdfArray();
        int n2 = this.pageSize.getRotation() % 360;
        int n3 = this.writer.b();
        for (int i2 = 0; i2 < this.annotations.size(); ++i2) {
            Object object;
            PdfAnnotation pdfAnnotation = (PdfAnnotation)this.annotations.get(i2);
            int n4 = pdfAnnotation.getPlaceInPage();
            if (n4 > n3) {
                this.delayedAnnotations.add(pdfAnnotation);
                continue;
            }
            if (pdfAnnotation.isForm()) {
                if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.e()) != null) {
                    this.a.a((HashMap)object);
                }
                if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                    this.a.a(((PdfAnnotation)object).d());
                }
            }
            if (pdfAnnotation.isAnnotation()) {
                pdfArray.add(pdfAnnotation.d());
                if (!pdfAnnotation.isUsed()) {
                    object = (PdfRectangle)pdfAnnotation.get(PdfName.RECT);
                    switch (n2) {
                        case 90: {
                            pdfAnnotation.put(PdfName.RECT, new PdfRectangle(this.pageSize.top() - ((PdfRectangle)object).bottom(), ((PdfRectangle)object).left(), this.pageSize.top() - ((PdfRectangle)object).top(), ((PdfRectangle)object).right()));
                            break;
                        }
                        case 180: {
                            pdfAnnotation.put(PdfName.RECT, new PdfRectangle(this.pageSize.right() - ((PdfRectangle)object).left(), this.pageSize.top() - ((PdfRectangle)object).bottom(), this.pageSize.right() - ((PdfRectangle)object).right(), this.pageSize.top() - ((PdfRectangle)object).top()));
                            break;
                        }
                        case 270: {
                            pdfAnnotation.put(PdfName.RECT, new PdfRectangle(((PdfRectangle)object).bottom(), this.pageSize.right() - ((PdfRectangle)object).left(), ((PdfRectangle)object).top(), this.pageSize.right() - ((PdfRectangle)object).right()));
                        }
                    }
                }
            }
            if (pdfAnnotation.isUsed()) continue;
            pdfAnnotation.a();
            try {
                this.writer.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.d());
                continue;
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
        return pdfArray;
    }

    public PdfDictionary codeTransition(PdfTransition pdfTransition) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.TRANS);
        switch (pdfTransition.getType()) {
            case 1: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.V);
                pdfDictionary.put(PdfName.M, PdfName.O);
                break;
            }
            case 2: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.H);
                pdfDictionary.put(PdfName.M, PdfName.O);
                break;
            }
            case 3: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.V);
                pdfDictionary.put(PdfName.M, PdfName.I);
                break;
            }
            case 4: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.H);
                pdfDictionary.put(PdfName.M, PdfName.I);
                break;
            }
            case 5: {
                pdfDictionary.put(PdfName.S, PdfName.BLINDS);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.V);
                break;
            }
            case 6: {
                pdfDictionary.put(PdfName.S, PdfName.BLINDS);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.H);
                break;
            }
            case 7: {
                pdfDictionary.put(PdfName.S, PdfName.BOX);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.M, PdfName.I);
                break;
            }
            case 8: {
                pdfDictionary.put(PdfName.S, PdfName.BOX);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.M, PdfName.O);
                break;
            }
            case 9: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(0));
                break;
            }
            case 10: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(180));
                break;
            }
            case 11: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(90));
                break;
            }
            case 12: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(270));
                break;
            }
            case 13: {
                pdfDictionary.put(PdfName.S, PdfName.DISSOLVE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                break;
            }
            case 14: {
                pdfDictionary.put(PdfName.S, PdfName.GLITTER);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(0));
                break;
            }
            case 15: {
                pdfDictionary.put(PdfName.S, PdfName.GLITTER);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(270));
                break;
            }
            case 16: {
                pdfDictionary.put(PdfName.S, PdfName.GLITTER);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(315));
            }
        }
        return pdfDictionary;
    }

    public boolean newPage() throws DocumentException {
        PdfObject pdfObject;
        this.isNewpage = true;
        if (this.writer.getDirectContent().b() == 0 && this.writer.getDirectContentUnder().b() == 0 && (this.pageEmpty || this.writer != null && this.writer.g())) {
            return false;
        }
        PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
        if (pdfPageEvent != null) {
            pdfPageEvent.onEndPage(this.writer, this);
        }
        super.newPage();
        this.imageIndentLeft = 0.0f;
        this.imageIndentRight = 0.0f;
        this.flushLines();
        PdfDictionary pdfDictionary = this.pageResources.a();
        int n2 = this.pageSize.getRotation();
        PdfPage pdfPage = n2 == 0 ? new PdfPage(new PdfRectangle(this.pageSize, n2), this.thisCropSize, pdfDictionary) : new PdfPage(new PdfRectangle(this.pageSize, n2), this.thisCropSize, pdfDictionary, new PdfNumber(n2));
        if (this.transition != null) {
            pdfPage.put(PdfName.TRANS, this.codeTransition(this.transition));
            this.transition = null;
        }
        if (this.duration > 0) {
            pdfPage.put(PdfName.DUR, new PdfNumber(this.duration));
            this.duration = 0;
        }
        if (this.pageAA != null) {
            try {
                pdfPage.put(PdfName.AA, this.writer.addToBody(this.pageAA).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.pageAA = null;
        }
        if (this.annotations.size() > 0 && (pdfObject = this.rotateAnnotations()).size() != 0) {
            pdfPage.put(PdfName.ANNOTS, pdfObject);
        }
        if (!this.open || this.close) {
            throw new PdfException("The document isn't open.");
        }
        if (this.text.b() > this.textEmptySize) {
            this.text.endText();
        } else {
            this.text = null;
        }
        pdfObject = this.writer.a(pdfPage, new PdfContents(this.writer.getDirectContentUnder(), this.graphics, this.text, this.writer.getDirectContent(), this.pageSize));
        this.initPage();
        this.isNewpage = false;
        return true;
    }

    public void open() {
        if (!this.open) {
            super.open();
            this.writer.open();
            this.currentOutline = this.rootOutline = new PdfOutline(this.writer);
        }
        try {
            this.initPage();
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public void b(PdfOutline pdfOutline) throws IOException {
        int n2;
        pdfOutline.setIndirectReference(this.writer.getPdfIndirectReference());
        if (pdfOutline.parent() != null) {
            pdfOutline.put(PdfName.PARENT, pdfOutline.parent().indirectReference());
        }
        ArrayList arrayList = pdfOutline.getKids();
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            this.b((PdfOutline)arrayList.get(n2));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 > 0) {
                ((PdfOutline)arrayList.get(n2)).put(PdfName.PREV, ((PdfOutline)arrayList.get(n2 - 1)).indirectReference());
            }
            if (n2 >= n3 - 1) continue;
            ((PdfOutline)arrayList.get(n2)).put(PdfName.NEXT, ((PdfOutline)arrayList.get(n2 + 1)).indirectReference());
        }
        if (n3 > 0) {
            pdfOutline.put(PdfName.FIRST, ((PdfOutline)arrayList.get(0)).indirectReference());
            pdfOutline.put(PdfName.LAST, ((PdfOutline)arrayList.get(n3 - 1)).indirectReference());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            PdfOutline pdfOutline2 = (PdfOutline)arrayList.get(n2);
            this.writer.addToBody((PdfObject)pdfOutline2, pdfOutline2.indirectReference());
        }
    }

    public void d() throws IOException {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.b(this.rootOutline);
        this.writer.addToBody((PdfObject)this.rootOutline, this.rootOutline.indirectReference());
    }

    public void a(PdfOutline pdfOutline) {
        ArrayList arrayList = pdfOutline.getKids();
        PdfOutline pdfOutline2 = pdfOutline.parent();
        if (arrayList.size() == 0) {
            if (pdfOutline2 != null) {
                pdfOutline2.a(pdfOutline2.a() + 1);
            }
        } else {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                this.a((PdfOutline)arrayList.get(i2));
            }
            if (pdfOutline2 != null) {
                if (pdfOutline.isOpen()) {
                    pdfOutline2.a(pdfOutline.a() + pdfOutline2.a() + 1);
                } else {
                    pdfOutline2.a(pdfOutline2.a() + 1);
                    pdfOutline.a(-pdfOutline.a());
                }
            }
        }
    }

    public void a() {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.a(this.rootOutline);
    }

    public void close() {
        if (this.close) {
            return;
        }
        try {
            this.newPage();
            if (this.imageWait != null) {
                this.newPage();
            }
            if (this.annotations.size() > 0) {
                throw new RuntimeException(this.annotations.size() + " annotations had invalid placement pages.");
            }
            PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
            if (pdfPageEvent != null) {
                pdfPageEvent.onCloseDocument(this.writer, this);
            }
            super.close();
            this.writer.a(this.localDestinations);
            this.a();
            this.d();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.writer.close();
    }

    public PageResources b() {
        return this.pageResources;
    }

    public void b(PdfPTable pdfPTable, float f2) throws DocumentException {
        int n2;
        float[] fArray;
        int n3;
        float f3;
        if (pdfPTable.getHeaderRows() >= pdfPTable.size()) {
            return;
        }
        boolean bl2 = pdfPTable.getSkipFirstHeader();
        float f4 = pdfPTable.getHeaderHeight();
        float f5 = this.f();
        float f6 = f3 = this.indentTop() - this.currentHeight;
        int n4 = n3 = pdfPTable.getHeaderRows();
        PdfContentByte[] pdfContentByteArray = null;
        float f7 = 0.0f;
        int n5 = 0;
        int n6 = 0;
        float[] fArray2 = pdfPTable.getAbsoluteWidths();
        PdfPTableEvent pdfPTableEvent = pdfPTable.getTableEvent();
        pdfPTable.setTableEvent(null);
        float[] fArray3 = new float[pdfPTable.size()];
        int n7 = 0;
        for (n4 = n3; n4 < pdfPTable.size(); ++n4) {
            if (n4 == n3 && f6 - pdfPTable.getRowHeight(n4) - f4 < f5) {
                if (this.currentHeight == 0.0f) {
                    ++n3;
                    continue;
                }
                this.newPage();
                n3 = n4--;
                f5 = this.f();
                f6 = f3 = this.indentTop() - this.currentHeight;
                bl2 = false;
                continue;
            }
            if (f6 - pdfPTable.getRowHeight(n4) < f5) {
                if (pdfContentByteArray != null) {
                    if (pdfPTableEvent != null) {
                        fArray = new float[n7 + 1];
                        fArray[0] = f7;
                        for (n2 = 0; n2 < n7; ++n2) {
                            fArray[n2 + 1] = fArray[n2] - fArray3[n2];
                        }
                        pdfPTableEvent.tableLayout(pdfPTable, pdfPTable.a(f2, n5, n5 + n7 - n6, true), fArray, n6, n5, pdfContentByteArray);
                    }
                    PdfPTable.endWritingRows(pdfContentByteArray);
                    pdfContentByteArray = null;
                }
                this.newPage();
                n3 = n4--;
                f5 = this.f();
                f6 = f3 = this.indentTop() - this.currentHeight;
                continue;
            }
            if (pdfContentByteArray == null) {
                pdfContentByteArray = PdfPTable.beginWritingRows(this.writer.getDirectContent());
                if (pdfPTableEvent != null && !bl2) {
                    n7 = 0;
                    n6 = pdfPTable.getHeaderRows();
                    for (int i2 = 0; i2 < n6; ++i2) {
                        fArray3[n7++] = pdfPTable.getRowHeight(i2);
                    }
                    f7 = f6;
                    n5 = n4;
                }
                if (!bl2) {
                    f6 = pdfPTable.writeSelectedRows(0, pdfPTable.getHeaderRows(), f2, f6, pdfContentByteArray);
                } else {
                    bl2 = false;
                }
            }
            if (pdfPTableEvent != null) {
                fArray3[n7++] = pdfPTable.getRowHeight(n4);
            }
            f6 = pdfPTable.writeSelectedRows(n4, n4 + 1, f2, f6, pdfContentByteArray);
        }
        if (pdfContentByteArray != null) {
            if (pdfPTableEvent != null) {
                fArray = new float[n7 + 1];
                fArray[0] = f7;
                for (n2 = 0; n2 < n7; ++n2) {
                    fArray[n2 + 1] = fArray[n2] - fArray3[n2];
                }
                pdfPTableEvent.tableLayout(pdfPTable, pdfPTable.a(f2, n5, n5 + n7 - n6, true), fArray, n6, n5, pdfContentByteArray);
            }
            PdfPTable.endWritingRows(pdfContentByteArray);
            this.text.moveText(0.0f, f6 - f3);
            this.currentHeight = this.indentTop() - f6;
        }
        pdfPTable.setTableEvent(pdfPTableEvent);
    }

    public boolean add(Element element) throws DocumentException {
        if (this.writer != null && this.writer.g()) {
            return false;
        }
        try {
            switch (element.type()) {
                case 0: {
                    this.info.a(((Meta)element).name(), ((Meta)element).content());
                    break;
                }
                case 1: {
                    this.info.a(((Meta)element).content());
                    break;
                }
                case 2: {
                    this.info.c(((Meta)element).content());
                    break;
                }
                case 3: {
                    this.info.e(((Meta)element).content());
                    break;
                }
                case 4: {
                    this.info.b(((Meta)element).content());
                    break;
                }
                case 7: {
                    this.info.d(((Meta)element).content());
                    break;
                }
                case 5: {
                    this.info.a();
                    break;
                }
                case 6: {
                    this.info.b();
                    break;
                }
                case 10: {
                    PdfChunk pdfChunk;
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk pdfChunk2 = new PdfChunk((Chunk)element, this.currentAction);
                    while ((pdfChunk = this.line.a(pdfChunk2)) != null) {
                        this.carriageReturn();
                        pdfChunk2 = pdfChunk;
                    }
                    this.pageEmpty = false;
                    if (!pdfChunk2.a("NEWPAGE")) break;
                    this.newPage();
                    break;
                }
                case 17: {
                    Anchor anchor = (Anchor)element;
                    String string = anchor.reference();
                    this.leading = anchor.leading();
                    if (string != null) {
                        this.currentAction = new PdfAction(string);
                    }
                    element.process(this);
                    this.currentAction = null;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annotation = (Annotation)element;
                    switch (annotation.annotationType()) {
                        case 1: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((URL)annotation.attributes().get(Annotation.URL))));
                            break;
                        }
                        case 2: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.FILE))));
                            break;
                        }
                        case 3: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.FILE), (String)annotation.attributes().get(Annotation.DESTINATION))));
                            break;
                        }
                        case 7: {
                            boolean[] blArray = (boolean[])annotation.attributes().get(Annotation.PARAMETERS);
                            String string = (String)annotation.attributes().get(Annotation.FILE);
                            String string2 = (String)annotation.attributes().get(Annotation.MIMETYPE);
                            PdfFileSpecification pdfFileSpecification = blArray[0] ? PdfFileSpecification.fileEmbedded(this.writer, string, string, null) : PdfFileSpecification.fileExtern(this.writer, string);
                            PdfAnnotation pdfAnnotation = PdfAnnotation.createScreen(this.writer, new Rectangle(annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury()), string, pdfFileSpecification, string2, blArray[1]);
                            this.annotations.add(pdfAnnotation);
                            break;
                        }
                        case 4: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.FILE), (Integer)annotation.attributes().get(Annotation.PAGE))));
                            break;
                        }
                        case 5: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((Integer)annotation.attributes().get(Annotation.NAMED))));
                            break;
                        }
                        case 6: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.APPLICATION), (String)annotation.attributes().get(Annotation.PARAMETERS), (String)annotation.attributes().get(Annotation.OPERATION), (String)annotation.attributes().get(Annotation.DEFAULTDIR))));
                            break;
                        }
                        default: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(this.indentRight() - this.line.c()), annotation.lly(this.indentTop() - this.currentHeight), annotation.urx(this.indentRight() - this.line.c() + 20.0f), annotation.ury(this.indentTop() - this.currentHeight - 20.0f), new PdfString(annotation.title()), new PdfString(annotation.content())));
                        }
                    }
                    this.pageEmpty = false;
                    break;
                }
                case 11: {
                    this.leading = ((Phrase)element).leading();
                    element.process(this);
                    break;
                }
                case 12: {
                    Paragraph paragraph = (Paragraph)element;
                    this.alignment = paragraph.alignment();
                    this.leading = paragraph.leading();
                    this.carriageReturn();
                    if (this.currentHeight + this.line.d() + this.leading > this.indentTop() - this.f()) {
                        this.newPage();
                    }
                    this.indentLeft += paragraph.indentationLeft();
                    this.indentRight += paragraph.indentationRight();
                    this.carriageReturn();
                    this.paraIndent += paragraph.indentationLeft();
                    PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
                    if (pdfPageEvent != null && this.isParagraph) {
                        pdfPageEvent.onParagraph(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    if (paragraph.getKeepTogether()) {
                        Table table = new Table(1, 1);
                        table.setOffset(0.0f);
                        table.setBorder(0);
                        table.setWidth(100.0f);
                        table.setTableFitsPage(true);
                        Cell cell = new Cell(paragraph);
                        cell.setBorder(0);
                        cell.setHorizontalAlignment(paragraph.alignment());
                        table.addCell(cell);
                        this.add(table);
                        break;
                    }
                    element.process(this);
                    this.paraIndent -= paragraph.indentationLeft();
                    if (pdfPageEvent != null && this.isParagraph) {
                        pdfPageEvent.onParagraphEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    this.alignment = 0;
                    this.indentLeft -= paragraph.indentationLeft();
                    this.indentRight -= paragraph.indentationRight();
                    this.carriageReturn();
                    break;
                }
                case 13: 
                case 16: {
                    boolean bl2;
                    Section section = (Section)element;
                    boolean bl3 = bl2 = section.title() != null;
                    if (section.isChapter()) {
                        this.newPage();
                    } else {
                        this.newLine();
                    }
                    if (bl2) {
                        PdfOutline pdfOutline;
                        float f2 = this.indentTop() - this.currentHeight;
                        int n2 = this.pageSize.getRotation();
                        if (n2 == 90 || n2 == 180) {
                            f2 = this.pageSize.height() - f2;
                        }
                        PdfDestination pdfDestination = new PdfDestination(2, f2);
                        while (this.currentOutline.level() >= section.depth()) {
                            this.currentOutline = this.currentOutline.parent();
                        }
                        this.currentOutline = pdfOutline = new PdfOutline(this.currentOutline, pdfDestination, section.title(), section.isBookmarkOpen());
                    }
                    this.carriageReturn();
                    this.indentLeft += section.indentationLeft();
                    this.indentRight += section.indentationRight();
                    PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
                    if (pdfPageEvent != null) {
                        if (element.type() == 16) {
                            pdfPageEvent.onChapter(this.writer, this, this.indentTop() - this.currentHeight, section.title());
                        } else {
                            pdfPageEvent.onSection(this.writer, this, this.indentTop() - this.currentHeight, section.depth(), section.title());
                        }
                    }
                    if (bl2) {
                        this.isParagraph = false;
                        this.add(section.title());
                        this.isParagraph = true;
                    }
                    this.indentLeft += section.indentation();
                    element.process(this);
                    this.indentLeft -= section.indentationLeft() + section.indentation();
                    this.indentRight -= section.indentationRight();
                    if (pdfPageEvent == null) break;
                    if (element.type() == 16) {
                        pdfPageEvent.onChapterEnd(this.writer, this, this.indentTop() - this.currentHeight);
                        break;
                    }
                    pdfPageEvent.onSectionEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    break;
                }
                case 14: {
                    List list = (List)element;
                    this.listIndentLeft += list.indentationLeft();
                    this.indentRight += list.indentationRight();
                    element.process(this);
                    this.listIndentLeft -= list.indentationLeft();
                    this.indentRight -= list.indentationRight();
                    break;
                }
                case 15: {
                    ListItem listItem = (ListItem)element;
                    this.alignment = listItem.alignment();
                    this.listIndentLeft += listItem.indentationLeft();
                    this.indentRight += listItem.indentationRight();
                    this.leading = listItem.leading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    this.carriageReturn();
                    this.listIndentLeft -= listItem.indentationLeft();
                    this.indentRight -= listItem.indentationRight();
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.pageEmpty = false;
                    break;
                }
                case 23: {
                    this.newLine();
                    this.flushLines();
                    PdfPTable pdfPTable = (PdfPTable)element;
                    float f3 = (this.indentRight() - this.indentLeft()) * pdfPTable.getWidthPercentage() / 100.0f;
                    float f4 = 0.0f;
                    switch (pdfPTable.getHorizontalAlignment()) {
                        case 0: {
                            f4 = this.indentLeft();
                            break;
                        }
                        case 2: {
                            f4 = this.indentRight() - f3;
                            break;
                        }
                        default: {
                            f4 = (this.indentRight() + this.indentLeft() - f3) / 2.0f;
                        }
                    }
                    pdfPTable.setTotalWidth(f3);
                    this.b(pdfPTable, f4);
                    break;
                }
                case 22: {
                    boolean bl4;
                    ((Table)element).complete();
                    float f5 = ((Table)element).getOffset();
                    if (Float.isNaN(f5)) {
                        f5 = this.leading;
                    }
                    this.carriageReturn();
                    this.lines.add(new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, f5));
                    this.currentHeight += f5;
                    this.flushLines();
                    float f6 = this.indentTop();
                    float f7 = this.currentHeight;
                    PdfContentByte pdfContentByte = new PdfContentByte(this.writer);
                    PdfTable pdfTable = new PdfTable((Table)element, this.indentLeft(), this.indentRight(), this.currentHeight > 0.0f ? f6 - this.currentHeight - 6.0f : f6);
                    boolean bl5 = ((Table)element).hasToFitPageTable() ? pdfTable.bottom() < this.f() : (bl4 = false);
                    if (this.pageEmpty) {
                        bl4 = false;
                    }
                    boolean bl6 = ((Table)element).hasToFitPageCells();
                    ArrayList arrayList = pdfTable.c();
                    ArrayList arrayList2 = null;
                    while (!arrayList.isEmpty()) {
                        float f8;
                        int n3;
                        int n4;
                        PdfCell pdfCell;
                        float f9 = 0.0f;
                        boolean bl7 = false;
                        int n5 = 0;
                        boolean bl8 = false;
                        Object object = arrayList.listIterator();
                        while (object.hasNext() && !bl4) {
                            pdfCell = (PdfCell)object.next();
                            if (bl6) {
                                if (!pdfCell.a()) {
                                    if (pdfCell.getGroupNumber() != n5) {
                                        boolean bl9 = true;
                                        n5 = pdfCell.getGroupNumber();
                                        n4 = 0;
                                        while (pdfCell.getGroupNumber() == n5 && bl9 && object.hasNext()) {
                                            if (pdfCell.bottom() < this.f()) {
                                                bl9 = false;
                                            }
                                            pdfCell = (PdfCell)object.next();
                                            ++n4;
                                        }
                                        if (!bl9) break;
                                        for (int i2 = n4; i2 >= 0; --i2) {
                                            pdfCell = (PdfCell)object.previous();
                                        }
                                    }
                                } else if (!bl8) {
                                    bl8 = true;
                                    boolean bl10 = true;
                                    int n6 = 0;
                                    float f10 = pdfCell.top();
                                    while (pdfCell.a() && bl10 && object.hasNext()) {
                                        if (f10 - pdfCell.bottom(0.0f) > this.indentTop() - this.currentHeight - this.f()) {
                                            bl10 = false;
                                        }
                                        pdfCell = (PdfCell)object.next();
                                        ++n6;
                                    }
                                    n5 = pdfCell.getGroupNumber();
                                    while (pdfCell.getGroupNumber() == n5 && bl10 && object.hasNext()) {
                                        if ((double)(f10 - pdfCell.bottom(0.0f)) > (double)(this.indentTop() - this.currentHeight - this.f()) - 10.0) {
                                            bl10 = false;
                                        }
                                        pdfCell = (PdfCell)object.next();
                                        ++n6;
                                    }
                                    for (n3 = n6; n3 >= 0; --n3) {
                                        pdfCell = (PdfCell)object.previous();
                                    }
                                    if (!bl10) {
                                        while (pdfCell.a()) {
                                            object.remove();
                                            pdfCell = (PdfCell)object.next();
                                        }
                                        break;
                                    }
                                }
                            }
                            this.lines = pdfCell.getLines(f6, this.f());
                            if (this.lines != null && this.lines.size() > 0) {
                                bl7 = true;
                                pdfContentByte.rectangle(pdfCell.rectangle(f6, this.f()));
                                f9 = Math.max(pdfCell.bottom(), this.f());
                                float f11 = pdfCell.top(f6 - f7);
                                this.text.moveText(0.0f, f11);
                                f8 = this.flushLines() - f11;
                                this.text.moveText(0.0f, f8);
                                if (f7 + f8 > this.currentHeight) {
                                    this.currentHeight = f7 + f8;
                                }
                            }
                            ArrayList arrayList3 = pdfCell.getImages(f6, this.f());
                            Iterator iterator = arrayList3.iterator();
                            while (iterator.hasNext()) {
                                bl7 = true;
                                Image image = (Image)iterator.next();
                                this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                            }
                            if (!pdfCell.c()) continue;
                            object.remove();
                        }
                        bl4 = false;
                        if (bl7) {
                            object = new Rectangle(pdfTable);
                            ((Rectangle)object).setBorder(pdfTable.border());
                            ((Rectangle)object).setBorderWidth(pdfTable.borderWidth());
                            ((Rectangle)object).setBorderColor(pdfTable.borderColor());
                            ((Rectangle)object).setBackgroundColor(pdfTable.backgroundColor());
                            ((Rectangle)object).setGrayFill(pdfTable.grayFill());
                            PdfContentByte pdfContentByte2 = this.writer.getDirectContentUnder();
                            pdfContentByte2.rectangle(((Rectangle)object).rectangle(this.top(), this.f()));
                            pdfContentByte2.add(pdfContentByte);
                            ((Rectangle)object).setGrayFill(0.0f);
                            ((Rectangle)object).setBackgroundColor(null);
                            pdfContentByte2.rectangle(((Rectangle)object).rectangle(this.top(), this.f()));
                        }
                        pdfContentByte = new PdfContentByte(null);
                        if (arrayList.isEmpty()) continue;
                        this.graphics.setLineWidth(pdfTable.borderWidth());
                        if (bl7 && (pdfTable.border() & 2) == 2) {
                            object = pdfTable.borderColor();
                            if (object != null) {
                                this.graphics.setColorStroke((Color)object);
                            }
                            this.graphics.moveTo(pdfTable.left(), Math.max(pdfTable.bottom(), this.f()));
                            this.graphics.lineTo(pdfTable.right(), Math.max(pdfTable.bottom(), this.f()));
                            this.graphics.stroke();
                            if (object != null) {
                                this.graphics.resetRGBColorStroke();
                            }
                        }
                        this.pageEmpty = false;
                        float f12 = f9;
                        this.newPage();
                        float f13 = 0.0f;
                        n4 = 0;
                        if (this.currentHeight > 0.0f) {
                            f13 = 6.0f;
                            this.currentHeight += f13;
                            n4 = 1;
                            this.newLine();
                            this.flushLines();
                            this.indentTop = this.currentHeight - this.leading;
                            this.currentHeight = 0.0f;
                        } else {
                            this.flushLines();
                        }
                        arrayList2 = pdfTable.a();
                        int n7 = arrayList2.size();
                        if (n7 > 0) {
                            pdfCell = (PdfCell)arrayList2.get(0);
                            float f14 = pdfCell.top(0.0f);
                            for (int i3 = 0; i3 < n7; ++i3) {
                                pdfCell = (PdfCell)arrayList2.get(i3);
                                pdfCell.setTop(this.indentTop() - f14 + pdfCell.top(0.0f));
                                pdfCell.setBottom(this.indentTop() - f14 + pdfCell.bottom(0.0f));
                                f6 = pdfCell.bottom();
                                pdfContentByte.rectangle(pdfCell.rectangle(this.indentTop(), this.f()));
                                ArrayList arrayList4 = pdfCell.getImages(this.indentTop(), this.f());
                                Iterator iterator = arrayList4.iterator();
                                while (iterator.hasNext()) {
                                    bl7 = true;
                                    Image image = (Image)iterator.next();
                                    this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                                }
                                this.lines = pdfCell.getLines(this.indentTop(), this.f());
                                float f15 = pdfCell.top(this.indentTop());
                                this.text.moveText(0.0f, f15 - f13);
                                f8 = this.flushLines() - f15 + f13;
                                this.text.moveText(0.0f, f8);
                            }
                            this.currentHeight = this.indentTop() - f6 + pdfTable.d();
                            this.text.moveText(0.0f, f6 - this.indentTop() - pdfTable.d() - this.currentHeight);
                        } else if (n4 != 0) {
                            f6 = this.indentTop();
                            this.text.moveText(0.0f, f6 - this.indentTop() - pdfTable.d());
                        }
                        f7 = this.currentHeight + pdfTable.d() - f13;
                        n7 = Math.min(arrayList.size(), pdfTable.b());
                        for (n3 = 0; n3 < n7; ++n3) {
                            float f16;
                            float f17;
                            pdfCell = (PdfCell)arrayList.get(n3);
                            if (!(pdfCell.top(-pdfTable.d()) > f9) || !((f17 = f6 - f12 + pdfCell.bottom()) > f6 - (f16 = pdfCell.remainingHeight()))) continue;
                            f12 += f17 - (f6 - f16);
                        }
                        n7 = arrayList.size();
                        pdfTable.setTop(this.indentTop());
                        pdfTable.setBottom(f6 - f12 + pdfTable.bottom(pdfTable.d()));
                        for (n3 = 0; n3 < n7; ++n3) {
                            pdfCell = (PdfCell)arrayList.get(n3);
                            float f18 = f6 - f12 + pdfCell.bottom();
                            float f19 = f6 - f12 + pdfCell.top(-pdfTable.d());
                            if (f19 > this.indentTop() - this.currentHeight + pdfTable.d()) {
                                f19 = this.indentTop() - this.currentHeight + pdfTable.d();
                            }
                            pdfCell.setTop(f19 - pdfTable.d());
                            pdfCell.setBottom(f18 - pdfTable.d());
                        }
                    }
                    this.text.moveText(0.0f, f7 - this.currentHeight);
                    this.lines.add(this.line);
                    this.currentHeight += this.line.d() - f6 + this.indentTop();
                    this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
                    this.pageEmpty = false;
                    break;
                }
                case 32: 
                case 34: 
                case 35: {
                    this.carriageReturn();
                    this.add((Image)element);
                    this.pageEmpty = false;
                    break;
                }
                case 39: {
                    Graphic graphic = (Graphic)element;
                    graphic.processAttributes(this.indentLeft(), this.f(), this.indentRight(), this.indentTop(), this.indentTop() - this.currentHeight);
                    this.graphics.add(graphic);
                    this.pageEmpty = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            throw new DocumentException(exception);
        }
    }

    private void addImage(PdfContentByte pdfContentByte, Image image, float f2, float f3, float f4, float f5, float f6, float f7) throws DocumentException {
        Annotation annotation = image.annotation();
        if (image.hasAbsolutePosition()) {
            pdfContentByte.addImage(image);
            if (annotation != null) {
                annotation.setDimensions(image.absoluteX(), image.absoluteY(), image.absoluteX() + image.scaledWidth(), image.absoluteY() + image.scaledHeight());
                this.add(annotation);
            }
        } else {
            pdfContentByte.addImage(image, f2, f3, f4, f5, f6, f7);
            if (annotation != null) {
                annotation.setDimensions(f6, f7, f6 + image.scaledWidth(), f7 + image.scaledHeight());
                this.add(annotation);
            }
        }
    }

    private void add(Image image) throws PdfException, DocumentException {
        this.pageEmpty = false;
        if (image.hasAbsolutePosition()) {
            this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.f()) {
            if (!this.strictImageSequence && this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            this.newPage();
            if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.f()) {
                this.imageWait = image;
                return;
            }
        }
        if (image == this.imageWait) {
            this.imageWait = null;
        }
        boolean bl2 = (image.alignment() & 4) == 4 && (image.alignment() & 1) != 1;
        boolean bl3 = (image.alignment() & 8) == 8;
        float f2 = this.leading / 2.0f;
        if (bl2) {
            f2 += this.leading;
        }
        float f3 = this.indentTop() - this.currentHeight - image.scaledHeight() - f2;
        float[] fArray = image.matrix();
        float f4 = this.indentLeft() - fArray[4];
        if ((image.alignment() & 2) == 2) {
            f4 = this.indentRight() - image.scaledWidth() - fArray[4];
        }
        if ((image.alignment() & 1) == 1) {
            f4 = this.indentLeft() + (this.indentRight() - this.indentLeft() - image.scaledWidth()) / 2.0f - fArray[4];
        }
        if (image.hasAbsoluteX()) {
            f4 = image.absoluteX();
        }
        this.addImage(this.graphics, image, fArray[0], fArray[1], fArray[2], fArray[3], f4, f3 - fArray[5]);
        if (bl2) {
            if (this.imageEnd < 0.0f || this.imageEnd < this.currentHeight + image.scaledHeight() + f2) {
                this.imageEnd = this.currentHeight + image.scaledHeight() + f2;
            }
            if ((image.alignment() & 2) == 2) {
                this.imageIndentRight += image.scaledWidth() + image.indentationLeft();
            } else {
                this.imageIndentLeft += image.scaledWidth() + image.indentationRight();
            }
        }
        if (!bl2 && !bl3) {
            this.currentHeight += image.scaledHeight() + f2;
            this.flushLines();
            this.text.moveText(0.0f, -(image.scaledHeight() + f2));
            this.newLine();
        }
    }

    private void initPage() throws DocumentException {
        float f2;
        float f3;
        float f4;
        float f5;
        Object object;
        this.annotations = this.delayedAnnotations;
        this.delayedAnnotations = new ArrayList();
        this.pageResources = new PageResources();
        this.writer.d();
        ++this.pageN;
        float f6 = this.leading;
        int n2 = this.alignment;
        this.marginLeft = this.nextMarginLeft;
        this.marginRight = this.nextMarginRight;
        this.marginTop = this.nextMarginTop;
        this.marginBottom = this.nextMarginBottom;
        this.imageEnd = -1.0f;
        this.imageIndentRight = 0.0f;
        this.imageIndentLeft = 0.0f;
        this.graphics = new PdfContentByte(this.writer);
        this.text = new PdfContentByte(this.writer);
        this.text.beginText();
        this.text.moveText(this.left(), this.top());
        this.textEmptySize = this.text.b();
        this.text.reset();
        this.text.beginText();
        this.leading = 16.0f;
        this.indentBottom = 0.0f;
        this.indentTop = 0.0f;
        this.currentHeight = 0.0f;
        this.pageSize = this.nextPageSize;
        this.thisCropSize = this.cropSize;
        if (this.pageSize.backgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.borderColor() != null || this.pageSize.grayFill() > 0.0f) {
            this.add(this.pageSize);
        }
        if (this.watermark != null) {
            object = this.watermark.matrix();
            this.addImage(this.graphics, this.watermark, object[0], object[1], object[2], object[3], this.watermark.offsetX() - object[4], this.watermark.offsetY() - object[5]);
        }
        if (this.footer != null) {
            float f7 = this.indentLeft;
            f5 = this.indentRight;
            f4 = this.listIndentLeft;
            f3 = this.imageIndentLeft;
            f2 = this.imageIndentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.listIndentLeft = 0.0f;
            this.imageIndentLeft = 0.0f;
            this.imageIndentRight = 0.0f;
            this.footer.setPageNumber(this.pageN);
            this.leading = this.footer.paragraph().leading();
            this.add(this.footer.paragraph());
            this.indentBottom = this.currentHeight;
            this.text.moveText(this.left(), this.f());
            this.flushLines();
            this.text.moveText(-this.left(), -this.bottom());
            this.footer.setTop(this.bottom(this.currentHeight));
            this.footer.setBottom(this.bottom() - 0.75f * this.leading);
            this.footer.setLeft(this.left());
            this.footer.setRight(this.right());
            this.graphics.rectangle(this.footer);
            this.indentBottom = this.currentHeight + this.leading * 2.0f;
            this.currentHeight = 0.0f;
            this.indentLeft = f7;
            this.indentRight = f5;
            this.listIndentLeft = f4;
            this.imageIndentLeft = f3;
            this.imageIndentRight = f2;
        }
        this.text.moveText(this.left(), this.top());
        if (this.header != null) {
            float f8 = this.indentLeft;
            f5 = this.indentRight;
            f4 = this.listIndentLeft;
            f3 = this.imageIndentLeft;
            f2 = this.imageIndentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.listIndentLeft = 0.0f;
            this.imageIndentLeft = 0.0f;
            this.imageIndentRight = 0.0f;
            this.header.setPageNumber(this.pageN);
            this.leading = this.header.paragraph().leading();
            this.text.moveText(0.0f, this.leading);
            this.add(this.header.paragraph());
            this.newLine();
            this.indentTop = this.currentHeight - this.leading;
            this.header.setTop(this.top() + this.leading);
            this.header.setBottom(this.indentTop() + this.leading * 2.0f / 3.0f);
            this.header.setLeft(this.left());
            this.header.setRight(this.right());
            this.graphics.rectangle(this.header);
            this.flushLines();
            this.currentHeight = 0.0f;
            this.indentLeft = f8;
            this.indentRight = f5;
            this.listIndentLeft = f4;
            this.imageIndentLeft = f3;
            this.imageIndentRight = f2;
        }
        this.pageEmpty = true;
        try {
            if (this.imageWait != null) {
                this.add(this.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.leading = f6;
        this.alignment = n2;
        this.carriageReturn();
        object = this.writer.getPageEvent();
        if (object != null) {
            if (this.firstPageEvent) {
                object.onOpenDocument(this.writer, this);
            }
            object.onStartPage(this.writer, this);
        }
        this.firstPageEvent = false;
    }

    private void carriageReturn() throws DocumentException {
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        if (this.line != null) {
            if (this.currentHeight + this.line.d() + this.leading < this.indentTop() - this.f()) {
                if (this.line.size() > 0) {
                    this.currentHeight += this.line.d();
                    this.lines.add(this.line);
                    this.pageEmpty = false;
                }
            } else {
                this.newPage();
            }
        }
        if (this.imageEnd > -1.0f && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1.0f;
            this.imageIndentRight = 0.0f;
            this.imageIndentLeft = 0.0f;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private void newLine() throws DocumentException {
        this.carriageReturn();
        if (this.lines != null && this.lines.size() > 0) {
            this.lines.add(this.line);
            this.currentHeight += this.line.d();
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private float flushLines() throws DocumentException {
        if (this.lines == null) {
            return 0.0f;
        }
        boolean bl2 = false;
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
            bl2 = true;
        }
        if (this.lines.size() == 0) {
            return 0.0f;
        }
        Object[] objectArray = new Object[2];
        PdfFont pdfFont = null;
        float f2 = 0.0f;
        Float f3 = new Float(0.0f);
        objectArray[1] = f3;
        Iterator iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            PdfLine pdfLine = (PdfLine)iterator.next();
            if (this.isNewpage && bl2) {
                bl2 = false;
                this.text.moveText(pdfLine.f() - this.indentLeft() + this.listIndentLeft + this.paraIndent, -pdfLine.d());
            } else {
                this.text.moveText(pdfLine.f() - this.indentLeft() + this.listIndentLeft, -pdfLine.d());
            }
            if (pdfLine.listSymbol() != null) {
                Object object;
                PdfChunk pdfChunk = pdfLine.listSymbol();
                this.text.moveText(-pdfLine.listIndent(), 0.0f);
                if (pdfChunk.e().compareTo(pdfFont) != 0) {
                    pdfFont = pdfChunk.e();
                    this.text.setFontAndSize(pdfFont.c(), pdfFont.d());
                }
                if (pdfChunk.f() != null) {
                    object = pdfChunk.f();
                    this.text.setColorFill((Color)object);
                    this.text.showText(pdfChunk.toString());
                    this.text.resetRGBColorFill();
                } else if (pdfChunk.j()) {
                    object = pdfChunk.g();
                    float[] fArray = ((Image)object).matrix();
                    float f4 = this.text.getXTLM();
                    float f5 = this.text.getYTLM();
                    fArray[4] = f4 + pdfChunk.h() - fArray[4];
                    fArray[5] = f5 + pdfChunk.d() - fArray[5];
                    this.addImage(this.graphics, (Image)object, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                } else {
                    this.text.showText(pdfChunk.toString());
                }
                this.text.moveText(pdfLine.listIndent(), 0.0f);
            }
            objectArray[0] = pdfFont;
            this.a(pdfLine, this.text, this.graphics, objectArray, this.writer.getSpaceCharRatio());
            pdfFont = (PdfFont)objectArray[0];
            f2 += pdfLine.d();
            if (this.indentLeft() - this.listIndentLeft == pdfLine.f()) continue;
            this.text.moveText(this.indentLeft() - pdfLine.f() - this.listIndentLeft, 0.0f);
        }
        this.lines = new ArrayList();
        return f2;
    }

    public PdfInfo e() {
        return this.info;
    }

    public PdfCatalog a(PdfIndirectReference pdfIndirectReference) {
        PdfCatalog pdfCatalog = this.rootOutline.getKids().size() > 0 ? new PdfCatalog(this, pdfIndirectReference, this.rootOutline.indirectReference()) : new PdfCatalog(this, pdfIndirectReference);
        if (this.openActionName != null) {
            PdfAction pdfAction = this.a(this.openActionName);
            pdfCatalog.a(pdfAction);
        } else if (this.openActionAction != null) {
            pdfCatalog.a(this.openActionAction);
        }
        if (this.additionalActions != null) {
            pdfCatalog.a(this.additionalActions);
        }
        if (this.pageLabels != null) {
            pdfCatalog.a(this.pageLabels);
        }
        pdfCatalog.a(this.localDestinations, this.documentJavaScript, this.writer);
        pdfCatalog.a(this.viewerPreferences);
        if (this.a.a()) {
            try {
                pdfCatalog.a(this.writer.addToBody(this.a).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
        return pdfCatalog;
    }

    public float a(Table table) {
        float f2 = this.currentHeight > 0.0f ? this.indentTop() - this.currentHeight - 2.0f * this.leading : this.indentTop();
        PdfTable pdfTable = new PdfTable(table, this.indentLeft(), this.indentRight(), f2);
        return pdfTable.bottom();
    }

    public boolean a(PdfPTable pdfPTable, float f2) {
        float f3 = (this.indentRight() - this.indentLeft()) * pdfPTable.getWidthPercentage() / 100.0f;
        pdfPTable.setTotalWidth(f3);
        return pdfPTable.getTotalHeight() <= this.indentTop() - this.currentHeight - this.f() - f2;
    }

    private float indentLeft() {
        return this.left(this.indentLeft + this.listIndentLeft + this.imageIndentLeft);
    }

    private float indentRight() {
        return this.right(this.indentRight + this.imageIndentRight);
    }

    private float indentTop() {
        return this.top(this.indentTop);
    }

    public float f() {
        return this.bottom(this.indentBottom);
    }

    public void a(PdfOutline pdfOutline, String string) {
        this.a(string, pdfOutline.getPdfDestination());
    }

    public PdfAcroForm getAcroForm() {
        return this.a;
    }

    public PdfOutline getRootOutline() {
        return this.rootOutline;
    }

    public void a(PdfLine pdfLine, PdfContentByte pdfContentByte, PdfContentByte pdfContentByte2, Object[] objectArray, float f2) throws DocumentException {
        float f3;
        float f4;
        boolean bl2;
        PdfFont pdfFont = (PdfFont)objectArray[0];
        float f5 = ((Float)objectArray[1]).floatValue();
        float f6 = 0.0f;
        int n2 = pdfLine.b();
        int n3 = pdfLine.toString().length();
        boolean bl3 = bl2 = pdfLine.hasToBeJustified() && (n2 != 0 || n3 > 1);
        if (bl2) {
            if (pdfLine.isNewlineSplit() && pdfLine.c() >= f5 * (f2 * (float)n2 + (float)n3 - 1.0f)) {
                if (pdfLine.a()) {
                    pdfContentByte.moveText(pdfLine.c() - f5 * (f2 * (float)n2 + (float)n3 - 1.0f), 0.0f);
                }
                pdfContentByte.setWordSpacing(f2 * f5);
                pdfContentByte.setCharacterSpacing(f5);
            } else {
                char c2;
                String string;
                float f7 = pdfLine.c();
                PdfChunk pdfChunk = pdfLine.getChunk(pdfLine.size() - 1);
                if (pdfChunk != null && (string = pdfChunk.toString()).length() > 0 && ".,;:'".indexOf(c2 = string.charAt(string.length() - 1)) >= 0) {
                    f4 = f7;
                    f6 = (f7 += pdfChunk.e().a(c2) * 0.4f) - f4;
                }
                f3 = f7 / (f2 * (float)n2 + (float)n3 - 1.0f);
                pdfContentByte.setWordSpacing(f2 * f3);
                pdfContentByte.setCharacterSpacing(f3);
                f5 = f3;
            }
        }
        int n4 = pdfLine.getLastStrokeChunk();
        int n5 = 0;
        float f8 = f3 = pdfContentByte.getXTLM();
        f4 = pdfContentByte.getYTLM();
        boolean bl4 = false;
        Iterator iterator = pdfLine.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            float f9;
            PdfChunk pdfChunk = (PdfChunk)iterator.next();
            Color color = pdfChunk.f();
            if (n5 <= n4) {
                f9 = bl2 ? pdfChunk.getWidthCorrected(f5, f2 * f5) : pdfChunk.a();
                if (pdfChunk.i()) {
                    Object[] objectArray2;
                    Object object3;
                    float f10;
                    object2 = pdfLine.getChunk(n5 + 1);
                    if (pdfChunk.a("UNDERLINE")) {
                        f10 = f5;
                        if (object2 != null && ((PdfChunk)object2).a("UNDERLINE")) {
                            f10 = 0.0f;
                        }
                        if (object2 == null) {
                            f10 += f6;
                        }
                        object3 = (Object[][])pdfChunk.c("UNDERLINE");
                        object = null;
                        boolean bl5 = false;
                        for (int i2 = 0; i2 < ((Object[][])object3).length; ++i2) {
                            objectArray2 = object3[i2];
                            object = (Color)objectArray2[0];
                            float[] fArray = (float[])objectArray2[1];
                            if (object == null) {
                                object = color;
                            }
                            if (object != null) {
                                pdfContentByte2.setColorStroke((Color)object);
                            }
                            float f11 = pdfChunk.e().d();
                            pdfContentByte2.setLineWidth(fArray[0] + f11 * fArray[1]);
                            float f12 = fArray[2] + f11 * fArray[3];
                            int n6 = (int)fArray[4];
                            if (n6 != 0) {
                                pdfContentByte2.setLineCap(n6);
                            }
                            pdfContentByte2.moveTo(f3, f4 + f12);
                            pdfContentByte2.lineTo(f3 + f9 - f10, f4 + f12);
                            pdfContentByte2.stroke();
                            if (object != null) {
                                pdfContentByte2.resetGrayStroke();
                            }
                            if (n6 == 0) continue;
                            pdfContentByte2.setLineCap(0);
                        }
                        pdfContentByte2.setLineWidth(1.0f);
                    }
                    if (pdfChunk.a("ACTION")) {
                        f10 = f5;
                        if (object2 != null && ((PdfChunk)object2).a("ACTION")) {
                            f10 = 0.0f;
                        }
                        if (object2 == null) {
                            f10 += f6;
                        }
                        pdfContentByte.a(new PdfAnnotation(this.writer, f3, f4, f3 + f9 - f10, f4 + pdfChunk.e().d(), (PdfAction)pdfChunk.c("ACTION")));
                    }
                    if (pdfChunk.a("REMOTEGOTO")) {
                        f10 = f5;
                        if (object2 != null && ((PdfChunk)object2).a("REMOTEGOTO")) {
                            f10 = 0.0f;
                        }
                        if (object2 == null) {
                            f10 += f6;
                        }
                        object3 = (Object[])pdfChunk.c("REMOTEGOTO");
                        object = (String)object3[0];
                        if (object3[1] instanceof String) {
                            this.a((String)object, (String)object3[1], f3, f4, f3 + f9 - f10, f4 + pdfChunk.e().d());
                        } else {
                            this.a((String)object, (Integer)object3[1], f3, f4, f3 + f9 - f10, f4 + pdfChunk.e().d());
                        }
                    }
                    if (pdfChunk.a("LOCALGOTO")) {
                        f10 = f5;
                        if (object2 != null && ((PdfChunk)object2).a("LOCALGOTO")) {
                            f10 = 0.0f;
                        }
                        if (object2 == null) {
                            f10 += f6;
                        }
                        this.a((String)pdfChunk.c("LOCALGOTO"), f3, f4, f3 + f9 - f10, f4 + pdfChunk.e().d());
                    }
                    if (pdfChunk.a("LOCALDESTINATION")) {
                        f10 = f5;
                        if (object2 != null && ((PdfChunk)object2).a("LOCALDESTINATION")) {
                            f10 = 0.0f;
                        }
                        if (object2 == null) {
                            f10 += f6;
                        }
                        this.a((String)pdfChunk.c("LOCALDESTINATION"), new PdfDestination(0, f3, f4 + pdfChunk.e().d(), 0.0f));
                    }
                    if (pdfChunk.a("GENERICTAG")) {
                        f10 = f5;
                        if (object2 != null && ((PdfChunk)object2).a("GENERICTAG")) {
                            f10 = 0.0f;
                        }
                        if (object2 == null) {
                            f10 += f6;
                        }
                        object3 = new Rectangle(f3, f4, f3 + f9 - f10, f4 + pdfChunk.e().d());
                        object = this.writer.getPageEvent();
                        if (object != null) {
                            object.onGenericTag(this.writer, this, (Rectangle)object3, (String)pdfChunk.c("GENERICTAG"));
                        }
                    }
                    if (pdfChunk.a("BACKGROUND")) {
                        f10 = f5;
                        if (object2 != null && ((PdfChunk)object2).a("BACKGROUND")) {
                            f10 = 0.0f;
                        }
                        if (object2 == null) {
                            f10 += f6;
                        }
                        float f13 = pdfChunk.e().d();
                        float f14 = pdfChunk.e().c().getFontDescriptor(1, f13);
                        float f15 = pdfChunk.e().c().getFontDescriptor(3, f13);
                        Object[] objectArray3 = (Object[])pdfChunk.c("BACKGROUND");
                        pdfContentByte2.setColorFill((Color)objectArray3[0]);
                        objectArray2 = (float[])objectArray3[1];
                        pdfContentByte2.rectangle(f3 - objectArray2[0], f4 + f15 - objectArray2[1], f9 - f10 + objectArray2[0] + objectArray2[2], f14 - f15 + objectArray2[1] + objectArray2[3]);
                        pdfContentByte2.fill();
                        pdfContentByte2.setGrayFill(0.0f);
                    }
                    if (pdfChunk.a("PDFANNOTATION")) {
                        f10 = f5;
                        if (object2 != null && ((PdfChunk)object2).a("PDFANNOTATION")) {
                            f10 = 0.0f;
                        }
                        if (object2 == null) {
                            f10 += f6;
                        }
                        float f16 = pdfChunk.e().d();
                        float f17 = pdfChunk.e().c().getFontDescriptor(1, f16);
                        float f18 = pdfChunk.e().c().getFontDescriptor(3, f16);
                        PdfAnnotation pdfAnnotation = PdfFormField.shallowDuplicate((PdfAnnotation)pdfChunk.c("PDFANNOTATION"));
                        pdfAnnotation.put(PdfName.RECT, new PdfRectangle(f3, f4 + f18, f3 + f9 - f10, f4 + f17));
                        pdfContentByte.a(pdfAnnotation);
                    }
                    if (pdfChunk.a("SKEW")) {
                        float[] fArray = (float[])pdfChunk.c("SKEW");
                        pdfContentByte.setTextMatrix(1.0f, fArray[0], fArray[1], 1.0f, f3, f4);
                    }
                    if (pdfChunk.j()) {
                        Image image = pdfChunk.g();
                        float[] fArray = image.matrix();
                        fArray[4] = f3 + pdfChunk.h() - fArray[4];
                        fArray[5] = f4 + pdfChunk.d() - fArray[5];
                        this.addImage(pdfContentByte2, image, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        pdfContentByte.moveText(f3 + f5 + image.scaledWidth() - pdfContentByte.getXTLM(), 0.0f);
                    }
                }
                f3 += f9;
                ++n5;
            }
            if (pdfChunk.e().compareTo(pdfFont) != 0) {
                pdfFont = pdfChunk.e();
                pdfContentByte.setFontAndSize(pdfFont.c(), pdfFont.d());
            }
            f9 = 0.0f;
            object2 = (Object[])pdfChunk.c("TEXTRENDERMODE");
            int n7 = 0;
            float f19 = 1.0f;
            object = null;
            Float f20 = (Float)pdfChunk.c("SUBSUPSCRIPT");
            if (object2 != null) {
                n7 = (Integer)object2[0] & 3;
                if (n7 != 0) {
                    pdfContentByte.setTextRenderingMode(n7);
                }
                if (n7 == 1 || n7 == 2) {
                    f19 = ((Float)object2[1]).floatValue();
                    if (f19 != 1.0f) {
                        pdfContentByte.setLineWidth(f19);
                    }
                    if ((object = (Color)object2[2]) == null) {
                        object = color;
                    }
                    if (object != null) {
                        pdfContentByte.setColorStroke((Color)object);
                    }
                }
            }
            if (f20 != null) {
                f9 = f20.floatValue();
            }
            if (color != null) {
                pdfContentByte.setColorFill(color);
            }
            if (f9 != 0.0f) {
                pdfContentByte.setTextRise(f9);
            }
            if (pdfChunk.j()) {
                bl4 = true;
            } else if (bl2 && n2 > 0 && pdfChunk.b()) {
                String string = pdfChunk.toString();
                int n8 = string.indexOf(32);
                if (n8 < 0) {
                    pdfContentByte.showText(pdfChunk.toString());
                } else {
                    float f21 = -f2 * f5 * 1000.0f / pdfChunk.font.d();
                    PdfTextArray pdfTextArray = new PdfTextArray(string.substring(0, n8));
                    int n9 = n8;
                    while ((n8 = string.indexOf(32, n9 + 1)) >= 0) {
                        pdfTextArray.add(f21);
                        pdfTextArray.add(string.substring(n9, n8));
                        n9 = n8;
                    }
                    pdfTextArray.add(f21);
                    pdfTextArray.add(string.substring(n9));
                    pdfContentByte.showText(pdfTextArray);
                }
            } else {
                pdfContentByte.showText(pdfChunk.toString());
            }
            if (f9 != 0.0f) {
                pdfContentByte.setTextRise(0.0f);
            }
            if (color != null) {
                pdfContentByte.resetRGBColorFill();
            }
            if (n7 != 0) {
                pdfContentByte.setTextRenderingMode(0);
            }
            if (object != null) {
                pdfContentByte.resetRGBColorStroke();
            }
            if (f19 != 1.0f) {
                pdfContentByte.setLineWidth(1.0f);
            }
            if (!pdfChunk.a("SKEW")) continue;
            bl4 = true;
            pdfContentByte.setTextMatrix(f3, f4);
        }
        if (bl2) {
            pdfContentByte.setWordSpacing(0.0f);
            pdfContentByte.setCharacterSpacing(0.0f);
            if (pdfLine.isNewlineSplit()) {
                f5 = 0.0f;
            }
        }
        if (bl4) {
            pdfContentByte.moveText(f8 - pdfContentByte.getXTLM(), 0.0f);
        }
        objectArray[0] = pdfFont;
        objectArray[1] = new Float(f5);
    }

    public void a(String string, float f2, float f3, float f4, float f5) {
        PdfAction pdfAction = this.a(string);
        this.annotations.add(new PdfAnnotation(this.writer, f2, f3, f4, f5, pdfAction));
    }

    public PdfAction a(String string) {
        PdfAction pdfAction;
        Object[] objectArray = (Object[])this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[0] == null) {
            if (objectArray[1] == null) {
                objectArray[1] = this.writer.getPdfIndirectReference();
            }
            pdfAction = new PdfAction((PdfIndirectReference)objectArray[1]);
            objectArray[0] = pdfAction;
            this.localDestinations.put(string, objectArray);
        } else {
            pdfAction = (PdfAction)objectArray[0];
        }
        return pdfAction;
    }

    public boolean a(String string, PdfDestination pdfDestination) {
        Object[] objectArray = (Object[])this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[2] != null) {
            return false;
        }
        objectArray[2] = pdfDestination;
        this.localDestinations.put(string, objectArray);
        pdfDestination.addPage(this.writer.a());
        return true;
    }

    public void a(String string, String string2, float f2, float f3, float f4, float f5) {
        this.annotations.add(new PdfAnnotation(this.writer, f2, f3, f4, f5, new PdfAction(string, string2)));
    }

    public void a(String string, int n2, float f2, float f3, float f4, float f5) {
        this.writer.addAnnotation(new PdfAnnotation(this.writer, f2, f3, f4, f5, new PdfAction(string, n2)));
    }

    public void setViewerPreferences(int n2) {
        this.viewerPreferences |= n2;
    }

    public void a(PdfAction pdfAction, float f2, float f3, float f4, float f5) {
        this.writer.addAnnotation(new PdfAnnotation(this.writer, f2, f3, f4, f5, pdfAction));
    }

    public void b(String string) {
        this.openActionName = string;
        this.openActionAction = null;
    }

    public void b(PdfAction pdfAction) {
        this.openActionAction = pdfAction;
        this.openActionName = null;
    }

    public void b(PdfName pdfName, PdfAction pdfAction) {
        if (this.additionalActions == null) {
            this.additionalActions = new PdfDictionary();
        }
        this.additionalActions.put(pdfName, pdfAction);
    }

    public void a(PdfPageLabels pdfPageLabels) {
        this.pageLabels = pdfPageLabels;
    }

    public void a(PdfAction pdfAction) {
        if (pdfAction.get(PdfName.JS) == null) {
            throw new RuntimeException("Only JavaScript actions are allowed.");
        }
        try {
            this.documentJavaScript.add(this.writer.addToBody(pdfAction).getIndirectReference());
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void a(Rectangle rectangle) {
        this.cropSize = new Rectangle(rectangle);
    }

    public void b(PdfFormField pdfFormField) {
        this.a.addCalculationOrder(pdfFormField);
    }

    public void b(int n2) {
        this.a.setSigFlags(n2);
    }

    public void a(PdfFormField pdfFormField) {
        this.annotations.add(pdfFormField);
        ArrayList arrayList = pdfFormField.c();
        if (arrayList != null) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                this.a((PdfFormField)arrayList.get(i2));
            }
        }
    }

    public void a(PdfAnnotation pdfAnnotation) {
        this.pageEmpty = false;
        if (pdfAnnotation.isForm()) {
            PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
            if (pdfFormField.getParent() == null) {
                this.a(pdfFormField);
            }
        } else {
            this.annotations.add(pdfAnnotation);
        }
    }

    public void a(int n2) {
        this.duration = n2 > 0 ? n2 : -1;
    }

    public void a(PdfTransition pdfTransition) {
        this.transition = pdfTransition;
    }

    public void a(PdfName pdfName, PdfAction pdfAction) {
        if (this.pageAA == null) {
            this.pageAA = new PdfDictionary();
        }
        this.pageAA.put(pdfName, pdfAction);
    }

    public boolean c() {
        return this.strictImageSequence;
    }

    public void b(boolean bl2) {
        this.strictImageSequence = bl2;
    }

    public void a(boolean bl2) {
        this.pageEmpty = bl2;
    }

    public void clearTextWrap() throws DocumentException {
        super.clearTextWrap();
        float f2 = this.imageEnd - this.currentHeight;
        if (this.line != null) {
            f2 += this.line.d();
        }
        if (this.imageEnd > -1.0f && f2 > 0.0f) {
            this.carriageReturn();
            this.currentHeight += f2;
        }
    }

    public static PdfWriter a(PdfDocument pdfDocument) {
        return pdfDocument.writer;
    }

    public class PdfCatalog
    extends PdfDictionary {
        private final PdfDocument this$0;

        public PdfCatalog(PdfDocument pdfDocument, PdfIndirectReference pdfIndirectReference) {
            super(CATALOG);
            this.this$0 = pdfDocument;
            this.put(PdfName.PAGES, pdfIndirectReference);
        }

        public PdfCatalog(PdfDocument pdfDocument, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2) {
            super(CATALOG);
            this.this$0 = pdfDocument;
            this.put(PdfName.PAGES, pdfIndirectReference);
            this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            this.put(PdfName.OUTLINES, pdfIndirectReference2);
        }

        public void a(TreeMap treeMap, ArrayList arrayList, PdfWriter pdfWriter) {
            if (treeMap.size() == 0 && arrayList.size() == 0) {
                return;
            }
            try {
                String[] stringArray;
                PdfDictionary pdfDictionary = new PdfDictionary();
                if (treeMap.size() > 0) {
                    stringArray = new PdfArray();
                    Object object = treeMap.keySet().iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        Object[] objectArray = (Object[])treeMap.get(string);
                        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)objectArray[1];
                        stringArray.add(new PdfString(string));
                        stringArray.add(pdfIndirectReference);
                    }
                    object = new PdfDictionary();
                    ((PdfDictionary)object).put(PdfName.NAMES, (PdfObject)stringArray);
                    pdfDictionary.put(PdfName.DESTS, pdfWriter.addToBody((PdfObject)object).getIndirectReference());
                }
                if (arrayList.size() > 0) {
                    stringArray = new String[arrayList.size()];
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        stringArray[i2] = Integer.toHexString(i2);
                    }
                    Arrays.sort(stringArray, new StringCompare());
                    PdfArray pdfArray = new PdfArray();
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        pdfArray.add(new PdfString(stringArray[i3]));
                        pdfArray.add((PdfIndirectReference)arrayList.get(i3));
                    }
                    PdfDictionary pdfDictionary2 = new PdfDictionary();
                    pdfDictionary2.put(PdfName.NAMES, pdfArray);
                    pdfDictionary.put(PdfName.JAVASCRIPT, pdfWriter.addToBody(pdfDictionary2).getIndirectReference());
                }
                this.put(PdfName.NAMES, pdfWriter.addToBody(pdfDictionary).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }

        public void a(int n2) {
            if ((n2 & 1) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.SINGLEPAGE);
            } else if ((n2 & 2) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.ONECOLUMN);
            } else if ((n2 & 4) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNLEFT);
            } else if ((n2 & 8) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNRIGHT);
            }
            if ((n2 & 0x10) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.USENONE);
            } else if ((n2 & 0x20) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            } else if ((n2 & 0x40) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.USETHUMBS);
            } else if ((n2 & 0x80) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.FULLSCREEN);
            }
            if ((n2 & 0x3FF00) == 0) {
                return;
            }
            PdfDictionary pdfDictionary = new PdfDictionary();
            if ((n2 & 0x100) != 0) {
                pdfDictionary.put(PdfName.HIDETOOLBAR, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x200) != 0) {
                pdfDictionary.put(PdfName.HIDEMENUBAR, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x400) != 0) {
                pdfDictionary.put(PdfName.HIDEWINDOWUI, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x800) != 0) {
                pdfDictionary.put(PdfName.FITWINDOW, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x1000) != 0) {
                pdfDictionary.put(PdfName.CENTERWINDOW, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x2000) != 0) {
                pdfDictionary.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USENONE);
            } else if ((n2 & 0x4000) != 0) {
                pdfDictionary.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USEOUTLINES);
            } else if ((n2 & 0x8000) != 0) {
                pdfDictionary.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USETHUMBS);
            }
            if ((n2 & 0x10000) != 0) {
                pdfDictionary.put(PdfName.DIRECTION, PdfName.L2R);
            } else if ((n2 & 0x20000) != 0) {
                pdfDictionary.put(PdfName.DIRECTION, PdfName.R2L);
            }
            this.put(PdfName.VIEWERPREFERENCES, pdfDictionary);
        }

        public void a(PdfAction pdfAction) {
            this.put(PdfName.OPENACTION, pdfAction);
        }

        public void a(PdfDictionary pdfDictionary) {
            try {
                this.put(PdfName.AA, PdfDocument.a(this.this$0).addToBody(pdfDictionary).getIndirectReference());
            }
            catch (Exception exception) {
                new ExceptionConverter(exception);
            }
        }

        public void a(PdfPageLabels pdfPageLabels) {
            this.put(PdfName.PAGELABELS, pdfPageLabels.a());
        }

        public void a(PdfObject pdfObject) {
            this.put(PdfName.ACROFORM, pdfObject);
        }
    }

    public class PdfInfo
    extends PdfDictionary {
        private final PdfDocument this$0;

        public PdfInfo(PdfDocument pdfDocument) {
            this.this$0 = pdfDocument;
            this.a();
            this.b();
        }

        public void a(String string) {
            this.put(PdfName.TITLE, new PdfString(string, "UnicodeBig"));
        }

        public void c(String string) {
            this.put(PdfName.SUBJECT, new PdfString(string, "UnicodeBig"));
        }

        public void e(String string) {
            this.put(PdfName.KEYWORDS, new PdfString(string, "UnicodeBig"));
        }

        public void b(String string) {
            this.put(PdfName.AUTHOR, new PdfString(string, "UnicodeBig"));
        }

        public void d(String string) {
            this.put(PdfName.CREATOR, new PdfString(string, "UnicodeBig"));
        }

        public void a() {
            this.put(PdfName.PRODUCER, new PdfString(Document.getVersion()));
        }

        public void b() {
            PdfDate pdfDate = new PdfDate();
            this.put(PdfName.CREATIONDATE, pdfDate);
            this.put(PdfName.MODDATE, pdfDate);
        }

        public void a(String string, String string2) {
            if (string.equals("Producer") || string.equals("CreationDate")) {
                return;
            }
            this.put(new PdfName(string), new PdfString(string2, "UnicodeBig"));
        }
    }
}

