/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ListItem;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfFont;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfLine {
    public ArrayList line;
    public float left;
    public float width;
    public int alignment;
    public float height;
    public PdfChunk listSymbol = null;
    public float symbolIndent;
    public boolean newlineSplit = false;
    public float originalWidth;
    public boolean isRTL = false;

    public PdfLine(float f2, float f3, int n2, float f4) {
        this.left = f2;
        this.originalWidth = this.width = f3 - f2;
        this.alignment = n2;
        this.height = f4;
        this.line = new ArrayList();
    }

    public PdfLine(float f2, float f3, int n2, boolean bl2, ArrayList arrayList, boolean bl3) {
        this.left = f2;
        this.width = f3;
        this.alignment = n2;
        this.line = arrayList;
        this.newlineSplit = bl2;
        this.isRTL = bl3;
    }

    public PdfChunk a(PdfChunk pdfChunk) {
        if (pdfChunk == null || pdfChunk.toString().equals("")) {
            return null;
        }
        PdfChunk pdfChunk2 = pdfChunk.b(this.width);
        boolean bl2 = this.newlineSplit = pdfChunk.isNewlineSplit() || pdfChunk2 == null;
        if (pdfChunk.c() > 0) {
            if (pdfChunk2 != null) {
                pdfChunk.trimLastSpace();
            }
            this.width -= pdfChunk.a();
            this.line.add(pdfChunk);
        } else {
            if (this.line.size() < 1) {
                pdfChunk = pdfChunk2;
                pdfChunk2 = pdfChunk.a(this.width);
                this.width -= pdfChunk.a();
                if (pdfChunk.c() > 0) {
                    this.line.add(pdfChunk);
                    return pdfChunk2;
                }
                this.line.add(pdfChunk2);
                return null;
            }
            this.width += ((PdfChunk)this.line.get(this.line.size() - 1)).trimLastSpace();
        }
        return pdfChunk2;
    }

    public int size() {
        return this.line.size();
    }

    public Iterator iterator() {
        return this.line.iterator();
    }

    public float d() {
        return this.height;
    }

    public float f() {
        if (this.isRTL) {
            switch (this.alignment) {
                case 0: {
                    return this.left + this.width;
                }
                case 1: {
                    return this.left + this.width / 2.0f;
                }
            }
            return this.left;
        }
        switch (this.alignment) {
            case 2: {
                return this.left + this.width;
            }
            case 1: {
                return this.left + this.width / 2.0f;
            }
        }
        return this.left;
    }

    public boolean hasToBeJustified() {
        return (this.alignment == 3 || this.alignment == 8) && this.width != 0.0f;
    }

    public void resetAlignment() {
        if (this.alignment == 3) {
            this.alignment = 0;
        }
    }

    public float c() {
        return this.width;
    }

    public int b() {
        String string = this.toString();
        int n2 = string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) != ' ') continue;
            ++n3;
        }
        return n3;
    }

    public void setListItem(ListItem listItem) {
        this.listSymbol = new PdfChunk(listItem.listSymbol(), null);
        this.symbolIndent = listItem.indentationLeft();
    }

    public PdfChunk listSymbol() {
        return this.listSymbol;
    }

    public float listIndent() {
        return this.symbolIndent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.line.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((PdfChunk)iterator.next()).toString());
        }
        return stringBuffer.toString();
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit && this.alignment != 8;
    }

    public int getLastStrokeChunk() {
        PdfChunk pdfChunk;
        int n2;
        for (n2 = this.line.size() - 1; n2 >= 0 && !(pdfChunk = (PdfChunk)this.line.get(n2)).i(); --n2) {
        }
        return n2;
    }

    public PdfChunk getChunk(int n2) {
        if (n2 < 0 || n2 >= this.line.size()) {
            return null;
        }
        return (PdfChunk)this.line.get(n2);
    }

    public float getOriginalWidth() {
        return this.originalWidth;
    }

    public float e() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.line.size(); ++i2) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(i2);
            f2 = !pdfChunk.j() ? Math.max(pdfChunk.e().d(), f2) : Math.max(pdfChunk.g().scaledHeight() + pdfChunk.d(), f2);
        }
        return f2;
    }

    public boolean a() {
        return this.isRTL;
    }

    public float getWidthCorrected(float f2, float f3) {
        float f4 = 0.0f;
        for (int i2 = 0; i2 < this.line.size(); ++i2) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(i2);
            f4 += pdfChunk.getWidthCorrected(f2, f3);
        }
        return f4;
    }

    public float getDescender() {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.line.size(); ++i2) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(i2);
            if (pdfChunk.j()) {
                f2 = Math.min(f2, pdfChunk.d());
                continue;
            }
            PdfFont pdfFont = pdfChunk.e();
            f2 = Math.min(f2, pdfFont.c().getFontDescriptor(3, pdfFont.d()));
        }
        return f2;
    }
}

