/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfReaderInstance;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;

public class PdfLister {
    public PrintStream a;

    public PdfLister(PrintStream printStream) {
        this.a = printStream;
    }

    public void listAnyObject(PdfObject pdfObject) {
        switch (pdfObject.type()) {
            case 5: {
                this.listArray((PdfArray)pdfObject);
                break;
            }
            case 6: {
                this.listDict((PdfDictionary)pdfObject);
                break;
            }
            case 3: {
                this.a.println("(" + pdfObject.toString() + ")");
                break;
            }
            default: {
                this.a.println(pdfObject.toString());
            }
        }
    }

    public void listDict(PdfDictionary pdfDictionary) {
        this.a.println("<<");
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = pdfDictionary.get(pdfName);
            this.a.print(pdfName.toString());
            this.a.print(' ');
            this.listAnyObject(pdfObject);
        }
        this.a.println(">>");
    }

    public void listArray(PdfArray pdfArray) {
        this.a.println('[');
        Iterator iterator = pdfArray.getArrayList().iterator();
        while (iterator.hasNext()) {
            PdfObject pdfObject = (PdfObject)iterator.next();
            this.listAnyObject(pdfObject);
        }
        this.a.println(']');
    }

    public void listStream(PRStream pRStream, PdfReaderInstance pdfReaderInstance) {
        try {
            this.listDict(pRStream);
            this.a.println("startstream");
            byte[] byArray = PdfReader.getStreamBytes(pRStream, pdfReaderInstance.d());
            int n2 = byArray.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (byArray[i2] != 13 || byArray[i2 + 1] == 10) continue;
                byArray[i2] = 10;
            }
            this.a.println(new String(byArray));
            this.a.println("endstream");
        }
        catch (IOException iOException) {
            System.err.println("I/O exception: " + iOException);
        }
    }

    public void listPage(PdfImportedPage pdfImportedPage) {
        int n2 = pdfImportedPage.getPageNumber();
        PdfReaderInstance pdfReaderInstance = pdfImportedPage.h();
        PdfReader pdfReader = pdfReaderInstance.b();
        PdfDictionary pdfDictionary = pdfReader.getPageN(n2);
        this.listDict(pdfDictionary);
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
        switch (pdfObject.type) {
            case 7: {
                this.listStream((PRStream)pdfObject, pdfReaderInstance);
                break;
            }
            case 5: {
                Iterator iterator = ((PdfArray)pdfObject).getArrayList().iterator();
                while (iterator.hasNext()) {
                    PdfObject pdfObject2 = PdfReader.getPdfObject((PdfObject)iterator.next());
                    this.listStream((PRStream)pdfObject2, pdfReaderInstance);
                    this.a.println("-----------");
                }
                break;
            }
        }
    }
}

