/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.StringCompare;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNameTree {
    private static final int leafSize = 64;
    private static final StringCompare stringCompare = new StringCompare();

    public static PdfDictionary writeTree(HashMap hashMap, PdfWriter pdfWriter) throws IOException {
        int n2;
        int n3;
        int n4;
        if (hashMap.size() == 0) {
            return null;
        }
        String[] stringArray = new String[hashMap.size()];
        stringArray = hashMap.keySet().toArray(stringArray);
        Arrays.sort(stringArray, stringCompare);
        if (stringArray.length <= 64) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                pdfArray.add(new PdfString(stringArray[i2], null));
                pdfArray.add((PdfIndirectReference)hashMap.get(stringArray[i2]));
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            return pdfDictionary;
        }
        int n5 = 64;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[(stringArray.length + 64 - 1) / 64];
        for (n4 = 0; n4 < pdfIndirectReferenceArray.length; ++n4) {
            n2 = Math.min(n3 + 64, stringArray.length);
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            pdfArray.add(new PdfString(stringArray[n3], null));
            pdfArray.add(new PdfString(stringArray[n2 - 1], null));
            pdfDictionary.put(PdfName.LIMITS, pdfArray);
            pdfArray = new PdfArray();
            for (n3 = n4 * 64; n3 < n2; ++n3) {
                pdfArray.add(new PdfString(stringArray[n3], null));
                pdfArray.add((PdfIndirectReference)hashMap.get(stringArray[n3]));
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            pdfIndirectReferenceArray[n4] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
        }
        n4 = pdfIndirectReferenceArray.length;
        while (true) {
            if (n4 <= 64) {
                PdfArray pdfArray = new PdfArray();
                for (n2 = 0; n2 < n4; ++n2) {
                    pdfArray.add(pdfIndirectReferenceArray[n2]);
                }
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                return pdfDictionary;
            }
            n3 = (stringArray.length + (n5 *= 64) - 1) / n5;
            for (n2 = 0; n2 < n3; ++n2) {
                int n6;
                int n7 = Math.min(n6 + 64, n4);
                PdfDictionary pdfDictionary = new PdfDictionary();
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfString(stringArray[n2 * n5], null));
                pdfArray.add(new PdfString(stringArray[Math.min((n2 + 1) * n5, stringArray.length) - 1], null));
                pdfDictionary.put(PdfName.LIMITS, pdfArray);
                pdfArray = new PdfArray();
                for (n6 = n2 * 64; n6 < n7; ++n6) {
                    pdfArray.add(pdfIndirectReferenceArray[n6]);
                }
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                pdfIndirectReferenceArray[n2] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
            }
            n4 = n3;
        }
    }

    private static void iterateItems(PdfDictionary pdfDictionary, HashMap hashMap) {
        block3: {
            PdfArray pdfArray;
            block2: {
                pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES));
                if (pdfArray == null) break block2;
                ArrayList arrayList = pdfArray.getArrayList();
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    PdfString pdfString = (PdfString)PdfReader.getPdfObject((PdfObject)arrayList.get(i2++));
                    hashMap.put(pdfString.toString(), arrayList.get(i2));
                }
                break block3;
            }
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) break block3;
            ArrayList arrayList = pdfArray.getArrayList();
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList.get(i3));
                PdfNameTree.iterateItems(pdfDictionary2, hashMap);
            }
        }
    }

    public static HashMap readTree(PdfDictionary pdfDictionary) {
        HashMap hashMap = new HashMap();
        if (pdfDictionary != null) {
            PdfNameTree.iterateItems(pdfDictionary, hashMap);
        }
        return hashMap;
    }
}

