/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PdfObject {
    public static final int BOOLEAN = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int NAME = 4;
    public static final int ARRAY = 5;
    public static final int DICTIONARY = 6;
    public static final int STREAM = 7;
    public static final int NULL = 8;
    public static final int INDIRECT = 10;
    public static final String NOTHING = "";
    public static final String TEXT_PDFDOCENCODING = "PDF";
    public static final String TEXT_UNICODE = "UnicodeBig";
    public byte[] bytes;
    public int type;

    public PdfObject(int n2) {
        this.type = n2;
    }

    public PdfObject(int n2, String string) {
        this.type = n2;
        this.bytes = PdfEncodings.convertToBytes(string, null);
    }

    public PdfObject(int n2, byte[] byArray) {
        this.bytes = byArray;
        this.type = n2;
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        if (this.bytes != null) {
            outputStream.write(this.bytes);
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        if (this.bytes == null) {
            return super.toString();
        }
        return PdfEncodings.convertToString(this.bytes, null);
    }

    public int length() {
        return this.toString().length();
    }

    public void setContent(String string) {
        this.bytes = PdfEncodings.convertToBytes(string, null);
    }

    public int type() {
        return this.type;
    }

    public boolean isNull() {
        return this.type == 8;
    }

    public boolean isBoolean() {
        return this.type == 1;
    }

    public boolean isNumber() {
        return this.type == 2;
    }

    public boolean isString() {
        return this.type == 3;
    }

    public boolean isName() {
        return this.type == 4;
    }

    public boolean isArray() {
        return this.type == 5;
    }

    public boolean isDictionary() {
        return this.type == 6;
    }

    public boolean isStream() {
        return this.type == 7;
    }

    public boolean isIndirect() {
        return this.type == 10;
    }
}

