/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColorDetails;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.FontDetails;
import com.lowagie.text.pdf.OutputStreamCounter;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfPages;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SpotColor;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class PdfWriter
extends DocWriter {
    public static final int PageLayoutSinglePage = 1;
    public static final int PageLayoutOneColumn = 2;
    public static final int PageLayoutTwoColumnLeft = 4;
    public static final int PageLayoutTwoColumnRight = 8;
    public static final int PageModeUseNone = 16;
    public static final int PageModeUseOutlines = 32;
    public static final int PageModeUseThumbs = 64;
    public static final int PageModeFullScreen = 128;
    public static final int HideToolbar = 256;
    public static final int HideMenubar = 512;
    public static final int HideWindowUI = 1024;
    public static final int FitWindow = 2048;
    public static final int CenterWindow = 4096;
    public static final int NonFullScreenPageModeUseNone = 8192;
    public static final int NonFullScreenPageModeUseOutlines = 16384;
    public static final int NonFullScreenPageModeUseThumbs = 32768;
    public static final int DirectionL2R = 65536;
    public static final int DirectionR2L = 131072;
    public static final int AllowPrinting = 2052;
    public static final int AllowModifyContents = 8;
    public static final int AllowCopy = 16;
    public static final int AllowModifyAnnotations = 32;
    public static final int AllowFillIn = 256;
    public static final int AllowScreenReaders = 512;
    public static final int AllowAssembly = 1024;
    public static final int AllowDegradedPrinting = 4;
    public static final boolean STRENGTH40BITS = false;
    public static final boolean STRENGTH128BITS = true;
    public static final PdfName DOCUMENT_CLOSE = PdfName.DC;
    public static final PdfName WILL_SAVE = PdfName.WS;
    public static final PdfName DID_SAVE = PdfName.DS;
    public static final PdfName WILL_PRINT = PdfName.WP;
    public static final PdfName DID_PRINT = PdfName.DP;
    public static final PdfName PAGE_OPEN = PdfName.O;
    public static final PdfName PAGE_CLOSE = PdfName.C;
    public static final int SIGNATURE_EXISTS = 1;
    public static final int SIGNATURE_APPEND_ONLY = 2;
    public static final char VERSION_1_2 = '2';
    public static final char VERSION_1_3 = '3';
    public static final char VERSION_1_4 = '4';
    public static final char VERSION_1_5 = '5';
    private static final int VPOINT = 7;
    public byte[] HEADER = PdfWriter.getISOBytes("%PDF-1.4\n%\u00e2\u00e3\u00cf\u00d3\n");
    public PdfPages root = new PdfPages(this);
    public PdfDictionary imageDictionary = new PdfDictionary();
    private HashMap images = new HashMap();
    public HashMap formXObjects = new HashMap();
    public int formXObjectsCounter = 1;
    public int fontNumber = 1;
    public int colorNumber = 1;
    public int patternNumber = 1;
    public PdfContentByte directContent;
    public PdfContentByte directContentUnder;
    public HashMap documentFonts = new HashMap();
    public HashMap documentColors = new HashMap();
    public HashMap documentPatterns = new HashMap();
    public HashMap documentShadings = new HashMap();
    public HashMap documentShadingPatterns = new HashMap();
    public ColorDetails patternColorspaceRGB;
    public ColorDetails patternColorspaceGRAY;
    public ColorDetails patternColorspaceCMYK;
    public HashMap documentSpotPatterns = new HashMap();
    public HashMap documentExtGState = new HashMap();
    public PdfBody body;
    public PdfDocument pdf;
    private PdfPageEvent pageEvent;
    public PdfEncryption crypto;
    public HashMap importedPages = new HashMap();
    public PdfReaderInstance currentPdfReaderInstance;
    public ArrayList pageReferences = new ArrayList();
    public int currentPageNumber = 1;
    public PdfDictionary group;
    public static final float SPACE_CHAR_RATIO_DEFAULT = 2.5f;
    public static final float NO_SPACE_CHAR_RATIO = 1.0E7f;
    public static final int RUN_DIRECTION_DEFAULT = 0;
    public static final int RUN_DIRECTION_NO_BIDI = 1;
    public static final int RUN_DIRECTION_LTR = 2;
    public static final int RUN_DIRECTION_RTL = 3;
    public int runDirection = 1;
    private float spaceCharRatio = 2.5f;
    private PdfDictionary extraCatalog;

    public PdfWriter() {
    }

    public PdfWriter(PdfDocument pdfDocument, OutputStream outputStream) {
        super(pdfDocument, outputStream);
        this.pdf = pdfDocument;
        this.directContent = new PdfContentByte(this);
        this.directContentUnder = new PdfContentByte(this);
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream, DocListener docListener) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.addDocListener(docListener);
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public PdfIndirectReference a(PdfPage pdfPage, PdfContents pdfContents) throws PdfException {
        PdfIndirectObject pdfIndirectObject;
        if (!this.open) {
            throw new PdfException("The document isn't open.");
        }
        try {
            pdfIndirectObject = this.body.a(pdfContents);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        pdfPage.a(pdfIndirectObject.getIndirectReference());
        if (this.group != null) {
            pdfPage.put(PdfName.GROUP, this.group);
            this.group = null;
        }
        this.root.a(pdfPage);
        ++this.currentPageNumber;
        return null;
    }

    public PdfName a(Image image) throws PdfException, DocumentException {
        PdfName pdfName;
        if (this.images.containsKey(image.getMySerialId())) {
            pdfName = (PdfName)this.images.get(image.getMySerialId());
        } else {
            if (image.isImgTemplate()) {
                pdfName = new PdfName("img" + this.images.size());
                if (image.templateData() == null) {
                    try {
                        ImgWMF imgWMF = (ImgWMF)image;
                        imgWMF.readWMF(this.getDirectContent().createTemplate(0.0f, 0.0f));
                    }
                    catch (Exception exception) {
                        throw new DocumentException(exception);
                    }
                }
            } else {
                PdfObject pdfObject;
                Image image2 = image.getImageMask();
                PdfIndirectReference pdfIndirectReference = null;
                if (image2 != null) {
                    pdfObject = (PdfName)this.images.get(image2.getMySerialId());
                    pdfIndirectReference = this.a((PdfName)pdfObject);
                }
                pdfObject = new PdfImage(image, "img" + this.images.size(), pdfIndirectReference);
                if (image.hasICCProfile()) {
                    PdfICCBased pdfICCBased = new PdfICCBased(image.getICCProfile());
                    PdfIndirectReference pdfIndirectReference2 = this.add(pdfICCBased);
                    PdfArray pdfArray = new PdfArray();
                    pdfArray.add(PdfName.ICCBASED);
                    pdfArray.add(pdfIndirectReference2);
                    PdfObject pdfObject2 = ((PdfDictionary)pdfObject).get(PdfName.COLORSPACE);
                    if (pdfObject2 != null && pdfObject2.isArray()) {
                        ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                        if (arrayList.size() > 1 && PdfName.INDEXED.equals(arrayList.get(0))) {
                            arrayList.set(1, pdfArray);
                        } else {
                            ((PdfDictionary)pdfObject).put(PdfName.COLORSPACE, pdfArray);
                        }
                    } else {
                        ((PdfDictionary)pdfObject).put(PdfName.COLORSPACE, pdfArray);
                    }
                }
                this.a((PdfImage)pdfObject);
                pdfName = ((PdfImage)pdfObject).name();
            }
            this.images.put(image.getMySerialId(), pdfName);
        }
        return pdfName;
    }

    public PdfIndirectReference a(PdfImage pdfImage) throws PdfException {
        if (!this.imageDictionary.contains(pdfImage.name())) {
            PdfIndirectObject pdfIndirectObject;
            try {
                pdfIndirectObject = this.body.a(pdfImage);
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.imageDictionary.put(pdfImage.name(), pdfIndirectObject.getIndirectReference());
            return pdfIndirectObject.getIndirectReference();
        }
        return (PdfIndirectReference)this.imageDictionary.get(pdfImage.name());
    }

    public PdfIndirectReference add(PdfICCBased pdfICCBased) throws PdfException {
        PdfIndirectObject pdfIndirectObject;
        try {
            pdfIndirectObject = this.body.a(pdfICCBased);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        return pdfIndirectObject.getIndirectReference();
    }

    public PdfIndirectReference a(PdfName pdfName) {
        return (PdfIndirectReference)this.imageDictionary.get(pdfName);
    }

    public void open() {
        super.open();
        try {
            this.os.write(this.HEADER);
            this.body = new PdfBody(this);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public PdfDictionary getCatalog(PdfIndirectReference pdfIndirectReference) {
        return ((PdfDocument)this.document).a(pdfIndirectReference);
    }

    public void addSharedObjectsToBody() throws IOException {
        Object object;
        Object object2;
        Iterator<Object> iterator = this.documentFonts.values().iterator();
        while (iterator.hasNext()) {
            object2 = (Object[])iterator.next();
            ((FontDetails)object2).a(this);
        }
        iterator = this.formXObjects.values().iterator();
        while (iterator.hasNext()) {
            object2 = (Object[])iterator.next();
            object = (PdfTemplate)object2[1];
            if (object != null && object.g() instanceof PRIndirectReference || object == null || object.getType() != 1) continue;
            PdfIndirectObject pdfIndirectObject = this.body.a((PdfObject)object.e(), object.g());
        }
        iterator = this.importedPages.values().iterator();
        while (iterator.hasNext()) {
            this.currentPdfReaderInstance = (PdfReaderInstance)iterator.next();
            this.currentPdfReaderInstance.a();
        }
        this.currentPdfReaderInstance = null;
        iterator = this.documentColors.values().iterator();
        while (iterator.hasNext()) {
            object2 = (ColorDetails)iterator.next();
            object = this.body.a((PdfObject)((ColorDetails)object2).a(this), ((ColorDetails)object2).a());
        }
        iterator = this.documentPatterns.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (PdfPatternPainter)iterator.next();
            object = this.body.a((PdfObject)((PdfPatternPainter)object2).i(), ((PdfTemplate)object2).g());
        }
        iterator = this.documentShadingPatterns.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (PdfShadingPattern)iterator.next();
            ((PdfShadingPattern)object2).e();
        }
        iterator = this.documentShadings.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (PdfShading)iterator.next();
            ((PdfShading)object2).d();
        }
        iterator = this.documentExtGState.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (PdfDictionary)iterator.next();
            object = (PdfObject[])this.documentExtGState.get(object2);
            this.addToBody((PdfObject)object2, (PdfIndirectReference)object[1]);
        }
    }

    public synchronized void close() {
        if (this.open) {
            if (this.currentPageNumber - 1 != this.pageReferences.size()) {
                throw new RuntimeException("The page " + this.pageReferences.size() + " was requested but the document has only " + (this.currentPageNumber - 1) + " pages.");
            }
            this.pdf.close();
            try {
                Object object;
                this.addSharedObjectsToBody();
                PdfIndirectReference pdfIndirectReference = this.root.a();
                PdfDictionary pdfDictionary = this.getCatalog(pdfIndirectReference);
                if (this.extraCatalog != null) {
                    pdfDictionary.mergeDifferent(this.extraCatalog);
                }
                PdfIndirectObject pdfIndirectObject = this.body.a(pdfDictionary);
                PdfIndirectObject pdfIndirectObject2 = this.body.a(((PdfDocument)this.document).e());
                PdfIndirectReference pdfIndirectReference2 = null;
                PdfObject pdfObject = null;
                if (this.crypto != null) {
                    object = this.body.a(this.crypto.getEncryptionDictionary());
                    pdfIndirectReference2 = ((PdfIndirectObject)object).getIndirectReference();
                    pdfObject = this.crypto.getFileID();
                } else {
                    pdfObject = PdfEncryption.createInfoId(PdfEncryption.createDocumentId());
                }
                this.body.a(this.os);
                object = new PdfTrailer(this.body.b(), this.body.c(), pdfIndirectObject.getIndirectReference(), pdfIndirectObject2.getIndirectReference(), pdfIndirectReference2, pdfObject);
                ((PdfTrailer)object).toPdf(this, this.os);
                super.close();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
    }

    public float getTableBottom(Table table) {
        return this.pdf.a(table) - this.pdf.f();
    }

    public boolean fitsPage(Table table, float f2) {
        return this.pdf.a(table) > this.pdf.f() + f2;
    }

    public boolean fitsPage(Table table) {
        return this.fitsPage(table, 0.0f);
    }

    public boolean fitsPage(PdfPTable pdfPTable, float f2) {
        return this.pdf.a(pdfPTable, f2);
    }

    public boolean fitsPage(PdfPTable pdfPTable) {
        return this.pdf.a(pdfPTable, 0.0f);
    }

    public boolean g() {
        return this.pause;
    }

    public PdfContentByte getDirectContent() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContent;
    }

    public PdfContentByte getDirectContentUnder() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContentUnder;
    }

    public void d() {
        this.directContent.reset();
        this.directContentUnder.reset();
    }

    public PdfAcroForm getAcroForm() {
        return this.pdf.getAcroForm();
    }

    public PdfOutline getRootOutline() {
        return this.directContent.getRootOutline();
    }

    public OutputStreamCounter c() {
        return this.os;
    }

    public FontDetails a(BaseFont baseFont) {
        if (baseFont.getFontType() == 4) {
            return new FontDetails(new PdfName("F" + this.fontNumber++), this.body.a(), baseFont);
        }
        FontDetails fontDetails = (FontDetails)this.documentFonts.get(baseFont);
        if (fontDetails == null) {
            fontDetails = new FontDetails(new PdfName("F" + this.fontNumber++), this.body.a(), baseFont);
            this.documentFonts.put(baseFont, fontDetails);
        }
        return fontDetails;
    }

    public void b(PdfDictionary pdfDictionary) {
        Iterator iterator = this.documentFonts.values().iterator();
        while (iterator.hasNext()) {
            FontDetails fontDetails = (FontDetails)iterator.next();
            if (pdfDictionary.get(fontDetails.a()) == null) continue;
            fontDetails.setSubset(false);
        }
    }

    public ColorDetails a(PdfSpotColor pdfSpotColor) {
        ColorDetails colorDetails = (ColorDetails)this.documentColors.get(pdfSpotColor);
        if (colorDetails == null) {
            colorDetails = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.a(), pdfSpotColor);
            this.documentColors.put(pdfSpotColor, colorDetails);
        }
        return colorDetails;
    }

    public ColorDetails a(Color color) {
        int n2 = ExtendedColor.getType(color);
        if (n2 == 4 || n2 == 5) {
            throw new RuntimeException("An uncolored tile pattern can not have another pattern or shading as color.");
        }
        try {
            switch (n2) {
                case 0: {
                    if (this.patternColorspaceRGB == null) {
                        this.patternColorspaceRGB = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.a(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICERGB);
                        PdfIndirectObject pdfIndirectObject = this.body.a((PdfObject)pdfArray, this.patternColorspaceRGB.a());
                    }
                    return this.patternColorspaceRGB;
                }
                case 2: {
                    if (this.patternColorspaceCMYK == null) {
                        this.patternColorspaceCMYK = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.a(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICECMYK);
                        PdfIndirectObject pdfIndirectObject = this.body.a((PdfObject)pdfArray, this.patternColorspaceCMYK.a());
                    }
                    return this.patternColorspaceCMYK;
                }
                case 1: {
                    if (this.patternColorspaceGRAY == null) {
                        this.patternColorspaceGRAY = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.a(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICEGRAY);
                        PdfIndirectObject pdfIndirectObject = this.body.a((PdfObject)pdfArray, this.patternColorspaceGRAY.a());
                    }
                    return this.patternColorspaceGRAY;
                }
                case 3: {
                    ColorDetails colorDetails = this.a(((SpotColor)color).getPdfSpotColor());
                    ColorDetails colorDetails2 = (ColorDetails)this.documentSpotPatterns.get(colorDetails);
                    if (colorDetails2 == null) {
                        colorDetails2 = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.a(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(colorDetails.a());
                        PdfIndirectObject pdfIndirectObject = this.body.a((PdfObject)pdfArray, colorDetails2.a());
                        this.documentSpotPatterns.put(colorDetails, colorDetails2);
                    }
                    return colorDetails2;
                }
            }
            throw new RuntimeException("Invalid color type in PdfWriter.addSimplePatternColorspace().");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void a(PdfShadingPattern pdfShadingPattern) {
        if (!this.documentShadingPatterns.containsKey(pdfShadingPattern)) {
            pdfShadingPattern.a(this.patternNumber);
            ++this.patternNumber;
            this.documentShadingPatterns.put(pdfShadingPattern, null);
            this.a(pdfShadingPattern.d());
        }
    }

    public void a(PdfShading pdfShading) {
        if (!this.documentShadings.containsKey(pdfShading)) {
            this.documentShadings.put(pdfShading, null);
            pdfShading.a(this.documentShadings.size());
        }
    }

    public PdfObject[] a(PdfDictionary pdfDictionary) {
        if (!this.documentExtGState.containsKey(pdfDictionary)) {
            this.documentExtGState.put(pdfDictionary, new PdfObject[]{new PdfName("GS" + (this.documentExtGState.size() + 1)), this.getPdfIndirectReference()});
        }
        return (PdfObject[])this.documentExtGState.get(pdfDictionary);
    }

    public PdfDocument f() {
        return this.pdf;
    }

    public PdfIndirectReference getPdfIndirectReference() {
        return this.body.a();
    }

    public int i() {
        return this.body.d();
    }

    public PdfName a(PdfPatternPainter pdfPatternPainter) {
        PdfName pdfName = (PdfName)this.documentPatterns.get(pdfPatternPainter);
        try {
            if (pdfName == null) {
                pdfName = new PdfName("P" + this.patternNumber);
                ++this.patternNumber;
                this.documentPatterns.put(pdfPatternPainter, pdfName);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    public PdfName a(PdfTemplate pdfTemplate) {
        PdfIndirectReference pdfIndirectReference = pdfTemplate.g();
        Object[] objectArray = (Object[])this.formXObjects.get(pdfIndirectReference);
        PdfName pdfName = null;
        try {
            if (objectArray == null) {
                pdfName = new PdfName("Xf" + this.formXObjectsCounter);
                ++this.formXObjectsCounter;
                if (pdfTemplate.getType() == 2) {
                    pdfTemplate = null;
                }
                this.formXObjects.put(pdfIndirectReference, new Object[]{pdfName, pdfTemplate});
            } else {
                pdfName = (PdfName)objectArray[0];
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    public void setPageEvent(PdfPageEvent pdfPageEvent) {
        this.pageEvent = pdfPageEvent;
    }

    public PdfPageEvent getPageEvent() {
        return this.pageEvent;
    }

    public void a(TreeMap treeMap) throws IOException {
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object[] objectArray = (Object[])treeMap.get(string);
            PdfDestination pdfDestination = (PdfDestination)objectArray[2];
            if (pdfDestination == null) {
                throw new RuntimeException("The name '" + string + "' has no local destination.");
            }
            if (objectArray[1] == null) {
                objectArray[1] = this.getPdfIndirectReference();
            }
            PdfIndirectObject pdfIndirectObject = this.body.a((PdfObject)pdfDestination, (PdfIndirectReference)objectArray[1]);
        }
    }

    public int getPageNumber() {
        return this.pdf.getPageNumber();
    }

    public void setViewerPreferences(int n2) {
        this.pdf.setViewerPreferences(n2);
    }

    public void setEncryption(byte[] byArray, byte[] byArray2, int n2, boolean bl2) throws DocumentException {
        if (this.pdf.isOpen()) {
            throw new DocumentException("Encryption can only be added before opening the document.");
        }
        this.crypto = new PdfEncryption();
        this.crypto.setupAllKeys(byArray, byArray2, n2, bl2);
    }

    public void setEncryption(boolean bl2, String string, String string2, int n2) throws DocumentException {
        this.setEncryption(PdfWriter.getISOBytes(string), PdfWriter.getISOBytes(string2), n2, bl2);
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.a(pdfObject);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.a(pdfObject, pdfIndirectReference);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, int n2) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.a(pdfObject, n2);
        return pdfIndirectObject;
    }

    public void setOpenAction(String string) {
        this.pdf.b(string);
    }

    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        this.pdf.b(pdfName, pdfAction);
    }

    public void setOpenAction(PdfAction pdfAction) {
        this.pdf.b(pdfAction);
    }

    public void setPageLabels(PdfPageLabels pdfPageLabels) {
        this.pdf.a(pdfPageLabels);
    }

    public PdfEncryption e() {
        return this.crypto;
    }

    public RandomAccessFileOrArray a(PdfReader pdfReader) {
        return this.currentPdfReaderInstance.d();
    }

    public int getNewObjectNumber(PdfReader pdfReader, int n2, int n3) {
        return this.currentPdfReaderInstance.a(n2, n3);
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n2) {
        PdfReaderInstance pdfReaderInstance = (PdfReaderInstance)this.importedPages.get(pdfReader);
        if (pdfReaderInstance == null) {
            pdfReaderInstance = pdfReader.getPdfReaderInstance(this);
            this.importedPages.put(pdfReader, pdfReaderInstance);
        }
        return pdfReaderInstance.b(n2);
    }

    public void addJavaScript(PdfAction pdfAction) {
        this.pdf.a(pdfAction);
    }

    public void addJavaScript(String string, boolean bl2) {
        this.addJavaScript(PdfAction.javaScript(string, this, bl2));
    }

    public void addJavaScript(String string) {
        this.addJavaScript(string, false);
    }

    public void setCropBoxSize(Rectangle rectangle) {
        this.pdf.a(rectangle);
    }

    public PdfIndirectReference getPageReference(int n2) {
        PdfIndirectReference pdfIndirectReference;
        if (--n2 < 0) {
            throw new IndexOutOfBoundsException("The page numbers start at 1.");
        }
        if (n2 < this.pageReferences.size()) {
            pdfIndirectReference = (PdfIndirectReference)this.pageReferences.get(n2);
            if (pdfIndirectReference == null) {
                pdfIndirectReference = this.body.a();
                this.pageReferences.set(n2, pdfIndirectReference);
            }
        } else {
            int n3 = n2 - this.pageReferences.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.pageReferences.add(null);
            }
            pdfIndirectReference = this.body.a();
            this.pageReferences.add(pdfIndirectReference);
        }
        return pdfIndirectReference;
    }

    public PdfIndirectReference a() {
        return this.getPageReference(this.currentPageNumber);
    }

    public int b() {
        return this.currentPageNumber;
    }

    public void addCalculationOrder(PdfFormField pdfFormField) {
        this.pdf.b(pdfFormField);
    }

    public void setSigFlags(int n2) {
        this.pdf.b(n2);
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        this.pdf.a(pdfAnnotation);
    }

    public void setPdfVersion(char c2) {
        this.HEADER[7] = (byte)c2;
    }

    public int reorderPages(int[] nArray) throws DocumentException {
        return this.root.a(nArray);
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f2) {
        this.spaceCharRatio = f2 < 0.001f ? 0.001f : f2;
    }

    public void setRunDirection(int n2) {
        if (n2 < 1 || n2 > 3) {
            throw new RuntimeException("Invalid run direction: " + n2);
        }
        this.runDirection = n2;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public void setDuration(int n2) {
        this.pdf.a(n2);
    }

    public void setTransition(PdfTransition pdfTransition) {
        this.pdf.a(pdfTransition);
    }

    public void freeReader(PdfReader pdfReader) throws IOException {
        this.currentPdfReaderInstance = (PdfReaderInstance)this.importedPages.get(pdfReader);
        if (this.currentPdfReaderInstance == null) {
            return;
        }
        this.currentPdfReaderInstance.a();
        this.currentPdfReaderInstance = null;
        this.importedPages.remove(pdfReader);
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + pdfName.toString());
        }
        this.pdf.a(pdfName, pdfAction);
    }

    public int getCurrentDocumentSize() {
        return this.body.c() + this.body.b() * 20 + 72;
    }

    public boolean isStrictImageSequence() {
        return this.pdf.c();
    }

    public void setStrictImageSequence(boolean bl2) {
        this.pdf.b(bl2);
    }

    public void setPageEmpty(boolean bl2) {
        this.pdf.a(bl2);
    }

    public PdfDictionary getInfo() {
        return ((PdfDocument)this.document).e();
    }

    public PdfDictionary getExtraCatalog() {
        return this.extraCatalog;
    }

    public void setExtraCatalog(PdfDictionary pdfDictionary) {
        this.extraCatalog = pdfDictionary;
    }

    public void setLinearPageMode() {
        this.root.c(null);
    }

    public PdfDictionary getGroup() {
        return this.group;
    }

    public void setGroup(PdfDictionary pdfDictionary) {
        this.group = pdfDictionary;
    }

    public static class PdfTrailer
    extends PdfDictionary {
        public int a;

        public PdfTrailer(int n2, int n3, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2, PdfIndirectReference pdfIndirectReference3, PdfObject pdfObject) {
            this.a = n3;
            this.put(PdfName.SIZE, new PdfNumber(n2));
            this.put(PdfName.ROOT, pdfIndirectReference);
            if (pdfIndirectReference2 != null) {
                this.put(PdfName.INFO, pdfIndirectReference2);
            }
            if (pdfIndirectReference3 != null) {
                this.put(PdfName.ENCRYPT, pdfIndirectReference3);
            }
            if (pdfObject != null) {
                this.put(PdfName.ID, pdfObject);
            }
        }

        public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
            outputStream.write(DocWriter.getISOBytes("trailer\n"));
            super.toPdf(null, outputStream);
            outputStream.write(DocWriter.getISOBytes("\nstartxref\n"));
            outputStream.write(DocWriter.getISOBytes(String.valueOf(this.a)));
            outputStream.write(DocWriter.getISOBytes("\n%%EOF\n"));
        }
    }

    public static class PdfBody {
        private ArrayList xrefs = new ArrayList();
        private int position;
        private PdfWriter writer;

        public PdfBody(PdfWriter pdfWriter) {
            this.xrefs.add(new PdfCrossReference(0, 65535));
            this.position = pdfWriter.c().getCounter();
            this.writer = pdfWriter;
        }

        public PdfIndirectObject a(PdfObject pdfObject) throws IOException {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(this.b(), pdfObject, this.writer);
            this.xrefs.add(new PdfCrossReference(this.position));
            pdfIndirectObject.a(this.writer.c());
            this.position = this.writer.c().getCounter();
            return pdfIndirectObject;
        }

        public PdfIndirectReference a() {
            this.xrefs.add(new PdfCrossReference(0));
            return new PdfIndirectReference(0, this.b() - 1);
        }

        public int d() {
            this.xrefs.add(new PdfCrossReference(0));
            return this.b() - 1;
        }

        public PdfIndirectObject a(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) throws IOException {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(pdfIndirectReference.getNumber(), pdfObject, this.writer);
            this.xrefs.set(pdfIndirectReference.getNumber(), new PdfCrossReference(this.position));
            pdfIndirectObject.a(this.writer.c());
            this.position = this.writer.c().getCounter();
            return pdfIndirectObject;
        }

        public PdfIndirectObject a(PdfObject pdfObject, int n2) throws IOException {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n2, pdfObject, this.writer);
            this.xrefs.set(n2, new PdfCrossReference(this.position));
            pdfIndirectObject.a(this.writer.c());
            this.position = this.writer.c().getCounter();
            return pdfIndirectObject;
        }

        public int c() {
            return this.position;
        }

        public int b() {
            return this.xrefs.size();
        }

        public void a(OutputStream outputStream) throws IOException {
            outputStream.write(DocWriter.getISOBytes("xref\n0 "));
            outputStream.write(DocWriter.getISOBytes(String.valueOf(this.b())));
            outputStream.write(10);
            Iterator iterator = this.xrefs.iterator();
            while (iterator.hasNext()) {
                PdfCrossReference pdfCrossReference = (PdfCrossReference)iterator.next();
                pdfCrossReference.toPdf(null, outputStream);
            }
        }

        public static class PdfCrossReference {
            private int offset;
            private int generation;

            public PdfCrossReference(int n2, int n3) {
                this.offset = n2;
                this.generation = n3;
            }

            public PdfCrossReference(int n2) {
                this(n2, 0);
            }

            public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
                String string = "0000000000" + this.offset;
                StringBuffer stringBuffer = new StringBuffer(string.substring(string.length() - 10));
                string = "00000" + this.generation;
                String string2 = string.substring(string.length() - 5);
                if (this.generation == 65535) {
                    outputStream.write(DocWriter.getISOBytes(stringBuffer.append(' ').append(string2).append(" f \n").toString()));
                } else {
                    outputStream.write(DocWriter.getISOBytes(stringBuffer.append(' ').append(string2).append(" n \n").toString()));
                }
            }
        }
    }
}

