/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.BaseFont;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;

public class RandomAccessFileOrArray
implements DataInput {
    public RandomAccessFile f;
    public String c;
    public byte[] b;
    public int e;
    public byte a;
    public boolean d = false;
    private int startOffset = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessFileOrArray(String string) throws IOException {
        File file = new File(string);
        if (!file.canRead()) {
            InputStream inputStream = BaseFont.getResourceStream(string);
            if (inputStream == null) {
                throw new IOException(string + " not found as file or resource.");
            }
            try {
                int n2;
                byte[] byArray = new byte[4096];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n2 = inputStream.read(byArray)) >= 1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                this.b = byteArrayOutputStream.toByteArray();
                return;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.c = string;
        this.f = new RandomAccessFile(string, "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessFileOrArray(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            int n2;
            byte[] byArray = new byte[4096];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = inputStream.read(byArray)) >= 1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            this.b = byteArrayOutputStream.toByteArray();
            return;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RandomAccessFileOrArray(byte[] byArray) {
        this.b = byArray;
    }

    public RandomAccessFileOrArray(RandomAccessFileOrArray randomAccessFileOrArray) {
        this.c = randomAccessFileOrArray.c;
        this.b = randomAccessFileOrArray.b;
        this.startOffset = randomAccessFileOrArray.startOffset;
    }

    public void pushBack(byte by2) {
        this.a = by2;
        this.d = true;
    }

    public int read() throws IOException {
        if (this.d) {
            this.d = false;
            return this.a & 0xFF;
        }
        if (this.b == null) {
            return this.f.read();
        }
        if (this.e >= this.b.length) {
            return -1;
        }
        return this.b[this.e++] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        if (this.d) {
            this.d = false;
            if (n3 == 1) {
                byArray[n2] = this.a;
                return 1;
            }
            n4 = 1;
            byArray[n2++] = this.a;
            --n3;
        }
        if (this.b == null) {
            return this.f.read(byArray, n2, n3) + n4;
        }
        if (this.e >= this.b.length) {
            return -1;
        }
        if (this.e + n3 > this.b.length) {
            n3 = this.b.length - this.e;
        }
        System.arraycopy(this.b, this.e, byArray, n2, n3);
        this.e += n3;
        return n3 + n4;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        do {
            if ((n4 = this.read(byArray, n2 + n5, n3 - n5)) >= 0) continue;
            throw new EOFException();
        } while ((n5 += n4) < n3);
    }

    public long skip(long l2) throws IOException {
        return this.skipBytes((int)l2);
    }

    public int skipBytes(int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        if (n2 <= 0) {
            return 0;
        }
        int n6 = 0;
        if (this.d) {
            this.d = false;
            if (n2 == 1) {
                return 1;
            }
            --n2;
            n6 = 1;
        }
        if ((n5 = (n4 = this.getFilePointer()) + n2) > (n3 = this.length())) {
            n5 = n3;
        }
        this.seek(n5);
        return n5 - n4 + n6;
    }

    public void reOpen() throws IOException {
        this.d = false;
        if (this.c != null) {
            this.close();
            this.f = new RandomAccessFile(this.c, "r");
            if (this.startOffset != 0) {
                this.f.seek(this.startOffset);
            }
        } else {
            this.e = this.startOffset;
        }
    }

    public void insureOpen() throws IOException {
        if (this.c != null && this.f == null) {
            this.reOpen();
        }
    }

    public void close() throws IOException {
        this.d = false;
        if (this.f != null) {
            this.f.close();
            this.f = null;
        }
    }

    public int length() throws IOException {
        if (this.b == null) {
            return (int)this.f.length() - this.startOffset;
        }
        return this.b.length - this.startOffset;
    }

    public void seek(int n2) throws IOException {
        n2 += this.startOffset;
        this.d = false;
        if (this.b == null) {
            this.insureOpen();
            this.f.seek(n2);
        } else {
            this.e = n2;
        }
    }

    public void seek(long l2) throws IOException {
        this.seek((int)l2);
    }

    public int getFilePointer() throws IOException {
        int n2;
        int n3 = n2 = this.d ? 1 : 0;
        if (this.b == null) {
            return (int)this.f.getFilePointer() - n2 - this.startOffset;
        }
        return this.e - n2 - this.startOffset;
    }

    public boolean readBoolean() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    public byte readByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public int readUnsignedByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public short readShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n3 << 8) + n2);
    }

    public final short readShortLE() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n3 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + n2;
    }

    public final int readUnsignedShortLE() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n3 << 0);
    }

    public char readChar() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 8) + n2);
    }

    public final char readCharLE() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n3 << 0));
    }

    public int readInt() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.read();
        if ((n5 | (n4 = this.read()) | (n3 = this.read()) | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + n2;
    }

    public final int readIntLE() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.read();
        if ((n5 | (n4 = this.read()) | (n3 = this.read()) | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    public final long readUnsignedInt() throws IOException {
        long l2;
        long l3;
        long l4;
        long l5 = this.read();
        if ((l5 | (l4 = (long)this.read()) | (l3 = (long)this.read()) | (l2 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (l5 << 24) + (l4 << 16) + (l3 << 8) + (l2 << 0);
    }

    public final long readUnsignedIntLE() throws IOException {
        long l2;
        long l3;
        long l4;
        long l5 = this.read();
        if ((l5 | (l4 = (long)this.read()) | (l3 = (long)this.read()) | (l2 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (l2 << 24) + (l3 << 16) + (l4 << 8) + (l5 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final long readLongLE() throws IOException {
        int n2 = this.readIntLE();
        int n3 = this.readIntLE();
        return ((long)n3 << 32) + ((long)n2 & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final float readFloatLE() throws IOException {
        return Float.intBitsToFloat(this.readIntLE());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final double readDoubleLE() throws IOException {
        return Double.longBitsToDouble(this.readLongLE());
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        boolean bl2 = false;
        block4: while (!bl2) {
            n2 = this.read();
            switch (n2) {
                case -1: 
                case 10: {
                    bl2 = true;
                    continue block4;
                }
                case 13: {
                    bl2 = true;
                    int n3 = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(n3);
                    continue block4;
                }
            }
            stringBuffer.append((char)n2);
        }
        if (n2 == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int n2) {
        this.startOffset = n2;
    }
}

