/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;

public class TextField {
    public static final float BORDER_WIDTH_THIN = 1.0f;
    public static final float BORDER_WIDTH_MEDIUM = 2.0f;
    public static final float BORDER_WIDTH_THICK = 3.0f;
    public static final int VISIBLE = 0;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int READ_ONLY = 1;
    public static final int REQUIRED = 2;
    public static final int MULTILINE = 4;
    public static final int DO_NOT_SCROLL = 8;
    public static final int PASSWORD = 16;
    public static final int FILE_SELECTION = 32;
    public static final int DO_NOT_SPELL_CHECK = 64;
    public static final int EDIT = 128;
    public float borderWidth = 1.0f;
    public int borderStyle = 0;
    public Color borderColor;
    public Color backgroundColor;
    public Color textColor;
    public BaseFont font;
    public float fontSize = 0.0f;
    public int alignment = 0;
    public PdfWriter writer;
    public String text;
    public Rectangle box;
    public int rotation = 0;
    private int visibility;
    private String fieldName;
    private String defaultText;
    private int options;
    private int maxCharacterLength;
    private String[] choices;
    private String[] choiceExports;
    private int choiceSelection;
    private int topFirst;

    public TextField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        this.writer = pdfWriter;
        this.box = rectangle;
        this.fieldName = string;
    }

    public BaseFont getRealFont() throws IOException, DocumentException {
        if (this.font == null) {
            return BaseFont.createFont("Helvetica", "Cp1252", false);
        }
        return this.font;
    }

    public PdfAppearance getBorderAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.writer.getDirectContent().createAppearance(this.box.width(), this.box.height());
        switch (this.rotation) {
            case 90: {
                pdfAppearance.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, this.box.height(), 0.0f);
                break;
            }
            case 180: {
                pdfAppearance.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, this.box.width(), this.box.height());
                break;
            }
            case 270: {
                pdfAppearance.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.box.width());
            }
        }
        if (this.backgroundColor != null) {
            pdfAppearance.setColorFill(this.backgroundColor);
            pdfAppearance.rectangle(0.0f, 0.0f, this.box.width(), this.box.height());
            pdfAppearance.fill();
        }
        if (this.borderStyle == 1) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setLineDash(3.0f, 0.0f);
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                pdfAppearance.stroke();
            }
        } else if (this.borderStyle == 4) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.moveTo(0.0f, this.borderWidth / 2.0f);
                pdfAppearance.lineTo(this.box.width(), this.borderWidth / 2.0f);
                pdfAppearance.stroke();
            }
        } else if (this.borderStyle == 2) {
            Color color;
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                pdfAppearance.stroke();
            }
            if ((color = this.backgroundColor) == null) {
                color = Color.white;
            }
            pdfAppearance.setGrayFill(1.0f);
            this.drawTopFrame(pdfAppearance);
            pdfAppearance.setColorFill(color.darker());
            this.drawBottomFrame(pdfAppearance);
        } else if (this.borderStyle == 3) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                pdfAppearance.setColorStroke(this.borderColor);
                pdfAppearance.setLineWidth(this.borderWidth);
                pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                pdfAppearance.stroke();
            }
            pdfAppearance.setGrayFill(0.5f);
            this.drawTopFrame(pdfAppearance);
            pdfAppearance.setGrayFill(0.75f);
            this.drawBottomFrame(pdfAppearance);
        } else if (this.borderWidth != 0.0f && this.borderColor != null) {
            pdfAppearance.setColorStroke(this.borderColor);
            pdfAppearance.setLineWidth(this.borderWidth);
            pdfAppearance.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
            pdfAppearance.stroke();
        }
        return pdfAppearance;
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.text == null || this.text.length() == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        BaseFont baseFont = this.getRealFont();
        boolean bl2 = this.borderStyle == 2 || this.borderStyle == 3;
        float f2 = this.box.height() - this.borderWidth * 2.0f;
        if (bl2) {
            f2 -= this.borderWidth * 2.0f;
        }
        float f3 = bl2 ? 2.0f * this.borderWidth : this.borderWidth;
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f3, f3, this.box.width() - 2.0f * f3, this.box.height() - 2.0f * f3);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        if (this.textColor == null) {
            pdfAppearance.setGrayFill(0.0f);
        } else {
            pdfAppearance.setColorFill(this.textColor);
        }
        pdfAppearance.beginText();
        if ((this.options & 4) != 0) {
            float f4;
            float f5;
            ArrayList arrayList;
            float f6 = this.fontSize;
            float f7 = this.box.width() - 3.0f * f3;
            ArrayList arrayList2 = arrayList = TextField.getHardBreaks(this.text);
            float f8 = baseFont.getFontDescriptor(8, 1.0f) - baseFont.getFontDescriptor(6, 1.0f);
            if (f6 == 0.0f) {
                f6 = f2 / (float)arrayList.size() / f8;
                if (f6 > 4.0f) {
                    if (f6 > 12.0f) {
                        f6 = 12.0f;
                    }
                    f5 = Math.max((f6 - 4.0f) / 10.0f, 0.2f);
                    while (f6 > 4.0f && !((float)(arrayList2 = TextField.breakLines(arrayList, baseFont, f6, f7)).size() * f6 * f8 <= f2)) {
                        f6 -= f5;
                    }
                }
                if (f6 <= 4.0f) {
                    f6 = 4.0f;
                    arrayList2 = TextField.breakLines(arrayList, baseFont, f6, f7);
                }
            } else {
                arrayList2 = TextField.breakLines(arrayList, baseFont, f6, f7);
            }
            pdfAppearance.setFontAndSize(baseFont, f6);
            pdfAppearance.setLeading(f6 * f8);
            f5 = f3 + f2 - baseFont.getFontDescriptor(8, f6);
            String string = (String)arrayList2.get(0);
            if (this.alignment == 2) {
                f4 = baseFont.getWidthPoint(string, f6);
                pdfAppearance.moveText(this.box.width() - 2.0f * f3 - f4, f5);
            } else if (this.alignment == 1) {
                string = string.trim();
                f4 = baseFont.getWidthPoint(string, f6);
                pdfAppearance.moveText(this.box.width() / 2.0f - f4 / 2.0f, f5);
            } else {
                pdfAppearance.moveText(2.0f * f3, f5);
            }
            pdfAppearance.showText(string);
            int n2 = (int)(f2 / f6 / f8) + 1;
            n2 = Math.min(n2, arrayList2.size());
            for (int i2 = 1; i2 < n2; ++i2) {
                float f9;
                string = (String)arrayList2.get(i2);
                if (this.alignment == 2) {
                    f9 = baseFont.getWidthPoint(string, f6);
                    pdfAppearance.moveText(this.box.width() - 2.0f * f3 - f9 - pdfAppearance.getXTLM(), 0.0f);
                } else if (this.alignment == 1) {
                    string = string.trim();
                    f9 = baseFont.getWidthPoint(string, f6);
                    pdfAppearance.moveText(this.box.width() / 2.0f - f9 / 2.0f - pdfAppearance.getXTLM(), 0.0f);
                }
                pdfAppearance.newlineShowText(string);
            }
        } else {
            float f10;
            float f11;
            float f12 = this.fontSize;
            if (f12 == 0.0f) {
                f11 = f2 / (baseFont.getFontDescriptor(7, 1.0f) - baseFont.getFontDescriptor(6, 1.0f));
                f10 = baseFont.getWidthPoint(this.text, 1.0f);
                f12 = f10 == 0.0f ? f11 : (this.box.width() - 2.0f * f3) / f10;
                if (f12 > f11) {
                    f12 = f11;
                }
                if (f12 < 4.0f) {
                    f12 = 4.0f;
                }
            }
            pdfAppearance.setFontAndSize(baseFont, f12);
            f11 = f3 + (f2 - baseFont.getFontDescriptor(1, f12)) / 2.0f;
            if (f11 < f3) {
                f11 = f3;
            }
            if (this.alignment == 2) {
                f10 = baseFont.getWidthPoint(this.text, f12);
                pdfAppearance.moveText(this.box.width() - 2.0f * f3 - f10, f11);
            } else if (this.alignment == 1) {
                f10 = baseFont.getWidthPoint(this.text, f12);
                pdfAppearance.moveText(this.box.width() / 2.0f - f10 / 2.0f, f11);
            } else {
                pdfAppearance.moveText(2.0f * f3, f11);
            }
            pdfAppearance.showText(this.text);
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    public PdfAppearance a() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.choices == null || this.choices.length == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        int n2 = this.choiceSelection;
        if (n2 >= this.choices.length) {
            n2 = this.choices.length - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        BaseFont baseFont = this.getRealFont();
        float f2 = this.fontSize;
        if (f2 == 0.0f) {
            f2 = 12.0f;
        }
        boolean bl2 = this.borderStyle == 2 || this.borderStyle == 3;
        float f3 = this.box.height() - this.borderWidth * 2.0f;
        if (bl2) {
            f3 -= this.borderWidth * 2.0f;
        }
        float f4 = bl2 ? 2.0f * this.borderWidth : this.borderWidth;
        float f5 = baseFont.getFontDescriptor(8, f2) - baseFont.getFontDescriptor(6, f2);
        int n3 = (int)(f3 / f5) + 1;
        int n4 = 0;
        int n5 = 0;
        n5 = n2 + n3 / 2 + 1;
        n4 = n5 - n3;
        if (n4 < 0) {
            n5 += n4;
            n4 = 0;
        }
        if ((n5 = n4 + n3) > this.choices.length) {
            n5 = this.choices.length;
        }
        this.topFirst = n4;
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f4, f4, this.box.width() - 2.0f * f4, this.box.height() - 2.0f * f4);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        Color color = this.textColor == null ? new GrayColor(0) : this.textColor;
        pdfAppearance.setColorFill(new Color(10, 36, 106));
        pdfAppearance.rectangle(f4, f4 + f3 - (float)(n2 - n4 + 1) * f5, this.box.width() - 2.0f * f4, f5);
        pdfAppearance.fill();
        pdfAppearance.beginText();
        pdfAppearance.setFontAndSize(baseFont, f2);
        pdfAppearance.setLeading(f5);
        pdfAppearance.moveText(f4 * 2.0f, f4 + f3 - baseFont.getFontDescriptor(8, f2) + f5);
        pdfAppearance.setColorFill(color);
        for (int i2 = n4; i2 < n5; ++i2) {
            if (i2 == n2) {
                pdfAppearance.setGrayFill(1.0f);
                pdfAppearance.newlineShowText(this.choices[i2]);
                pdfAppearance.setColorFill(color);
                continue;
            }
            pdfAppearance.newlineShowText(this.choices[i2]);
        }
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    public static ArrayList getHardBreaks(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 == '\r') {
                if (i2 + 1 < n2 && cArray[i2 + 1] == '\n') {
                    ++i2;
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if (c2 == '\n') {
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c2);
        }
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    public static void trimRight(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        while (n2 != 0) {
            if (stringBuffer.charAt(--n2) != ' ') {
                return;
            }
            stringBuffer.setLength(n2);
        }
        return;
    }

    public static ArrayList breakLines(ArrayList arrayList, BaseFont baseFont, float f2, float f3) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            stringBuffer.setLength(0);
            float f4 = 0.0f;
            char[] cArray = ((String)arrayList.get(i2)).toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            int n4 = -1;
            char c2 = '\u0000';
            int n5 = 0;
            block6: for (int i3 = 0; i3 < n2; ++i3) {
                c2 = cArray[i3];
                switch (n3) {
                    case 0: {
                        f4 += baseFont.getWidthPoint(c2, f2);
                        stringBuffer.append(c2);
                        if (f4 > f3) {
                            f4 = 0.0f;
                            if (stringBuffer.length() > 1) {
                                stringBuffer.setLength(stringBuffer.length() - 1);
                            }
                            arrayList2.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n5 = --i3;
                            if (c2 == ' ') {
                                n3 = 2;
                                continue block6;
                            }
                            n3 = 1;
                            continue block6;
                        }
                        if (c2 == ' ') continue block6;
                        n3 = 1;
                        continue block6;
                    }
                    case 1: {
                        f4 += baseFont.getWidthPoint(c2, f2);
                        stringBuffer.append(c2);
                        if (c2 == ' ') {
                            n4 = i3;
                        }
                        if (!(f4 > f3)) continue block6;
                        f4 = 0.0f;
                        if (n4 >= 0) {
                            i3 = n4;
                            stringBuffer.setLength(n4 - n5);
                            TextField.trimRight(stringBuffer);
                            arrayList2.add(stringBuffer.toString());
                            stringBuffer.setLength(0);
                            n5 = i3;
                            n4 = -1;
                            n3 = 2;
                            continue block6;
                        }
                        if (stringBuffer.length() > 1) {
                            stringBuffer.setLength(stringBuffer.length() - 1);
                        }
                        arrayList2.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        n5 = --i3;
                        if (c2 != ' ') continue block6;
                        n3 = 2;
                        continue block6;
                    }
                    case 2: {
                        if (c2 == ' ') continue block6;
                        f4 = 0.0f;
                        --i3;
                        n3 = 1;
                    }
                }
            }
            TextField.trimRight(stringBuffer);
            arrayList2.add(stringBuffer.toString());
        }
        return arrayList2;
    }

    public PdfFormField getTextField() throws IOException, DocumentException {
        PdfFormField pdfFormField = PdfFormField.createTextField(this.writer, false, false, this.maxCharacterLength);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        pdfFormField.setFieldName(this.fieldName);
        switch (this.alignment) {
            case 1: {
                pdfFormField.setQuadding(1);
                break;
            }
            case 2: {
                pdfFormField.setQuadding(2);
            }
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        pdfFormField.setValueAsString(this.text);
        if (this.defaultText != null) {
            pdfFormField.setDefaultValueAsString(this.defaultText);
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        if ((this.options & 1) != 0) {
            pdfFormField.setFieldFlags(1);
        }
        if ((this.options & 2) != 0) {
            pdfFormField.setFieldFlags(2);
        }
        if ((this.options & 4) != 0) {
            pdfFormField.setFieldFlags(4096);
        }
        if ((this.options & 8) != 0) {
            pdfFormField.setFieldFlags(0x800000);
        }
        if ((this.options & 0x10) != 0) {
            pdfFormField.setFieldFlags(8192);
        }
        if ((this.options & 0x20) != 0) {
            pdfFormField.setFieldFlags(0x100000);
        }
        if ((this.options & 0x40) != 0) {
            pdfFormField.setFieldFlags(0x400000);
        }
        return pdfFormField;
    }

    public PdfFormField getComboField() throws IOException, DocumentException {
        return this.getChoiceField(false);
    }

    public PdfFormField getListField() throws IOException, DocumentException {
        return this.getChoiceField(true);
    }

    public PdfFormField getChoiceField(boolean bl2) throws IOException, DocumentException {
        PdfAppearance pdfAppearance;
        int n2;
        this.options &= 0xFFFFFFFB;
        String[] stringArray = this.choices;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if ((n2 = this.choiceSelection) >= stringArray.length) {
            n2 = stringArray.length - 1;
        }
        this.text = "";
        if (n2 >= 0) {
            this.text = stringArray[n2];
        }
        if (n2 < 0) {
            n2 = 0;
        }
        PdfFormField pdfFormField = null;
        String[][] stringArray2 = null;
        if (this.choiceExports == null) {
            pdfFormField = bl2 ? PdfFormField.createList(this.writer, stringArray, n2) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, stringArray, n2);
        } else {
            int n3;
            stringArray2 = new String[stringArray.length][2];
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                String string = stringArray[n3];
                stringArray2[n3][1] = string;
                stringArray2[n3][0] = string;
            }
            n3 = Math.min(stringArray.length, this.choiceExports.length);
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.choiceExports[i2] == null) continue;
                stringArray2[i2][0] = this.choiceExports[i2];
            }
            pdfFormField = bl2 ? PdfFormField.createList(this.writer, stringArray2, n2) : PdfFormField.createCombo(this.writer, (this.options & 0x80) != 0, stringArray2, n2);
        }
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        pdfFormField.setFieldName(this.fieldName);
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (stringArray.length > 0) {
            if (stringArray2 != null) {
                pdfFormField.setValueAsString(stringArray2[n2][0]);
                pdfFormField.setDefaultValueAsString(stringArray2[n2][0]);
            } else {
                pdfFormField.setValueAsString(this.text);
                pdfFormField.setDefaultValueAsString(this.text);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        if (bl2) {
            pdfAppearance = this.a();
            if (this.topFirst > 0) {
                pdfFormField.put(PdfName.TI, new PdfNumber(this.topFirst));
            }
        } else {
            pdfAppearance = this.getAppearance();
        }
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        if ((this.options & 1) != 0) {
            pdfFormField.setFieldFlags(1);
        }
        if ((this.options & 2) != 0) {
            pdfFormField.setFieldFlags(2);
        }
        if ((this.options & 0x40) != 0) {
            pdfFormField.setFieldFlags(0x400000);
        }
        return pdfFormField;
    }

    private void drawTopFrame(PdfAppearance pdfAppearance) {
        pdfAppearance.moveTo(this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.box.height() - this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.borderWidth);
        pdfAppearance.fill();
    }

    private void drawBottomFrame(PdfAppearance pdfAppearance) {
        pdfAppearance.moveTo(this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - this.borderWidth, this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.box.width() - 2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        pdfAppearance.lineTo(this.borderWidth, this.borderWidth);
        pdfAppearance.fill();
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float f2) {
        this.borderWidth = f2;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int n2) {
        this.borderStyle = n2;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public BaseFont getFont() {
        return this.font;
    }

    public void setFont(BaseFont baseFont) {
        this.font = baseFont;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float f2) {
        this.fontSize = f2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle rectangle) {
        this.box = rectangle;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n2) {
        if (n2 % 90 != 0) {
            throw new IllegalArgumentException("Rotation must be a multiple of 90.");
        }
        if ((n2 %= 360) < 0) {
            n2 += 360;
        }
        this.rotation = n2;
    }

    public void setRotationFromPage(Rectangle rectangle) {
        this.setRotation(rectangle.getRotation());
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int n2) {
        this.visibility = n2;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String string) {
        this.defaultText = string;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int n2) {
        this.options = n2;
    }

    public int getMaxCharacterLength() {
        return this.maxCharacterLength;
    }

    public void setMaxCharacterLength(int n2) {
        this.maxCharacterLength = n2;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public void setChoices(String[] stringArray) {
        this.choices = stringArray;
    }

    public String[] getChoiceExports() {
        return this.choiceExports;
    }

    public void setChoiceExports(String[] stringArray) {
        this.choiceExports = stringArray;
    }

    public int getChoiceSelection() {
        return this.choiceSelection;
    }

    public void setChoiceSelection(int n2) {
        this.choiceSelection = n2;
    }

    public int b() {
        return this.topFirst;
    }
}

