/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.wmf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.wmf.InputMeta;
import com.lowagie.text.pdf.wmf.MetaObject;
import com.lowagie.text.pdf.wmf.MetaState;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MetaFont
extends MetaObject {
    public static final String[] f = new String[]{"Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique", "Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique", "Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic", "Symbol", "ZapfDingbats"};
    public int e;
    public float i;
    public int g;
    public int h;
    public boolean j;
    public boolean b;
    public int c;
    public int a;
    public String k = "arial";
    public BaseFont d = null;

    public MetaFont() {
        this.type = 3;
    }

    public void init(InputMeta inputMeta) throws IOException {
        int n2;
        int n3;
        this.e = Math.abs(inputMeta.readShort());
        inputMeta.skip(2);
        this.i = (float)((double)inputMeta.readShort() / 1800.0 * Math.PI);
        inputMeta.skip(2);
        this.g = inputMeta.readShort() >= 600 ? 1 : 0;
        this.h = inputMeta.readByte() != 0 ? 2 : 0;
        this.j = inputMeta.readByte() != 0;
        this.b = inputMeta.readByte() != 0;
        this.c = inputMeta.readByte();
        inputMeta.skip(3);
        this.a = inputMeta.readByte();
        byte[] byArray = new byte[32];
        for (n3 = 0; n3 < 32 && (n2 = inputMeta.readByte()) != 0; ++n3) {
            byArray[n3] = (byte)n2;
        }
        try {
            this.k = new String(byArray, 0, n3, "Cp1252");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.k = new String(byArray, 0, n3);
        }
        this.k = this.k.toLowerCase();
    }

    public BaseFont getFont() {
        String string;
        if (this.d != null) {
            return this.d;
        }
        if (this.k.indexOf("courier") != -1 || this.k.indexOf("terminal") != -1 || this.k.indexOf("fixedsys") != -1) {
            string = f[0 + this.h + this.g];
        } else if (this.k.indexOf("ms sans serif") != -1 || this.k.indexOf("arial") != -1 || this.k.indexOf("system") != -1) {
            string = f[4 + this.h + this.g];
        } else if (this.k.indexOf("arial black") != -1) {
            string = f[4 + this.h + 1];
        } else if (this.k.indexOf("times") != -1 || this.k.indexOf("ms serif") != -1 || this.k.indexOf("roman") != -1) {
            string = f[8 + this.h + this.g];
        } else if (this.k.indexOf("symbol") != -1) {
            string = f[12];
        } else {
            int n2 = this.a & 3;
            int n3 = this.a >> 4 & 7;
            block1 : switch (n3) {
                case 3: {
                    string = f[0 + this.h + this.g];
                    break;
                }
                case 1: {
                    string = f[8 + this.h + this.g];
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    string = f[4 + this.h + this.g];
                    break;
                }
                default: {
                    switch (n2) {
                        case 1: {
                            string = f[0 + this.h + this.g];
                            break block1;
                        }
                    }
                    string = f[4 + this.h + this.g];
                }
            }
        }
        try {
            this.d = BaseFont.createFont(string, "Cp1252", false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return this.d;
    }

    public float getAngle() {
        return this.i;
    }

    public boolean isUnderline() {
        return this.j;
    }

    public boolean isStrikeout() {
        return this.b;
    }

    public float getFontSize(MetaState metaState) {
        return Math.abs(metaState.transformY(this.e) - metaState.transformY(0)) * 0.86f;
    }
}

