/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.workers;

import foxtrot.AbstractWorkerThread;
import foxtrot.Task;

public class SingleWorkerThread
extends AbstractWorkerThread
implements Runnable {
    private static int sequence = 0;
    private Thread thread;
    private Link current;
    private boolean pending;

    public void start() {
        if (this.isAlive()) {
            return;
        }
        this.stop();
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public String getThreadName() {
        return "Foxtrot Single Worker Thread #" + SingleWorkerThread.a();
    }

    public static synchronized int a() {
        return ++sequence;
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive() && !this.isThreadInterrupted();
    }

    public boolean isWorkerThread() {
        return Thread.currentThread() == this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTask(Task task) {
        if (!this.isAlive()) {
            this.start();
        }
        SingleWorkerThread singleWorkerThread = this;
        synchronized (singleWorkerThread) {
            if (this.hasTasks()) {
                Link link = this.current;
                while (Link.b(link) != null) {
                    link = Link.b(link);
                }
                Link.a(link, new Link(task, null));
            } else {
                this.current = new Link(task, null);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task takeTask() throws InterruptedException {
        SingleWorkerThread singleWorkerThread = this;
        synchronized (singleWorkerThread) {
            while (!this.hasTasks()) {
                this.pending = false;
                this.wait();
            }
            this.pending = true;
            Task task = Link.a(this.current);
            this.current = Link.b(this.current);
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTasks() {
        SingleWorkerThread singleWorkerThread = this;
        synchronized (singleWorkerThread) {
            return this.current != null;
        }
    }

    public boolean isThreadInterrupted() {
        return this.thread.isInterrupted();
    }

    public void run() {
        while (!this.isThreadInterrupted()) {
            try {
                Task task = this.takeTask();
                this.run(task);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public void run(Task task) {
        this.runTask(task);
    }

    public static class 1 {
    }

    private static class Link {
        private Link next;
        private final Task task;

        private Link(Task task) {
            this.task = task;
        }

        public static Link b(Link link) {
            return link.next;
        }

        public static Link a(Link link, Link link2) {
            link.next = link2;
            return link.next;
        }

        public Link(Task task, 1 var2_2) {
            this(task);
        }

        public static Task a(Link link) {
            return link.task;
        }
    }
}

