/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.ant;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.RegexpPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class JRAntCompileTask
extends MatchingTask {
    private Path src = null;
    private File destdir = null;
    private File tempdir = null;
    private boolean keepjava = false;
    private String compiler = null;
    private Path classpath = null;
    private boolean xmlvalidation = true;
    private Map reportFilesMap = null;

    public void setSrcdir(Path path) {
        if (this.src == null) {
            this.src = path;
        } else {
            this.src.append(path);
        }
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void setTempdir(File file) {
        this.tempdir = file;
    }

    public void setKeepjava(boolean bl2) {
        this.keepjava = bl2;
    }

    public void setCompiler(String string) {
        this.compiler = string;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setXmlvalidation(boolean bl2) {
        this.xmlvalidation = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.checkParameters();
        this.reportFilesMap = new HashMap();
        JRProperties.backupProperties();
        try {
            if (this.tempdir != null) {
                JRProperties.setProperty("net.sf.jasperreports.compiler.temp.dir", String.valueOf(this.tempdir));
            }
            JRProperties.setProperty("net.sf.jasperreports.compiler.keep.java.file", this.keepjava);
            if (this.compiler != null) {
                JRProperties.setProperty("net.sf.jasperreports.compiler.class", this.compiler);
            }
            JRProperties.setProperty("net.sf.jasperreports.compiler.xml.validation", this.xmlvalidation);
            AntClassLoader antClassLoader = null;
            if (this.classpath != null) {
                JRProperties.setProperty("net.sf.jasperreports.compiler.classpath", String.valueOf(this.classpath));
                ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                antClassLoader = new AntClassLoader(classLoader, this.getProject(), this.classpath, true);
                antClassLoader.setThreadContextLoader();
            }
            try {
                this.scanSrc();
                this.compile();
            }
            finally {
                if (antClassLoader != null) {
                    antClassLoader.resetThreadContextLoader();
                }
            }
        }
        finally {
            JRProperties.restoreProperties();
        }
    }

    public void checkParameters() throws BuildException {
        if (this.src == null || this.src.size() == 0) {
            throw new BuildException("The srcdir attribute must be set.", this.location);
        }
        if (this.destdir != null && !this.destdir.isDirectory()) {
            throw new BuildException("The destination directory \"" + this.destdir + "\" does not exist " + "or is not a directory.", this.location);
        }
        if (this.tempdir != null && !this.tempdir.isDirectory()) {
            throw new BuildException("The temporary directory \"" + this.tempdir + "\" does not exist " + "or is not a directory.", this.location);
        }
    }

    public void scanSrc() throws BuildException {
        String[] stringArray = this.src.list();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2;
            File file = this.project.resolveFile(stringArray[i2]);
            if (!file.exists()) {
                throw new BuildException("The srcdir \"" + file.getPath() + "\" does not exist.", this.location);
            }
            if (file.isDirectory()) {
                stringArray2 = this.getDirectoryScanner(file);
                String[] stringArray3 = stringArray2.getIncludedFiles();
                this.scanDir(file, this.destdir != null ? this.destdir : file, stringArray3);
                continue;
            }
            stringArray2 = new String[]{file.getName()};
            this.scanDir(file.getParentFile(), this.destdir != null ? this.destdir : file.getParentFile(), stringArray2);
        }
    }

    public void scanDir(File file, File file2, String[] stringArray) {
        RegexpPatternMapper regexpPatternMapper = new RegexpPatternMapper();
        regexpPatternMapper.setFrom("^(.*)\\.(.*)$");
        regexpPatternMapper.setTo("\\1.jasper");
        SourceFileScanner sourceFileScanner = new SourceFileScanner((Task)this);
        String[] stringArray2 = sourceFileScanner.restrict(stringArray, file, file2, (FileNameMapper)regexpPatternMapper);
        if (stringArray2 != null && stringArray2.length > 0) {
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                this.reportFilesMap.put(new File(file, stringArray2[i2]).getAbsolutePath(), new File(file2, regexpPatternMapper.mapFileName(stringArray2[i2])[0]).getAbsolutePath());
            }
        }
    }

    public void compile() throws BuildException {
        Set set = this.reportFilesMap.keySet();
        if (set != null && set.size() > 0) {
            boolean bl2 = false;
            System.out.println("Compiling " + set.size() + " report design files.");
            String string = null;
            String string2 = null;
            File file = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                string2 = (String)this.reportFilesMap.get(string);
                file = new File(string2).getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                try {
                    System.out.print("File : " + string + " ... ");
                    JasperCompileManager.compileReportToFile(string, string2);
                    System.out.println("OK.");
                }
                catch (JRException jRException) {
                    System.out.println("FAILED.");
                    System.out.println("Error compiling report design : " + string);
                    jRException.printStackTrace(System.out);
                    bl2 = true;
                }
            }
            if (bl2) {
                throw new BuildException("Errors were encountered when compiling report designs.");
            }
        }
    }
}

