/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseMeterPlot;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;

public class JRDesignMeterPlot
extends JRBaseMeterPlot {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DATA_RANGE = "dataRange";
    public static final String PROPERTY_METER_ANGLE = "meterAngle";
    public static final String PROPERTY_METER_BACKGROUND_COLOR = "meterBackgroundColor";
    public static final String PROPERTY_NEEDLE_COLOR = "needleColor";
    public static final String PROPERTY_SHAPE = "shape";
    public static final String PROPERTY_TICK_COLOR = "tickColor";
    public static final String PROPERTY_TICK_INTERVAL = "tickInterval";
    public static final String PROPERTY_UNITS = "units";
    public static final String PROPERTY_VALUE_DISPLAY = "valueDisplay";
    public static final String PROPERTY_INTERVALS = "intervals";

    public JRDesignMeterPlot(JRChartPlot jRChartPlot, JRChart jRChart) {
        super(jRChartPlot, jRChart);
    }

    public void setDataRange(JRDataRange jRDataRange) throws JRException {
        JRDataRange jRDataRange2 = this.dataRange;
        this.dataRange = jRDataRange;
        this.getEventSupport().firePropertyChange(PROPERTY_DATA_RANGE, jRDataRange2, this.dataRange);
    }

    public void setValueDisplay(JRValueDisplay jRValueDisplay) {
        JRValueDisplay jRValueDisplay2 = this.valueDisplay;
        this.valueDisplay = jRValueDisplay;
        this.getEventSupport().firePropertyChange(PROPERTY_VALUE_DISPLAY, jRValueDisplay2, this.valueDisplay);
    }

    public void setShape(byte by2) throws JRException {
        if (by2 < 0 || by2 > 2) {
            throw new JRException("Unknown shape for MeterPlot");
        }
        byte by3 = this.shape;
        this.shape = by2;
        this.getEventSupport().firePropertyChange(PROPERTY_SHAPE, by3, this.shape);
    }

    public void addInterval(JRMeterInterval jRMeterInterval) {
        this.intervals.add(jRMeterInterval);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_INTERVALS, jRMeterInterval, this.intervals.size() - 1);
    }

    public void clearIntervals() {
        this.setIntervals(null);
    }

    public void setIntervals(Collection collection) {
        ArrayList arrayList = new ArrayList(this.intervals);
        this.intervals.clear();
        if (collection != null) {
            this.intervals.addAll(collection);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_INTERVALS, arrayList, this.intervals);
    }

    public void setMeterAngle(int n2) {
        int n3 = this.meterAngle;
        this.meterAngle = n2;
        this.getEventSupport().firePropertyChange(PROPERTY_METER_ANGLE, n3, this.meterAngle);
    }

    public void setUnits(String string) {
        String string2 = this.units;
        this.units = string;
        this.getEventSupport().firePropertyChange(PROPERTY_UNITS, string2, this.units);
    }

    public void setTickInterval(double d2) {
        double d3 = this.tickInterval;
        this.tickInterval = d2;
        this.getEventSupport().firePropertyChange(PROPERTY_TICK_INTERVAL, d3, this.tickInterval);
    }

    public void setMeterBackgroundColor(Color color) {
        Color color2 = this.meterBackgroundColor;
        this.meterBackgroundColor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_METER_BACKGROUND_COLOR, color2, this.meterBackgroundColor);
    }

    public void setNeedleColor(Color color) {
        Color color2 = this.needleColor;
        this.needleColor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_NEEDLE_COLOR, color2, this.needleColor);
    }

    public void setTickColor(Color color) {
        Color color2 = this.tickColor;
        this.tickColor = color;
        this.getEventSupport().firePropertyChange(PROPERTY_TICK_COLOR, color2, this.tickColor);
    }
}

