/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculator;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRCalculable;

public class JRPercentageCalculatorFactory {
    private static final Map builtInCalculators = new HashMap();
    private static final Map cachedCalculators;
    public static Class e;
    public static Class c;
    public static Class a;
    public static Class b;
    public static Class f;
    public static Class d;
    public static Class h;
    public static Class g;

    public static boolean hasBuiltInCalculator(Class clazz) {
        return builtInCalculators.containsKey(clazz.getName());
    }

    public static JRPercentageCalculator getPercentageCalculator(Class clazz, Class clazz2) {
        JRPercentageCalculator jRPercentageCalculator;
        if (clazz == null) {
            jRPercentageCalculator = (JRPercentageCalculator)builtInCalculators.get(clazz2.getName());
            if (jRPercentageCalculator == null) {
                throw new JRRuntimeException("Measure with type " + clazz2.getName() + " should specify a percentage calculator class.");
            }
        } else {
            jRPercentageCalculator = (JRPercentageCalculator)cachedCalculators.get(clazz.getName());
            if (jRPercentageCalculator == null) {
                try {
                    jRPercentageCalculator = (JRPercentageCalculator)clazz.newInstance();
                    cachedCalculators.put(clazz.getName(), jRPercentageCalculator);
                }
                catch (InstantiationException instantiationException) {
                    throw new JRRuntimeException("Error while creating percentage calculator instance of " + clazz + ".", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JRRuntimeException("Error while creating percentage calculator instance of " + clazz + ".", illegalAccessException);
                }
            }
        }
        return jRPercentageCalculator;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        builtInCalculators.put((e == null ? (e = JRPercentageCalculatorFactory.a("java.lang.Float")) : e).getName(), new FloatPercentageCalculator());
        builtInCalculators.put((c == null ? (c = JRPercentageCalculatorFactory.a("java.lang.Double")) : c).getName(), new DoublePercentageCalculator());
        builtInCalculators.put((a == null ? (a = JRPercentageCalculatorFactory.a("java.lang.Integer")) : a).getName(), new IntegerPercentageCalculator());
        builtInCalculators.put((b == null ? (b = JRPercentageCalculatorFactory.a("java.lang.Long")) : b).getName(), new LongPercentageCalculator());
        builtInCalculators.put((f == null ? (f = JRPercentageCalculatorFactory.a("java.lang.Short")) : f).getName(), new ShortPercentageCalculator());
        builtInCalculators.put((d == null ? (d = JRPercentageCalculatorFactory.a("java.lang.Byte")) : d).getName(), new BytePercentageCalculator());
        builtInCalculators.put((h == null ? (h = JRPercentageCalculatorFactory.a("java.math.BigDecimal")) : h).getName(), new BigDecimalPercentageCalculator());
        builtInCalculators.put((g == null ? (g = JRPercentageCalculatorFactory.a("java.math.BigInteger")) : g).getName(), new BigIntegerPercentageCalculator());
        cachedCalculators = new HashMap();
    }

    public static class BigIntegerPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            BigInteger bigInteger = (BigInteger)jRCalculable2.getValue();
            BigInteger bigInteger2 = (BigInteger)jRCalculable.getValue();
            BigInteger bigInteger3 = bigInteger != null && bigInteger.doubleValue() != 0.0 ? bigInteger2.multiply(BigInteger.valueOf(100L)).divide(bigInteger) : BigInteger.valueOf(0L);
            return bigInteger3;
        }
    }

    public static class BigDecimalPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            BigDecimal bigDecimal = (BigDecimal)jRCalculable2.getValue();
            BigDecimal bigDecimal2 = (BigDecimal)jRCalculable.getValue();
            BigDecimal bigDecimal3 = bigDecimal != null && bigDecimal.doubleValue() != 0.0 ? bigDecimal2.multiply(BigDecimal.valueOf(100L)).divide(bigDecimal, 4) : BigDecimal.valueOf(0L);
            return bigDecimal3;
        }
    }

    public static class DoublePercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Double d2 = (Double)jRCalculable2.getValue();
            Double d3 = (Double)jRCalculable.getValue();
            double d4 = 0.0;
            if (d2 != null && d2 != 0.0) {
                d4 = 100.0 * d3 / d2;
            }
            return new Double(d4);
        }
    }

    public static class FloatPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Float f2 = (Float)jRCalculable2.getValue();
            Float f3 = (Float)jRCalculable.getValue();
            float f4 = 0.0f;
            if (f2 != null && f2.floatValue() != 0.0f) {
                f4 = 100.0f * f3.floatValue() / f2.floatValue();
            }
            return new Float(f4);
        }
    }

    public static class LongPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Long l2 = (Long)jRCalculable2.getValue();
            Long l3 = (Long)jRCalculable.getValue();
            long l4 = 0L;
            if (l2 != null && l2 != 0L) {
                l4 = 100L * l3 / l2;
            }
            return new Long(l4);
        }
    }

    public static class IntegerPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Integer n2 = (Integer)jRCalculable2.getValue();
            Integer n3 = (Integer)jRCalculable.getValue();
            int n4 = 0;
            if (n2 != null && n2 != 0) {
                n4 = 100 * n3 / n2;
            }
            return new Integer(n4);
        }
    }

    public static class ShortPercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Short s2 = (Short)jRCalculable2.getValue();
            Short s3 = (Short)jRCalculable.getValue();
            short s4 = 0;
            if (s2 != null && s2 != 0) {
                s4 = (short)(100 * s3 / s2);
            }
            return new Short(s4);
        }
    }

    public static class BytePercentageCalculator
    implements JRPercentageCalculator {
        public Object calculatePercentage(JRCalculable jRCalculable, JRCalculable jRCalculable2) {
            Byte by2 = (Byte)jRCalculable2.getValue();
            Byte by3 = (Byte)jRCalculable.getValue();
            byte by4 = 0;
            if (by2 != null && by2 != 0) {
                by4 = (byte)(100 * by3 / by2);
            }
            return new Byte(by4);
        }
    }
}

