/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;

public class JRExpressionCollector {
    private final JRReport report;
    private final JRExpressionCollector parent;
    private Map expressionIds;
    private GeneratedIds generatedIds = new GeneratedIds();
    private Map crosstabIds = new HashMap();
    private Map datasetCollectors;
    private Map crosstabCollectors;
    private final Set collectedStyles;

    public static JRExpressionCollector collector(JRReport jRReport) {
        JRExpressionCollector jRExpressionCollector = new JRExpressionCollector(null, jRReport);
        jRExpressionCollector.collect();
        return jRExpressionCollector;
    }

    public static List collectExpressions(JRReport jRReport) {
        return JRExpressionCollector.collector(jRReport).getExpressions();
    }

    public static JRExpressionCollector collector(JRReport jRReport, JRCrosstab jRCrosstab) {
        JRExpressionCollector jRExpressionCollector = new JRExpressionCollector(null, jRReport);
        jRExpressionCollector.collect(jRCrosstab);
        return jRExpressionCollector;
    }

    public static List collectExpressions(JRReport jRReport, JRCrosstab jRCrosstab) {
        return JRExpressionCollector.collector(jRReport, jRCrosstab).getExpressions(jRCrosstab);
    }

    public JRExpressionCollector(JRExpressionCollector jRExpressionCollector, JRReport jRReport) {
        this.parent = jRExpressionCollector;
        this.report = jRReport;
        if (jRExpressionCollector == null) {
            this.expressionIds = new HashMap();
            this.datasetCollectors = new HashMap();
            this.crosstabCollectors = new HashMap();
        } else {
            this.expressionIds = this.parent.expressionIds;
        }
        this.collectedStyles = new HashSet();
    }

    private void addExpression(JRExpression jRExpression) {
        if (jRExpression != null) {
            Integer n2 = this.getExpressionId(jRExpression);
            if (n2 == null) {
                n2 = this.generatedIds.nextId();
                this.setGeneratedId(jRExpression, n2);
                this.generatedIds.put(n2, jRExpression);
            } else {
                JRExpression jRExpression2 = this.generatedIds.put(n2, jRExpression);
                if (jRExpression2 != null && !jRExpression2.equals(jRExpression)) {
                    Integer n3 = this.generatedIds.nextId();
                    this.updateGeneratedId(jRExpression2, n2, n3);
                    this.generatedIds.put(n3, jRExpression2);
                }
            }
        }
    }

    private void setGeneratedId(JRExpression jRExpression, Integer n2) {
        Integer n3 = this.expressionIds.put(jRExpression, n2);
        if (n3 != null && !((Object)n3).equals(n2)) {
            throw new JRRuntimeException("Expression \"" + jRExpression.getText() + "\" has two generated IDs");
        }
    }

    private void updateGeneratedId(JRExpression jRExpression, Integer n2, Integer n3) {
        Integer n4 = this.expressionIds.put(jRExpression, n3);
        if (n4 == null || !((Object)n4).equals(n2)) {
            throw new JRRuntimeException("Expression \"" + jRExpression.getText() + "\" not found with id " + n2);
        }
    }

    private JRExpressionCollector getCollector(JRElementDataset jRElementDataset) {
        JRDatasetRun jRDatasetRun = jRElementDataset.getDatasetRun();
        JRExpressionCollector jRExpressionCollector = jRDatasetRun == null ? this : this.getDatasetCollector(jRDatasetRun.getDatasetName());
        return jRExpressionCollector;
    }

    private JRExpressionCollector getDatasetCollector(String string) {
        JRExpressionCollector jRExpressionCollector = (JRExpressionCollector)this.datasetCollectors.get(string);
        if (jRExpressionCollector == null) {
            jRExpressionCollector = new JRExpressionCollector(this, this.report);
            this.datasetCollectors.put(string, jRExpressionCollector);
        }
        return jRExpressionCollector;
    }

    public JRExpressionCollector getCollector(JRDataset jRDataset) {
        JRExpressionCollector jRExpressionCollector = jRDataset.isMainDataset() || this.datasetCollectors == null ? this : this.getDatasetCollector(jRDataset.getName());
        return jRExpressionCollector;
    }

    public JRExpressionCollector getCollector(JRCrosstab jRCrosstab) {
        JRExpressionCollector jRExpressionCollector = (JRExpressionCollector)this.crosstabCollectors.get(jRCrosstab);
        if (jRExpressionCollector == null) {
            jRExpressionCollector = new JRExpressionCollector(this, this.report);
            this.crosstabCollectors.put(jRCrosstab, jRExpressionCollector);
        }
        return jRExpressionCollector;
    }

    public List getExpressions() {
        return new ArrayList(this.generatedIds.expressions());
    }

    public List getExpressions(JRDataset jRDataset) {
        return this.getCollector(jRDataset).getExpressions();
    }

    public List getExpressions(JRCrosstab jRCrosstab) {
        return this.getCollector(jRCrosstab).getExpressions();
    }

    public Integer getExpressionId(JRExpression jRExpression) {
        return (Integer)this.expressionIds.get(jRExpression);
    }

    public JRExpression getExpression(int n2) {
        return this.generatedIds.expression(n2);
    }

    public Integer getCrosstabId(JRCrosstab jRCrosstab) {
        return (Integer)this.crosstabIds.get(jRCrosstab);
    }

    public Collection collect() {
        this.collectTemplates();
        this.collect(this.report.getDefaultStyle());
        this.collect(this.report.getMainDataset());
        JRDataset[] jRDatasetArray = this.report.getDatasets();
        if (jRDatasetArray != null && jRDatasetArray.length > 0) {
            for (int i2 = 0; i2 < jRDatasetArray.length; ++i2) {
                JRExpressionCollector jRExpressionCollector = this.getCollector(jRDatasetArray[i2]);
                jRExpressionCollector.collect(jRDatasetArray[i2]);
            }
        }
        this.collect(this.report.getBackground());
        this.collect(this.report.getTitle());
        this.collect(this.report.getPageHeader());
        this.collect(this.report.getColumnHeader());
        this.collect(this.report.getDetail());
        this.collect(this.report.getColumnFooter());
        this.collect(this.report.getPageFooter());
        this.collect(this.report.getLastPageFooter());
        this.collect(this.report.getSummary());
        this.collect(this.report.getNoData());
        return this.getExpressions();
    }

    public void collectTemplates() {
        JRReportTemplate[] jRReportTemplateArray = this.report.getTemplates();
        if (jRReportTemplateArray != null) {
            for (int i2 = 0; i2 < jRReportTemplateArray.length; ++i2) {
                JRReportTemplate jRReportTemplate = jRReportTemplateArray[i2];
                this.collect(jRReportTemplate);
            }
        }
    }

    public void collect(JRReportTemplate jRReportTemplate) {
        this.addExpression(jRReportTemplate.getSourceExpression());
    }

    private void collect(JRStyle jRStyle) {
        if (jRStyle != null && this.collectedStyles.add(jRStyle)) {
            JRConditionalStyle[] jRConditionalStyleArray = jRStyle.getConditionalStyles();
            if (jRConditionalStyleArray != null && jRConditionalStyleArray.length > 0) {
                for (int i2 = 0; i2 < jRConditionalStyleArray.length; ++i2) {
                    this.addExpression(jRConditionalStyleArray[i2].getConditionExpression());
                }
            }
            this.collect(jRStyle.getStyle());
        }
    }

    private void collect(JRParameter[] jRParameterArray) {
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            for (int i2 = 0; i2 < jRParameterArray.length; ++i2) {
                this.addExpression(jRParameterArray[i2].getDefaultValueExpression());
            }
        }
    }

    private void collect(JRVariable[] jRVariableArray) {
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            for (int i2 = 0; i2 < jRVariableArray.length; ++i2) {
                JRVariable jRVariable = jRVariableArray[i2];
                this.addExpression(jRVariable.getExpression());
                this.addExpression(jRVariable.getInitialValueExpression());
            }
        }
    }

    private void collect(JRGroup[] jRGroupArray) {
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            for (int i2 = 0; i2 < jRGroupArray.length; ++i2) {
                JRGroup jRGroup = jRGroupArray[i2];
                this.addExpression(jRGroup.getExpression());
                this.collect(jRGroup.getGroupHeader());
                this.collect(jRGroup.getGroupFooter());
            }
        }
    }

    private void collect(JRBand jRBand) {
        if (jRBand != null) {
            this.addExpression(jRBand.getPrintWhenExpression());
            JRElement[] jRElementArray = jRBand.getElements();
            if (jRElementArray != null && jRElementArray.length > 0) {
                for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
                    jRElementArray[i2].collectExpressions(this);
                }
            }
        }
    }

    private void collectElement(JRElement jRElement) {
        this.collect(jRElement.getStyle());
        this.addExpression(jRElement.getPrintWhenExpression());
    }

    private void collectAnchor(JRAnchor jRAnchor) {
        this.addExpression(jRAnchor.getAnchorNameExpression());
    }

    private void collectHyperlink(JRHyperlink jRHyperlink) {
        if (jRHyperlink != null) {
            this.addExpression(jRHyperlink.getHyperlinkReferenceExpression());
            this.addExpression(jRHyperlink.getHyperlinkAnchorExpression());
            this.addExpression(jRHyperlink.getHyperlinkPageExpression());
            this.addExpression(jRHyperlink.getHyperlinkTooltipExpression());
            JRHyperlinkParameter[] jRHyperlinkParameterArray = jRHyperlink.getHyperlinkParameters();
            if (jRHyperlinkParameterArray != null) {
                for (int i2 = 0; i2 < jRHyperlinkParameterArray.length; ++i2) {
                    JRHyperlinkParameter jRHyperlinkParameter = jRHyperlinkParameterArray[i2];
                    this.collectHyperlinkParameter(jRHyperlinkParameter);
                }
            }
        }
    }

    public void collectHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        if (jRHyperlinkParameter != null) {
            this.addExpression(jRHyperlinkParameter.getValueExpression());
        }
    }

    public void collect(JRBreak jRBreak) {
        this.collectElement(jRBreak);
    }

    public void collect(JRLine jRLine) {
        this.collectElement(jRLine);
    }

    public void collect(JRRectangle jRRectangle) {
        this.collectElement(jRRectangle);
    }

    public void collect(JREllipse jREllipse) {
        this.collectElement(jREllipse);
    }

    public void collect(JRImage jRImage) {
        this.collectElement(jRImage);
        this.addExpression(jRImage.getExpression());
        this.collectAnchor(jRImage);
        this.collectHyperlink(jRImage);
    }

    public void collect(JRStaticText jRStaticText) {
        this.collectElement(jRStaticText);
    }

    public void collect(JRTextField jRTextField) {
        this.collectElement(jRTextField);
        this.addExpression(jRTextField.getExpression());
        this.collectAnchor(jRTextField);
        this.collectHyperlink(jRTextField);
    }

    public void collect(JRSubreport jRSubreport) {
        this.collectElement(jRSubreport);
        this.addExpression(jRSubreport.getParametersMapExpression());
        JRSubreportParameter[] jRSubreportParameterArray = jRSubreport.getParameters();
        if (jRSubreportParameterArray != null && jRSubreportParameterArray.length > 0) {
            for (int i2 = 0; i2 < jRSubreportParameterArray.length; ++i2) {
                this.addExpression(jRSubreportParameterArray[i2].getExpression());
            }
        }
        this.addExpression(jRSubreport.getConnectionExpression());
        this.addExpression(jRSubreport.getDataSourceExpression());
        this.addExpression(jRSubreport.getExpression());
    }

    public void collect(JRChart jRChart) {
        this.collectElement(jRChart);
        this.collectAnchor(jRChart);
        this.collectHyperlink(jRChart);
        this.addExpression(jRChart.getTitleExpression());
        this.addExpression(jRChart.getSubtitleExpression());
        jRChart.getDataset().collectExpressions(this);
        jRChart.getPlot().collectExpressions(this);
    }

    public void collect(JRPieDataset jRPieDataset) {
        this.collect((JRElementDataset)jRPieDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRPieDataset);
        jRExpressionCollector.addExpression(jRPieDataset.getKeyExpression());
        jRExpressionCollector.addExpression(jRPieDataset.getValueExpression());
        jRExpressionCollector.addExpression(jRPieDataset.getLabelExpression());
        jRExpressionCollector.collectHyperlink(jRPieDataset.getSectionHyperlink());
    }

    public void collect(JRCategoryDataset jRCategoryDataset) {
        this.collect((JRElementDataset)jRCategoryDataset);
        JRCategorySeries[] jRCategorySeriesArray = jRCategoryDataset.getSeries();
        if (jRCategorySeriesArray != null && jRCategorySeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRCategoryDataset);
            for (int i2 = 0; i2 < jRCategorySeriesArray.length; ++i2) {
                jRExpressionCollector.collect(jRCategorySeriesArray[i2]);
            }
        }
    }

    public void collect(JRXyDataset jRXyDataset) {
        this.collect((JRElementDataset)jRXyDataset);
        JRXySeries[] jRXySeriesArray = jRXyDataset.getSeries();
        if (jRXySeriesArray != null && jRXySeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRXyDataset);
            for (int i2 = 0; i2 < jRXySeriesArray.length; ++i2) {
                jRExpressionCollector.collect(jRXySeriesArray[i2]);
            }
        }
    }

    public void collect(JRTimeSeriesDataset jRTimeSeriesDataset) {
        this.collect((JRElementDataset)jRTimeSeriesDataset);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null && jRTimeSeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRTimeSeriesDataset);
            for (int i2 = 0; i2 < jRTimeSeriesArray.length; ++i2) {
                jRExpressionCollector.collect(jRTimeSeriesArray[i2]);
            }
        }
    }

    public void collect(JRTimePeriodDataset jRTimePeriodDataset) {
        this.collect((JRElementDataset)jRTimePeriodDataset);
        JRTimePeriodSeries[] jRTimePeriodSeriesArray = jRTimePeriodDataset.getSeries();
        if (jRTimePeriodSeriesArray != null && jRTimePeriodSeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRTimePeriodDataset);
            for (int i2 = 0; i2 < jRTimePeriodSeriesArray.length; ++i2) {
                jRExpressionCollector.collect(jRTimePeriodSeriesArray[i2]);
            }
        }
    }

    public void collect(JRValueDataset jRValueDataset) {
        this.collect((JRElementDataset)jRValueDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRValueDataset);
        jRExpressionCollector.addExpression(jRValueDataset.getValueExpression());
    }

    private void collect(JRXySeries jRXySeries) {
        this.addExpression(jRXySeries.getSeriesExpression());
        this.addExpression(jRXySeries.getXValueExpression());
        this.addExpression(jRXySeries.getYValueExpression());
        this.addExpression(jRXySeries.getLabelExpression());
        this.collectHyperlink(jRXySeries.getItemHyperlink());
    }

    private void collect(JRCategorySeries jRCategorySeries) {
        this.addExpression(jRCategorySeries.getSeriesExpression());
        this.addExpression(jRCategorySeries.getCategoryExpression());
        this.addExpression(jRCategorySeries.getValueExpression());
        this.addExpression(jRCategorySeries.getLabelExpression());
        this.collectHyperlink(jRCategorySeries.getItemHyperlink());
    }

    public void collect(JRBarPlot jRBarPlot) {
        this.addExpression(jRBarPlot.getCategoryAxisLabelExpression());
        this.addExpression(jRBarPlot.getValueAxisLabelExpression());
    }

    public void collect(JRBar3DPlot jRBar3DPlot) {
        this.addExpression(jRBar3DPlot.getCategoryAxisLabelExpression());
        this.addExpression(jRBar3DPlot.getValueAxisLabelExpression());
    }

    public void collect(JRLinePlot jRLinePlot) {
        this.addExpression(jRLinePlot.getCategoryAxisLabelExpression());
        this.addExpression(jRLinePlot.getValueAxisLabelExpression());
    }

    public void collect(JRTimeSeriesPlot jRTimeSeriesPlot) {
        this.addExpression(jRTimeSeriesPlot.getTimeAxisLabelExpression());
        this.addExpression(jRTimeSeriesPlot.getValueAxisLabelExpression());
    }

    public void collect(JRScatterPlot jRScatterPlot) {
        this.addExpression(jRScatterPlot.getXAxisLabelExpression());
        this.addExpression(jRScatterPlot.getYAxisLabelExpression());
    }

    public void collect(JRAreaPlot jRAreaPlot) {
        this.addExpression(jRAreaPlot.getCategoryAxisLabelExpression());
        this.addExpression(jRAreaPlot.getValueAxisLabelExpression());
    }

    private void collect(JRTimeSeries jRTimeSeries) {
        this.addExpression(jRTimeSeries.getSeriesExpression());
        this.addExpression(jRTimeSeries.getTimePeriodExpression());
        this.addExpression(jRTimeSeries.getValueExpression());
        this.addExpression(jRTimeSeries.getLabelExpression());
        this.collectHyperlink(jRTimeSeries.getItemHyperlink());
    }

    private void collect(JRTimePeriodSeries jRTimePeriodSeries) {
        this.addExpression(jRTimePeriodSeries.getSeriesExpression());
        this.addExpression(jRTimePeriodSeries.getStartDateExpression());
        this.addExpression(jRTimePeriodSeries.getEndDateExpression());
        this.addExpression(jRTimePeriodSeries.getValueExpression());
        this.addExpression(jRTimePeriodSeries.getLabelExpression());
        this.collectHyperlink(jRTimePeriodSeries.getItemHyperlink());
    }

    public void collect(JRXyzDataset jRXyzDataset) {
        this.collect((JRElementDataset)jRXyzDataset);
        JRXyzSeries[] jRXyzSeriesArray = jRXyzDataset.getSeries();
        if (jRXyzSeriesArray != null && jRXyzSeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRXyzDataset);
            for (int i2 = 0; i2 < jRXyzSeriesArray.length; ++i2) {
                jRExpressionCollector.collect(jRXyzSeriesArray[i2]);
            }
        }
    }

    private void collect(JRXyzSeries jRXyzSeries) {
        this.addExpression(jRXyzSeries.getSeriesExpression());
        this.addExpression(jRXyzSeries.getXValueExpression());
        this.addExpression(jRXyzSeries.getYValueExpression());
        this.addExpression(jRXyzSeries.getZValueExpression());
        this.collectHyperlink(jRXyzSeries.getItemHyperlink());
    }

    public void collect(JRBubblePlot jRBubblePlot) {
        this.addExpression(jRBubblePlot.getXAxisLabelExpression());
        this.addExpression(jRBubblePlot.getYAxisLabelExpression());
    }

    public void collect(JRHighLowPlot jRHighLowPlot) {
        this.addExpression(jRHighLowPlot.getTimeAxisLabelExpression());
        this.addExpression(jRHighLowPlot.getValueAxisLabelExpression());
    }

    public void collect(JRDataRange jRDataRange) {
        if (jRDataRange != null) {
            this.addExpression(jRDataRange.getLowExpression());
            this.addExpression(jRDataRange.getHighExpression());
        }
    }

    public void collect(JRMeterPlot jRMeterPlot) {
        List list = jRMeterPlot.getIntervals();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JRMeterInterval jRMeterInterval = (JRMeterInterval)iterator.next();
                this.collect(jRMeterInterval.getDataRange());
            }
        }
        this.collect(jRMeterPlot.getDataRange());
    }

    public void collect(JRThermometerPlot jRThermometerPlot) {
        this.collect(jRThermometerPlot.getDataRange());
        this.collect(jRThermometerPlot.getLowRange());
        this.collect(jRThermometerPlot.getMediumRange());
        this.collect(jRThermometerPlot.getHighRange());
    }

    public void collect(JRHighLowDataset jRHighLowDataset) {
        this.collect((JRElementDataset)jRHighLowDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRHighLowDataset);
        jRExpressionCollector.addExpression(jRHighLowDataset.getSeriesExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getDateExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getHighExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getLowExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getOpenExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getCloseExpression());
        jRExpressionCollector.addExpression(jRHighLowDataset.getVolumeExpression());
        jRExpressionCollector.collectHyperlink(jRHighLowDataset.getItemHyperlink());
    }

    public void collect(JRCandlestickPlot jRCandlestickPlot) {
        this.addExpression(jRCandlestickPlot.getTimeAxisLabelExpression());
        this.addExpression(jRCandlestickPlot.getValueAxisLabelExpression());
    }

    public void collect(JRCrosstab jRCrosstab) {
        JRCrosstabMeasure[] jRCrosstabMeasureArray;
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray;
        Object object;
        this.collectElement(jRCrosstab);
        this.createCrosstabId(jRCrosstab);
        JRCrosstabDataset jRCrosstabDataset = jRCrosstab.getDataset();
        this.collect(jRCrosstabDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRCrosstabDataset);
        JRExpressionCollector jRExpressionCollector2 = this.getCollector(jRCrosstab);
        jRExpressionCollector2.collect(this.report.getDefaultStyle());
        this.addExpression(jRCrosstab.getParametersMapExpression());
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        if (jRCrosstabParameterArray != null) {
            for (int i2 = 0; i2 < jRCrosstabParameterArray.length; ++i2) {
                this.addExpression(jRCrosstabParameterArray[i2].getExpression());
            }
        }
        jRExpressionCollector2.collect(jRCrosstab.getHeaderCell());
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        if (jRCrosstabRowGroupArray != null) {
            for (int i3 = 0; i3 < jRCrosstabRowGroupArray.length; ++i3) {
                JRCrosstabRowGroup jRCrosstabRowGroup = jRCrosstabRowGroupArray[i3];
                object = jRCrosstabRowGroup.getBucket();
                jRExpressionCollector.addExpression(object.getExpression());
                this.addExpression(object.getComparatorExpression());
                jRExpressionCollector2.collect(jRCrosstabRowGroup.getHeader());
                jRExpressionCollector2.collect(jRCrosstabRowGroup.getTotalHeader());
            }
        }
        if ((jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups()) != null) {
            for (int i4 = 0; i4 < jRCrosstabColumnGroupArray.length; ++i4) {
                object = jRCrosstabColumnGroupArray[i4];
                jRExpressionCollector.addExpression(object.getBucket().getExpression());
                this.addExpression(object.getBucket().getComparatorExpression());
                jRExpressionCollector2.collect(object.getHeader());
                jRExpressionCollector2.collect(object.getTotalHeader());
            }
        }
        if ((jRCrosstabMeasureArray = jRCrosstab.getMeasures()) != null) {
            for (int i5 = 0; i5 < jRCrosstabMeasureArray.length; ++i5) {
                jRExpressionCollector.addExpression(jRCrosstabMeasureArray[i5].getValueExpression());
            }
        }
        jRExpressionCollector2.collect(jRCrosstab.getWhenNoDataCell());
        this.collectCrosstabCells(jRCrosstab, jRExpressionCollector2);
    }

    private void createCrosstabId(JRCrosstab jRCrosstab) {
        this.crosstabIds.put(jRCrosstab, new Integer(this.crosstabIds.size()));
    }

    private void collectCrosstabCells(JRCrosstab jRCrosstab, JRExpressionCollector jRExpressionCollector) {
        block5: {
            block4: {
                if (!(jRCrosstab instanceof JRDesignCrosstab)) break block4;
                List list = ((JRDesignCrosstab)jRCrosstab).getCellsList();
                if (list == null) break block5;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)iterator.next();
                    jRExpressionCollector.collect(jRCrosstabCell.getContents());
                }
                break block5;
            }
            JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
            if (jRCrosstabCellArray != null) {
                for (int i2 = 0; i2 < jRCrosstabCellArray.length; ++i2) {
                    for (int i3 = 0; i3 < jRCrosstabCellArray[i2].length; ++i3) {
                        if (jRCrosstabCellArray[i2][i3] == null) continue;
                        jRExpressionCollector.collect(jRCrosstabCellArray[i2][i3].getContents());
                    }
                }
            }
        }
    }

    public Collection collect(JRDataset jRDataset) {
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRDataset);
        jRExpressionCollector.collect(jRDataset.getParameters());
        jRExpressionCollector.collect(jRDataset.getVariables());
        jRExpressionCollector.collect(jRDataset.getGroups());
        jRExpressionCollector.addExpression(jRDataset.getFilterExpression());
        return this.getExpressions(jRDataset);
    }

    public void collect(JRElementDataset jRElementDataset) {
        this.collect(jRElementDataset.getDatasetRun());
        JRExpression jRExpression = jRElementDataset.getIncrementWhenExpression();
        if (jRExpression != null) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRElementDataset);
            jRExpressionCollector.addExpression(jRExpression);
        }
    }

    private void collect(JRDatasetRun jRDatasetRun) {
        if (jRDatasetRun != null) {
            this.addExpression(jRDatasetRun.getParametersMapExpression());
            this.addExpression(jRDatasetRun.getConnectionExpression());
            this.addExpression(jRDatasetRun.getDataSourceExpression());
            JRDatasetParameter[] jRDatasetParameterArray = jRDatasetRun.getParameters();
            if (jRDatasetParameterArray != null && jRDatasetParameterArray.length > 0) {
                for (int i2 = 0; i2 < jRDatasetParameterArray.length; ++i2) {
                    this.addExpression(jRDatasetParameterArray[i2].getExpression());
                }
            }
        }
    }

    public void collect(JRCellContents jRCellContents) {
        if (jRCellContents != null) {
            this.collect(jRCellContents.getStyle());
            JRElement[] jRElementArray = jRCellContents.getElements();
            if (jRElementArray != null && jRElementArray.length > 0) {
                for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
                    jRElementArray[i2].collectExpressions(this);
                }
            }
        }
    }

    public void collect(JRFrame jRFrame) {
        this.collectElement(jRFrame);
        JRElement[] jRElementArray = jRFrame.getElements();
        if (jRElementArray != null) {
            for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
                jRElementArray[i2].collectExpressions(this);
            }
        }
    }

    protected static class GeneratedIds {
        private final TreeMap ids = new TreeMap();
        private int nextId = 0;
        private List expressions;

        public JRExpression put(Integer n2, JRExpression jRExpression) {
            this.expressions = null;
            return this.ids.put(n2, jRExpression);
        }

        public Integer nextId() {
            Integer n2 = new Integer(this.nextId);
            while (this.ids.containsKey(n2)) {
                n2 = new Integer(++this.nextId);
            }
            return n2;
        }

        public List expressions() {
            if (this.expressions == null) {
                this.expressions = new ArrayList(this.ids.values());
            }
            return this.expressions;
        }

        public JRExpression expression(int n2) {
            return (JRExpression)this.ids.get(new Integer(n2));
        }
    }
}

