/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRTypeSniffer;

public class JRImageRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;
    private byte[] imageData = null;
    private String imageLocation = null;
    private byte imageType = 0;
    private transient SoftReference awtImageRef = null;

    private JRImageRenderer(byte[] byArray) {
        this.imageData = byArray;
        if (byArray != null) {
            this.imageType = JRTypeSniffer.getImageType(byArray);
        }
    }

    private JRImageRenderer(String string) {
        this.imageLocation = string;
    }

    public static ClassLoader getClassLoader() {
        return JRResourcesUtil.getThreadClassLoader();
    }

    public static void setClassLoader(ClassLoader classLoader) {
        JRResourcesUtil.setThreadClassLoader(classLoader);
    }

    public static JRImageRenderer getInstance(byte[] byArray) {
        return new JRImageRenderer(byArray);
    }

    public static JRRenderable getInstance(String string) throws JRException {
        return JRImageRenderer.getInstance(string, (byte)1, true);
    }

    public static JRRenderable getInstance(String string, byte by2) throws JRException {
        return JRImageRenderer.getInstance(string, by2, true);
    }

    public static JRRenderable getInstance(String string, byte by2, boolean bl2) throws JRException {
        return JRImageRenderer.getInstance(string, by2, bl2, null, null);
    }

    public static JRRenderable getInstance(String string, byte by2, boolean bl2, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws JRException {
        if (string == null) {
            return null;
        }
        if (bl2) {
            return new JRImageRenderer(string);
        }
        try {
            byte[] byArray = JRLoader.loadBytesFromLocation(string, classLoader, uRLStreamHandlerFactory);
            return new JRImageRenderer(byArray);
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by2, jRException);
        }
    }

    public static JRRenderable getInstance(Image image, byte by2) throws JRException {
        return JRImageRenderer.getInstance(image, (byte)2, by2);
    }

    public static JRRenderable getInstance(Image image, byte by2, byte by3) throws JRException {
        try {
            return new JRImageRenderer(JRImageLoader.loadImageDataFromAWTImage(image, by2));
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by3, jRException);
        }
    }

    public static JRRenderable getInstance(InputStream inputStream, byte by2) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(inputStream));
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by2, jRException);
        }
    }

    public static JRRenderable getInstance(URL uRL, byte by2) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(uRL));
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by2, jRException);
        }
    }

    public static JRRenderable getInstance(File file, byte by2) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(file));
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by2, jRException);
        }
    }

    public static JRRenderable getOnErrorRendererForDimension(JRRenderable jRRenderable, byte by2) throws JRException {
        try {
            jRRenderable.getDimension();
            return jRRenderable;
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by2, jRException);
        }
    }

    public static JRRenderable getOnErrorRendererForImageData(JRRenderable jRRenderable, byte by2) throws JRException {
        try {
            jRRenderable.getImageData();
            return jRRenderable;
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by2, jRException);
        }
    }

    public static JRImageRenderer getOnErrorRendererForImage(JRImageRenderer jRImageRenderer, byte by2) throws JRException {
        try {
            jRImageRenderer.getImage();
            return jRImageRenderer;
        }
        catch (JRException jRException) {
            return JRImageRenderer.getOnErrorRenderer(by2, jRException);
        }
    }

    private static JRImageRenderer getOnErrorRenderer(byte by2, JRException jRException) throws JRException {
        JRImageRenderer jRImageRenderer = null;
        switch (by2) {
            case 3: {
                jRImageRenderer = new JRImageRenderer("net/sf/jasperreports/engine/images/noimage.GIF");
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw jRException;
            }
        }
        return jRImageRenderer;
    }

    public Image getImage() throws JRException {
        if (this.awtImageRef == null || this.awtImageRef.get() == null) {
            Image image = JRImageLoader.loadImage(this.getImageData());
            this.awtImageRef = new SoftReference<Image>(image);
        }
        return (Image)this.awtImageRef.get();
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public byte getType() {
        return 0;
    }

    public byte getImageType() {
        return this.imageType;
    }

    public Dimension2D getDimension() throws JRException {
        Image image = this.getImage();
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    public byte[] getImageData() throws JRException {
        if (this.imageData == null) {
            this.imageData = JRLoader.loadBytesFromLocation(this.imageLocation);
            if (this.imageData != null) {
                this.imageType = JRTypeSniffer.getImageType(this.imageData);
            }
        }
        return this.imageData;
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D) throws JRException {
        Image image = this.getImage();
        graphics2D.drawImage(image, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), null);
    }
}

