/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.util.JRImageLoader;

public class JRResultSetDataSource
implements JRDataSource {
    private static final String INDEXED_COLUMN_PREFIX = "COLUMN_";
    private static final int INDEXED_COLUMN_PREFIX_LENGTH = "COLUMN_".length();
    private ResultSet resultSet = null;
    private Map columnIndexMap = new HashMap();
    public static Class n;
    public static Class o;
    public static Class p;
    public static Class q;
    public static Class e;
    public static Class c;
    public static Class f;
    public static Class j;
    public static Class d;
    public static Class a;
    public static Class g;
    public static Class h;
    public static Class k;
    public static Class l;
    public static Class i;
    public static Class m;
    public static Class b;

    public JRResultSetDataSource(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public boolean next() throws JRException {
        boolean bl2 = false;
        if (this.resultSet != null) {
            try {
                bl2 = this.resultSet.next();
            }
            catch (SQLException sQLException) {
                throw new JRException("Unable to get next record.", sQLException);
            }
        }
        return bl2;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        Object object;
        block42: {
            object = null;
            if (jRField != null && this.resultSet != null) {
                Integer n2 = this.getColumnIndex(jRField.getName());
                Class clazz = jRField.getValueClass();
                try {
                    if (clazz.equals(n == null ? (n = JRResultSetDataSource.a("java.lang.Boolean")) : n)) {
                        object = this.resultSet.getBoolean(n2) ? Boolean.TRUE : Boolean.FALSE;
                        break block42;
                    }
                    if (clazz.equals(o == null ? (o = JRResultSetDataSource.a("java.lang.Byte")) : o)) {
                        object = new Byte(this.resultSet.getByte(n2));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(p == null ? (p = JRResultSetDataSource.a("java.util.Date")) : p)) {
                        object = this.resultSet.getDate(n2);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(q == null ? (q = JRResultSetDataSource.a("java.sql.Timestamp")) : q)) {
                        object = this.resultSet.getTimestamp(n2);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(e == null ? (e = JRResultSetDataSource.a("java.sql.Time")) : e)) {
                        object = this.resultSet.getTime(n2);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(c == null ? (c = JRResultSetDataSource.a("java.lang.Double")) : c)) {
                        object = new Double(this.resultSet.getDouble(n2));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(f == null ? (f = JRResultSetDataSource.a("java.lang.Float")) : f)) {
                        object = new Float(this.resultSet.getFloat(n2));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(j == null ? (j = JRResultSetDataSource.a("java.lang.Integer")) : j)) {
                        object = new Integer(this.resultSet.getInt(n2));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(d == null ? (d = JRResultSetDataSource.a("java.io.InputStream")) : d)) {
                        byte[] byArray = this.readBytes(n2);
                        object = byArray == null ? null : new ByteArrayInputStream(byArray);
                        break block42;
                    }
                    if (clazz.equals(a == null ? (a = JRResultSetDataSource.a("java.lang.Long")) : a)) {
                        object = new Long(this.resultSet.getLong(n2));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(g == null ? (g = JRResultSetDataSource.a("java.lang.Short")) : g)) {
                        object = new Short(this.resultSet.getShort(n2));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(h == null ? (h = JRResultSetDataSource.a("java.math.BigDecimal")) : h)) {
                        object = this.resultSet.getBigDecimal(n2);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(k == null ? (k = JRResultSetDataSource.a("java.lang.String")) : k)) {
                        int n3 = this.resultSet.getMetaData().getColumnType(n2);
                        switch (n3) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(n2);
                                if (this.resultSet.wasNull()) {
                                    object = null;
                                    break;
                                }
                                object = this.clobToString(clob);
                                break;
                            }
                            default: {
                                object = this.resultSet.getString(n2);
                                if (this.resultSet.wasNull()) {
                                    object = null;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block42;
                    }
                    if (clazz.equals(l == null ? (l = JRResultSetDataSource.a("java.sql.Clob")) : l)) {
                        object = this.resultSet.getClob(n2);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                    } else if (clazz.equals(i == null ? (i = JRResultSetDataSource.a("java.io.Reader")) : i)) {
                        Reader reader = null;
                        long l2 = -1L;
                        int n4 = this.resultSet.getMetaData().getColumnType(n2);
                        switch (n4) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(n2);
                                if (this.resultSet.wasNull()) break;
                                reader = clob.getCharacterStream();
                                l2 = clob.length();
                                break;
                            }
                            default: {
                                reader = this.resultSet.getCharacterStream(n2);
                                if (!this.resultSet.wasNull()) break;
                                reader = null;
                            }
                        }
                        object = reader == null ? null : this.getArrayReader(reader, l2);
                    } else if (clazz.equals(m == null ? (m = JRResultSetDataSource.a("java.sql.Blob")) : m)) {
                        object = this.resultSet.getBlob(n2);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                    } else {
                        byte[] byArray;
                        object = clazz.equals(b == null ? (b = JRResultSetDataSource.a("java.awt.Image")) : b) ? ((byArray = this.readBytes(n2)) == null ? null : JRImageLoader.loadImage(byArray)) : this.resultSet.getObject(n2);
                    }
                }
                catch (Exception exception) {
                    throw new JRException("Unable to get value for field '" + jRField.getName() + "' of class '" + clazz.getName() + "'", exception);
                }
            }
        }
        return object;
    }

    private Integer getColumnIndex(String string) throws JRException {
        Integer n2 = (Integer)this.columnIndexMap.get(string);
        if (n2 == null) {
            try {
                n2 = this.searchColumnByName(string);
                if (n2 == null) {
                    n2 = this.searchColumnByLabel(string);
                }
                if (n2 == null && string.startsWith(INDEXED_COLUMN_PREFIX) && ((n2 = new Integer(string.substring(INDEXED_COLUMN_PREFIX_LENGTH))) <= 0 || n2 > this.resultSet.getMetaData().getColumnCount())) {
                    throw new JRException("Column index out of range : " + n2);
                }
                if (n2 == null) {
                    throw new JRException("Unknown column name : " + string);
                }
            }
            catch (SQLException sQLException) {
                throw new JRException("Unable to retrieve result set metadata.", sQLException);
            }
            this.columnIndexMap.put(string, n2);
        }
        return n2;
    }

    public Integer searchColumnByName(String string) throws SQLException {
        Integer n2 = null;
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
            String string2 = resultSetMetaData.getColumnName(i2);
            if (!string.equalsIgnoreCase(string2)) continue;
            n2 = new Integer(i2);
            break;
        }
        return n2;
    }

    public Integer searchColumnByLabel(String string) throws SQLException {
        Integer n2 = null;
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
            String string2 = resultSetMetaData.getColumnLabel(i2);
            if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
            n2 = new Integer(i2);
            break;
        }
        return n2;
    }

    public String clobToString(Clob clob) throws JRException {
        try {
            int n2 = 8192;
            char[] cArray = new char[n2];
            BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream(), n2);
            StringBuffer stringBuffer = new StringBuffer((int)clob.length());
            int n3 = bufferedReader.read(cArray);
            while (n3 > 0) {
                stringBuffer.append(cArray, 0, n3);
                n3 = bufferedReader.read(cArray);
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            throw new JRException("Unable to read clob value", sQLException);
        }
        catch (IOException iOException) {
            throw new JRException("Unable to read clob value", iOException);
        }
    }

    public CharArrayReader getArrayReader(Reader reader, long l2) throws IOException {
        char[] cArray = new char[8192];
        CharArrayWriter charArrayWriter = new CharArrayWriter(l2 > 0L ? (int)l2 : 8192);
        BufferedReader bufferedReader = new BufferedReader(reader, 8192);
        int n2 = bufferedReader.read(cArray);
        while (n2 > 0) {
            charArrayWriter.write(cArray, 0, n2);
            n2 = bufferedReader.read(cArray);
        }
        charArrayWriter.flush();
        return new CharArrayReader(charArrayWriter.toCharArray());
    }

    public byte[] readBytes(Integer n2) throws SQLException, IOException {
        Object object;
        InputStream inputStream = null;
        long l2 = -1L;
        int n3 = this.resultSet.getMetaData().getColumnType(n2);
        switch (n3) {
            case 2004: {
                object = this.resultSet.getBlob(n2);
                if (this.resultSet.wasNull()) break;
                inputStream = object.getBinaryStream();
                l2 = object.length();
                break;
            }
            default: {
                inputStream = this.resultSet.getBinaryStream(n2);
                if (!this.resultSet.wasNull()) break;
                inputStream = null;
            }
        }
        object = null;
        if (inputStream != null) {
            object = this.readBytes(inputStream, l2);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(InputStream inputStream, long l2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(l2 > 0L ? (int)l2 : 1000);
        byte[] byArray = new byte[1000];
        int n2 = 0;
        try {
            while ((n2 = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

