/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;

public class JRSimpleTemplate
implements JRTemplate,
Serializable {
    private static final long serialVersionUID = 10200L;
    private final List includedTemplates = new ArrayList();
    private final List styles = new ArrayList();
    private JRStyle defaultStyle;

    public void addStyle(JRStyle jRStyle) throws JRException {
        this.checkExistingName(jRStyle.getName());
        if (jRStyle.isDefault()) {
            this.defaultStyle = jRStyle;
        }
        this.styles.add(jRStyle);
    }

    public void checkExistingName(String string) throws JRException {
        if (this.getStyle(string) != null) {
            throw new JRException("Duplicate declaration of template style : " + string);
        }
    }

    public boolean nameMatches(JRStyle jRStyle, String string) {
        String string2 = jRStyle.getName();
        return string == null ? string2 == null : string.equals(string2);
    }

    public JRStyle getStyle(String string) {
        JRStyle jRStyle = null;
        Iterator iterator = this.styles.iterator();
        while (iterator.hasNext()) {
            JRStyle jRStyle2 = (JRStyle)iterator.next();
            if (!this.nameMatches(jRStyle2, string)) continue;
            jRStyle = jRStyle2;
            break;
        }
        return jRStyle;
    }

    public boolean removeStyle(JRStyle jRStyle) {
        boolean bl2 = this.styles.remove(jRStyle);
        if (bl2 && jRStyle.isDefault()) {
            this.defaultStyle = null;
        }
        return bl2;
    }

    public JRStyle removeStyle(String string) {
        JRStyle jRStyle = null;
        ListIterator listIterator = this.styles.listIterator();
        while (listIterator.hasNext()) {
            JRStyle jRStyle2 = (JRStyle)listIterator.next();
            if (!this.nameMatches(jRStyle2, string)) continue;
            if (jRStyle2.isDefault()) {
                this.defaultStyle = null;
            }
            jRStyle = jRStyle2;
            listIterator.remove();
            break;
        }
        return jRStyle;
    }

    public JRStyle[] getStyles() {
        return this.styles.toArray(new JRStyle[this.styles.size()]);
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public JRReportFont getDefaultFont() {
        return null;
    }

    public void addIncludedTemplate(JRTemplateReference jRTemplateReference) {
        this.includedTemplates.add(jRTemplateReference);
    }

    public void addIncludedTemplate(String string) {
        this.includedTemplates.add(new JRTemplateReference(string));
    }

    public boolean removeIncludedTemplate(JRTemplateReference jRTemplateReference) {
        return this.includedTemplates.remove(jRTemplateReference);
    }

    public JRTemplateReference removeIncludedTemplate(String string) {
        JRTemplateReference jRTemplateReference = null;
        ListIterator listIterator = this.includedTemplates.listIterator();
        while (listIterator.hasNext()) {
            JRTemplateReference jRTemplateReference2 = (JRTemplateReference)listIterator.next();
            if (!jRTemplateReference2.getLocation().equals(string)) continue;
            jRTemplateReference = jRTemplateReference2;
            listIterator.remove();
        }
        return jRTemplateReference;
    }

    public JRTemplateReference[] getIncludedTemplates() {
        return this.includedTemplates.toArray(new JRTemplateReference[this.includedTemplates.size()]);
    }
}

