/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;

public class JasperExportManager {
    public static String exportReportToPdfFile(String string) throws JRException {
        File file = new File(string);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(file);
        File file2 = new File(file.getParent(), jasperPrint.getName() + ".pdf");
        String string2 = file2.toString();
        JasperExportManager.exportReportToPdfFile(jasperPrint, string2);
        return string2;
    }

    public static void exportReportToPdfFile(String string, String string2) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(string);
        JasperExportManager.exportReportToPdfFile(jasperPrint, string2);
    }

    public static void exportReportToPdfFile(JasperPrint jasperPrint, String string) throws JRException {
        JRPdfExporter jRPdfExporter = new JRPdfExporter();
        jRPdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        jRPdfExporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, string);
        jRPdfExporter.exportReport();
    }

    public static void exportReportToPdfStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperExportManager.exportReportToPdfStream(jasperPrint, outputStream);
    }

    public static void exportReportToPdfStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRPdfExporter jRPdfExporter = new JRPdfExporter();
        jRPdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        jRPdfExporter.setParameter(JRExporterParameter.OUTPUT_STREAM, outputStream);
        jRPdfExporter.exportReport();
    }

    public static byte[] exportReportToPdf(JasperPrint jasperPrint) throws JRException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JRPdfExporter jRPdfExporter = new JRPdfExporter();
        jRPdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        jRPdfExporter.setParameter(JRExporterParameter.OUTPUT_STREAM, byteArrayOutputStream);
        jRPdfExporter.exportReport();
        return byteArrayOutputStream.toByteArray();
    }

    public static String exportReportToXmlFile(String string, boolean bl2) throws JRException {
        File file = new File(string);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(file);
        File file2 = new File(file.getParent(), jasperPrint.getName() + ".jrpxml");
        String string2 = file2.toString();
        JasperExportManager.exportReportToXmlFile(jasperPrint, string2, bl2);
        return string2;
    }

    public static void exportReportToXmlFile(String string, String string2, boolean bl2) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(string);
        JasperExportManager.exportReportToXmlFile(jasperPrint, string2, bl2);
    }

    public static void exportReportToXmlFile(JasperPrint jasperPrint, String string, boolean bl2) throws JRException {
        JRXmlExporter jRXmlExporter = new JRXmlExporter();
        jRXmlExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        jRXmlExporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, string);
        jRXmlExporter.setParameter(JRXmlExporterParameter.IS_EMBEDDING_IMAGES, bl2 ? Boolean.TRUE : Boolean.FALSE);
        jRXmlExporter.exportReport();
    }

    public static void exportReportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperExportManager.exportReportToXmlStream(jasperPrint, outputStream);
    }

    public static void exportReportToXmlStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRXmlExporter jRXmlExporter = new JRXmlExporter();
        jRXmlExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        jRXmlExporter.setParameter(JRExporterParameter.OUTPUT_STREAM, outputStream);
        jRXmlExporter.exportReport();
    }

    public static String exportReportToXml(JasperPrint jasperPrint) throws JRException {
        StringBuffer stringBuffer = new StringBuffer();
        JRXmlExporter jRXmlExporter = new JRXmlExporter();
        jRXmlExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        jRXmlExporter.setParameter(JRExporterParameter.OUTPUT_STRING_BUFFER, stringBuffer);
        jRXmlExporter.exportReport();
        return stringBuffer.toString();
    }

    public static String exportReportToHtmlFile(String string) throws JRException {
        File file = new File(string);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(file);
        File file2 = new File(file.getParent(), jasperPrint.getName() + ".html");
        String string2 = file2.toString();
        JasperExportManager.exportReportToHtmlFile(jasperPrint, string2);
        return string2;
    }

    public static void exportReportToHtmlFile(String string, String string2) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(string);
        JasperExportManager.exportReportToHtmlFile(jasperPrint, string2);
    }

    public static void exportReportToHtmlFile(JasperPrint jasperPrint, String string) throws JRException {
        JRHtmlExporter jRHtmlExporter = new JRHtmlExporter();
        jRHtmlExporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        jRHtmlExporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, string);
        jRHtmlExporter.exportReport();
    }
}

