/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseDatasetParameter;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseDatasetRun
implements JRDatasetRun,
Serializable {
    private static final long serialVersionUID = 10200L;
    public String datasetName;
    public JRExpression parametersMapExpression;
    public JRDatasetParameter[] parameters;
    public JRExpression connectionExpression;
    public JRExpression dataSourceExpression;

    public JRBaseDatasetRun() {
    }

    public JRBaseDatasetRun(JRDatasetRun jRDatasetRun, JRBaseObjectFactory jRBaseObjectFactory) {
        jRBaseObjectFactory.put(jRDatasetRun, this);
        this.datasetName = jRDatasetRun.getDatasetName();
        this.parametersMapExpression = jRBaseObjectFactory.getExpression(jRDatasetRun.getParametersMapExpression());
        this.connectionExpression = jRBaseObjectFactory.getExpression(jRDatasetRun.getConnectionExpression());
        this.dataSourceExpression = jRBaseObjectFactory.getExpression(jRDatasetRun.getDataSourceExpression());
        JRDatasetParameter[] jRDatasetParameterArray = jRDatasetRun.getParameters();
        if (jRDatasetParameterArray != null && jRDatasetParameterArray.length > 0) {
            this.parameters = new JRBaseDatasetParameter[jRDatasetParameterArray.length];
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                this.parameters[i2] = jRBaseObjectFactory.getDatasetParameter(jRDatasetParameterArray[i2]);
            }
        }
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public JRDatasetParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    public Object clone() {
        JRBaseDatasetRun jRBaseDatasetRun = null;
        try {
            jRBaseDatasetRun = (JRBaseDatasetRun)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new JRRuntimeException(cloneNotSupportedException);
        }
        if (this.parametersMapExpression != null) {
            jRBaseDatasetRun.parametersMapExpression = (JRExpression)this.parametersMapExpression.clone();
        }
        if (this.connectionExpression != null) {
            jRBaseDatasetRun.connectionExpression = (JRExpression)this.connectionExpression.clone();
        }
        if (this.dataSourceExpression != null) {
            jRBaseDatasetRun.dataSourceExpression = (JRExpression)this.dataSourceExpression.clone();
        }
        if (this.parameters != null) {
            jRBaseDatasetRun.parameters = new JRDatasetParameter[this.parameters.length];
            for (int i2 = 0; i2 < this.parameters.length; ++i2) {
                jRBaseDatasetRun.parameters[i2] = (JRDatasetParameter)this.parameters[i2].clone();
            }
        }
        return jRBaseDatasetRun;
    }
}

